/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.client.binary.OBinaryRequestExecutor;
import com.orientechnologies.orient.client.remote.OBinaryAsyncRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OCreateRecordResponse;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;

public class OCreateRecordRequest
implements OBinaryAsyncRequest<OCreateRecordResponse> {
    private ORecord content;
    private byte[] rawContent;
    private ORecordId rid;
    private byte recordType;
    private byte mode;

    public OCreateRecordRequest() {
    }

    @Override
    public byte getMode() {
        return this.mode;
    }

    @Override
    public byte getCommand() {
        return 31;
    }

    @Override
    public String getDescription() {
        return "Create Record";
    }

    public OCreateRecordRequest(byte[] iContent, ORecordId iRid, byte iRecordType) {
        this.rawContent = iContent;
        this.rid = iRid;
        this.recordType = iRecordType;
    }

    public OCreateRecordRequest(ORecord iContent, ORecordId iRid, byte iRecordType) {
        this.content = iContent;
        this.rid = iRid;
        this.recordType = iRecordType;
    }

    @Override
    public void write(OChannelDataOutput network, OStorageRemoteSession session) throws IOException {
        network.writeShort((short)this.rid.getClusterId());
        network.writeBytes(this.rawContent);
        network.writeByte(this.recordType);
        network.writeByte(this.mode);
    }

    @Override
    public void read(OChannelDataInput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        int dataSegmentId = protocolVersion < 24 ? channel.readInt() : 0;
        this.rid = new ORecordId((int)channel.readShort(), -1L);
        byte[] rec = channel.readBytes();
        this.recordType = channel.readByte();
        this.mode = channel.readByte();
        this.content = Orient.instance().getRecordFactoryManager().newInstance(this.recordType, this.rid.getClusterId(), ODatabaseRecordThreadLocal.instance().getIfDefined());
        serializer.fromStream(rec, this.content, null);
    }

    public ORecordId getRid() {
        return this.rid;
    }

    public ORecord getContent() {
        return this.content;
    }

    public byte getRecordType() {
        return this.recordType;
    }

    @Override
    public void setMode(byte mode) {
        this.mode = mode;
    }

    @Override
    public OCreateRecordResponse createResponse() {
        return new OCreateRecordResponse();
    }

    @Override
    public OBinaryResponse execute(OBinaryRequestExecutor executor) {
        return executor.executeCreateRecord(this);
    }
}

