/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.client.binary.OBinaryRequestExecutor;
import com.orientechnologies.orient.client.remote.OBinaryRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OExperimentalResponse;
import com.orientechnologies.orient.client.remote.message.OLockRecordRequest;
import com.orientechnologies.orient.client.remote.message.OUnlockRecordRequest;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;

public class OExperimentalRequest
implements OBinaryRequest<OExperimentalResponse> {
    public static final byte REQUEST_RECORD_LOCK = 48;
    public static final byte REQUEST_RECORD_UNLOCK = 49;
    private byte messageID;
    private OBinaryRequest<? extends OBinaryResponse> request;

    public OExperimentalRequest() {
    }

    public OExperimentalRequest(OBinaryRequest<? extends OBinaryResponse> request) {
        this.messageID = request.getCommand();
        this.request = request;
    }

    @Override
    public void write(OChannelDataOutput network, OStorageRemoteSession session) throws IOException {
        network.writeByte(this.messageID);
        this.request.write(network, session);
    }

    @Override
    public void read(OChannelDataInput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        this.messageID = channel.readByte();
        this.request = this.createBinaryRequest(this.messageID);
        this.request.read(channel, protocolVersion, serializer);
    }

    private OBinaryRequest<? extends OBinaryResponse> createBinaryRequest(byte message) {
        switch (message) {
            case 48: {
                return new OLockRecordRequest();
            }
            case 49: {
                return new OUnlockRecordRequest();
            }
        }
        throw new ODatabaseException("Unknown message response for code:" + message);
    }

    @Override
    public byte getCommand() {
        return 102;
    }

    @Override
    public OExperimentalResponse createResponse() {
        return new OExperimentalResponse(this.request.createResponse());
    }

    @Override
    public OBinaryResponse execute(OBinaryRequestExecutor executor) {
        return executor.executeExperimental(this);
    }

    public byte getMessageID() {
        return this.messageID;
    }

    public OBinaryRequest<? extends OBinaryResponse> getRequest() {
        return this.request;
    }

    @Override
    public String getDescription() {
        return "Experimental message:" + (this.request == null ? "Not Defined" : this.request.getDescription());
    }
}

