/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OMessageHelper;
import com.orientechnologies.orient.client.remote.message.tx.IndexChange;
import com.orientechnologies.orient.client.remote.message.tx.ORecordOperationRequest;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerNetworkV37;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerNetworkV37Client;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OFetchTransactionResponse
implements OBinaryResponse {
    private int txId;
    private List<ORecordOperationRequest> operations;
    private List<IndexChange> indexChanges;

    public OFetchTransactionResponse() {
    }

    public OFetchTransactionResponse(int txId, Iterable<ORecordOperation> operations, Map<String, OTransactionIndexChanges> indexChanges, Map<ORID, ORID> updatedRids) {
        Map<ORID, ORID> reversed = updatedRids.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        this.txId = txId;
        this.indexChanges = new ArrayList<IndexChange>();
        ArrayList<ORecordOperationRequest> netOperations = new ArrayList<ORecordOperationRequest>();
        for (ORecordOperation oRecordOperation : operations) {
            if (oRecordOperation.type == 0) continue;
            ORecordOperationRequest request = new ORecordOperationRequest();
            request.setType(oRecordOperation.type);
            request.setVersion(oRecordOperation.getRecord().getVersion());
            request.setId(oRecordOperation.getRID());
            ORID oldID = reversed.get(oRecordOperation.getRID());
            request.setOldId(oldID != null ? oldID : oRecordOperation.getRID());
            request.setRecordType(ORecordInternal.getRecordType((ORecord)oRecordOperation.getRecord()));
            request.setRecord(ORecordSerializerNetworkV37.INSTANCE.toStream(oRecordOperation.getRecord()));
            request.setContentChanged(ORecordInternal.isContentChanged((ORecord)oRecordOperation.getRecord()));
            netOperations.add(request);
        }
        this.operations = netOperations;
        for (Map.Entry entry : indexChanges.entrySet()) {
            this.indexChanges.add(new IndexChange((String)entry.getKey(), (OTransactionIndexChanges)entry.getValue()));
        }
    }

    @Override
    public void write(OChannelDataOutput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        channel.writeInt(this.txId);
        for (ORecordOperationRequest txEntry : this.operations) {
            OFetchTransactionResponse.writeTransactionEntry(channel, txEntry, serializer);
        }
        channel.writeByte((byte)0);
        OMessageHelper.writeTransactionIndexChanges(channel, (ORecordSerializerNetworkV37)serializer, this.indexChanges);
    }

    static void writeTransactionEntry(OChannelDataOutput iNetwork, ORecordOperationRequest txEntry, ORecordSerializer serializer) throws IOException {
        iNetwork.writeByte((byte)1);
        iNetwork.writeByte(txEntry.getType());
        iNetwork.writeRID(txEntry.getId());
        iNetwork.writeRID(txEntry.getOldId());
        iNetwork.writeByte(txEntry.getRecordType());
        switch (txEntry.getType()) {
            case 3: {
                iNetwork.writeBytes(txEntry.getRecord());
                break;
            }
            case 1: {
                iNetwork.writeVersion(txEntry.getVersion());
                iNetwork.writeBytes(txEntry.getRecord());
                iNetwork.writeBoolean(txEntry.isContentChanged());
                break;
            }
            case 2: {
                iNetwork.writeVersion(txEntry.getVersion());
                iNetwork.writeBytes(txEntry.getRecord());
            }
        }
    }

    @Override
    public void read(OChannelDataInput network, OStorageRemoteSession session) throws IOException {
        byte hasEntry;
        ORecordSerializerNetworkV37Client serializer = ORecordSerializerNetworkV37Client.INSTANCE;
        this.txId = network.readInt();
        this.operations = new ArrayList<ORecordOperationRequest>();
        do {
            if ((hasEntry = network.readByte()) != 1) continue;
            ORecordOperationRequest entry = OFetchTransactionResponse.readTransactionEntry(network, (ORecordSerializer)serializer);
            this.operations.add(entry);
        } while (hasEntry == 1);
        this.indexChanges = OMessageHelper.readTransactionIndexChanges(network, (ORecordSerializerNetworkV37)serializer);
    }

    static ORecordOperationRequest readTransactionEntry(OChannelDataInput channel, ORecordSerializer ser) throws IOException {
        ORecordOperationRequest entry = new ORecordOperationRequest();
        entry.setType(channel.readByte());
        entry.setId((ORID)channel.readRID());
        entry.setOldId((ORID)channel.readRID());
        entry.setRecordType(channel.readByte());
        switch (entry.getType()) {
            case 3: {
                entry.setRecord(channel.readBytes());
                break;
            }
            case 1: {
                entry.setVersion(channel.readVersion());
                entry.setRecord(channel.readBytes());
                entry.setContentChanged(channel.readBoolean());
                break;
            }
            case 2: {
                entry.setVersion(channel.readVersion());
                entry.setRecord(channel.readBytes());
                break;
            }
        }
        return entry;
    }

    public int getTxId() {
        return this.txId;
    }

    public List<ORecordOperationRequest> getOperations() {
        return this.operations;
    }

    public List<IndexChange> getIndexChanges() {
        return this.indexChanges;
    }
}

