/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OMessageHelper;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerNetworkV37Client;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;
import java.util.Set;

public final class OReadRecordResponse
implements OBinaryResponse {
    private byte recordType;
    private int version;
    private byte[] record;
    private Set<ORecord> recordsToSend;
    private ORawBuffer result;

    public OReadRecordResponse() {
    }

    public OReadRecordResponse(byte recordType, int version, byte[] record, Set<ORecord> recordsToSend) {
        this.recordType = recordType;
        this.version = version;
        this.record = record;
        this.recordsToSend = recordsToSend;
    }

    @Override
    public void write(OChannelDataOutput network, int protocolVersion, ORecordSerializer serializer) throws IOException {
        if (this.record != null) {
            network.writeByte((byte)1);
            if (protocolVersion <= 27) {
                network.writeBytes(this.record);
                network.writeVersion(this.version);
                network.writeByte(this.recordType);
            } else {
                network.writeByte(this.recordType);
                network.writeVersion(this.version);
                network.writeBytes(this.record);
            }
            for (ORecord d : this.recordsToSend) {
                if (!d.getIdentity().isValid()) continue;
                network.writeByte((byte)2);
                OMessageHelper.writeRecord(network, d, serializer);
            }
        }
        network.writeByte((byte)0);
    }

    @Override
    public void read(OChannelDataInput network, OStorageRemoteSession session) throws IOException {
        ORecordSerializerNetworkV37Client serializer = ORecordSerializerNetworkV37Client.INSTANCE;
        if (network.readByte() == 0) {
            return;
        }
        byte type = network.readByte();
        int recVersion = network.readVersion();
        byte[] bytes = network.readBytes();
        ORawBuffer buffer = new ORawBuffer(bytes, recVersion, type);
        ODatabaseDocumentInternal database = ODatabaseRecordThreadLocal.instance().getIfDefined();
        while (network.readByte() == 2) {
            ORecord record = (ORecord)OMessageHelper.readIdentifiable(network, (ORecordSerializer)serializer);
            if (database == null) continue;
            database.getLocalCache().updateRecord(record);
        }
        this.result = buffer;
    }

    public byte[] getRecord() {
        return this.record;
    }

    public ORawBuffer getResult() {
        return this.result;
    }
}

