/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.client.remote.ORemoteConnectionManager;
import com.orientechnologies.orient.client.remote.OServerAdmin;
import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.OCachedDatabasePoolFactory;
import com.orientechnologies.orient.core.db.OCachedDatabasePoolFactoryImpl;
import com.orientechnologies.orient.core.db.OConnectionNext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseDocumentRemotePooled;
import com.orientechnologies.orient.core.db.ODatabasePoolImpl;
import com.orientechnologies.orient.core.db.ODatabasePoolInternal;
import com.orientechnologies.orient.core.db.ODatabaseTask;
import com.orientechnologies.orient.core.db.ODatabaseType;
import com.orientechnologies.orient.core.db.OSharedContext;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.db.OrientDBInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentRemote;
import com.orientechnologies.orient.core.db.document.OSharedContextRemote;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OStorage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class OrientDBRemote
implements OrientDBInternal {
    protected final Map<String, OSharedContext> sharedContexts = new HashMap<String, OSharedContext>();
    private final Map<String, OStorageRemote> storages = new HashMap<String, OStorageRemote>();
    private final Set<ODatabasePoolInternal> pools = new HashSet<ODatabasePoolInternal>();
    private final String[] hosts;
    private final OrientDBConfig configurations;
    private final Orient orient;
    private final OCachedDatabasePoolFactory cachedPoolFactory;
    protected volatile ORemoteConnectionManager connectionManager;
    private volatile boolean open = true;
    private Timer timer;
    private OConnectionNext connectionNext;

    public OrientDBRemote(String[] hosts, OrientDBConfig configurations, Orient orient) {
        this.hosts = hosts;
        this.orient = orient;
        this.configurations = configurations != null ? configurations : OrientDBConfig.defaultConfig();
        this.timer = new Timer("Remote background operations timer", true);
        this.connectionManager = new ORemoteConnectionManager(this.configurations.getConfigurations(), this.timer);
        orient.addOrientDB((OrientDBInternal)this);
        this.cachedPoolFactory = this.createCachedDatabasePoolFactory(this.configurations);
        this.connectionNext = new OConnectionNext(hosts.length);
    }

    protected OCachedDatabasePoolFactory createCachedDatabasePoolFactory(OrientDBConfig config) {
        int capacity = config.getConfigurations().getValueAsInteger(OGlobalConfiguration.DB_CACHED_POOL_CAPACITY);
        long timeout = config.getConfigurations().getValueAsInteger(OGlobalConfiguration.DB_CACHED_POOL_CLEAN_UP_TIMEOUT);
        return new OCachedDatabasePoolFactoryImpl((OrientDBInternal)this, capacity, timeout);
    }

    private String buildUrl(String name) {
        return String.join((CharSequence)";", this.hosts) + "/" + name;
    }

    public ODatabaseDocumentInternal open(String name, String user, String password) {
        return this.open(name, user, password, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODatabaseDocumentInternal open(String name, String user, String password, OrientDBConfig config) {
        this.checkOpen();
        OrientDBConfig resolvedConfig = this.solveConfig(config);
        try {
            OStorageRemote storage;
            OrientDBRemote orientDBRemote = this;
            synchronized (orientDBRemote) {
                storage = this.storages.get(name);
                if (storage == null) {
                    storage = new OStorageRemote(this.buildUrl(name), this, "rw", this.connectionManager, resolvedConfig, this.connectionNext);
                    this.storages.put(name, storage);
                }
            }
            ODatabaseDocumentRemote db = new ODatabaseDocumentRemote(storage);
            db.internalOpen(user, password, resolvedConfig, this.getOrCreateSharedContext((OStorage)storage));
            return db;
        }
        catch (Exception e) {
            throw OException.wrapException((OException)new ODatabaseException("Cannot open database '" + name + "'"), (Throwable)e);
        }
    }

    public void create(String name, String user, String password, ODatabaseType databaseType) {
        this.create(name, user, password, databaseType, null);
    }

    public synchronized void create(String name, String user, String password, ODatabaseType databaseType, OrientDBConfig config) {
        this.connectEndExecute(name, user, password, admin -> {
            String sendType = null;
            if (databaseType == ODatabaseType.MEMORY) {
                sendType = "memory";
            } else if (databaseType == ODatabaseType.PLOCAL) {
                sendType = "plocal";
            }
            admin.createDatabase(name, null, sendType);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODatabaseDocumentRemotePooled poolOpen(String name, String user, String password, ODatabasePoolInternal pool) {
        OStorageRemote storage;
        OrientDBRemote orientDBRemote = this;
        synchronized (orientDBRemote) {
            storage = this.storages.get(name);
            if (storage == null) {
                try {
                    storage = new OStorageRemote(this.buildUrl(name), this, "rw", this.connectionManager, this.solveConfig(pool.getConfig()), this.connectionNext);
                    this.storages.put(name, storage);
                }
                catch (Exception e) {
                    throw OException.wrapException((OException)new ODatabaseException("Cannot open database '" + name + "'"), (Throwable)e);
                }
            }
        }
        ODatabaseDocumentRemotePooled db = new ODatabaseDocumentRemotePooled(pool, storage);
        db.internalOpen(user, password, pool.getConfig(), this.getOrCreateSharedContext((OStorage)storage));
        return db;
    }

    public synchronized void closeStorage(OStorageRemote remote) {
        OSharedContext ctx = this.sharedContexts.get(remote.getName());
        if (ctx != null) {
            ctx.close();
            this.sharedContexts.remove(remote.getName());
        }
        ODatabaseDocumentRemote.deInit(remote);
        this.storages.remove(remote.getName());
        remote.shutdown();
    }

    public ODocument getServerInfo(String username, String password) {
        return this.connectEndExecute(null, username, password, admin -> admin.getServerInfo());
    }

    public ODocument getClusterStatus(String username, String password) {
        return this.connectEndExecute(null, username, password, admin -> admin.clusterStatus());
    }

    public String getGlobalConfiguration(String username, String password, OGlobalConfiguration config) {
        return this.connectEndExecute(null, username, password, admin -> admin.getGlobalConfiguration(config));
    }

    public void setGlobalConfiguration(String username, String password, OGlobalConfiguration config, String iConfigValue) {
        this.connectEndExecute(null, username, password, admin -> {
            admin.setGlobalConfiguration(config, iConfigValue);
            return null;
        });
    }

    public Map<String, String> getGlobalConfigurations(String username, String password) {
        return this.connectEndExecute(null, username, password, admin -> admin.getGlobalConfigurations());
    }

    public ORemoteConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T connectEndExecute(String name, String user, String password, Operation<T> operation) {
        this.checkOpen();
        OServerAdmin admin = null;
        int retry = this.configurations.getConfigurations().getValueAsInteger(OGlobalConfiguration.NETWORK_SOCKET_RETRY);
        while (retry > 0) {
            try {
                admin = new OServerAdmin(this, this.buildUrl(name));
                admin.connect(user, password);
                T t = operation.execute(admin);
                return t;
            }
            catch (IOException e) {
                if (--retry != 0) continue;
                throw OException.wrapException((OException)new ODatabaseException("Reached maximum retry limit on admin operations, the server may be offline"), (Throwable)e);
            }
            finally {
                if (admin == null) continue;
                admin.close();
            }
        }
        throw new ODatabaseException("Reached maximum retry limit on admin operations, the server may be offline");
    }

    public synchronized boolean exists(String name, String user, String password) {
        return this.connectEndExecute(name, user, password, admin -> admin.existsDatabase(name, null));
    }

    public synchronized void drop(String name, String user, String password) {
        this.connectEndExecute(name, user, password, admin -> admin.dropDatabase(name, null));
        OSharedContext ctx = this.sharedContexts.get(name);
        if (ctx != null) {
            ctx.close();
            this.sharedContexts.remove(name);
        }
        this.storages.remove(name);
    }

    public Set<String> listDatabases(String user, String password) {
        return this.connectEndExecute("", user, password, admin -> admin.listDatabases().keySet());
    }

    public void restore(String name, String user, String password, ODatabaseType type, String path, OrientDBConfig config) {
        this.connectEndExecute(name, user, password, admin -> {
            admin.createDatabase(name, "", type.name().toLowerCase(), path).close();
            return null;
        });
    }

    public ODatabasePoolInternal openPool(String name, String user, String password) {
        return this.openPool(name, user, password, null);
    }

    public ODatabasePoolInternal openPool(String name, String user, String password, OrientDBConfig config) {
        this.checkOpen();
        ODatabasePoolImpl pool = new ODatabasePoolImpl((OrientDBInternal)this, name, user, password, this.solveConfig(config));
        this.pools.add((ODatabasePoolInternal)pool);
        return pool;
    }

    public ODatabasePoolInternal cachedPool(String database, String user, String password) {
        return this.cachedPool(database, user, password, null);
    }

    public ODatabasePoolInternal cachedPool(String database, String user, String password, OrientDBConfig config) {
        this.checkOpen();
        ODatabasePoolInternal pool = this.cachedPoolFactory.get(database, user, password, this.solveConfig(config));
        this.pools.add(pool);
        return pool;
    }

    public void removePool(ODatabasePoolInternal pool) {
        this.pools.remove(pool);
    }

    public void close() {
        if (!this.open) {
            return;
        }
        this.timer.cancel();
        this.removeShutdownHook();
        this.internalClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalClose() {
        ArrayList<OStorageRemote> storagesCopy;
        if (!this.open) {
            return;
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        Object object = this;
        synchronized (object) {
            this.open = false;
            this.sharedContexts.values().forEach(x -> x.close());
            storagesCopy = new ArrayList<OStorageRemote>(this.storages.values());
        }
        for (OStorageRemote stg : storagesCopy) {
            try {
                ODatabaseDocumentRemote.deInit(stg);
                OLogManager.instance().info((Object)this, "- shutdown storage: " + stg.getName() + "...", new Object[0]);
                stg.shutdown();
            }
            catch (Exception e) {
                OLogManager.instance().warn((Object)this, "-- error on shutdown storage", (Throwable)e, new Object[0]);
            }
            catch (Error e) {
                OLogManager.instance().warn((Object)this, "-- error on shutdown storage", (Throwable)e, new Object[0]);
                throw e;
            }
        }
        object = this;
        synchronized (object) {
            this.sharedContexts.clear();
            this.storages.clear();
            this.connectionManager.close();
        }
    }

    private OrientDBConfig solveConfig(OrientDBConfig config) {
        if (config != null) {
            config.setParent(this.configurations);
            return config;
        }
        OrientDBConfig cfg = OrientDBConfig.defaultConfig();
        cfg.setParent(this.configurations);
        return cfg;
    }

    private synchronized void checkOpen() {
        if (!this.open) {
            throw new ODatabaseException("OrientDB Instance is closed");
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isEmbedded() {
        return false;
    }

    public void removeShutdownHook() {
        this.orient.removeOrientDB((OrientDBInternal)this);
    }

    public void loadAllDatabases() {
    }

    public ODatabaseDocumentInternal openNoAuthenticate(String iDbUrl, String user) {
        throw new UnsupportedOperationException("Open with no authentication is not supported in remote");
    }

    public void initCustomStorage(String name, String baseUrl, String userName, String userPassword) {
        throw new UnsupportedOperationException("Custom storage is not supported in remote");
    }

    public Collection<OStorage> getStorages() {
        throw new UnsupportedOperationException("List storage is not supported in remote");
    }

    public synchronized void forceDatabaseClose(String databaseName) {
        OStorageRemote remote = this.storages.get(databaseName);
        if (remote != null) {
            this.closeStorage(remote);
        }
    }

    public void restore(String name, InputStream in, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener) {
        throw new UnsupportedOperationException("raw restore is not supported in remote");
    }

    public ODatabaseDocumentInternal openNoAuthorization(String name) {
        throw new UnsupportedOperationException("impossible skip authentication and authorization in remote");
    }

    protected synchronized OSharedContext getOrCreateSharedContext(OStorage storage) {
        OSharedContext result = this.sharedContexts.get(storage.getName());
        if (result == null) {
            result = this.createSharedContext(storage);
            this.sharedContexts.put(storage.getName(), result);
        }
        return result;
    }

    private OSharedContext createSharedContext(OStorage storage) {
        OSharedContextRemote result = new OSharedContextRemote(storage, this);
        storage.getResource(OSharedContext.class.getName(), () -> result);
        return result;
    }

    public void schedule(TimerTask task, long delay, long period) {
        this.timer.schedule(task, delay, period);
    }

    public void scheduleOnce(TimerTask task, long delay) {
        this.timer.schedule(task, delay);
    }

    public <X> Future<X> executeNoAuthorization(String database, ODatabaseTask<X> task) {
        throw new UnsupportedOperationException("execute with no session not available in remote");
    }

    public <X> Future<X> execute(String database, String user, ODatabaseTask<X> task) {
        throw new UnsupportedOperationException("execute with no session not available in remote");
    }

    private static interface Operation<T> {
        public T execute(OServerAdmin var1) throws IOException;
    }
}

