/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.document;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.db.OSharedContext;
import com.orientechnologies.orient.core.db.OStringCache;
import com.orientechnologies.orient.core.db.OrientDBRemote;
import com.orientechnologies.orient.core.index.OIndexManagerRemote;
import com.orientechnologies.orient.core.metadata.function.OFunctionLibraryImpl;
import com.orientechnologies.orient.core.metadata.schema.OSchemaRemote;
import com.orientechnologies.orient.core.metadata.security.OSecurityRemote;
import com.orientechnologies.orient.core.metadata.sequence.OSequenceLibraryImpl;
import com.orientechnologies.orient.core.schedule.OSchedulerImpl;
import com.orientechnologies.orient.core.storage.OStorageInfo;

public class OSharedContextRemote
extends OSharedContext {
    public OSharedContextRemote(OStorageInfo storage, OrientDBRemote orientDBRemote) {
        this.stringCache = new OStringCache(orientDBRemote.getContextConfiguration().getValueAsInteger(OGlobalConfiguration.DB_STRING_CAHCE_SIZE));
        this.orientDB = orientDBRemote;
        this.storage = storage;
        this.schema = new OSchemaRemote();
        this.security = new OSecurityRemote();
        this.indexManager = new OIndexManagerRemote(storage);
        this.functionLibrary = new OFunctionLibraryImpl();
        this.scheduler = new OSchedulerImpl(this.orientDB);
        this.sequenceLibrary = new OSequenceLibraryImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load(ODatabaseDocumentInternal database) {
        long timer = PROFILER.startChrono();
        try {
            if (!this.loaded) {
                this.schema.load(database);
                this.indexManager.load(database);
                this.schema.forceSnapshot(database);
                this.security.load((ODatabaseSession)database);
                this.sequenceLibrary.load(database);
                this.schema.onPostIndexManagement();
                this.loaded = true;
            }
        }
        finally {
            PROFILER.stopChrono(PROFILER.getDatabaseMetric(database.getName(), "metadata.load"), "Loading of database metadata", timer, "db.*.metadata.load");
        }
    }

    public synchronized void close() {
        this.stringCache.close();
        this.schema.close();
        this.security.close();
        this.indexManager.close();
        this.sequenceLibrary.close();
        this.loaded = false;
    }

    public synchronized void reload(ODatabaseDocumentInternal database) {
        this.schema.reload(database);
        this.indexManager.reload();
        this.schema.forceSnapshot(database);
        this.security.load((ODatabaseSession)database);
        this.scheduler.load(database);
        this.sequenceLibrary.load(database);
        this.functionLibrary.load(database);
    }
}

