/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.security;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordLazySet;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.function.OFunction;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.metadata.security.ORestrictedOperation;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.OSecurityInternal;
import com.orientechnologies.orient.core.metadata.security.OSecurityPolicy;
import com.orientechnologies.orient.core.metadata.security.OSecurityPolicyImpl;
import com.orientechnologies.orient.core.metadata.security.OSecurityResourceProperty;
import com.orientechnologies.orient.core.metadata.security.OSecurityRole;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.metadata.security.OToken;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.metadata.security.auth.OAuthenticationInfo;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class OSecurityRemote
implements OSecurityInternal {
    public boolean isAllowed(ODatabaseSession session, Set<OIdentifiable> iAllowAll, Set<OIdentifiable> iAllowOperation) {
        return true;
    }

    public OIdentifiable allowRole(ODatabaseSession session, ODocument iDocument, ORestrictedOperation iOperation, String iRoleName) {
        ORID role = this.getRoleRID(session, iRoleName);
        if (role == null) {
            throw new IllegalArgumentException("Role '" + iRoleName + "' not found");
        }
        return this.allowIdentity(session, iDocument, iOperation.getFieldName(), (OIdentifiable)role);
    }

    public OIdentifiable allowUser(ODatabaseSession session, ODocument iDocument, ORestrictedOperation iOperation, String iUserName) {
        ORID user = this.getUserRID(session, iUserName);
        if (user == null) {
            throw new IllegalArgumentException("User '" + iUserName + "' not found");
        }
        return this.allowIdentity(session, iDocument, iOperation.getFieldName(), (OIdentifiable)user);
    }

    public OIdentifiable denyUser(ODatabaseSession session, ODocument iDocument, ORestrictedOperation iOperation, String iUserName) {
        ORID user = this.getUserRID(session, iUserName);
        if (user == null) {
            throw new IllegalArgumentException("User '" + iUserName + "' not found");
        }
        return this.disallowIdentity(session, iDocument, iOperation.getFieldName(), (OIdentifiable)user);
    }

    public OIdentifiable denyRole(ODatabaseSession session, ODocument iDocument, ORestrictedOperation iOperation, String iRoleName) {
        ORID role = this.getRoleRID(session, iRoleName);
        if (role == null) {
            throw new IllegalArgumentException("Role '" + iRoleName + "' not found");
        }
        return this.disallowIdentity(session, iDocument, iOperation.getFieldName(), (OIdentifiable)role);
    }

    public OIdentifiable allowIdentity(ODatabaseSession session, ODocument iDocument, String iAllowFieldName, OIdentifiable iId) {
        Set field = (Set)iDocument.field(iAllowFieldName);
        if (field == null) {
            field = new ORecordLazySet((ORecordElement)iDocument);
            iDocument.field(iAllowFieldName, (Object)field);
        }
        field.add(iId);
        return iId;
    }

    public ORID getRoleRID(ODatabaseSession session, String iRoleName) {
        if (iRoleName == null) {
            return null;
        }
        try (OResultSet result = session.query("select @rid as rid from ORole where name = ? limit 1", new Object[]{iRoleName});){
            if (result.hasNext()) {
                ORID oRID = (ORID)result.next().getProperty("rid");
                return oRID;
            }
        }
        return null;
    }

    public ORID getUserRID(ODatabaseSession session, String userName) {
        try (OResultSet result = session.query("select @rid as rid from OUser where name = ? limit 1", new Object[]{userName});){
            if (result.hasNext()) {
                ORID oRID = (ORID)result.next().getProperty("rid");
                return oRID;
            }
        }
        return null;
    }

    public OIdentifiable disallowIdentity(ODatabaseSession session, ODocument iDocument, String iAllowFieldName, OIdentifiable iId) {
        Set field = (Set)iDocument.field(iAllowFieldName);
        if (field != null) {
            field.remove(iId);
        }
        return iId;
    }

    public OUser authenticate(ODatabaseSession session, String iUsername, String iUserPassword) {
        throw new UnsupportedOperationException();
    }

    public OUser createUser(ODatabaseSession session, String iUserName, String iUserPassword, String ... iRoles) {
        OUser user = new OUser(iUserName, iUserPassword);
        if (iRoles != null) {
            for (String r : iRoles) {
                user.addRole(r);
            }
        }
        return user.save();
    }

    public OUser createUser(ODatabaseSession session, String userName, String userPassword, ORole ... roles) {
        OUser user = new OUser(userName, userPassword);
        if (roles != null) {
            for (ORole r : roles) {
                user.addRole((OSecurityRole)r);
            }
        }
        return user.save();
    }

    public OUser authenticate(ODatabaseSession session, OToken authToken) {
        throw new UnsupportedOperationException();
    }

    public ORole createRole(ODatabaseSession session, String iRoleName, OSecurityRole.ALLOW_MODES iAllowMode) {
        return this.createRole(session, iRoleName, null, iAllowMode);
    }

    public ORole createRole(ODatabaseSession session, String iRoleName, ORole iParent, OSecurityRole.ALLOW_MODES iAllowMode) {
        ORole role = new ORole(iRoleName, iParent, iAllowMode);
        return role.save();
    }

    public OUser getUser(ODatabaseSession session, String iUserName) {
        try (OResultSet result = session.query("select from OUser where name = ? limit 1", new Object[]{iUserName});){
            if (result.hasNext()) {
                OUser oUser = new OUser((ODocument)result.next().getElement().get());
                return oUser;
            }
        }
        return null;
    }

    public OUser getUser(ODatabaseSession session, ORID iRecordId) {
        if (iRecordId == null) {
            return null;
        }
        ODocument result = (ODocument)session.load(iRecordId, "roles:1");
        if (!result.getClassName().equals("OUser")) {
            result = null;
        }
        return new OUser(result);
    }

    public ORole getRole(ODatabaseSession session, OIdentifiable iRole) {
        OImmutableClass clazz;
        ODocument doc = (ODocument)session.load(iRole.getIdentity());
        if (doc != null && (clazz = ODocumentInternal.getImmutableSchemaClass((ODocument)doc)) != null && clazz.isOrole()) {
            return new ORole(doc);
        }
        return null;
    }

    public ORole getRole(ODatabaseSession session, String iRoleName) {
        if (iRoleName == null) {
            return null;
        }
        try (OResultSet result = session.query("select from ORole where name = ? limit 1", new Object[]{iRoleName});){
            if (result.hasNext()) {
                ORole oRole = new ORole((ODocument)result.next().getElement().get());
                return oRole;
            }
        }
        return null;
    }

    public List<ODocument> getAllUsers(ODatabaseSession session) {
        try (OResultSet rs = session.query("select from OUser", new Object[0]);){
            List<ODocument> list = rs.stream().map(e -> (ODocument)e.getElement().get()).collect(Collectors.toList());
            return list;
        }
    }

    public List<ODocument> getAllRoles(ODatabaseSession session) {
        try (OResultSet rs = session.query("select from ORole", new Object[0]);){
            List<ODocument> list = rs.stream().map(e -> (ODocument)e.getElement().get()).collect(Collectors.toList());
            return list;
        }
    }

    public Map<String, OSecurityPolicy> getSecurityPolicies(ODatabaseSession session, OSecurityRole role) {
        throw new UnsupportedOperationException();
    }

    public OSecurityPolicy getSecurityPolicy(ODatabaseSession session, OSecurityRole role, String resource) {
        throw new UnsupportedOperationException();
    }

    public void setSecurityPolicy(ODatabaseSession session, OSecurityRole role, String resource, OSecurityPolicyImpl policy) {
        throw new UnsupportedOperationException();
    }

    public OSecurityPolicyImpl createSecurityPolicy(ODatabaseSession session, String name) {
        throw new UnsupportedOperationException();
    }

    public OSecurityPolicyImpl getSecurityPolicy(ODatabaseSession session, String name) {
        throw new UnsupportedOperationException();
    }

    public void saveSecurityPolicy(ODatabaseSession session, OSecurityPolicyImpl policy) {
        throw new UnsupportedOperationException();
    }

    public void deleteSecurityPolicy(ODatabaseSession session, String name) {
        throw new UnsupportedOperationException();
    }

    public void removeSecurityPolicy(ODatabaseSession session, ORole role, String resource) {
        throw new UnsupportedOperationException();
    }

    public boolean dropUser(ODatabaseSession session, String iUserName) {
        Number removed = (Number)session.command("delete from OUser where name = ?", new Object[]{iUserName}).next().getProperty("count");
        return removed != null && removed.intValue() > 0;
    }

    public boolean dropRole(ODatabaseSession session, String iRoleName) {
        Number removed = (Number)session.command("delete from ORole where name = '" + iRoleName + "'", new Object[0]).next().getProperty("count");
        return removed != null && removed.intValue() > 0;
    }

    public void createClassTrigger(ODatabaseSession session) {
        throw new UnsupportedOperationException();
    }

    public long getVersion(ODatabaseSession session) {
        return 0L;
    }

    public void incrementVersion(ODatabaseSession session) {
        throw new UnsupportedOperationException();
    }

    public OUser create(ODatabaseSession session) {
        throw new UnsupportedOperationException();
    }

    public void load(ODatabaseSession session) {
    }

    public void close() {
    }

    public Set<String> getFilteredProperties(ODatabaseSession session, ODocument document) {
        return Collections.emptySet();
    }

    public boolean isAllowedWrite(ODatabaseSession session, ODocument document, String propertyName) {
        return true;
    }

    public boolean canCreate(ODatabaseSession session, ORecord record) {
        return true;
    }

    public boolean canRead(ODatabaseSession session, ORecord record) {
        return true;
    }

    public boolean canUpdate(ODatabaseSession session, ORecord record) {
        return true;
    }

    public boolean canDelete(ODatabaseSession session, ORecord record) {
        return true;
    }

    public boolean canExecute(ODatabaseSession session, OFunction function) {
        return true;
    }

    public boolean isReadRestrictedBySecurityPolicy(ODatabaseSession session, String resource) {
        return false;
    }

    public Set<OSecurityResourceProperty> getAllFilteredProperties(ODatabaseDocumentInternal database) {
        return Collections.EMPTY_SET;
    }

    public OSecurityUser securityAuthenticate(ODatabaseSession session, String userName, String password) {
        throw new UnsupportedOperationException();
    }

    public OSecurityUser securityAuthenticate(ODatabaseSession session, OAuthenticationInfo authenticationInfo) {
        throw new UnsupportedOperationException();
    }
}

