/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.common.concur.resource.OResourcePool;
import com.orientechnologies.common.concur.resource.OResourcePoolListener;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.client.binary.OChannelBinaryAsynchClient;
import com.orientechnologies.orient.core.config.OContextConfiguration;

public class ORemoteConnectionPool
implements OResourcePoolListener<String, OChannelBinaryAsynchClient> {
    private OResourcePool<String, OChannelBinaryAsynchClient> pool;

    public ORemoteConnectionPool(int iMaxResources) {
        this.pool = new OResourcePool(iMaxResources, (OResourcePoolListener)this);
    }

    protected OChannelBinaryAsynchClient createNetworkConnection(String serverURL, OContextConfiguration clientConfiguration) throws OIOException {
        if (serverURL == null) {
            throw new IllegalArgumentException("server url is null");
        }
        try {
            OLogManager.instance().debug((Object)this, "Trying to connect to the remote host %s...", new Object[]{serverURL});
            int sepPos = serverURL.indexOf(":");
            String remoteHost = serverURL.substring(0, sepPos);
            int remotePort = Integer.parseInt(serverURL.substring(sepPos + 1));
            OChannelBinaryAsynchClient ch = new OChannelBinaryAsynchClient(remoteHost, remotePort, clientConfiguration, 38);
            return ch;
        }
        catch (OIOException e) {
            throw e;
        }
        catch (Exception e) {
            OLogManager.instance().debug((Object)this, "Error on connecting to %s", (Throwable)e, new Object[]{serverURL});
            throw OException.wrapException((OException)new OIOException("Error on connecting to " + serverURL), (Throwable)e);
        }
    }

    public OChannelBinaryAsynchClient createNewResource(String iKey, Object ... iAdditionalArgs) {
        return this.createNetworkConnection(iKey, (OContextConfiguration)iAdditionalArgs[0]);
    }

    public boolean reuseResource(String iKey, Object[] iAdditionalArgs, OChannelBinaryAsynchClient iValue) {
        boolean canReuse = iValue.isConnected();
        if (!canReuse) {
            try {
                iValue.close();
            }
            catch (Exception e) {
                OLogManager.instance().debug((Object)this, "Error on closing socket connection", (Throwable)e, new Object[0]);
            }
        }
        iValue.markInUse();
        return canReuse;
    }

    public OResourcePool<String, OChannelBinaryAsynchClient> getPool() {
        return this.pool;
    }

    public OChannelBinaryAsynchClient acquire(String iServerURL, long timeout, OContextConfiguration clientConfiguration) {
        return (OChannelBinaryAsynchClient)((Object)this.pool.getResource((Object)iServerURL, timeout, new Object[]{clientConfiguration}));
    }

    public void checkIdle(long timeout) {
        for (OChannelBinaryAsynchClient resource : this.pool.getResources()) {
            if (resource.isInUse() || resource.getLastUse() + timeout >= System.currentTimeMillis()) continue;
            resource.close();
        }
    }
}

