/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.thread.OThreadPoolExecutors;
import com.orientechnologies.orient.client.binary.OChannelBinaryAsynchClient;
import com.orientechnologies.orient.client.remote.OBinaryRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.ODatabaseDocumentRemotePooled;
import com.orientechnologies.orient.client.remote.ORemoteConnectionManager;
import com.orientechnologies.orient.client.remote.ORemoteQueryResult;
import com.orientechnologies.orient.client.remote.ORemoteURLs;
import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.client.remote.OStorageRemoteNodeSession;
import com.orientechnologies.orient.client.remote.OStorageRemoteOperation;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.db.document.ODatabaseDocumentRemote;
import com.orientechnologies.orient.client.remote.db.document.OSharedContextRemote;
import com.orientechnologies.orient.client.remote.message.OConnect37Request;
import com.orientechnologies.orient.client.remote.message.OConnectResponse;
import com.orientechnologies.orient.client.remote.message.OCreateDatabaseRequest;
import com.orientechnologies.orient.client.remote.message.OCreateDatabaseResponse;
import com.orientechnologies.orient.client.remote.message.ODistributedStatusRequest;
import com.orientechnologies.orient.client.remote.message.ODistributedStatusResponse;
import com.orientechnologies.orient.client.remote.message.ODropDatabaseRequest;
import com.orientechnologies.orient.client.remote.message.ODropDatabaseResponse;
import com.orientechnologies.orient.client.remote.message.OExistsDatabaseRequest;
import com.orientechnologies.orient.client.remote.message.OExistsDatabaseResponse;
import com.orientechnologies.orient.client.remote.message.OFreezeDatabaseRequest;
import com.orientechnologies.orient.client.remote.message.OFreezeDatabaseResponse;
import com.orientechnologies.orient.client.remote.message.OGetGlobalConfigurationRequest;
import com.orientechnologies.orient.client.remote.message.OGetGlobalConfigurationResponse;
import com.orientechnologies.orient.client.remote.message.OListDatabasesRequest;
import com.orientechnologies.orient.client.remote.message.OListDatabasesResponse;
import com.orientechnologies.orient.client.remote.message.OListGlobalConfigurationsRequest;
import com.orientechnologies.orient.client.remote.message.OListGlobalConfigurationsResponse;
import com.orientechnologies.orient.client.remote.message.OReleaseDatabaseRequest;
import com.orientechnologies.orient.client.remote.message.OReleaseDatabaseResponse;
import com.orientechnologies.orient.client.remote.message.ORemoteResultSet;
import com.orientechnologies.orient.client.remote.message.OServerInfoRequest;
import com.orientechnologies.orient.client.remote.message.OServerInfoResponse;
import com.orientechnologies.orient.client.remote.message.OServerQueryRequest;
import com.orientechnologies.orient.client.remote.message.OServerQueryResponse;
import com.orientechnologies.orient.client.remote.message.OSetGlobalConfigurationRequest;
import com.orientechnologies.orient.client.remote.message.OSetGlobalConfigurationResponse;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.OCachedDatabasePoolFactory;
import com.orientechnologies.orient.core.db.OCachedDatabasePoolFactoryImpl;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabasePoolImpl;
import com.orientechnologies.orient.core.db.ODatabasePoolInternal;
import com.orientechnologies.orient.core.db.ODatabaseTask;
import com.orientechnologies.orient.core.db.ODatabaseType;
import com.orientechnologies.orient.core.db.OSharedContext;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.db.OrientDBInternal;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.metadata.security.auth.OAuthenticationInfo;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.security.OCredentialInterceptor;
import com.orientechnologies.orient.core.security.OSecurityManager;
import com.orientechnologies.orient.core.security.OSecuritySystem;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerNetworkV37Client;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageInfo;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class OrientDBRemote
implements OrientDBInternal {
    protected final Map<String, OSharedContext> sharedContexts = new HashMap<String, OSharedContext>();
    private final Map<String, OStorageRemote> storages = new HashMap<String, OStorageRemote>();
    private final Set<ODatabasePoolInternal> pools = new HashSet<ODatabasePoolInternal>();
    private final String[] hosts;
    private final OrientDBConfig configurations;
    private final Orient orient;
    private final OCachedDatabasePoolFactory cachedPoolFactory;
    protected volatile ORemoteConnectionManager connectionManager;
    private volatile boolean open = true;
    private final Timer timer;
    private final ORemoteURLs urls;
    private final ExecutorService executor;

    public OrientDBRemote(String[] hosts, OrientDBConfig configurations, Orient orient) {
        this.hosts = hosts;
        this.orient = orient;
        this.configurations = configurations != null ? configurations : OrientDBConfig.defaultConfig();
        this.timer = new Timer("Remote background operations timer", true);
        this.connectionManager = new ORemoteConnectionManager(this.configurations.getConfigurations(), this.timer);
        orient.addOrientDB((OrientDBInternal)this);
        this.cachedPoolFactory = this.createCachedDatabasePoolFactory(this.configurations);
        this.urls = new ORemoteURLs(hosts, this.configurations.getConfigurations());
        int size = this.configurations.getConfigurations().getValueAsInteger(OGlobalConfiguration.EXECUTOR_POOL_MAX_SIZE);
        if (size == -1) {
            size = Runtime.getRuntime().availableProcessors() / 2;
        }
        this.executor = OThreadPoolExecutors.newScalingThreadPool((String)"OrientDBRemote", (int)0, (int)size, (int)100, (long)1L, (TimeUnit)TimeUnit.MINUTES);
    }

    protected OCachedDatabasePoolFactory createCachedDatabasePoolFactory(OrientDBConfig config) {
        int capacity = config.getConfigurations().getValueAsInteger(OGlobalConfiguration.DB_CACHED_POOL_CAPACITY);
        long timeout = config.getConfigurations().getValueAsInteger(OGlobalConfiguration.DB_CACHED_POOL_CLEAN_UP_TIMEOUT);
        return new OCachedDatabasePoolFactoryImpl((OrientDBInternal)this, capacity, timeout);
    }

    private String buildUrl(String name) {
        return String.join((CharSequence)";", this.hosts) + "/" + name;
    }

    public ODatabaseDocumentInternal open(String name, String user, String password) {
        return this.open(name, user, password, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODatabaseDocumentInternal open(String name, String user, String password, OrientDBConfig config) {
        this.checkOpen();
        OrientDBConfig resolvedConfig = this.solveConfig(config);
        try {
            OStorageRemote storage;
            OrientDBRemote orientDBRemote = this;
            synchronized (orientDBRemote) {
                storage = this.storages.get(name);
                if (storage == null) {
                    storage = new OStorageRemote(this.urls, name, this, "rw", this.connectionManager, resolvedConfig);
                    this.storages.put(name, storage);
                }
            }
            ODatabaseDocumentRemote db = new ODatabaseDocumentRemote(storage, this.getOrCreateSharedContext(storage));
            db.internalOpen(user, password, resolvedConfig);
            return db;
        }
        catch (Exception e) {
            throw OException.wrapException((OException)new ODatabaseException("Cannot open database '" + name + "'"), (Throwable)e);
        }
    }

    public ODatabaseDocumentInternal open(OAuthenticationInfo authenticationInfo, OrientDBConfig config) {
        throw new UnsupportedOperationException();
    }

    public void create(String name, String user, String password, ODatabaseType databaseType) {
        this.create(name, user, password, databaseType, null);
    }

    public synchronized void create(String name, String user, String password, ODatabaseType databaseType, OrientDBConfig config) {
        config = this.solveConfig(config);
        if (name == null || name.length() <= 0 || name.contains("`")) {
            String message = "Cannot create unnamed remote storage. Check your syntax";
            OLogManager.instance().error((Object)this, "Cannot create unnamed remote storage. Check your syntax", null, new Object[0]);
            throw new OStorageException("Cannot create unnamed remote storage. Check your syntax");
        }
        String create = String.format("CREATE DATABASE `%s` %s ", name, databaseType.name());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Set keys = config.getConfigurations().getContextKeys();
        if (!keys.isEmpty()) {
            ArrayList<String> entries = new ArrayList<String>();
            for (String key : keys) {
                OGlobalConfiguration globalKey = OGlobalConfiguration.findByKey((String)key);
                entries.add(String.format("\"%s\": :%s", key, globalKey.name()));
                parameters.put(globalKey.name(), config.getConfigurations().getValue(globalKey));
            }
            create = create + String.format("{\"config\":{%s}}", String.join((CharSequence)",", entries));
        }
        this.executeServerStatement(create, user, password, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODatabaseDocumentRemotePooled poolOpen(String name, String user, String password, ODatabasePoolInternal pool) {
        OStorageRemote storage;
        OrientDBRemote orientDBRemote = this;
        synchronized (orientDBRemote) {
            storage = this.storages.get(name);
            if (storage == null) {
                try {
                    storage = new OStorageRemote(this.urls, name, this, "rw", this.connectionManager, this.solveConfig(pool.getConfig()));
                    this.storages.put(name, storage);
                }
                catch (Exception e) {
                    throw OException.wrapException((OException)new ODatabaseException("Cannot open database '" + name + "'"), (Throwable)e);
                }
            }
        }
        ODatabaseDocumentRemotePooled db = new ODatabaseDocumentRemotePooled(pool, storage, this.getOrCreateSharedContext(storage));
        db.internalOpen(user, password, pool.getConfig());
        return db;
    }

    public synchronized void closeStorage(OStorageRemote remote) {
        OSharedContext ctx = this.sharedContexts.get(remote.getName());
        if (ctx != null) {
            ctx.close();
            this.sharedContexts.remove(remote.getName());
        }
        this.storages.remove(remote.getName());
        remote.shutdown();
    }

    public ODocument getServerInfo(String username, String password) {
        OServerInfoRequest request = new OServerInfoRequest();
        OServerInfoResponse response = this.connectAndSend(null, username, password, request);
        ODocument res = new ODocument();
        res.fromJSON(response.getResult());
        return res;
    }

    public ODocument getClusterStatus(String username, String password) {
        ODistributedStatusRequest request = new ODistributedStatusRequest();
        ODistributedStatusResponse response = this.connectAndSend(null, username, password, request);
        OLogManager.instance().debug((Object)this, "Cluster status %s", new Object[]{response.getClusterConfig().toJSON("prettyPrint")});
        return response.getClusterConfig();
    }

    public String getGlobalConfiguration(String username, String password, OGlobalConfiguration config) {
        OGetGlobalConfigurationRequest request = new OGetGlobalConfigurationRequest(config.getKey());
        OGetGlobalConfigurationResponse response = this.connectAndSend(null, username, password, request);
        return response.getValue();
    }

    public void setGlobalConfiguration(String username, String password, OGlobalConfiguration config, String iConfigValue) {
        String value = iConfigValue != null ? iConfigValue : "";
        OSetGlobalConfigurationRequest request = new OSetGlobalConfigurationRequest(config.getKey(), value);
        OSetGlobalConfigurationResponse response = this.connectAndSend(null, username, password, request);
    }

    public Map<String, String> getGlobalConfigurations(String username, String password) {
        OListGlobalConfigurationsRequest request = new OListGlobalConfigurationsRequest();
        OListGlobalConfigurationsResponse response = this.connectAndSend(null, username, password, request);
        return response.getConfigs();
    }

    public ORemoteConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public synchronized boolean exists(String name, String user, String password) {
        OExistsDatabaseRequest request = new OExistsDatabaseRequest(name, null);
        OExistsDatabaseResponse response = this.connectAndSend(name, user, password, request);
        return response.isExists();
    }

    public synchronized void drop(String name, String user, String password) {
        ODropDatabaseRequest request = new ODropDatabaseRequest(name, null);
        ODropDatabaseResponse response = this.connectAndSend(name, user, password, request);
        OSharedContext ctx = this.sharedContexts.get(name);
        if (ctx != null) {
            ctx.close();
            this.sharedContexts.remove(name);
        }
        this.storages.remove(name);
    }

    public void internalDrop(String database) {
        throw new UnsupportedOperationException();
    }

    public Set<String> listDatabases(String user, String password) {
        return this.getDatabases(user, password).keySet();
    }

    public Map<String, String> getDatabases(String user, String password) {
        OListDatabasesRequest request = new OListDatabasesRequest();
        OListDatabasesResponse response = this.connectAndSend(null, user, password, request);
        return response.getDatabases();
    }

    public void restore(String name, String user, String password, ODatabaseType type, String path, OrientDBConfig config) {
        if (name == null || name.length() <= 0) {
            String message = "Cannot create unnamed remote storage. Check your syntax";
            OLogManager.instance().error((Object)this, "Cannot create unnamed remote storage. Check your syntax", null, new Object[0]);
            throw new OStorageException("Cannot create unnamed remote storage. Check your syntax");
        }
        OCreateDatabaseRequest request = new OCreateDatabaseRequest(name, type.name().toLowerCase(), null, path);
        OCreateDatabaseResponse response = this.connectAndSend(name, user, password, request);
    }

    public <T extends OBinaryResponse> T connectAndSend(String name, String user, String password, OBinaryRequest<T> request) {
        return (T)this.connectAndExecute(name, user, password, session -> this.networkAdminOperation(request, session, "Error sending request:" + request.getDescription()));
    }

    public ODatabasePoolInternal openPool(String name, String user, String password) {
        return this.openPool(name, user, password, null);
    }

    public ODatabasePoolInternal openPool(String name, String user, String password, OrientDBConfig config) {
        this.checkOpen();
        ODatabasePoolImpl pool = new ODatabasePoolImpl((OrientDBInternal)this, name, user, password, this.solveConfig(config));
        this.pools.add((ODatabasePoolInternal)pool);
        return pool;
    }

    public ODatabasePoolInternal cachedPool(String database, String user, String password) {
        return this.cachedPool(database, user, password, null);
    }

    public ODatabasePoolInternal cachedPool(String database, String user, String password, OrientDBConfig config) {
        this.checkOpen();
        ODatabasePoolInternal pool = this.cachedPoolFactory.get(database, user, password, this.solveConfig(config));
        this.pools.add(pool);
        return pool;
    }

    public void removePool(ODatabasePoolInternal pool) {
        this.pools.remove(pool);
    }

    public void close() {
        if (!this.open) {
            return;
        }
        this.timer.cancel();
        this.removeShutdownHook();
        this.internalClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalClose() {
        ArrayList<OStorageRemote> storagesCopy;
        if (!this.open) {
            return;
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        Object object = this;
        synchronized (object) {
            this.open = false;
            this.sharedContexts.values().forEach(x -> x.close());
            storagesCopy = new ArrayList<OStorageRemote>(this.storages.values());
        }
        for (OStorageRemote stg : storagesCopy) {
            try {
                OLogManager.instance().info((Object)this, "- shutdown storage: %s ...", new Object[]{stg.getName()});
                stg.shutdown();
            }
            catch (Exception e) {
                OLogManager.instance().warn((Object)this, "-- error on shutdown storage", (Throwable)e, new Object[0]);
            }
            catch (Error e) {
                OLogManager.instance().warn((Object)this, "-- error on shutdown storage", (Throwable)e, new Object[0]);
                throw e;
            }
        }
        object = this;
        synchronized (object) {
            this.sharedContexts.clear();
            this.storages.clear();
            this.connectionManager.close();
        }
    }

    private OrientDBConfig solveConfig(OrientDBConfig config) {
        if (config != null) {
            config.setParent(this.configurations);
            return config;
        }
        OrientDBConfig cfg = OrientDBConfig.defaultConfig();
        cfg.setParent(this.configurations);
        return cfg;
    }

    private void checkOpen() {
        if (!this.open) {
            throw new ODatabaseException("OrientDB Instance is closed");
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isEmbedded() {
        return false;
    }

    public void removeShutdownHook() {
        this.orient.removeOrientDB((OrientDBInternal)this);
    }

    public void loadAllDatabases() {
    }

    public ODatabaseDocumentInternal openNoAuthenticate(String iDbUrl, String user) {
        throw new UnsupportedOperationException("Open with no authentication is not supported in remote");
    }

    public void initCustomStorage(String name, String baseUrl, String userName, String userPassword) {
        throw new UnsupportedOperationException("Custom storage is not supported in remote");
    }

    public Collection<OStorage> getStorages() {
        throw new UnsupportedOperationException("List storage is not supported in remote");
    }

    public synchronized void forceDatabaseClose(String databaseName) {
        OStorageRemote remote = this.storages.get(databaseName);
        if (remote != null) {
            this.closeStorage(remote);
        }
    }

    public void restore(String name, InputStream in, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener) {
        throw new UnsupportedOperationException("raw restore is not supported in remote");
    }

    public ODatabaseDocumentInternal openNoAuthorization(String name) {
        throw new UnsupportedOperationException("impossible skip authentication and authorization in remote");
    }

    protected synchronized OSharedContext getOrCreateSharedContext(OStorageRemote storage) {
        OSharedContext result = this.sharedContexts.get(storage.getName());
        if (result == null) {
            result = this.createSharedContext(storage);
            this.sharedContexts.put(storage.getName(), result);
        }
        return result;
    }

    private OSharedContext createSharedContext(OStorageRemote storage) {
        OSharedContextRemote context = new OSharedContextRemote((OStorageInfo)storage, this);
        storage.setSharedContext(context);
        return context;
    }

    public void schedule(TimerTask task, long delay, long period) {
        this.timer.schedule(task, delay, period);
    }

    public void scheduleOnce(TimerTask task, long delay) {
        this.timer.schedule(task, delay);
    }

    public <X> Future<X> executeNoAuthorization(String database, ODatabaseTask<X> task) {
        throw new UnsupportedOperationException("execute with no session not available in remote");
    }

    public <X> Future<X> execute(String database, String user, ODatabaseTask<X> task) {
        throw new UnsupportedOperationException("execute with no session not available in remote");
    }

    public Future<?> execute(Runnable task) {
        return this.executor.submit(task);
    }

    public <X> Future<X> execute(Callable<X> task) {
        return this.executor.submit(task);
    }

    public void releaseDatabase(String database, String user, String password) {
        OReleaseDatabaseRequest request = new OReleaseDatabaseRequest(database, null);
        OReleaseDatabaseResponse response = this.connectAndSend(database, user, password, request);
    }

    public void freezeDatabase(String database, String user, String password) {
        OFreezeDatabaseRequest request = new OFreezeDatabaseRequest(database, null);
        OFreezeDatabaseResponse response = this.connectAndSend(database, user, password, request);
    }

    public OResultSet executeServerStatement(String statement, String user, String pw, Object ... params) {
        int recordsPerPage = this.getContextConfiguration().getValueAsInteger(OGlobalConfiguration.QUERY_REMOTE_RESULTSET_PAGE_SIZE);
        if (recordsPerPage <= 0) {
            recordsPerPage = 100;
        }
        OServerQueryRequest request = new OServerQueryRequest("sql", statement, params, OServerQueryRequest.COMMAND, (ORecordSerializer)ORecordSerializerNetworkV37Client.INSTANCE, recordsPerPage);
        OServerQueryResponse response = this.connectAndSend(null, user, pw, request);
        ORemoteResultSet rs = new ORemoteResultSet(null, response.getQueryId(), response.getResult(), response.getExecutionPlan(), response.getQueryStats(), response.isHasNextPage());
        return new ORemoteQueryResult(rs, response.isTxChanges(), response.isReloadMetadata()).getResult();
    }

    public OResultSet executeServerStatement(String statement, String user, String pw, Map<String, Object> params) {
        int recordsPerPage = this.getContextConfiguration().getValueAsInteger(OGlobalConfiguration.QUERY_REMOTE_RESULTSET_PAGE_SIZE);
        if (recordsPerPage <= 0) {
            recordsPerPage = 100;
        }
        OServerQueryRequest request = new OServerQueryRequest("sql", statement, params, OServerQueryRequest.COMMAND, (ORecordSerializer)ORecordSerializerNetworkV37Client.INSTANCE, recordsPerPage);
        OServerQueryResponse response = this.connectAndSend(null, user, pw, request);
        ORemoteResultSet rs = new ORemoteResultSet(null, response.getQueryId(), response.getResult(), response.getExecutionPlan(), response.getQueryStats(), response.isHasNextPage());
        return new ORemoteQueryResult(rs, response.isTxChanges(), response.isReloadMetadata()).getResult();
    }

    public OContextConfiguration getContextConfiguration() {
        return this.configurations.getConfigurations();
    }

    public <T extends OBinaryResponse> T networkAdminOperation(final OBinaryRequest<T> request, OStorageRemoteSession session, String errorMessage) {
        return (T)((OBinaryResponse)this.networkAdminOperation(new OStorageRemoteOperation<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T execute(OChannelBinaryAsynchClient network, OStorageRemoteSession session) throws IOException {
                try {
                    network.beginRequest(request.getCommand(), session);
                    request.write((OChannelDataOutput)network, session);
                }
                finally {
                    network.endRequest();
                }
                Object response = request.createResponse();
                try {
                    OStorageRemote.beginResponse(network, session);
                    response.read((OChannelDataInput)network, session);
                }
                finally {
                    network.endResponse();
                }
                return response;
            }
        }, errorMessage, session));
    }

    public <T> T networkAdminOperation(OStorageRemoteOperation<T> operation, String errorMessage, OStorageRemoteSession session) {
        OChannelBinaryAsynchClient network = null;
        OContextConfiguration config = this.getContextConfiguration();
        try {
            String serverUrl = this.urls.getNextAvailableServerURL(false, session, config, OStorageRemote.CONNECTION_STRATEGY.STICKY);
            do {
                try {
                    network = OStorageRemote.getNetwork(serverUrl, this.connectionManager, config);
                }
                catch (OException e) {
                    serverUrl = this.urls.removeAndGet(serverUrl);
                    if (serverUrl != null) continue;
                    throw e;
                }
            } while (network == null);
            T res = operation.execute(network, session);
            this.connectionManager.release(network);
            return res;
        }
        catch (Exception e) {
            if (network != null) {
                this.connectionManager.release(network);
            }
            session.closeAllSessions(this.connectionManager, config);
            throw OException.wrapException((OException)new OStorageException(errorMessage), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T connectAndExecute(String name, String user, String password, SessionOperation<T> operation) {
        this.checkOpen();
        OStorageRemoteSession newSession = new OStorageRemoteSession(-1);
        int retry = this.configurations.getConfigurations().getValueAsInteger(OGlobalConfiguration.NETWORK_SOCKET_RETRY);
        while (retry > 0) {
            try {
                T result;
                String foundPassword;
                String username;
                OCredentialInterceptor ci = OSecurityManager.instance().newCredentialInterceptor();
                String url = this.buildUrl(name);
                if (ci != null) {
                    ci.intercept(url, user, password);
                    username = ci.getUsername();
                    foundPassword = ci.getPassword();
                } else {
                    username = user;
                    foundPassword = password;
                }
                OConnect37Request request = new OConnect37Request(username, foundPassword);
                this.networkAdminOperation((OChannelBinaryAsynchClient network, OStorageRemoteSession session) -> {
                    OStorageRemoteNodeSession nodeSession = session.getOrCreateServerSession(network.getServerURL());
                    try {
                        network.beginRequest(request.getCommand(), session);
                        request.write((OChannelDataOutput)network, session);
                    }
                    finally {
                        network.endRequest();
                    }
                    OConnectResponse response = request.createResponse();
                    try {
                        network.beginResponse(nodeSession.getSessionId(), true);
                        response.read((OChannelDataInput)network, session);
                    }
                    finally {
                        network.endResponse();
                    }
                    return null;
                }, "Cannot connect to the remote server/database '" + url + "'", newSession);
                T t = result = operation.execute(newSession);
                return t;
            }
            catch (IOException e) {
                if (--retry != 0) continue;
                throw OException.wrapException((OException)new ODatabaseException("Reached maximum retry limit on admin operations, the server may be offline"), (Throwable)e);
            }
            finally {
                newSession.closeAllSessions(this.connectionManager, this.configurations.getConfigurations());
            }
        }
        throw new ODatabaseException("Reached maximum retry limit on admin operations, the server may be offline");
    }

    public OrientDBConfig getConfigurations() {
        return this.configurations;
    }

    public OSecuritySystem getSecuritySystem() {
        throw new UnsupportedOperationException();
    }

    public void create(String name, String user, String password, ODatabaseType type, OrientDBConfig config, ODatabaseTask<Void> createOps) {
        throw new UnsupportedOperationException();
    }

    public String getConnectionUrl() {
        return "remote:" + String.join((CharSequence)";", this.urls.getUrls());
    }

    private static interface SessionOperation<T> {
        public T execute(OStorageRemoteSession var1) throws IOException;
    }
}

