/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.client.remote.db.document.ODatabaseDocumentRemote;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ORemoteResultSet
implements OResultSet {
    private final ODatabaseDocumentRemote db;
    private final String queryId;
    private List<OResultInternal> currentPage;
    private Optional<OExecutionPlan> executionPlan;
    private Map<String, Long> queryStats;
    private boolean hasNextPage;

    public ORemoteResultSet(ODatabaseDocumentRemote db, String queryId, List<OResultInternal> currentPage, Optional<OExecutionPlan> executionPlan, Map<String, Long> queryStats, boolean hasNextPage) {
        this.db = db;
        this.queryId = queryId;
        this.currentPage = currentPage;
        this.executionPlan = executionPlan;
        this.queryStats = queryStats;
        this.hasNextPage = hasNextPage;
        if (db != null) {
            db.queryStarted(queryId, this);
            for (OResultInternal result : currentPage) {
                result.bindToCache((ODatabaseDocumentInternal)db);
            }
        }
    }

    public boolean hasNext() {
        if (!this.currentPage.isEmpty()) {
            return true;
        }
        if (!this.hasNextPage()) {
            return false;
        }
        this.fetchNextPage();
        return !this.currentPage.isEmpty();
    }

    private void fetchNextPage() {
        if (this.db != null) {
            this.db.fetchNextPage(this);
        }
    }

    public OResult next() {
        ORecord record;
        if (this.currentPage.isEmpty()) {
            if (!this.hasNextPage()) {
                throw new IllegalStateException();
            }
            this.fetchNextPage();
        }
        if (this.currentPage.isEmpty()) {
            throw new IllegalStateException();
        }
        OResultInternal internal = this.currentPage.remove(0);
        if (internal.isRecord() && this.db != null && this.db.getTransaction().isActive() && (record = this.db.getTransaction().getRecord(((ORecord)internal.getRecord().get()).getIdentity())) != null) {
            internal = new OResultInternal((OIdentifiable)record);
        }
        return internal;
    }

    public void close() {
        if (this.hasNextPage && this.db != null) {
            this.db.closeQuery(this.queryId);
        }
    }

    public Optional<OExecutionPlan> getExecutionPlan() {
        return this.executionPlan;
    }

    public Map<String, Long> getQueryStats() {
        return this.queryStats;
    }

    public void add(OResultInternal item) {
        this.currentPage.add(item);
    }

    public boolean hasNextPage() {
        return this.hasNextPage;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public void fetched(List<OResultInternal> result, boolean hasNextPage, Optional<OExecutionPlan> executionPlan, Map<String, Long> queryStats) {
        this.currentPage = result;
        this.hasNextPage = hasNextPage;
        if (queryStats != null) {
            this.queryStats = queryStats;
        }
        executionPlan.ifPresent(x -> {
            this.executionPlan = executionPlan;
        });
    }
}

