/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.client.binary.OChannelBinaryAsynchClient;
import com.orientechnologies.orient.client.remote.ORemoteConnectionPool;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

public class ORemoteConnectionManager {
    public static final String PARAM_MAX_POOL = "maxpool";
    protected final ConcurrentMap<String, ORemoteConnectionPool> connections = new ConcurrentHashMap<String, ORemoteConnectionPool>();
    protected final long timeout;
    protected final long idleTimeout;
    private final TimerTask idleTask;

    public ORemoteConnectionManager(OContextConfiguration clientConfiguration, Timer timer) {
        this.timeout = clientConfiguration.getValueAsLong(OGlobalConfiguration.NETWORK_LOCK_TIMEOUT);
        int idleSecs = clientConfiguration.getValueAsInteger(OGlobalConfiguration.CLIENT_CHANNEL_IDLE_TIMEOUT);
        this.idleTimeout = TimeUnit.MILLISECONDS.convert(idleSecs, TimeUnit.SECONDS);
        if (clientConfiguration.getValueAsBoolean(OGlobalConfiguration.CLIENT_CHANNEL_IDLE_CLOSE)) {
            this.idleTask = new TimerTask(){

                @Override
                public void run() {
                    ORemoteConnectionManager.this.checkIdle();
                }
            };
            long delay = this.idleTimeout / 3L;
            timer.schedule(this.idleTask, delay, delay);
        } else {
            this.idleTask = null;
        }
    }

    public void close() {
        for (Map.Entry entry : this.connections.entrySet()) {
            this.closePool((ORemoteConnectionPool)entry.getValue());
        }
        this.connections.clear();
        if (this.idleTask != null) {
            this.idleTask.cancel();
        }
    }

    public OChannelBinaryAsynchClient acquire(String iServerURL, OContextConfiguration clientConfiguration) {
        long localTimeout = this.timeout;
        ORemoteConnectionPool pool = (ORemoteConnectionPool)this.connections.get(iServerURL);
        if (pool == null) {
            ORemoteConnectionPool prev;
            int maxPool = 8;
            if (clientConfiguration != null) {
                Object netLockTimeout;
                Object max = clientConfiguration.getValue(OGlobalConfiguration.CLIENT_CHANNEL_MAX_POOL);
                if (max != null) {
                    maxPool = Integer.parseInt(max.toString());
                }
                if ((netLockTimeout = clientConfiguration.getValue(OGlobalConfiguration.NETWORK_LOCK_TIMEOUT)) != null) {
                    localTimeout = Integer.parseInt(netLockTimeout.toString());
                }
            }
            if ((prev = this.connections.putIfAbsent(iServerURL, pool = new ORemoteConnectionPool(maxPool))) != null) {
                pool.getPool().close();
                pool = prev;
            }
        }
        try {
            OChannelBinaryAsynchClient ret = pool.acquire(iServerURL, localTimeout, clientConfiguration);
            ret.markInUse();
            return ret;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            OLogManager.instance().debug((Object)this, "Error on retrieving the connection from pool: " + iServerURL, (Throwable)e, new Object[0]);
            return null;
        }
    }

    public void release(OChannelBinaryAsynchClient conn) {
        if (conn == null) {
            return;
        }
        conn.markReturned();
        ORemoteConnectionPool pool = (ORemoteConnectionPool)this.connections.get(conn.getServerURL());
        if (pool != null) {
            if (!conn.isConnected()) {
                OLogManager.instance().debug((Object)this, "Network connection pool is receiving a closed connection to reuse: discard it", new Object[0]);
                this.remove(conn);
            } else {
                pool.getPool().returnResource((Object)conn);
            }
        }
    }

    public void remove(OChannelBinaryAsynchClient conn) {
        if (conn == null) {
            return;
        }
        ORemoteConnectionPool pool = (ORemoteConnectionPool)this.connections.get(conn.getServerURL());
        if (pool == null) {
            throw new IllegalStateException("Connection cannot be released because the pool doesn't exist anymore");
        }
        pool.getPool().remove((Object)conn);
        try {
            conn.unlock();
        }
        catch (Exception e) {
            OLogManager.instance().debug((Object)this, "Cannot unlock connection lock", (Throwable)e, new Object[0]);
        }
        try {
            conn.close();
        }
        catch (Exception e) {
            OLogManager.instance().debug((Object)this, "Cannot close connection", (Throwable)e, new Object[0]);
        }
    }

    public Set<String> getURLs() {
        return this.connections.keySet();
    }

    public int getMaxResources(String url) {
        ORemoteConnectionPool pool = (ORemoteConnectionPool)this.connections.get(url);
        if (pool == null) {
            return 0;
        }
        return pool.getPool().getMaxResources();
    }

    public int getAvailableConnections(String url) {
        ORemoteConnectionPool pool = (ORemoteConnectionPool)this.connections.get(url);
        if (pool == null) {
            return 0;
        }
        return pool.getPool().getAvailableResources();
    }

    public int getReusableConnections(String url) {
        ORemoteConnectionPool pool = (ORemoteConnectionPool)this.connections.get(url);
        if (pool == null) {
            return 0;
        }
        return pool.getPool().getInPoolResources();
    }

    public int getCreatedInstancesInPool(String url) {
        ORemoteConnectionPool pool = (ORemoteConnectionPool)this.connections.get(url);
        if (pool == null) {
            return 0;
        }
        return pool.getPool().getCreatedInstances();
    }

    public void closePool(String url) {
        ORemoteConnectionPool pool = (ORemoteConnectionPool)this.connections.remove(url);
        if (pool == null) {
            return;
        }
        this.closePool(pool);
    }

    protected void closePool(ORemoteConnectionPool pool) {
        ArrayList conns = new ArrayList(pool.getPool().getAllResources());
        for (OChannelBinaryAsynchClient c : conns) {
            try {
                c.close();
            }
            catch (Exception e) {
                OLogManager.instance().debug((Object)this, "Cannot close binary channel", (Throwable)e, new Object[0]);
            }
        }
        pool.getPool().close();
    }

    public ORemoteConnectionPool getPool(String url) {
        return (ORemoteConnectionPool)this.connections.get(url);
    }

    public void checkIdle() {
        for (Map.Entry entry : this.connections.entrySet()) {
            ((ORemoteConnectionPool)entry.getValue()).checkIdle(this.idleTimeout);
        }
    }
}

