/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.metadata.schema;

import com.orientechnologies.orient.client.remote.metadata.schema.OClassRemote;
import com.orientechnologies.orient.client.remote.metadata.schema.OViewRemote;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.ODatabaseLifecycleListener;
import com.orientechnologies.orient.core.db.ODatabaseListener;
import com.orientechnologies.orient.core.db.viewmanager.ViewCreationListener;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OSchemaShared;
import com.orientechnologies.orient.core.metadata.schema.OView;
import com.orientechnologies.orient.core.metadata.schema.OViewConfig;
import com.orientechnologies.orient.core.metadata.schema.OViewImpl;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class OSchemaRemote
extends OSchemaShared {
    private AtomicBoolean skipPush = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClass getOrCreateClass(ODatabaseDocumentInternal database, String iClassName, OClass ... superClasses) {
        OClass cls;
        if (iClassName == null) {
            return null;
        }
        this.acquireSchemaReadLock();
        try {
            cls = (OClass)this.classes.get(iClassName.toLowerCase(Locale.ENGLISH));
            if (cls != null) {
                OClass oClass = cls;
                return oClass;
            }
        }
        finally {
            this.releaseSchemaReadLock();
        }
        int[] clusterIds = null;
        this.acquireSchemaWriteLock(database);
        try {
            cls = (OClass)this.classes.get(iClassName.toLowerCase(Locale.ENGLISH));
            if (cls != null) {
                OClass oClass = cls;
                return oClass;
            }
            cls = this.createClass(database, iClassName, clusterIds, superClasses);
            this.addClusterClassMap(cls);
        }
        finally {
            this.releaseSchemaWriteLock(database);
        }
        return cls;
    }

    protected OClassImpl createClassInstance(ODocument c) {
        return new OClassRemote((OSchemaShared)this, c, (String)c.field("name"));
    }

    protected OViewImpl createViewInstance(ODocument c) {
        return new OViewRemote(this, c, (String)c.field("name"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClass createClass(ODatabaseDocumentInternal database, String className, int[] clusterIds, OClass ... superClasses) {
        OClass result;
        Character wrongCharacter = OSchemaShared.checkClassNameIfValid((String)className);
        if (wrongCharacter != null) {
            throw new OSchemaException("Invalid class name found. Character '" + wrongCharacter + "' cannot be used in class name '" + className + "'");
        }
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_CREATE, new Object[0]);
        if (superClasses != null) {
            OClassImpl.checkParametersConflict(Arrays.asList(superClasses));
        }
        this.acquireSchemaWriteLock(database);
        try {
            String key = className.toLowerCase(Locale.ENGLISH);
            if (this.classes.containsKey(key)) {
                throw new OSchemaException("Class '" + className + "' already exists in current database");
            }
            this.checkClustersAreAbsent(clusterIds);
            StringBuilder cmd = new StringBuilder("create class ");
            cmd.append('`');
            cmd.append(className);
            cmd.append('`');
            ArrayList<OClass> superClassesList = new ArrayList<OClass>();
            if (superClasses != null && superClasses.length > 0) {
                boolean first = true;
                for (OClass superClass : superClasses) {
                    if (superClass == null) continue;
                    if (first) {
                        cmd.append(" extends ");
                    } else {
                        cmd.append(", ");
                    }
                    cmd.append('`').append(superClass.getName()).append('`');
                    first = false;
                    superClassesList.add(superClass);
                }
            }
            if (clusterIds != null) {
                if (clusterIds.length == 1 && clusterIds[0] == -1) {
                    cmd.append(" abstract");
                } else {
                    cmd.append(" cluster ");
                    for (int i = 0; i < clusterIds.length; ++i) {
                        if (i > 0) {
                            cmd.append(',');
                        } else {
                            cmd.append(' ');
                        }
                        cmd.append(clusterIds[i]);
                    }
                }
            }
            database.command(cmd.toString(), new Object[0]).close();
            this.reload(database);
            result = (OClass)this.classes.get(className.toLowerCase(Locale.ENGLISH));
            Iterator it = Orient.instance().getDbLifecycleListeners();
            while (it.hasNext()) {
                ((ODatabaseLifecycleListener)it.next()).onCreateClass((ODatabaseInternal)database, result);
            }
            it = database.getListeners().iterator();
            while (it.hasNext()) {
                ((ODatabaseListener)it.next()).onCreateClass((ODatabase)database, result);
            }
        }
        finally {
            this.releaseSchemaWriteLock(database);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClass createClass(ODatabaseDocumentInternal database, String className, int clusters, OClass ... superClasses) {
        OClass result;
        Character wrongCharacter = OSchemaShared.checkClassNameIfValid((String)className);
        if (wrongCharacter != null) {
            throw new OSchemaException("Invalid class name found. Character '" + wrongCharacter + "' cannot be used in class name '" + className + "'");
        }
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_CREATE, new Object[0]);
        if (superClasses != null) {
            OClassImpl.checkParametersConflict(Arrays.asList(superClasses));
        }
        this.acquireSchemaWriteLock(database);
        try {
            String key = className.toLowerCase(Locale.ENGLISH);
            if (this.classes.containsKey(key)) {
                throw new OSchemaException("Class '" + className + "' already exists in current database");
            }
            StringBuilder cmd = new StringBuilder("create class ");
            cmd.append('`');
            cmd.append(className);
            cmd.append('`');
            ArrayList<OClass> superClassesList = new ArrayList<OClass>();
            if (superClasses != null && superClasses.length > 0) {
                boolean first = true;
                for (OClass superClass : superClasses) {
                    if (superClass == null) continue;
                    if (first) {
                        cmd.append(" extends ");
                    } else {
                        cmd.append(", ");
                    }
                    cmd.append(superClass.getName());
                    first = false;
                    superClassesList.add(superClass);
                }
            }
            if (clusters == 0) {
                cmd.append(" abstract");
            } else {
                cmd.append(" clusters ");
                cmd.append(clusters);
            }
            database.command(cmd.toString(), new Object[0]).close();
            this.reload(database);
            result = (OClass)this.classes.get(className.toLowerCase(Locale.ENGLISH));
            Iterator it = Orient.instance().getDbLifecycleListeners();
            while (it.hasNext()) {
                ((ODatabaseLifecycleListener)it.next()).onCreateClass((ODatabaseInternal)database, result);
            }
            it = database.getListeners().iterator();
            while (it.hasNext()) {
                ((ODatabaseListener)it.next()).onCreateClass((ODatabase)database, result);
            }
        }
        finally {
            this.releaseSchemaWriteLock(database);
        }
        return result;
    }

    public OView createView(ODatabaseDocumentInternal database, OViewConfig cfg, ViewCreationListener listener) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OView createView(ODatabaseDocumentInternal database, OViewConfig cfg) {
        OView result;
        Character wrongCharacter = OSchemaShared.checkClassNameIfValid((String)cfg.getName());
        if (wrongCharacter != null) {
            throw new OSchemaException("Invalid view name found. Character '" + wrongCharacter + "' cannot be used in view name '" + cfg.getName() + "'");
        }
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_CREATE, new Object[0]);
        this.acquireSchemaWriteLock(database);
        try {
            String key = cfg.getName().toLowerCase(Locale.ENGLISH);
            if (this.views.containsKey(key)) {
                throw new OSchemaException("View '" + cfg.getName() + "' already exists in current database");
            }
            StringBuilder cmd = new StringBuilder("create view ");
            cmd.append('`');
            cmd.append(cfg.getName());
            cmd.append('`');
            cmd.append(" FROM (" + cfg.getQuery() + ") ");
            if (cfg.isUpdatable()) {
                cmd.append(" UPDATABLE");
            }
            database.command(cmd.toString(), new Object[0]).close();
            this.reload(database);
            result = (OView)this.views.get(cfg.getName().toLowerCase(Locale.ENGLISH));
            Iterator it = Orient.instance().getDbLifecycleListeners();
            while (it.hasNext()) {
                ((ODatabaseLifecycleListener)it.next()).onCreateView((ODatabaseInternal)database, result);
            }
            it = database.getListeners().iterator();
            while (it.hasNext()) {
                ((ODatabaseListener)it.next()).onCreateView((ODatabase)database, result);
            }
        }
        finally {
            this.releaseSchemaWriteLock(database);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OView createView(ODatabaseDocumentInternal database, String name, String statement, Map<String, Object> metadata) {
        OView result;
        Character wrongCharacter = OSchemaShared.checkClassNameIfValid((String)name);
        if (wrongCharacter != null) {
            throw new OSchemaException("Invalid class name found. Character '" + wrongCharacter + "' cannot be used in view name '" + name + "'");
        }
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_CREATE, new Object[0]);
        this.acquireSchemaWriteLock(database);
        try {
            String key = name.toLowerCase(Locale.ENGLISH);
            if (this.views.containsKey(key)) {
                throw new OSchemaException("View '" + name + "' already exists in current database");
            }
            StringBuilder cmd = new StringBuilder("create view ");
            cmd.append('`');
            cmd.append(name);
            cmd.append('`');
            cmd.append(" FROM (" + statement + ") ");
            database.command(cmd.toString(), new Object[0]).close();
            this.reload(database);
            result = (OView)this.views.get(name.toLowerCase(Locale.ENGLISH));
            Iterator it = Orient.instance().getDbLifecycleListeners();
            while (it.hasNext()) {
                ((ODatabaseLifecycleListener)it.next()).onCreateView((ODatabaseInternal)database, result);
            }
            it = database.getListeners().iterator();
            while (it.hasNext()) {
                ((ODatabaseListener)it.next()).onCreateView((ODatabase)database, result);
            }
        }
        finally {
            this.releaseSchemaWriteLock(database);
        }
        return result;
    }

    private void checkClustersAreAbsent(int[] iClusterIds) {
        if (iClusterIds == null) {
            return;
        }
        for (int clusterId : iClusterIds) {
            if (clusterId < 0 || !this.clustersToClasses.containsKey(clusterId)) continue;
            throw new OSchemaException("Cluster with id " + clusterId + " already belongs to class " + this.clustersToClasses.get(clusterId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropClass(ODatabaseDocumentInternal database, String className) {
        this.acquireSchemaWriteLock(database);
        try {
            if (database.getTransaction().isActive()) {
                throw new IllegalStateException("Cannot drop a class inside a transaction");
            }
            if (className == null) {
                throw new IllegalArgumentException("Class name is null");
            }
            database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_DELETE, new Object[0]);
            String key = className.toLowerCase(Locale.ENGLISH);
            OClass cls = (OClass)this.classes.get(key);
            if (cls == null) {
                throw new OSchemaException("Class '" + className + "' was not found in current database");
            }
            if (!cls.getSubclasses().isEmpty()) {
                throw new OSchemaException("Class '" + className + "' cannot be dropped because it has sub classes " + cls.getSubclasses() + ". Remove the dependencies before trying to drop it again");
            }
            StringBuilder cmd = new StringBuilder("drop class `");
            cmd.append(className);
            cmd.append("` unsafe");
            database.command(cmd.toString(), new Object[0]).close();
            this.reload(database);
            database.getLocalCache().freeCluster(cls.getDefaultClusterId());
        }
        finally {
            this.releaseSchemaWriteLock(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropView(ODatabaseDocumentInternal database, String name) {
        this.acquireSchemaWriteLock(database);
        try {
            if (database.getTransaction().isActive()) {
                throw new IllegalStateException("Cannot drop a class inside a transaction");
            }
            if (name == null) {
                throw new IllegalArgumentException("View name is null");
            }
            database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_DELETE, new Object[0]);
            String key = name.toLowerCase(Locale.ENGLISH);
            OClass cls = (OClass)this.views.get(key);
            if (cls == null) {
                throw new OSchemaException("View '" + name + "' was not found in current database");
            }
            if (!cls.getSubclasses().isEmpty()) {
                throw new OSchemaException("View '" + name + "' cannot be dropped because it has sub classes " + cls.getSubclasses() + ". Remove the dependencies before trying to drop it again");
            }
            StringBuilder cmd = new StringBuilder("drop view ");
            cmd.append(name);
            cmd.append(" unsafe");
            database.command(cmd.toString(), new Object[0]).close();
            this.reload(database);
            database.getLocalCache().freeCluster(cls.getDefaultClusterId());
        }
        finally {
            this.releaseSchemaWriteLock(database);
        }
    }

    public void acquireSchemaWriteLock(ODatabaseDocumentInternal database) {
        this.skipPush.set(true);
    }

    public void releaseSchemaWriteLock(ODatabaseDocumentInternal database, boolean iSave) {
        this.skipPush.set(false);
    }

    public void checkEmbedded() {
        throw new OSchemaException("'Internal' schema modification methods can be used only inside of embedded database");
    }

    public void update(ODocument schema) {
        if (!this.skipPush.get()) {
            this.document = schema;
            super.fromStream();
            this.snapshot = null;
        }
    }

    public int addBlobCluster(ODatabaseDocumentInternal database, int clusterId) {
        throw new OSchemaException("Not supported operation use instead ODatabaseSession.addBlobCluster");
    }

    public void removeBlobCluster(ODatabaseDocumentInternal database, String clusterName) {
        throw new OSchemaException("Not supported operation use instead ODatabaseSession.dropCluster");
    }
}

