/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.client.binary.OBinaryRequestExecutor;
import com.orientechnologies.orient.client.remote.OBinaryRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OCeilingPhysicalPositionsResponse;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;

public class OCeilingPhysicalPositionsRequest
implements OBinaryRequest<OCeilingPhysicalPositionsResponse> {
    private int clusterId;
    private OPhysicalPosition physicalPosition;

    public OCeilingPhysicalPositionsRequest(int clusterId, OPhysicalPosition physicalPosition) {
        this.clusterId = clusterId;
        this.physicalPosition = physicalPosition;
    }

    public OCeilingPhysicalPositionsRequest() {
    }

    @Override
    public void write(OChannelDataOutput network, OStorageRemoteSession session) throws IOException {
        network.writeInt(this.clusterId);
        network.writeLong(this.physicalPosition.clusterPosition);
    }

    @Override
    public void read(OChannelDataInput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        this.clusterId = channel.readInt();
        this.physicalPosition = new OPhysicalPosition(channel.readLong());
    }

    public OPhysicalPosition getPhysicalPosition() {
        return this.physicalPosition;
    }

    @Override
    public String getDescription() {
        return "Retrieve ceiling positions";
    }

    @Override
    public byte getCommand() {
        return 42;
    }

    public int getClusterId() {
        return this.clusterId;
    }

    @Override
    public OCeilingPhysicalPositionsResponse createResponse() {
        return new OCeilingPhysicalPositionsResponse();
    }

    @Override
    public OBinaryResponse execute(OBinaryRequestExecutor executor) {
        return executor.executeCeilingPosition(this);
    }
}

