/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentRemote;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.tool.ODatabaseImpExpAbstract;
import com.orientechnologies.orient.core.db.tool.ODatabaseImportException;
import com.orientechnologies.orient.core.db.tool.ODatabaseTool;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;

public class ODatabaseImportRemote
extends ODatabaseImpExpAbstract {
    private String options;

    public ODatabaseImportRemote(ODatabaseDocumentInternal iDatabase, String iFileName, OCommandOutputListener iListener) {
        super(iDatabase, iFileName, iListener);
    }

    public void run() {
        try {
            this.importDatabase();
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error during database import", (Throwable)e, new Object[0]);
        }
    }

    public ODatabaseTool setOptions(String iOptions) {
        this.options = iOptions;
        return super.setOptions(iOptions);
    }

    public void importDatabase() throws ODatabaseImportException {
        File file = new File(this.getFileName());
        try {
            ODatabaseDocument db = this.getDatabase();
            if (db instanceof ODatabaseDocumentTx) {
                db = (ODatabaseDocument)((ODatabaseDocumentTx)db).getUnderlying();
            }
            ((ODatabaseDocumentRemote)db).importDatabase(this.options, new FileInputStream(file), file.getName(), this.getListener());
        }
        catch (FileNotFoundException e) {
            throw OException.wrapException((OException)new ODatabaseImportException("Error importing the database"), (Throwable)e);
        }
    }

    public void close() {
    }
}

