/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.OStorageException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;

public class ORemoteURLs {
    private static final int DEFAULT_PORT = 2424;
    private static final int DEFAULT_SSL_PORT = 2434;
    private final List<String> serverURLs = new ArrayList<String>();
    private List<String> initialServerURLs;
    private int nextServerToConnect;

    public ORemoteURLs(String[] hosts, OContextConfiguration config) {
        for (String host : hosts) {
            this.addHost(host, config);
        }
        this.initialServerURLs = new ArrayList<String>(this.serverURLs);
        this.nextServerToConnect = 0;
    }

    public synchronized void remove(String serverUrl) {
        this.serverURLs.remove(serverUrl);
        this.nextServerToConnect = 0;
    }

    public synchronized List<String> getUrls() {
        return Collections.unmodifiableList(this.serverURLs);
    }

    public synchronized String removeAndGet(String url) {
        this.remove(url);
        OLogManager.instance().debug((Object)this, "Updated server list: %s...", new Object[]{this.serverURLs});
        if (!this.serverURLs.isEmpty()) {
            return this.serverURLs.get(0);
        }
        return null;
    }

    public synchronized void addAll(List<String> toAdd, OContextConfiguration clientConfiguration) {
        if (toAdd.size() > 0) {
            this.serverURLs.clear();
            this.nextServerToConnect = 0;
            for (String host : toAdd) {
                this.addHost(host, clientConfiguration);
            }
        }
    }

    protected String addHost(String host, OContextConfiguration clientConfiguration) {
        if (host.contains("/")) {
            host = host.substring(0, host.indexOf("/"));
        }
        if (!host.contains(":")) {
            host = clientConfiguration.getValueAsBoolean(OGlobalConfiguration.CLIENT_USE_SSL) ? host + ":" + this.getDefaultSSLPort() : host + ":" + this.getDefaultPort();
        } else if (host.split(":").length < 2 || host.split(":")[1].trim().length() == 0) {
            host = clientConfiguration.getValueAsBoolean(OGlobalConfiguration.CLIENT_USE_SSL) ? host + this.getDefaultSSLPort() : host + this.getDefaultPort();
        }
        if (!this.serverURLs.contains(host)) {
            this.serverURLs.add(host);
            OLogManager.instance().debug((Object)this, "Registered the new available server '%s'", new Object[]{host});
        }
        return host;
    }

    protected int getDefaultPort() {
        return 2424;
    }

    protected int getDefaultSSLPort() {
        return 2434;
    }

    private static List<String> parseAddressesFromUrl(String url) {
        ArrayList<String> addresses = new ArrayList<String>();
        int dbPos = url.indexOf(47);
        if (dbPos == -1) {
            addresses.add(url);
        } else {
            for (String host : url.substring(0, dbPos).split(";")) {
                addresses.add(host);
            }
        }
        return addresses;
    }

    public synchronized String parseServerUrls(String url, OContextConfiguration contextConfiguration) {
        int dbPos = url.indexOf(47);
        String name = dbPos == -1 ? url : url.substring(url.lastIndexOf("/") + 1);
        String lastHost = null;
        List<String> hosts = ORemoteURLs.parseAddressesFromUrl(url);
        Iterator<String> iterator = hosts.iterator();
        while (iterator.hasNext()) {
            String host;
            lastHost = host = iterator.next();
            this.addHost(host, contextConfiguration);
        }
        if (this.serverURLs.size() == 1 && contextConfiguration.getValueAsBoolean(OGlobalConfiguration.NETWORK_BINARY_DNS_LOADBALANCING_ENABLED)) {
            List<String> toAdd = this.fetchHostsFromDns(lastHost, contextConfiguration);
            this.serverURLs.addAll(toAdd);
        }
        this.initialServerURLs = new ArrayList<String>(this.serverURLs);
        return name;
    }

    public synchronized void reloadOriginalURLs() {
        this.serverURLs.clear();
        this.serverURLs.addAll(this.initialServerURLs);
    }

    private List<String> fetchHostsFromDns(String primaryServer, OContextConfiguration contextConfiguration) {
        OLogManager.instance().debug((Object)this, "Retrieving URLs from DNS '%s' (timeout=%d)...", new Object[]{primaryServer, contextConfiguration.getValueAsInteger(OGlobalConfiguration.NETWORK_BINARY_DNS_LOADBALANCING_TIMEOUT)});
        ArrayList<String> toAdd = new ArrayList<String>();
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            env.put("com.sun.jndi.ldap.connect.timeout", contextConfiguration.getValueAsString(OGlobalConfiguration.NETWORK_BINARY_DNS_LOADBALANCING_TIMEOUT));
            InitialDirContext ictx = new InitialDirContext(env);
            String hostName = !primaryServer.contains(":") ? primaryServer : primaryServer.substring(0, primaryServer.indexOf(":"));
            Attributes attrs = ictx.getAttributes(hostName, new String[]{"TXT"});
            Attribute attr = attrs.get("TXT");
            if (attr != null) {
                for (int i = 0; i < attr.size(); ++i) {
                    String[] parts;
                    String configuration = (String)attr.get(i);
                    if (configuration.startsWith("\"")) {
                        configuration = configuration.substring(1, configuration.length() - 1);
                    }
                    if (configuration == null) continue;
                    for (String part : parts = configuration.split(" ")) {
                        if (!part.startsWith("s=")) continue;
                        toAdd.add(part.substring("s=".length()));
                    }
                }
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return toAdd;
    }

    private synchronized String getNextConnectUrl(OStorageRemoteSession session, OContextConfiguration contextConfiguration) {
        if (this.serverURLs.isEmpty()) {
            this.reloadOriginalURLs();
            if (this.serverURLs.isEmpty()) {
                throw new OStorageException("Cannot create a connection to remote server because url list is empty");
            }
        }
        ++this.nextServerToConnect;
        if (this.nextServerToConnect >= this.serverURLs.size()) {
            this.nextServerToConnect = 0;
        }
        String serverURL = this.serverURLs.get(this.nextServerToConnect);
        if (session != null) {
            session.serverURLIndex = this.nextServerToConnect;
            session.currentUrl = serverURL;
        }
        return serverURL;
    }

    public synchronized String getServerURFromList(boolean iNextAvailable, OStorageRemoteSession session, OContextConfiguration contextConfiguration) {
        if (session != null && session.getCurrentUrl() != null && !iNextAvailable) {
            return session.getCurrentUrl();
        }
        if (this.serverURLs.isEmpty()) {
            this.reloadOriginalURLs();
            if (this.serverURLs.isEmpty()) {
                throw new OStorageException("Cannot create a connection to remote server because url list is empty");
            }
        }
        int serverURLIndex = session != null ? session.serverURLIndex : 0;
        if (iNextAvailable) {
            ++serverURLIndex;
        }
        if (serverURLIndex < 0 || serverURLIndex >= this.serverURLs.size()) {
            serverURLIndex = 0;
        }
        String serverURL = this.serverURLs.get(serverURLIndex);
        if (session != null) {
            session.serverURLIndex = serverURLIndex;
            session.currentUrl = serverURL;
        }
        return serverURL;
    }

    public synchronized String getNextAvailableServerURL(boolean iIsConnectOperation, OStorageRemoteSession session, OContextConfiguration contextConfiguration, OStorageRemote.CONNECTION_STRATEGY strategy) {
        String url = null;
        if (session.isStickToSession()) {
            strategy = OStorageRemote.CONNECTION_STRATEGY.STICKY;
        }
        switch (strategy) {
            case STICKY: {
                url = session.getServerUrl();
                if (url != null) break;
                url = this.getServerURFromList(false, session, contextConfiguration);
                break;
            }
            case ROUND_ROBIN_CONNECT: {
                url = iIsConnectOperation || session.getServerUrl() == null ? this.getNextConnectUrl(session, contextConfiguration) : session.getServerUrl();
                OLogManager.instance().debug((Object)this, "ROUND_ROBIN_CONNECT: Next remote operation will be executed on server: %s (isConnectOperation=%s)", new Object[]{url, iIsConnectOperation});
                break;
            }
            case ROUND_ROBIN_REQUEST: {
                url = this.getServerURFromList(true, session, contextConfiguration);
                OLogManager.instance().debug((Object)this, "ROUND_ROBIN_REQUEST: Next remote operation will be executed on server: %s (isConnectOperation=%s)", new Object[]{url, iIsConnectOperation});
                break;
            }
            default: {
                throw new OConfigurationException("Connection mode " + (Object)((Object)strategy) + " is not supported");
            }
        }
        return url;
    }

    public synchronized void updateDistributedNodes(List<String> hosts, OContextConfiguration clientConfiguration) {
        if (!clientConfiguration.getValueAsBoolean(OGlobalConfiguration.CLIENT_CONNECTION_FETCH_HOST_LIST)) {
            List<String> definedHosts = this.initialServerURLs;
            for (String host : definedHosts) {
                this.addHost(host, clientConfiguration);
            }
            return;
        }
        for (String host : hosts) {
            this.addHost(host, clientConfiguration);
        }
    }
}

