/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.client.binary.OBinaryRequestExecutor;
import com.orientechnologies.orient.client.remote.OBinaryAsyncRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OUpdateRecordResponse;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;

public class OUpdateRecordRequest
implements OBinaryAsyncRequest<OUpdateRecordResponse> {
    private ORecordId rid;
    private byte[] rawContent;
    private ORecord content;
    private int version;
    private boolean updateContent = true;
    private byte recordType;
    private byte mode;

    public OUpdateRecordRequest(ORecordId iRid, byte[] iContent, int iVersion, boolean updateContent, byte iRecordType) {
        this.rid = iRid;
        this.rawContent = iContent;
        this.version = iVersion;
        this.updateContent = updateContent;
        this.recordType = iRecordType;
    }

    public OUpdateRecordRequest(ORecordId iRid, ORecord iContent, int iVersion, boolean updateContent, byte iRecordType) {
        this.rid = iRid;
        this.version = iVersion;
        this.updateContent = updateContent;
        this.content = iContent;
        this.recordType = iRecordType;
    }

    public OUpdateRecordRequest() {
    }

    @Override
    public byte getCommand() {
        return 32;
    }

    @Override
    public String getDescription() {
        return "Update Record";
    }

    @Override
    public void read(OChannelDataInput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        this.rid = channel.readRID();
        if (protocolVersion >= 23) {
            this.updateContent = channel.readBoolean();
        }
        byte[] bts = channel.readBytes();
        this.version = channel.readVersion();
        this.recordType = channel.readByte();
        this.mode = channel.readByte();
        this.content = Orient.instance().getRecordFactoryManager().newInstance(this.recordType, this.rid.getClusterId(), ODatabaseRecordThreadLocal.instance().getIfDefined());
        serializer.fromStream(bts, this.content, null);
    }

    @Override
    public void write(OChannelDataOutput network, OStorageRemoteSession session) throws IOException {
        network.writeRID((ORID)this.rid);
        network.writeBoolean(this.updateContent);
        network.writeBytes(this.rawContent);
        network.writeVersion(this.version);
        network.writeByte(this.recordType);
        network.writeByte(this.mode);
    }

    public ORecord getContent() {
        return this.content;
    }

    @Override
    public byte getMode() {
        return this.mode;
    }

    public byte getRecordType() {
        return this.recordType;
    }

    public ORecordId getRid() {
        return this.rid;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isUpdateContent() {
        return this.updateContent;
    }

    @Override
    public void setMode(byte mode) {
        this.mode = mode;
    }

    @Override
    public OUpdateRecordResponse createResponse() {
        return new OUpdateRecordResponse();
    }

    @Override
    public OBinaryResponse execute(OBinaryRequestExecutor executor) {
        return executor.executeUpdateRecord(this);
    }
}

