/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecordVersionHelper;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedDatabaseRepairer;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ODistributedTxContext;
import com.orientechnologies.orient.server.distributed.conflict.ODistributedConflictResolver;
import com.orientechnologies.orient.server.distributed.impl.ODistributedTransactionManager;
import com.orientechnologies.orient.server.distributed.impl.task.OClusterRepairInfoTask;
import com.orientechnologies.orient.server.distributed.impl.task.OCompleted2pcTask;
import com.orientechnologies.orient.server.distributed.impl.task.OCreateRecordTask;
import com.orientechnologies.orient.server.distributed.impl.task.OFixCreateRecordTask;
import com.orientechnologies.orient.server.distributed.impl.task.OFixUpdateRecordTask;
import com.orientechnologies.orient.server.distributed.impl.task.OReadRecordTask;
import com.orientechnologies.orient.server.distributed.impl.task.ORepairClusterTask;
import com.orientechnologies.orient.server.distributed.impl.task.ORepairRecordsTask;
import com.orientechnologies.orient.server.distributed.impl.task.OTxTaskResult;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class OConflictResolverDatabaseRepairer
implements ODistributedDatabaseRepairer {
    private final ODistributedServerManager dManager;
    private final String databaseName;
    private final AtomicLong recordProcessed = new AtomicLong(0L);
    private final AtomicLong recordCanceled = new AtomicLong(0L);
    private final AtomicLong totalTimeProcessing = new AtomicLong(0L);
    private final boolean active;
    private ConcurrentMap<ORecordId, Boolean> records = new ConcurrentHashMap<ORecordId, Boolean>();
    private ConcurrentMap<Integer, Boolean> clusters = new ConcurrentHashMap<Integer, Boolean>();
    private final TimerTask checkTask;
    private List<ODistributedConflictResolver> conflictResolvers = new ArrayList<ODistributedConflictResolver>();

    public OConflictResolverDatabaseRepairer(ODistributedServerManager manager, String databaseName) {
        String[] items;
        this.dManager = manager;
        this.databaseName = databaseName;
        String chain = OGlobalConfiguration.DISTRIBUTED_CONFLICT_RESOLVER_REPAIRER_CHAIN.getValueAsString();
        for (String item : items = chain.split(",")) {
            ODistributedConflictResolver cr = (ODistributedConflictResolver)manager.getConflictResolverFactory().getImplementation((Object)item);
            if (cr == null) {
                throw new OConfigurationException("Cannot find '" + item + "' conflict resolver implementation. Available are: " + manager.getConflictResolverFactory().getRegisteredImplementationNames());
            }
            this.conflictResolvers.add(cr);
        }
        this.checkTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long start = System.currentTimeMillis();
                try {
                    OConflictResolverDatabaseRepairer.this.check();
                }
                catch (Throwable t) {
                    OLogManager.instance().error((Object)this, "Error on repairing distributed database", t, new Object[0]);
                }
                finally {
                    OConflictResolverDatabaseRepairer.this.totalTimeProcessing.addAndGet(System.currentTimeMillis() - start);
                }
            }
        };
        long time = OGlobalConfiguration.DISTRIBUTED_CONFLICT_RESOLVER_REPAIRER_CHECK_EVERY.getValueAsLong();
        if (time > 0L) {
            Orient.instance().scheduleTask(this.checkTask, time, time);
            this.active = true;
        } else {
            this.active = false;
        }
    }

    public void enqueueRepairRecord(ORecordId rid) {
        if (!this.active) {
            return;
        }
        if (rid == null || !rid.isPersistent()) {
            return;
        }
        if (rid.getClusterPosition() < -1L) {
            return;
        }
        this.recordProcessed.incrementAndGet();
        this.records.put(rid, Boolean.TRUE);
    }

    public void cancelRepairRecord(ORecordId rid) {
        if (!this.active) {
            return;
        }
        if (rid.getClusterPosition() < -1L) {
            return;
        }
        if (this.records.remove(rid) != null) {
            this.recordCanceled.incrementAndGet();
        }
    }

    public void enqueueRepairCluster(int clusterId) {
        if (!this.active) {
            return;
        }
        if (clusterId < -1) {
            return;
        }
        this.recordProcessed.incrementAndGet();
        this.clusters.put(clusterId, Boolean.TRUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check() throws Exception {
        ODatabaseDocumentTx db = null;
        try {
            int batchMax = OGlobalConfiguration.DISTRIBUTED_CONFLICT_RESOLVER_REPAIRER_BATCH.getValueAsInteger();
            ArrayList<ORecordId> rids = new ArrayList<ORecordId>(batchMax);
            for (Integer n : this.clusters.keySet()) {
            }
            this.clusters.clear();
            for (ORecordId rid : this.records.keySet()) {
                rids.add(rid);
                if (rids.size() < batchMax) continue;
                break;
            }
            if (!rids.isEmpty() && this.repairRecords((ODatabaseDocumentInternal)(db = this.getDatabase()), rids)) {
                for (ORecordId rid : rids) {
                    this.records.remove(rid);
                }
            }
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repairCluster(ODatabaseDocumentInternal db, Integer clusterId) throws Exception {
        block16: {
            if (clusterId < 0) {
                return;
            }
            ODistributedConfiguration dCfg = this.dManager.getDatabaseConfiguration(this.databaseName);
            int maxAutoRetry = OGlobalConfiguration.DISTRIBUTED_CONCURRENT_TX_MAX_AUTORETRY.getValueAsInteger();
            int autoRetryDelay = OGlobalConfiguration.DISTRIBUTED_CONCURRENT_TX_AUTORETRY_DELAY.getValueAsInteger();
            ODistributedRequestId requestId = new ODistributedRequestId(this.dManager.getLocalNodeId(), this.dManager.getNextMessageIdCounter());
            ODistributedDatabase localDistributedDatabase = this.dManager.getMessageService().getDatabase(this.databaseName);
            if (db == null) {
                db = this.getDatabase();
            }
            String clusterName = db.getClusterNameById(clusterId.intValue());
            ODistributedTxContext ctx = localDistributedDatabase.registerTxContext(requestId);
            String serverOwner = dCfg.getClusterOwner(clusterName);
            if (serverOwner == null || !serverOwner.equals(this.dManager.getLocalNodeName())) {
                ODistributedServerLog.debug((Object)this, (String)this.dManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Cannot auto repair cluster '%s' (%d) because current server (%s) is not the owner (owner=%s reqId=%s)", (Object[])new Object[]{clusterName, clusterId, this.dManager.getLocalNodeName(), serverOwner, requestId});
                return;
            }
            try {
                ArrayList<ORecordId> rids = new ArrayList<ORecordId>(1);
                rids.add(new ORecordId(clusterId.intValue(), -1L));
                ODistributedTransactionManager.acquireMultipleRecordLocks(this, this.dManager, localDistributedDatabase, rids, maxAutoRetry, autoRetryDelay, null, ctx, 2000L);
                try {
                    int repaired;
                    Set involvedServers;
                    block15: {
                        ArrayList<String> clusterNames = new ArrayList<String>();
                        clusterNames.add(clusterName);
                        involvedServers = dCfg.getServers(clusterNames);
                        HashSet nonLocalServers = new HashSet(involvedServers);
                        nonLocalServers.remove(this.dManager.getLocalNodeName());
                        if (nonLocalServers.isEmpty()) {
                            return;
                        }
                        ODistributedServerLog.debug((Object)this, (String)this.dManager.getLocalNodeName(), (String)involvedServers.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Auto repairing cluster '%s' (%d) on servers %s (reqId=%s)...", (Object[])new Object[]{clusterName, clusterId, involvedServers, requestId});
                        OClusterRepairInfoTask task = new OClusterRepairInfoTask(clusterId);
                        ODistributedResponse response = this.dManager.sendRequest(this.databaseName, clusterNames, nonLocalServers, (ORemoteTask)task, requestId.getMessageId(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null);
                        repaired = 0;
                        try {
                            Object payload;
                            if (response != null && (payload = response.getPayload()) instanceof Map) {
                                repaired = this.repairClusterAtBlocks(db, clusterNames, clusterId, (Map)payload);
                            }
                            if (repaired != 0) break block15;
                        }
                        catch (Throwable throwable) {
                            if (repaired == 0) {
                                ODistributedServerLog.debug((Object)this, (String)this.dManager.getLocalNodeName(), (String)involvedServers.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Auto repairing of cluster '%s' completed. No fix is needed (reqId=%s)", (Object[])new Object[]{clusterName, repaired, requestId});
                            } else {
                                ODistributedServerLog.info((Object)this, (String)this.dManager.getLocalNodeName(), (String)involvedServers.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Auto repairing of cluster '%s' completed. Repaired %d records (reqId=%s)", (Object[])new Object[]{clusterName, repaired, requestId});
                            }
                            throw throwable;
                        }
                        ODistributedServerLog.debug((Object)this, (String)this.dManager.getLocalNodeName(), (String)involvedServers.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Auto repairing of cluster '%s' completed. No fix is needed (reqId=%s)", (Object[])new Object[]{clusterName, repaired, requestId});
                        break block16;
                    }
                    ODistributedServerLog.info((Object)this, (String)this.dManager.getLocalNodeName(), (String)involvedServers.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Auto repairing of cluster '%s' completed. Repaired %d records (reqId=%s)", (Object[])new Object[]{clusterName, repaired, requestId});
                }
                finally {
                    localDistributedDatabase.popTxContext(requestId);
                    ctx.destroy();
                }
            }
            catch (Throwable e) {
                ODistributedServerLog.debug((Object)this, (String)this.dManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error executing auto repairing on cluster '%s' (error=%s, reqId=%s)", (Object[])new Object[]{clusterName, e.toString(), requestId});
                return;
            }
        }
    }

    private int repairClusterAtBlocks(ODatabaseDocumentInternal db, List<String> clusterNames, int clusterId, Map<String, Object> repairInfoResult) throws IOException {
        OStorage storage = db.getStorage().getUnderlying();
        long localEnd = storage.getClusterById(clusterId).getNextPosition() - 1L;
        int batchMax = OGlobalConfiguration.DISTRIBUTED_CONFLICT_RESOLVER_REPAIRER_BATCH.getValueAsInteger();
        int recordRepaired = 0;
        for (Map.Entry<String, Object> entry : repairInfoResult.entrySet()) {
            String server = entry.getKey();
            ODistributedServerManager.DB_STATUS status = this.dManager.getDatabaseStatus(server, this.databaseName);
            if (status != ODistributedServerManager.DB_STATUS.ONLINE) {
                ODistributedServerLog.debug((Object)this, (String)this.dManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Cannot align missing records of cluster '%s' on server %s, because is not ONLINE (status=%s)", (Object[])new Object[]{clusterNames.get(0), server, status});
                return 0;
            }
            Object result = entry.getValue();
            if (!(result instanceof Long)) continue;
            long remoteEnd = (Long)result;
            ORepairClusterTask task = new ORepairClusterTask(clusterId);
            for (long pos = remoteEnd + 1L; pos <= localEnd; ++pos) {
                ORecordId rid = new ORecordId(clusterId, pos);
                ORawBuffer rawRecord = (ORawBuffer)storage.readRecord(rid, null, true, false, null).getResult();
                if (rawRecord == null) continue;
                task.add(new OCreateRecordTask(rid, rawRecord.buffer, rawRecord.version, rawRecord.recordType));
                ++recordRepaired;
                if (task.getTasks().size() <= batchMax) continue;
                ArrayList<String> servers = new ArrayList<String>(1);
                servers.add(server);
                ODistributedResponse response = this.dManager.sendRequest(this.databaseName, clusterNames, servers, (ORemoteTask)task, this.dManager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null);
                task = new ORepairClusterTask(clusterId);
            }
            if (!task.getTasks().isEmpty()) {
                ArrayList<String> servers = new ArrayList<String>(1);
                servers.add(server);
                ODistributedResponse oDistributedResponse = this.dManager.sendRequest(this.databaseName, clusterNames, servers, (ORemoteTask)task, this.dManager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null);
            }
            if (task.getTasks().size() == 0) {
                ODistributedServerLog.debug((Object)this, (String)this.dManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Auto repair aligned %d records of cluster '%s'", (Object[])new Object[]{task.getTasks().size(), clusterNames.get(0)});
                continue;
            }
            ODistributedServerLog.info((Object)this, (String)this.dManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Auto repair aligned %d records of cluster '%s'", (Object[])new Object[]{task.getTasks().size(), clusterNames.get(0)});
        }
        return recordRepaired;
    }

    public void repairRecord(ORecordId rid) {
        ArrayList<ORecordId> rids = new ArrayList<ORecordId>();
        rids.add(rid);
        this.repairRecords((ODatabaseDocumentInternal)this.getDatabase(), rids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean repairRecords(ODatabaseDocumentInternal db, List<ORecordId> rids) {
        dCfg = this.dManager.getDatabaseConfiguration(this.databaseName);
        maxAutoRetry = OGlobalConfiguration.DISTRIBUTED_CONCURRENT_TX_MAX_AUTORETRY.getValueAsInteger();
        autoRetryDelay = OGlobalConfiguration.DISTRIBUTED_CONCURRENT_TX_AUTORETRY_DELAY.getValueAsInteger();
        requestId = new ODistributedRequestId(this.dManager.getLocalNodeId(), this.dManager.getNextMessageIdCounter());
        localDistributedDatabase = this.dManager.getMessageService().getDatabase(this.databaseName);
        ctx = localDistributedDatabase.registerTxContext(requestId);
        try {
            ODistributedTransactionManager.acquireMultipleRecordLocks(this, this.dManager, localDistributedDatabase, rids, maxAutoRetry, autoRetryDelay, null, ctx, 2000L);
            try {
                clusterNames = new HashSet<String>();
                for (ORecordId rid : rids) {
                    clusterNames.add(db.getClusterNameById(rid.getClusterId()));
                }
                involvedServers = dCfg.getServers(clusterNames);
                nonLocalServers = new HashSet<E>(involvedServers);
                nonLocalServers.remove(this.dManager.getLocalNodeName());
                if (nonLocalServers.isEmpty()) {
                    var12_13 = true;
                    return var12_13;
                }
                localResult = new OTxTaskResult();
                for (ORecordId var14_16 : rids) {
                    res = var14_16.getClusterPosition() > -1L ? db.getStorage().readRecord(var14_16, null, true, false, null) : null;
                    if (res != null) {
                        localResult.results.add(res.getResult());
                        continue;
                    }
                    localResult.results.add(null);
                }
                ODistributedServerLog.debug((Object)this, (String)this.dManager.getLocalNodeName(), (String)involvedServers.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Auto repairing records %s on servers %s (reqId=%s)...", (Object[])new Object[]{rids, involvedServers, requestId});
                tx = new ORepairRecordsTask();
                for (ORecordId rid : rids) {
                    tx.add(new OReadRecordTask(rid));
                }
                var14_18 = this.dManager.sendRequest(this.databaseName, clusterNames, nonLocalServers, (ORemoteTask)tx, requestId.getMessageId(), ODistributedRequest.EXECUTION_MODE.RESPONSE, (Object)localResult, null);
                repairMap = new HashMap<String, OCompleted2pcTask>(rids.size());
                for (String server : involvedServers) {
                    completedTask = new OCompleted2pcTask(requestId, false, tx.getPartitionKey());
                    repairMap.put(server, completedTask);
                }
                if (var14_18 == null || !((payload = var14_18.getPayload()) instanceof Map)) ** GOTO lbl127
                map = (Map)payload;
                for (i = 0; i < localResult.results.size(); ++i) {
                    groupedResult = new HashMap<Object, ArrayList<E>>();
                    rid = rids.get(i);
lbl50:
                    // 2 sources

                    for (Map.Entry<K, V> entry : map.entrySet()) {
                        if (!(entry.getValue() instanceof Throwable)) break block33;
                        ODistributedServerLog.info((Object)this, (String)this.dManager.getLocalNodeName(), (String)((String)entry.getKey()), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Error on auto repairing record %s on servers %s (error=%s)", (Object[])new Object[]{rid, entry.getKey(), entry.getValue()});
                        var23_37 = false;
                        repaired = 0;
                        var25_41 = repairMap.entrySet().iterator();
                        ** break block34
                    }
                    ** GOTO lbl98
                }
                ** GOTO lbl127
lbl-1000:
                // 1 sources

                {
                    block33: {
                        while (var25_41.hasNext()) {
                            entry = var25_41.next();
                            server = (String)entry.getKey();
                            task = (OCompleted2pcTask)entry.getValue();
                            repaired += task.getFixTasks().size();
                            if (this.dManager.getLocalNodeName().equals(server)) {
                                this.dManager.executeOnLocalNode(requestId, (ORemoteTask)task, db);
                                continue;
                            }
                            servers = new ArrayList<String>();
                            servers.add(server);
                            this.dManager.getAvailableNodes(servers, this.databaseName);
                            if (servers.isEmpty()) continue;
                            var14_20 = this.dManager.sendRequest(this.databaseName, clusterNames, servers, (ORemoteTask)task, this.dManager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null);
                        }
                        if (repaired == 0) {
                            ODistributedServerLog.debug((Object)this, (String)this.dManager.getLocalNodeName(), (String)involvedServers.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Auto repairing completed. No fix is needed (reqId=%s)", (Object[])new Object[]{repaired, requestId});
                            return var23_37;
                        }
                        ODistributedServerLog.info((Object)this, (String)this.dManager.getLocalNodeName(), (String)involvedServers.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Auto repairing completed. Sent %d fix messages for %d records (reqId=%s)", (Object[])new Object[]{repaired, rids.size(), requestId});
                        return var23_37;
                    }
                    try {
                        v = (OTxTaskResult)entry.getValue();
                        remoteValue = v.results.get(i);
                        var25_42 = (List)groupedResult.get(remoteValue);
                        if (var25_42 == null) {
                            var25_43 = new ArrayList<E>();
                            groupedResult.put(remoteValue, var25_43);
                        }
                        var25_44.add(entry.getKey());
                        ** GOTO lbl50
                    }
                    catch (Throwable var32_53) {
                        block35: {
                            repaired = 0;
                            var34_55 = repairMap.entrySet().iterator();
                            break block35;
lbl98:
                            // 1 sources

                            if (groupedResult.size() == 1) continue;
                            config = null;
                            winner = null;
                            candidates /* !! */  = groupedResult;
                            for (ODistributedConflictResolver var25_45 : this.conflictResolvers) {
                                conflictResult = var25_45.onConflict(this.databaseName, db.getClusterNameById(rid.getClusterId()), rid, this.dManager, candidates /* !! */ , config);
                                winner = conflictResult.winner;
                                if (winner != null) break;
                                candidates /* !! */  = conflictResult.candidates;
                            }
                            if (winner == null) continue;
                            for (Map.Entry var25_46 : groupedResult.entrySet()) {
                                value = var25_46.getKey();
                                servers = (List)var25_46.getValue();
                                for (String server : servers) {
                                    ODistributedServerLog.debug((Object)this, (String)this.dManager.getLocalNodeName(), (String)server, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Preparing fix for record %s on servers %s, value=%s...", (Object[])new Object[]{rid, server, winner});
                                    if (winner.equals(value)) continue;
                                    completedTask = (OCompleted2pcTask)repairMap.get(server);
                                    if (winner instanceof ORawBuffer && value instanceof ORawBuffer) {
                                        winnerRecord = (ORawBuffer)winner;
                                        completedTask.addFixTask((ORemoteTask)new OFixUpdateRecordTask(rid, winnerRecord.buffer, ORecordVersionHelper.setRollbackMode((int)winnerRecord.version), winnerRecord.recordType));
                                        continue;
                                    }
                                    if (winner instanceof ORecordNotFoundException && value instanceof ORawBuffer) {
                                        completedTask.addFixTask((ORemoteTask)new OFixCreateRecordTask(rid, -1));
                                        continue;
                                    }
                                    if (value instanceof Throwable) continue;
                                }
                            }
                            continue;
lbl127:
                            // 2 sources

                            repaired = 0;
                            for (Map.Entry<K, V> entry : repairMap.entrySet()) {
                                server = (String)entry.getKey();
                                task = (OCompleted2pcTask)entry.getValue();
                                repaired += task.getFixTasks().size();
                                if (this.dManager.getLocalNodeName().equals(server)) {
                                    this.dManager.executeOnLocalNode(requestId, (ORemoteTask)task, db);
                                    continue;
                                }
                                servers = new ArrayList<String>();
                                servers.add(server);
                                this.dManager.getAvailableNodes(servers, this.databaseName);
                                if (servers.isEmpty()) continue;
                                var14_22 = this.dManager.sendRequest(this.databaseName, clusterNames, servers, (ORemoteTask)task, this.dManager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null);
                            }
                            if (repaired == 0) {
                                ODistributedServerLog.debug((Object)this, (String)this.dManager.getLocalNodeName(), (String)involvedServers.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Auto repairing completed. No fix is needed (reqId=%s)", (Object[])new Object[]{repaired, requestId});
                                return true;
                            }
                            ODistributedServerLog.info((Object)this, (String)this.dManager.getLocalNodeName(), (String)involvedServers.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Auto repairing completed. Sent %d fix messages for %d records (reqId=%s)", (Object[])new Object[]{repaired, rids.size(), requestId});
                            return true;
                        }
                        while (var34_55.hasNext()) {
                            entry = var34_55.next();
                            server = (String)entry.getKey();
                            task = (OCompleted2pcTask)entry.getValue();
                            repaired += task.getFixTasks().size();
                            if (this.dManager.getLocalNodeName().equals(server)) {
                                this.dManager.executeOnLocalNode(requestId, (ORemoteTask)task, db);
                                continue;
                            }
                            servers = new ArrayList<String>();
                            servers.add(server);
                            this.dManager.getAvailableNodes(servers, this.databaseName);
                            if (servers.isEmpty()) continue;
                            var14_24 = this.dManager.sendRequest(this.databaseName, clusterNames, servers, (ORemoteTask)task, this.dManager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null);
                        }
                        if (repaired == 0) {
                            ODistributedServerLog.debug((Object)this, (String)this.dManager.getLocalNodeName(), (String)involvedServers.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Auto repairing completed. No fix is needed (reqId=%s)", (Object[])new Object[]{repaired, requestId});
                            throw var32_53;
                        }
                        ODistributedServerLog.info((Object)this, (String)this.dManager.getLocalNodeName(), (String)involvedServers.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Auto repairing completed. Sent %d fix messages for %d records (reqId=%s)", (Object[])new Object[]{repaired, rids.size(), requestId});
                        throw var32_53;
                        break;
                    }
                }
            }
            finally {
                localDistributedDatabase.popTxContext(requestId);
                ctx.destroy();
            }
        }
        catch (Throwable e) {
            ODistributedServerLog.debug((Object)this, (String)this.dManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error executing auto repairing (error=%s, reqId=%s)", (Object[])new Object[]{e.toString(), requestId});
            return false;
        }
    }

    public long getRecordProcessed() {
        return this.recordProcessed.get();
    }

    public long getTotalTimeProcessing() {
        return this.totalTimeProcessing.get();
    }

    private ODatabaseDocumentTx getDatabase() {
        return this.dManager.getMessageService().getDatabase(this.databaseName).getDatabaseInstance();
    }

    public void shutdown() {
        if (this.checkTask != null) {
            this.checkTask.cancel();
        }
        this.records.clear();
    }
}

