/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.Member;
import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.concur.OOfflineNodeException;
import com.orientechnologies.common.console.ODefaultConsoleReader;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OAnsiCode;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.common.util.OArrays;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.ODatabaseLifecycleListener;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OScenarioThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.schema.clusterselection.OClusterSelectionStrategy;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerConfiguration;
import com.orientechnologies.orient.server.config.OServerHandlerConfiguration;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import com.orientechnologies.orient.server.config.OServerUserConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedLifecycleListener;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ODistributedStrategy;
import com.orientechnologies.orient.server.distributed.OModifiableDistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ORemoteServerController;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.conflict.ODistributedConflictResolverFactory;
import com.orientechnologies.orient.server.distributed.impl.OClusterHealthChecker;
import com.orientechnologies.orient.server.distributed.impl.OClusterOwnershipAssignmentStrategy;
import com.orientechnologies.orient.server.distributed.impl.ODefaultClusterOwnershipAssignmentStrategy;
import com.orientechnologies.orient.server.distributed.impl.ODefaultDistributedStrategy;
import com.orientechnologies.orient.server.distributed.impl.ODistributedDatabaseChunk;
import com.orientechnologies.orient.server.distributed.impl.ODistributedDatabaseImpl;
import com.orientechnologies.orient.server.distributed.impl.ODistributedLockManagerExecutor;
import com.orientechnologies.orient.server.distributed.impl.ODistributedLockManagerRequester;
import com.orientechnologies.orient.server.distributed.impl.ODistributedMessageServiceImpl;
import com.orientechnologies.orient.server.distributed.impl.ODistributedOutput;
import com.orientechnologies.orient.server.distributed.impl.ODistributedStorage;
import com.orientechnologies.orient.server.distributed.impl.OIncrementalServerSync;
import com.orientechnologies.orient.server.distributed.impl.OLocalClusterWrapperStrategy;
import com.orientechnologies.orient.server.distributed.impl.task.OCopyDatabaseChunkTask;
import com.orientechnologies.orient.server.distributed.impl.task.ODefaultRemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.impl.task.ORestartServerTask;
import com.orientechnologies.orient.server.distributed.impl.task.OStopServerTask;
import com.orientechnologies.orient.server.distributed.impl.task.OSyncDatabaseDeltaTask;
import com.orientechnologies.orient.server.distributed.impl.task.OSyncDatabaseTask;
import com.orientechnologies.orient.server.distributed.sql.OCommandExecutorSQLHASyncCluster;
import com.orientechnologies.orient.server.distributed.task.OAbstractReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.ODatabaseIsOldException;
import com.orientechnologies.orient.server.distributed.task.ODistributedDatabaseDeltaSyncException;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import com.orientechnologies.orient.server.network.OServerNetworkListener;
import com.orientechnologies.orient.server.plugin.OServerPluginAbstract;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public abstract class ODistributedAbstractPlugin
extends OServerPluginAbstract
implements ODistributedServerManager,
ODatabaseLifecycleListener,
OCommandOutputListener {
    public static final String REPLICATOR_USER = "_CrossServerTempUser";
    protected static final String PAR_DEF_DISTRIB_DB_CONFIG = "configuration.db.default";
    protected static final String NODE_NAME_ENV = "ORIENTDB_NODE_NAME";
    protected OServer serverInstance;
    protected boolean enabled = true;
    protected String nodeUuid;
    protected String nodeName = null;
    protected int nodeId = -1;
    protected File defaultDatabaseConfigFile;
    protected ConcurrentHashMap<String, ODistributedStorage> storages = new ConcurrentHashMap();
    protected volatile ODistributedServerManager.NODE_STATUS status = ODistributedServerManager.NODE_STATUS.OFFLINE;
    protected long lastClusterChangeOn;
    protected List<ODistributedLifecycleListener> listeners = new ArrayList<ODistributedLifecycleListener>();
    protected final ConcurrentMap<String, ORemoteServerController> remoteServers = new ConcurrentHashMap<String, ORemoteServerController>();
    protected TimerTask publishLocalNodeConfigurationTask = null;
    protected TimerTask haStatsTask = null;
    protected OClusterHealthChecker healthCheckerTask = null;
    protected String coordinatorServer;
    protected AtomicLong localMessageIdCounter = new AtomicLong();
    protected OClusterOwnershipAssignmentStrategy clusterAssignmentStrategy = new ODefaultClusterOwnershipAssignmentStrategy(this);
    protected static final int DEPLOY_DB_MAX_RETRIES = 10;
    protected Map<String, Member> activeNodes = new ConcurrentHashMap<String, Member>();
    protected Map<String, String> activeNodesNamesByUuid = new ConcurrentHashMap<String, String>();
    protected Map<String, String> activeNodesUuidByName = new ConcurrentHashMap<String, String>();
    protected final List<String> registeredNodeById = new ArrayList<String>();
    protected final Map<String, Integer> registeredNodeByName = new HashMap<String, Integer>();
    protected Map<String, Long> autoRemovalOfServers = new ConcurrentHashMap<String, Long>();
    protected volatile ODistributedMessageServiceImpl messageService;
    protected Date startedOn = new Date();
    protected ORemoteTaskFactory taskFactory = new ODefaultRemoteTaskFactory();
    protected ODistributedStrategy responseManagerFactory = new ODefaultDistributedStrategy();
    private volatile String lastServerDump = "";
    protected CountDownLatch serverStarted = new CountDownLatch(1);
    private ODistributedConflictResolverFactory conflictResolverFactory = new ODistributedConflictResolverFactory();
    private final ODistributedLockManagerRequester lockManagerRequester = new ODistributedLockManagerRequester(this);
    private final ODistributedLockManagerExecutor lockManagerExecutor = new ODistributedLockManagerExecutor(this);

    protected ODistributedAbstractPlugin() {
    }

    public void waitUntilNodeOnline() throws InterruptedException {
        this.serverStarted.await();
    }

    public void waitUntilNodeOnline(String nodeName, String databaseName) throws InterruptedException {
        while (this.messageService == null || this.messageService.getDatabase(databaseName) == null || !this.isNodeOnline(nodeName, databaseName)) {
            Thread.sleep(100L);
        }
    }

    public ODatabaseLifecycleListener.PRIORITY getPriority() {
        return ODatabaseLifecycleListener.PRIORITY.LAST;
    }

    public void config(OServer oServer, OServerParameterConfiguration[] iParams) {
        this.serverInstance = oServer;
        oServer.setVariable("ODistributedAbstractPlugin", (Object)this);
        for (OServerParameterConfiguration param : iParams) {
            if (param.name.equalsIgnoreCase("enabled")) {
                if (Boolean.parseBoolean(OSystemVariableResolver.resolveSystemVariables((String)param.value))) continue;
                this.enabled = false;
                return;
            }
            if (param.name.equalsIgnoreCase("nodeName")) {
                this.nodeName = param.value;
                if (!this.nodeName.contains(".")) continue;
                throw new OConfigurationException("Illegal node name '" + this.nodeName + "'. '.' is not allowed in node name");
            }
            if (!param.name.startsWith(PAR_DEF_DISTRIB_DB_CONFIG)) continue;
            this.setDefaultDatabaseConfigFile(param.value);
        }
        if (this.serverInstance.getUser("replicator") == null) {
            OLogManager.instance().config((Object)this, "Found 'replicator' user. Starting from OrientDB v2.2 this internal user is no needed anymore. Removing it...", new Object[0]);
        }
        try {
            this.serverInstance.dropUser("replicator");
        }
        catch (IOException e) {
            throw OException.wrapException((OException)new OConfigurationException("Error on deleting 'replicator' user"), (Throwable)e);
        }
    }

    public synchronized String getCoordinatorServer() {
        return this.coordinatorServer;
    }

    public File getDefaultDatabaseConfigFile() {
        return this.defaultDatabaseConfigFile;
    }

    public void setDefaultDatabaseConfigFile(String iFile) {
        this.defaultDatabaseConfigFile = new File(OSystemVariableResolver.resolveSystemVariables((String)iFile));
        if (!this.defaultDatabaseConfigFile.exists()) {
            throw new OConfigurationException("Cannot find distributed database config file: " + this.defaultDatabaseConfigFile);
        }
    }

    public void startup() {
        if (!this.enabled) {
            return;
        }
        Orient.instance().addDbLifecycleListener((ODatabaseLifecycleListener)this);
    }

    public ODistributedAbstractPlugin registerLifecycleListener(ODistributedLifecycleListener iListener) {
        this.listeners.add(iListener);
        return this;
    }

    public ODistributedAbstractPlugin unregisterLifecycleListener(ODistributedLifecycleListener iListener) {
        this.listeners.remove(iListener);
        return this;
    }

    public void shutdown() {
        if (!this.enabled) {
            return;
        }
        for (ORemoteServerController server : this.remoteServers.values()) {
            server.close();
        }
        this.remoteServers.clear();
        if (this.publishLocalNodeConfigurationTask != null) {
            this.publishLocalNodeConfigurationTask.cancel();
        }
        if (this.healthCheckerTask != null) {
            this.healthCheckerTask.cancel();
        }
        if (this.haStatsTask != null) {
            this.haStatsTask.cancel();
        }
        if (this.messageService != null) {
            this.messageService.shutdown();
        }
        this.activeNodes.clear();
        this.activeNodesNamesByUuid.clear();
        this.activeNodesUuidByName.clear();
        this.setNodeStatus(ODistributedServerManager.NODE_STATUS.OFFLINE);
        Orient.instance().removeDbLifecycleListener((ODatabaseLifecycleListener)this);
        for (ODistributedStorage s : this.storages.values()) {
            try {
                s.shutdownAsynchronousWorker();
                s.close();
            }
            catch (Exception exception) {}
        }
        this.storages.clear();
    }

    public ODistributedLockManagerRequester getLockManagerRequester() {
        return this.lockManagerRequester;
    }

    public ODistributedLockManagerExecutor getLockManagerExecutor() {
        return this.lockManagerExecutor;
    }

    public void onOpen(ODatabaseInternal iDatabase) {
        if (!this.isRelatedToLocalServer(iDatabase)) {
            return;
        }
        if (this.status != ODistributedServerManager.NODE_STATUS.ONLINE && this.status != ODistributedServerManager.NODE_STATUS.STARTING) {
            return;
        }
        ODatabaseDocumentInternal currDb = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        try {
            String dbName = iDatabase.getName();
            ODistributedConfiguration cfg = this.getDatabaseConfiguration(dbName);
            if (cfg == null) {
                return;
            }
            ODistributedDatabaseImpl distribDatabase = this.getMessageService().getDatabase(dbName);
            if (distribDatabase == null) {
                distribDatabase = this.messageService.registerDatabase(dbName, cfg);
                distribDatabase.resume();
                distribDatabase.setOnline();
            }
            if (!(iDatabase.getStorage() instanceof ODistributedStorage) || ((ODistributedStorage)iDatabase.getStorage()).getDistributedManager().isOffline()) {
                ODistributedStorage storage = this.getStorage(dbName);
                storage.wrap((OAbstractPaginatedStorage)iDatabase.getStorage().getUnderlying());
                iDatabase.replaceStorage((OStorage)storage);
                if (this.isNodeOnline(this.nodeName, dbName)) {
                    this.installDbClustersLocalStrategy(iDatabase);
                }
            }
        }
        catch (HazelcastException e) {
            throw new OOfflineNodeException("Hazelcast instance is not available");
        }
        catch (HazelcastInstanceNotActiveException e) {
            throw new OOfflineNodeException("Hazelcast instance is not available");
        }
        finally {
            ODatabaseRecordThreadLocal.INSTANCE.set(currDb);
        }
    }

    public void onClose(ODatabaseInternal iDatabase) {
    }

    public void onDrop(ODatabaseInternal iDatabase) {
        this.removeStorage(iDatabase.getName());
        ODistributedMessageServiceImpl msgService = this.getMessageService();
        if (msgService != null) {
            msgService.unregisterDatabase(iDatabase.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStorage(String name) {
        ConcurrentHashMap<String, ODistributedStorage> concurrentHashMap = this.storages;
        synchronized (concurrentHashMap) {
            ODistributedStorage storage = this.storages.remove(name);
            if (storage != null) {
                storage.close(true, true);
            }
        }
    }

    public void onDropClass(ODatabaseInternal iDatabase, OClass iClass) {
    }

    public String getName() {
        return "cluster";
    }

    public void sendShutdown() {
        this.shutdown();
    }

    public String getNodeName(Member iMember) {
        return this.getNodeName(iMember, true);
    }

    public String getNodeName(Member iMember, boolean useCache) {
        if (iMember == null || iMember.getUuid() == null) {
            return "?";
        }
        if (this.nodeUuid.equals(iMember.getUuid())) {
            return this.nodeName;
        }
        String name = this.activeNodesNamesByUuid.get(iMember.getUuid());
        if (name != null) {
            return name;
        }
        ODocument cfg = this.getNodeConfigurationByUuid(iMember.getUuid(), useCache);
        if (cfg != null) {
            return (String)cfg.field("name");
        }
        return "ext:" + iMember.getUuid();
    }

    public boolean updateCachedDatabaseConfiguration(String iDatabaseName, OModifiableDistributedConfiguration cfg) {
        int currVersion;
        boolean modified;
        Integer oldVersion;
        ODistributedStorage stg = this.storages.get(iDatabaseName);
        if (stg == null) {
            return false;
        }
        ODistributedConfiguration dCfg = stg.getDistributedConfiguration();
        ODocument oldCfg = dCfg != null ? dCfg.getDocument() : null;
        Integer n = oldVersion = oldCfg != null ? (Integer)oldCfg.field("version") : null;
        if (oldVersion == null) {
            oldVersion = 0;
        }
        boolean bl = modified = (currVersion = cfg.getVersion()) > oldVersion;
        if (oldCfg != null && !modified) {
            OLogManager.instance().debug((Object)this, "Skip saving of distributed configuration file for database '%s' because is unchanged (version %d)", new Object[]{iDatabaseName, currVersion});
            return false;
        }
        stg.setDistributedConfiguration(cfg);
        ODistributedServerLog.info((Object)((Object)this), (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Broadcasting new distributed configuration for database: %s (version=%d)\n", (Object[])new Object[]{iDatabaseName, currVersion});
        return modified;
    }

    public ODistributedConfiguration getDatabaseConfiguration(String iDatabaseName) {
        return this.getDatabaseConfiguration(iDatabaseName, true);
    }

    public ODistributedConfiguration getDatabaseConfiguration(String iDatabaseName, boolean createIfNotPresent) {
        ODistributedStorage stg;
        ODistributedStorage oDistributedStorage = stg = createIfNotPresent ? this.getStorage(iDatabaseName) : this.getStorageIfExists(iDatabaseName);
        if (stg == null) {
            return null;
        }
        return stg.getDistributedConfiguration();
    }

    public OServer getServerInstance() {
        return this.serverInstance;
    }

    public ODocument getClusterConfiguration() {
        if (!this.enabled) {
            return null;
        }
        ODocument cluster = new ODocument();
        cluster.field("localName", (Object)this.getName());
        cluster.field("localId", (Object)this.nodeUuid);
        ArrayList<ODocument> members = new ArrayList<ODocument>();
        cluster.field("members", members, new OType[]{OType.EMBEDDEDLIST});
        for (Member member : this.activeNodes.values()) {
            members.add(this.getNodeConfigurationByUuid(member.getUuid(), true));
        }
        return cluster;
    }

    public abstract String getPublicAddress();

    public ODocument getLocalNodeConfiguration() {
        ODocument nodeCfg = new ODocument();
        nodeCfg.setTrackingChanges(false);
        nodeCfg.field("id", (Object)this.nodeId);
        nodeCfg.field("uuid", (Object)this.nodeUuid);
        nodeCfg.field("name", (Object)this.nodeName);
        nodeCfg.field("publicAddress", (Object)this.getPublicAddress());
        nodeCfg.field("startedOn", (Object)this.startedOn);
        nodeCfg.field("status", (Object)this.getNodeStatus());
        nodeCfg.field("connections", (Object)this.serverInstance.getClientConnectionManager().getTotal());
        ArrayList listeners = new ArrayList();
        nodeCfg.field("listeners", listeners, new OType[]{OType.EMBEDDEDLIST});
        for (OServerNetworkListener listener : this.serverInstance.getNetworkListeners()) {
            HashMap<String, String> listenerCfg = new HashMap<String, String>();
            listeners.add(listenerCfg);
            listenerCfg.put("protocol", listener.getProtocolType().getSimpleName());
            listenerCfg.put("listen", listener.getListeningAddress(true));
        }
        OServerUserConfiguration user = this.serverInstance.getUser(REPLICATOR_USER);
        if (user != null) {
            nodeCfg.field("user_replicator", (Object)this.serverInstance.getUser((String)REPLICATOR_USER).password);
        }
        nodeCfg.field("databases", this.getManagedDatabases());
        long maxMem = Runtime.getRuntime().maxMemory();
        long totMem = Runtime.getRuntime().totalMemory();
        long freeMem = Runtime.getRuntime().freeMemory();
        long usedMem = totMem - freeMem;
        nodeCfg.field("usedMemory", (Object)usedMem);
        nodeCfg.field("freeMemory", (Object)freeMem);
        nodeCfg.field("maxMemory", (Object)maxMem);
        nodeCfg.field("latencies", (Object)this.getMessageService().getLatencies(), new OType[]{OType.EMBEDDED});
        nodeCfg.field("messages", (Object)this.getMessageService().getMessageStats(), new OType[]{OType.EMBEDDED});
        Iterator it = Orient.instance().getDbLifecycleListeners();
        while (it.hasNext()) {
            ODatabaseLifecycleListener listener = (ODatabaseLifecycleListener)it.next();
            if (listener == null) continue;
            listener.onLocalNodeConfigurationRequest(nodeCfg);
        }
        return nodeCfg;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public ODistributedServerManager.NODE_STATUS getNodeStatus() {
        return this.status;
    }

    public void setNodeStatus(ODistributedServerManager.NODE_STATUS iStatus) {
        if (this.status.equals((Object)iStatus)) {
            return;
        }
        this.status = iStatus;
        ODistributedServerLog.warn((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Updated node status to '%s'", (Object[])new Object[]{this.status});
    }

    public boolean checkNodeStatus(ODistributedServerManager.NODE_STATUS iStatus2Check) {
        return this.status.equals((Object)iStatus2Check);
    }

    public ODistributedResponse sendRequest(String iDatabaseName, Collection<String> iClusterNames, Collection<String> iTargetNodes, ORemoteTask iTask, long reqId, ODistributedRequest.EXECUTION_MODE iExecutionMode, Object localResult, OCallable<Void, ODistributedRequestId> iAfterSentCallback) {
        ODistributedRequest req = new ODistributedRequest(this.taskFactory, this.nodeId, reqId, iDatabaseName, iTask);
        ODatabaseDocumentInternal currentDatabase = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        if (currentDatabase != null && currentDatabase.getUser() != null) {
            req.setUserRID((ORecordId)currentDatabase.getUser().getIdentity().getIdentity());
        }
        ODistributedDatabaseImpl db = this.messageService.getDatabase(iDatabaseName);
        if (iTargetNodes == null || iTargetNodes.isEmpty()) {
            ODistributedServerLog.error((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"No nodes configured for partition '%s.%s' request: %s", (Object[])new Object[]{iDatabaseName, iClusterNames, req});
            throw new ODistributedException("No nodes configured for partition '" + iDatabaseName + "." + iClusterNames + "' request: " + req);
        }
        if (db == null) {
            ODistributedServerLog.error((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Distributed database '%s' not found", (Object[])new Object[]{iDatabaseName});
            throw new ODistributedException("Distributed database '" + iDatabaseName + "' not found on server '" + this.nodeName + "'");
        }
        this.messageService.updateMessageStats(iTask.getName());
        return db.send2Nodes(req, iClusterNames, iTargetNodes, iExecutionMode, localResult, iAfterSentCallback);
    }

    public Object executeOnLocalNode(final ODistributedRequestId reqId, final ORemoteTask task, final ODatabaseDocumentInternal database) {
        if (database != null && !(database.getStorage() instanceof ODistributedStorage)) {
            throw new ODistributedException("Distributed storage was not installed for database '" + database.getName() + "'. Implementation found: " + database.getStorage().getClass().getName());
        }
        final ODistributedAbstractPlugin manager = this;
        return OScenarioThreadLocal.executeAsDistributed((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    Object result = task.execute(reqId, ODistributedAbstractPlugin.this.serverInstance, (ODistributedServerManager)manager, database);
                    if (result instanceof Throwable && !(result instanceof OException)) {
                        ODistributedServerLog.error((Object)this, (String)ODistributedAbstractPlugin.this.nodeName, (String)ODistributedAbstractPlugin.this.getNodeNameById(reqId.getNodeId()), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Error on executing request %d (%s) on local node: ", (Throwable)((Throwable)result), (Object[])new Object[]{reqId, task});
                    } else {
                        ODistributedDatabaseImpl ddb;
                        String sourceNodeName = task.getNodeSource();
                        if (database != null && (ddb = ODistributedAbstractPlugin.this.getMessageService().getDatabase(database.getName())) != null && !(result instanceof Throwable) && task instanceof OAbstractReplicatedTask) {
                            ddb.setLSN(sourceNodeName, ((OAbstractReplicatedTask)task).getLastLSN(), true);
                        }
                    }
                    return result;
                }
                catch (InterruptedException e) {
                    ODistributedServerLog.debug((Object)this, (String)ODistributedAbstractPlugin.this.nodeName, (String)ODistributedAbstractPlugin.this.getNodeNameById(reqId.getNodeId()), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Interrupted execution on executing distributed request %s on local node: %s", (Throwable)e, (Object[])new Object[]{reqId, task});
                    return e;
                }
                catch (Throwable e) {
                    if (!(e instanceof OException)) {
                        ODistributedServerLog.error((Object)this, (String)ODistributedAbstractPlugin.this.nodeName, (String)ODistributedAbstractPlugin.this.getNodeNameById(reqId.getNodeId()), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Error on executing distributed request %s on local node: %s", (Throwable)e, (Object[])new Object[]{reqId, task});
                    }
                    return e;
                }
            }
        });
    }

    public Set<String> getManagedDatabases() {
        return this.messageService != null ? this.messageService.getDatabases() : Collections.EMPTY_SET;
    }

    public String getLocalNodeName() {
        return this.nodeName;
    }

    public int getLocalNodeId() {
        return this.nodeId;
    }

    public void onLocalNodeConfigurationRequest(ODocument iConfiguration) {
    }

    public void onCreateClass(ODatabaseInternal iDatabase, OClass iClass) {
        if (OScenarioThreadLocal.INSTANCE.isRunModeDistributed()) {
            return;
        }
        if (this.status != ODistributedServerManager.NODE_STATUS.ONLINE && this.status != ODistributedServerManager.NODE_STATUS.STARTING) {
            return;
        }
        if (!this.isRelatedToLocalServer(iDatabase)) {
            return;
        }
        if (this.messageService.getDatabase(iDatabase.getName()) == null) {
            return;
        }
        ODistributedConfiguration cfg = this.getDatabaseConfiguration(iDatabase.getName());
        this.installClustersOfClass(iDatabase, iClass, cfg.modify());
    }

    public ODocument getStats() {
        ODocument doc = new ODocument();
        HashMap nodes = new HashMap();
        doc.field("nodes", nodes);
        HashMap<String, Object> localNode = new HashMap<String, Object>();
        doc.field("localNode", localNode);
        localNode.put("name", this.nodeName);
        localNode.put("averageResponseTime", this.messageService.getAverageResponseTime());
        HashMap databases = new HashMap();
        localNode.put("databases", databases);
        for (String dbName : this.messageService.getDatabases()) {
            HashMap db = new HashMap();
            databases.put(dbName, db);
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNodeNameById(int id) {
        if (id < 0) {
            throw new IllegalArgumentException("Node id " + id + " is invalid");
        }
        List<String> list = this.registeredNodeById;
        synchronized (list) {
            if (id < this.registeredNodeById.size()) {
                return this.registeredNodeById.get(id);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNodeIdByName(String name) {
        Map<String, Integer> map = this.registeredNodeByName;
        synchronized (map) {
            Integer val = this.registeredNodeByName.get(name);
            if (val == null) {
                return -1;
            }
            return val;
        }
    }

    public String getNodeUuidByName(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Node name " + name + " is invalid");
        }
        return this.activeNodesUuidByName.get(name);
    }

    public void updateLastClusterChange() {
        this.lastClusterChangeOn = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reassignClustersOwnership(final String iNode, String databaseName, OModifiableDistributedConfiguration cfg) {
        final ODatabaseDocumentTx database = this.serverInstance.openDatabase(databaseName, "internal", "internal", null, true);
        try {
            this.executeInDistributedDatabaseLock(databaseName, 15000L, cfg, new OCallable<Boolean, OModifiableDistributedConfiguration>(){

                public Boolean call(OModifiableDistributedConfiguration cfg) {
                    ODistributedAbstractPlugin.this.rebalanceClusterOwnership(iNode, (ODatabaseInternal)database, cfg);
                    return null;
                }
            });
        }
        finally {
            database.activateOnCurrentThread();
            database.close();
        }
    }

    public boolean isNodeAvailable(String iNodeName, String iDatabaseName) {
        ODistributedServerManager.DB_STATUS s = this.getDatabaseStatus(iNodeName, iDatabaseName);
        return s != ODistributedServerManager.DB_STATUS.OFFLINE && s != ODistributedServerManager.DB_STATUS.NOT_AVAILABLE;
    }

    public boolean isNodeStatusEqualsTo(String iNodeName, String iDatabaseName, ODistributedServerManager.DB_STATUS ... statuses) {
        ODistributedServerManager.DB_STATUS s = this.getDatabaseStatus(iNodeName, iDatabaseName);
        for (ODistributedServerManager.DB_STATUS st : statuses) {
            if (s != st) continue;
            return true;
        }
        return false;
    }

    public boolean isNodeAvailable(String iNodeName) {
        if (iNodeName == null) {
            return false;
        }
        return this.activeNodes.containsKey(iNodeName);
    }

    public boolean isNodeOnline(String iNodeName, String iDatabaseName) {
        return this.getDatabaseStatus(iNodeName, iDatabaseName) == ODistributedServerManager.DB_STATUS.ONLINE;
    }

    public boolean isOffline() {
        return this.status != ODistributedServerManager.NODE_STATUS.ONLINE;
    }

    public int getAvailableNodes(Collection<String> iNodes, String databaseName) {
        Iterator<String> it = iNodes.iterator();
        while (it.hasNext()) {
            String node = it.next();
            if (this.isNodeAvailable(node, databaseName)) continue;
            it.remove();
        }
        return iNodes.size();
    }

    public int getNodesWithStatus(Collection<String> iNodes, String databaseName, ODistributedServerManager.DB_STATUS ... statuses) {
        Iterator<String> it = iNodes.iterator();
        while (it.hasNext()) {
            String node = it.next();
            if (this.isNodeStatusEqualsTo(node, databaseName, statuses)) continue;
            it.remove();
        }
        return iNodes.size();
    }

    public String toString() {
        return this.nodeName;
    }

    public ODistributedMessageServiceImpl getMessageService() {
        while (this.messageService == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new OOfflineNodeException("Message Service is not available");
            }
        }
        return this.messageService;
    }

    public long getLastClusterChangeOn() {
        return this.lastClusterChangeOn;
    }

    public int getAvailableNodes(String iDatabaseName) {
        int availableNodes = 0;
        for (Map.Entry<String, Member> entry : this.activeNodes.entrySet()) {
            if (!this.isNodeAvailable(entry.getKey(), iDatabaseName)) continue;
            ++availableNodes;
        }
        return availableNodes;
    }

    public List<String> getOnlineNodes(String iDatabaseName) {
        ArrayList<String> onlineNodes = new ArrayList<String>(this.activeNodes.size());
        for (Map.Entry<String, Member> entry : this.activeNodes.entrySet()) {
            if (!this.isNodeOnline(entry.getKey(), iDatabaseName)) continue;
            onlineNodes.add(entry.getKey());
        }
        return onlineNodes;
    }

    public synchronized boolean installDatabase(final boolean iStartup, final String databaseName, final boolean forceDeployment, final boolean tryWithDeltaFirst) {
        if (this.getDatabaseStatus(this.getLocalNodeName(), databaseName) == ODistributedServerManager.DB_STATUS.OFFLINE) {
            return false;
        }
        if (databaseName.equalsIgnoreCase("OSystem")) {
            return false;
        }
        final ODistributedDatabaseImpl distrDatabase = this.messageService.registerDatabase(databaseName, null);
        return this.executeInDistributedDatabaseLock(databaseName, 0L, null, new OCallable<Boolean, OModifiableDistributedConfiguration>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean call(OModifiableDistributedConfiguration cfg) {
                boolean databaseInstalled;
                block18: {
                    List nodes = cfg.getServers(null, ODistributedAbstractPlugin.this.nodeName);
                    ODistributedAbstractPlugin.this.getAvailableNodes(nodes, databaseName);
                    if (nodes.size() == 0) {
                        ODistributedServerLog.error((Object)this, (String)ODistributedAbstractPlugin.this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Cannot install database '%s' on local node, because no servers are available", (Object[])new Object[]{databaseName});
                        return false;
                    }
                    ODistributedServerLog.info((Object)this, (String)ODistributedAbstractPlugin.this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Current node is a %s for database '%s'", (Object[])new Object[]{cfg.getServerRole(ODistributedAbstractPlugin.this.nodeName), databaseName});
                    Set configuredDatabases = ODistributedAbstractPlugin.this.serverInstance.getAvailableStorageNames().keySet();
                    if (!iStartup && configuredDatabases.contains(databaseName)) {
                        return false;
                    }
                    ODistributedStorage stg = ODistributedAbstractPlugin.this.getStorage(databaseName);
                    stg.setDistributedConfiguration(cfg);
                    distrDatabase.suspend();
                    Boolean deploy = forceDeployment ? Boolean.TRUE : (Boolean)cfg.getDocument().field("autoDeploy");
                    try {
                        if (!distrDatabase.exists() || distrDatabase.getSyncConfiguration().getMomentum().isEmpty()) {
                            if (deploy == null || !deploy.booleanValue()) {
                                ODistributedServerLog.debug((Object)this, (String)ODistributedAbstractPlugin.this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Skipping download of database '%s' from the cluster because autoDeploy=false", (Object[])new Object[]{databaseName});
                                ODistributedAbstractPlugin.this.setDatabaseStatus(ODistributedAbstractPlugin.this.nodeName, databaseName, ODistributedServerManager.DB_STATUS.ONLINE);
                                distrDatabase.resume();
                                return false;
                            }
                            databaseInstalled = ODistributedAbstractPlugin.this.requestFullDatabase(distrDatabase, databaseName, iStartup, cfg);
                        } else if (tryWithDeltaFirst) {
                            try {
                                databaseInstalled = ODistributedAbstractPlugin.this.requestDatabaseDelta(distrDatabase, databaseName, cfg);
                            }
                            catch (ODistributedDatabaseDeltaSyncException e) {
                                ODistributedAbstractPlugin.this.removeStorage(databaseName);
                                if (deploy == null || !deploy.booleanValue()) {
                                    ODistributedServerLog.debug((Object)this, (String)ODistributedAbstractPlugin.this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Skipping download of database '%s' from the cluster because autoDeploy=false", (Object[])new Object[]{databaseName});
                                    ODistributedAbstractPlugin.this.setDatabaseStatus(ODistributedAbstractPlugin.this.nodeName, databaseName, ODistributedServerManager.DB_STATUS.ONLINE);
                                    distrDatabase.resume();
                                    return false;
                                }
                                databaseInstalled = ODistributedAbstractPlugin.this.requestFullDatabase(distrDatabase, databaseName, iStartup, cfg);
                            }
                        } else {
                            databaseInstalled = ODistributedAbstractPlugin.this.requestFullDatabase(distrDatabase, databaseName, iStartup, cfg);
                        }
                        if (!databaseInstalled) break block18;
                        ODatabaseDocumentTx db = distrDatabase.getDatabaseInstance();
                        try {
                            try {
                                distrDatabase.getSyncConfiguration().setLastLSN(ODistributedAbstractPlugin.this.nodeName, ((OLocalPaginatedStorage)db.getStorage().getUnderlying()).getLSN(), true);
                            }
                            catch (IOException e) {
                                ODistributedServerLog.error((Object)this, (String)ODistributedAbstractPlugin.this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on setting LSN after the installation of database '%s'", (Object[])new Object[]{databaseName});
                            }
                        }
                        finally {
                            db.close();
                        }
                    }
                    catch (ODatabaseIsOldException e) {
                        ODistributedAbstractPlugin.this.setDatabaseStatus(ODistributedAbstractPlugin.this.nodeName, databaseName, ODistributedServerManager.DB_STATUS.ONLINE);
                        Set<String> otherServers = ODistributedAbstractPlugin.this.getAvailableNodeNames(databaseName);
                        otherServers.remove(ODistributedAbstractPlugin.this.nodeName);
                        ODistributedServerLog.info((Object)this, (String)ODistributedAbstractPlugin.this.nodeName, (String)otherServers.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Current copy of database '%s' is newer then the copy present in the cluster. Use the local copy and force other nodes to download this", (Object[])new Object[]{databaseName});
                        for (String s : otherServers) {
                            ODistributedAbstractPlugin.this.setDatabaseStatus(s, databaseName, ODistributedServerManager.DB_STATUS.NOT_AVAILABLE);
                        }
                        databaseInstalled = true;
                        distrDatabase.resume();
                    }
                }
                return databaseInstalled;
            }
        });
    }

    protected boolean requestFullDatabase(ODistributedDatabaseImpl distrDatabase, String databaseName, boolean backupDatabase, OModifiableDistributedConfiguration cfg) {
        for (int retry = 0; retry < 10; ++retry) {
            if (!this.requestDatabaseFullSync(distrDatabase, backupDatabase, databaseName, retry > 0, cfg)) continue;
            return true;
        }
        return false;
    }

    public boolean requestDatabaseDelta(ODistributedDatabaseImpl distrDatabase, String databaseName, OModifiableDistributedConfiguration cfg) {
        List nodes = cfg.getServers(null, this.nodeName);
        this.getAvailableNodes(nodes, databaseName);
        if (nodes.size() == 0) {
            return false;
        }
        ODistributedServerLog.warn((Object)((Object)this), (String)this.nodeName, (String)nodes.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"requesting delta database sync for '%s' on local server...", (Object[])new Object[]{databaseName});
        HashMap<String, OLogSequenceNumber> selectedNodes = new HashMap<String, OLogSequenceNumber>(nodes.size());
        for (String string : nodes) {
            OLogSequenceNumber lsn = distrDatabase.getSyncConfiguration().getLastLSN(string);
            if (lsn != null) {
                selectedNodes.put(string, lsn);
                continue;
            }
            ODistributedServerLog.info((Object)((Object)this), (String)this.nodeName, (String)string, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Last LSN not found for database '%s', skip delta database sync", (Object[])new Object[]{databaseName});
        }
        if (selectedNodes.isEmpty()) {
            ODistributedServerLog.error((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"No LSN found for delta sync for database '%s'. Asking for full database sync...", (Object[])new Object[]{databaseName});
            throw new ODistributedDatabaseDeltaSyncException("Requested database delta sync but no LSN was found");
        }
        block4: for (Map.Entry entry : selectedNodes.entrySet()) {
            String targetNode = (String)entry.getKey();
            OLogSequenceNumber lsn = (OLogSequenceNumber)entry.getValue();
            OSyncDatabaseDeltaTask deployTask = new OSyncDatabaseDeltaTask(lsn, distrDatabase.getSyncConfiguration().getLastOperationTimestamp());
            ArrayList<String> targetNodes = new ArrayList<String>(1);
            targetNodes.add(targetNode);
            ODistributedServerLog.info((Object)((Object)this), (String)this.nodeName, (String)targetNode, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Requesting database delta sync for '%s' LSN=%s...", (Object[])new Object[]{databaseName, lsn});
            try {
                Map results = (Map)this.sendRequest(databaseName, null, targetNodes, (ORemoteTask)deployTask, this.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null).getPayload();
                ODistributedServerLog.debug((Object)((Object)this), (String)this.nodeName, (String)((Object)selectedNodes).toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Database delta sync returned: %s", (Object[])new Object[]{results});
                String dbPath = this.serverInstance.getDatabaseDirectory() + databaseName;
                for (Map.Entry r : results.entrySet()) {
                    Object value = r.getValue();
                    if (value instanceof Boolean) continue;
                    String server = (String)r.getKey();
                    if (value instanceof ODistributedDatabaseDeltaSyncException) {
                        ODistributedDatabaseDeltaSyncException exc = (ODistributedDatabaseDeltaSyncException)((Object)value);
                        ODistributedServerLog.warn((Object)((Object)this), (String)this.nodeName, (String)server, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Error on installing database delta for '%s' (err=%s)", (Object[])new Object[]{databaseName, exc.getMessage()});
                        ODistributedServerLog.warn((Object)((Object)this), (String)this.nodeName, (String)server, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Requesting full database '%s' sync...", (Object[])new Object[]{databaseName});
                        this.setDatabaseStatus(server, databaseName, ODistributedServerManager.DB_STATUS.ONLINE);
                        throw (ODistributedDatabaseDeltaSyncException)((Object)value);
                    }
                    if (value instanceof ODatabaseIsOldException) {
                        throw (ODatabaseIsOldException)((Object)value);
                    }
                    if (value instanceof Throwable) {
                        ODistributedServerLog.error((Object)((Object)this), (String)this.nodeName, (String)server, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Error on installing database delta %s in %s (%s)", (Object[])new Object[]{value, databaseName, dbPath, value});
                        this.setDatabaseStatus(this.nodeName, databaseName, ODistributedServerManager.DB_STATUS.NOT_AVAILABLE);
                        return false;
                    }
                    if (value instanceof ODistributedDatabaseChunk) {
                        File uniqueClustersBackupDirectory = this.getClusterOwnedExclusivelyByCurrentNode(dbPath, databaseName);
                        this.installDatabaseFromNetwork(dbPath, databaseName, distrDatabase, server, (ODistributedDatabaseChunk)value, true, uniqueClustersBackupDirectory, cfg);
                        ODistributedServerLog.info((Object)((Object)this), (String)this.nodeName, (String)targetNode, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Installed delta of database '%s'...", (Object[])new Object[]{databaseName});
                        if (cfg.isSharded()) continue;
                        continue block4;
                    }
                    throw new IllegalArgumentException("Type " + value + " not supported");
                }
            }
            catch (ODatabaseIsOldException e) {
                throw e;
            }
            catch (Exception e) {
                ODistributedServerLog.error((Object)((Object)this), (String)this.nodeName, (String)targetNode, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Error on asking delta backup of database '%s' (err=%s)", (Object[])new Object[]{databaseName, e.getMessage()});
                throw new ODistributedDatabaseDeltaSyncException(lsn, e.toString());
            }
        }
        distrDatabase.resume();
        return true;
    }

    protected boolean requestDatabaseFullSync(ODistributedDatabaseImpl distrDatabase, boolean backupDatabase, String databaseName, boolean iAskToAllNodes, OModifiableDistributedConfiguration cfg) {
        List nodes = cfg.getServers(null, this.nodeName);
        if (nodes.isEmpty()) {
            ODistributedServerLog.warn((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Cannot request full deploy of database '%s' because there are no nodes available with such database", (Object[])new Object[]{databaseName});
            return false;
        }
        ArrayList<String> selectedNodes = new ArrayList<String>();
        if (!iAskToAllNodes) {
            for (String n : nodes) {
                if (!this.isNodeStatusEqualsTo(n, databaseName, ODistributedServerManager.DB_STATUS.BACKUP)) continue;
                selectedNodes.add(n);
                break;
            }
            if (selectedNodes.isEmpty()) {
                for (String f : nodes) {
                    if (!this.isNodeStatusEqualsTo(f, databaseName, ODistributedServerManager.DB_STATUS.ONLINE, ODistributedServerManager.DB_STATUS.BACKUP)) continue;
                    selectedNodes.add(f);
                    break;
                }
            }
        }
        if (selectedNodes.isEmpty()) {
            selectedNodes.addAll(nodes);
        }
        ODistributedServerLog.warn((Object)((Object)this), (String)this.nodeName, (String)((Object)selectedNodes).toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Requesting deploy of database '%s' on local server...", (Object[])new Object[]{databaseName});
        OLogSequenceNumber lastLSN = distrDatabase.getSyncConfiguration().getLastLSN(this.getLocalNodeName());
        OSyncDatabaseTask deployTask = new OSyncDatabaseTask(lastLSN, distrDatabase.getSyncConfiguration().getLastOperationTimestamp());
        Map results = (Map)this.sendRequest(databaseName, null, selectedNodes, (ORemoteTask)deployTask, this.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null).getPayload();
        ODistributedServerLog.debug((Object)((Object)this), (String)this.nodeName, (String)((Object)selectedNodes).toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Deploy returned: %s", (Object[])new Object[]{results});
        String dbPath = this.serverInstance.getDatabaseDirectory() + databaseName;
        for (Map.Entry r : results.entrySet()) {
            Object value = r.getValue();
            if (value instanceof Boolean) continue;
            if (value instanceof ODatabaseIsOldException) {
                throw (ODatabaseIsOldException)((Object)value);
            }
            if (value instanceof Throwable) {
                ODistributedServerLog.error((Object)((Object)this), (String)this.nodeName, (String)((String)r.getKey()), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Error on installing database '%s' in %s", (Throwable)((Exception)value), (Object[])new Object[]{databaseName, dbPath});
                this.setDatabaseStatus(this.nodeName, databaseName, ODistributedServerManager.DB_STATUS.NOT_AVAILABLE);
                if (!(value instanceof ODistributedException)) continue;
                throw (ODistributedException)((Object)value);
            }
            if (value instanceof ODistributedDatabaseChunk) {
                File uniqueClustersBackupDirectory = this.getClusterOwnedExclusivelyByCurrentNode(dbPath, databaseName);
                ODistributedStorage stg = this.storages.remove(databaseName);
                if (stg != null) {
                    stg.close(true, false);
                }
                if (backupDatabase) {
                    this.backupCurrentDatabase(databaseName);
                }
                this.installDatabaseFromNetwork(dbPath, databaseName, distrDatabase, (String)r.getKey(), (ODistributedDatabaseChunk)value, false, uniqueClustersBackupDirectory, cfg);
                distrDatabase.resume();
                return true;
            }
            throw new IllegalArgumentException("Type " + value + " not supported");
        }
        throw new ODistributedException("No response received from remote nodes for auto-deploy of database '" + databaseName + "'");
    }

    protected File getClusterOwnedExclusivelyByCurrentNode(String dbPath, String iDatabaseName) {
        ODistributedConfiguration cfg = this.getDatabaseConfiguration(iDatabaseName);
        HashSet<String> clusters = new HashSet<String>();
        for (String clName : cfg.getClusterNames()) {
            List servers = cfg.getServers(clName, null);
            if (servers == null || servers.size() != 1 || !((String)servers.get(0)).equals(this.getLocalNodeName())) continue;
            clusters.add(clName);
        }
        if (!clusters.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            Orient.instance();
            String backupDirectory = stringBuilder.append(Orient.getHomePath()).append("/temp/db_").append(iDatabaseName).toString();
            File backupFullPath = new File(backupDirectory);
            if (backupFullPath.exists()) {
                OFileUtils.deleteRecursively((File)backupFullPath);
            } else {
                backupFullPath.mkdirs();
            }
            ODistributedServerLog.warn((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Saving clusters %s to directory '%s' to be replaced after distributed full backup...", (Object[])new Object[]{clusters, backupFullPath});
            for (String clName : clusters) {
                File oldFile = new File(dbPath + "/" + clName + ".pcl");
                File newFile = new File(backupFullPath + "/" + clName + ".pcl");
                if (oldFile.exists() && !oldFile.renameTo(newFile)) {
                    ODistributedServerLog.error((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Cannot make a safe copy of exclusive clusters. Error on moving file %s -> %s: restore of database '%s' has been aborted because unsafe", (Object[])new Object[]{oldFile, newFile, iDatabaseName});
                    throw new ODistributedException("Cannot make a safe copy of exclusive clusters");
                }
                oldFile = new File(dbPath + "/" + clName + ".cpm");
                newFile = new File(backupFullPath + "/" + clName + ".cpm");
                if (!oldFile.exists() || oldFile.renameTo(newFile)) continue;
                ODistributedServerLog.error((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Cannot make a safe copy of exclusive clusters. Error on moving file %s -> %s: restore of database '%s' has been aborted because unsafe", (Object[])new Object[]{oldFile, newFile, iDatabaseName});
                throw new ODistributedException("Cannot make a safe copy of exclusive clusters");
            }
            return backupFullPath;
        }
        return null;
    }

    protected void backupCurrentDatabase(String iDatabaseName) {
        String backuppath;
        Orient.instance().unregisterStorageByName(iDatabaseName);
        String backupdirectory = OGlobalConfiguration.DISTRIBUTED_BACKUP_DIRECTORY.getValueAsString();
        if (backupdirectory == null || OIOUtils.getStringContent((Object)backupdirectory).trim().isEmpty()) {
            return;
        }
        String string = backuppath = backupdirectory.startsWith("/") ? backupdirectory : this.serverInstance.getDatabaseDirectory() + backupdirectory;
        if (!backuppath.endsWith("/")) {
            backuppath = backuppath + "/";
        }
        backuppath = backuppath + iDatabaseName;
        File backupfullpath = new File(backuppath);
        File f = new File(backupdirectory);
        if (f.exists()) {
            OFileUtils.deleteRecursively((File)backupfullpath);
        } else {
            f.mkdirs();
        }
        String dbpath = this.serverInstance.getDatabaseDirectory() + iDatabaseName;
        ODistributedServerLog.warn((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"moving existent database '%s' in '%s' to '%s' and get a fresh copy from a remote node...", (Object[])new Object[]{iDatabaseName, dbpath, backuppath});
        File olddirectory = new File(dbpath);
        if (!olddirectory.renameTo(backupfullpath)) {
            ODistributedServerLog.error((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"error on moving existent database '%s' located in '%s' to '%s'. deleting old database...", (Object[])new Object[]{iDatabaseName, dbpath, backupfullpath});
            OFileUtils.deleteRecursively((File)olddirectory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void installDatabaseFromNetwork(final String dbPath, final String databaseName, ODistributedDatabaseImpl distrDatabase, final String iNode, final ODistributedDatabaseChunk firstChunk, boolean delta, File uniqueClustersBackupDirectory, OModifiableDistributedConfiguration cfg) {
        final String fileName = Orient.getTempPath() + "install_" + databaseName + ".zip";
        String localNodeName = this.nodeName;
        ODistributedServerLog.info((Object)((Object)this), (String)localNodeName, (String)iNode, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Copying remote database '%s' to: %s", (Object[])new Object[]{databaseName, fileName});
        final File file = new File(fileName);
        if (file.exists()) {
            file.delete();
        }
        try {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        catch (IOException e) {
            throw OException.wrapException((OException)new ODistributedException("Error on creating temp database file to install locally"), (Throwable)e);
        }
        File completedFile = new File(file.getAbsolutePath() + ".completed");
        if (completedFile.exists()) {
            completedFile.delete();
        }
        final AtomicReference momentum = new AtomicReference();
        try {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Thread.currentThread().setName("OrientDB installDatabase node=" + ODistributedAbstractPlugin.this.nodeName + " db=" + databaseName);
                        ODistributedDatabaseChunk chunk = firstChunk;
                        momentum.set(chunk.getMomentum());
                        FileOutputStream fOut = new FileOutputStream(fileName, false);
                        try {
                            long fileSize = ODistributedAbstractPlugin.this.writeDatabaseChunk(1, chunk, fOut);
                            int chunkNum = 2;
                            while (!chunk.last) {
                                ODistributedResponse response = ODistributedAbstractPlugin.this.sendRequest(databaseName, null, OMultiValue.getSingletonList((Object)iNode), (ORemoteTask)new OCopyDatabaseChunkTask(chunk.filePath, chunkNum, chunk.offset + (long)chunk.buffer.length, false), ODistributedAbstractPlugin.this.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null);
                                Object result = response.getPayload();
                                if (!(result instanceof Boolean)) {
                                    if (result instanceof Exception) {
                                        ODistributedServerLog.error((Object)this, (String)ODistributedAbstractPlugin.this.nodeName, (String)iNode, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"error on installing database %s in %s (chunk #%d)", (Throwable)((Exception)result), (Object[])new Object[]{databaseName, dbPath, chunkNum});
                                    } else if (result instanceof ODistributedDatabaseChunk) {
                                        chunk = (ODistributedDatabaseChunk)result;
                                        fileSize += ODistributedAbstractPlugin.this.writeDatabaseChunk(chunkNum, chunk, fOut);
                                    }
                                }
                                ++chunkNum;
                            }
                            fOut.flush();
                            new File(file.getAbsolutePath() + ".completed").createNewFile();
                            ODistributedServerLog.info((Object)this, (String)ODistributedAbstractPlugin.this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Database copied correctly, size=%s", (Object[])new Object[]{OFileUtils.getSizeAsString((long)fileSize)});
                        }
                        finally {
                            try {
                                fOut.flush();
                                ((OutputStream)fOut).close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    catch (Exception e) {
                        ODistributedServerLog.error((Object)this, (String)ODistributedAbstractPlugin.this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on transferring database '%s' to '%s'", (Throwable)e, (Object[])new Object[]{databaseName, fileName});
                        throw OException.wrapException((OException)new ODistributedException("Error on transferring database"), (Throwable)e);
                    }
                }
            }).start();
        }
        catch (Exception e) {
            ODistributedServerLog.error((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on transferring database '%s' to '%s'", (Throwable)e, (Object[])new Object[]{databaseName, fileName});
            throw OException.wrapException((OException)new ODistributedException("Error on transferring database"), (Throwable)e);
        }
        ODatabaseDocumentTx db = this.installDatabaseOnLocalNode(databaseName, dbPath, iNode, fileName, delta, uniqueClustersBackupDirectory, cfg);
        if (db != null) {
            try {
                distrDatabase.getSyncConfiguration().load();
                distrDatabase.getSyncConfiguration().setLastLSN(localNodeName, ((OLocalPaginatedStorage)db.getStorage().getUnderlying()).getLSN(), false);
            }
            catch (IOException e) {
                ODistributedServerLog.error((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on loading %s file for database '%s'", (Throwable)e, (Object[])new Object[]{"distributed-sync.json", databaseName});
            }
            try {
                this.rebalanceClusterOwnership(this.nodeName, (ODatabaseInternal)db, cfg);
                distrDatabase.setOnline();
            }
            finally {
                db.activateOnCurrentThread();
                db.close();
            }
        }
        Set localManagedClusters = cfg.getClustersOnServer(localNodeName);
        Set sourceNodeClusters = cfg.getClustersOnServer(iNode);
        localManagedClusters.removeAll(sourceNodeClusters);
        HashSet<String> toSynchClusters = new HashSet<String>();
        for (String cl : localManagedClusters) {
            List servers = cfg.getServers(cl, localNodeName);
            this.getAvailableNodes(servers, databaseName);
            if (servers.isEmpty()) continue;
            toSynchClusters.add(cl);
        }
        for (String cl : toSynchClusters) {
            OCommandExecutorSQLHASyncCluster.replaceCluster(this, this.serverInstance, databaseName, cl);
        }
    }

    public ORemoteTaskFactory getTaskFactory() {
        return this.taskFactory;
    }

    public void propagateSchemaChanges(ODatabaseInternal iDatabase) {
        ODistributedConfiguration cfg = this.getDatabaseConfiguration(iDatabase.getName());
        if (cfg == null) {
            return;
        }
        for (OClass c : iDatabase.getMetadata().getSchema().getClasses()) {
            if (c.getClusterSelection() instanceof OLocalClusterWrapperStrategy) continue;
            ((OClassImpl)c).setClusterSelectionInternal((OClusterSelectionStrategy)new OLocalClusterWrapperStrategy(this, iDatabase.getName(), c, c.getClusterSelection()));
        }
    }

    public synchronized boolean installClustersOfClass(final ODatabaseInternal iDatabase, final OClass iClass, OModifiableDistributedConfiguration cfg) {
        String databaseName = iDatabase.getName();
        if (!(iClass.getClusterSelection() instanceof OLocalClusterWrapperStrategy)) {
            ((OClassImpl)iClass).setClusterSelectionInternal((OClusterSelectionStrategy)new OLocalClusterWrapperStrategy(this, databaseName, iClass, iClass.getClusterSelection()));
        }
        if (iClass.isAbstract()) {
            return false;
        }
        this.getMessageService().registerDatabase(databaseName, (ODistributedConfiguration)cfg);
        return this.executeInDistributedDatabaseLock(databaseName, 20000L, cfg, new OCallable<Boolean, OModifiableDistributedConfiguration>(){

            public Boolean call(OModifiableDistributedConfiguration lastCfg) {
                Set<String> availableNodes = ODistributedAbstractPlugin.this.getAvailableNodeNames(iDatabase.getName());
                List<String> cluster2Create = ODistributedAbstractPlugin.this.clusterAssignmentStrategy.assignClusterOwnershipOfClass(iDatabase, lastCfg, iClass, availableNodes);
                HashMap<OClass, List<String>> cluster2CreateMap = new HashMap<OClass, List<String>>(1);
                cluster2CreateMap.put(iClass, cluster2Create);
                ODistributedAbstractPlugin.this.createClusters(iDatabase, cluster2CreateMap, lastCfg);
                return true;
            }
        });
    }

    private void createClusters(final ODatabaseInternal iDatabase, final Map<OClass, List<String>> cluster2Create, OModifiableDistributedConfiguration cfg) {
        if (cluster2Create.isEmpty()) {
            return;
        }
        this.executeInDistributedDatabaseLock(iDatabase.getName(), 0L, cfg, new OCallable<Object, OModifiableDistributedConfiguration>(){

            public Object call(OModifiableDistributedConfiguration cfg) {
                ODistributedAbstractPlugin.this.updateCachedDatabaseConfiguration(iDatabase.getName(), cfg, true);
                for (Map.Entry entry : cluster2Create.entrySet()) {
                    final OClass clazz = (OClass)entry.getKey();
                    for (final String newClusterName : (List)entry.getValue()) {
                        ODistributedServerLog.info((Object)this, (String)ODistributedAbstractPlugin.this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Class '%s', creation of new local cluster '%s' (id=%d)", (Object[])new Object[]{clazz, newClusterName, iDatabase.getClusterIdByName(newClusterName)});
                        OScenarioThreadLocal.executeAsDefault((Callable)new Callable<Object>(){

                            @Override
                            public Object call() throws Exception {
                                block2: {
                                    try {
                                        clazz.addCluster(newClusterName);
                                    }
                                    catch (Exception e) {
                                        if (iDatabase.getClusterNames().contains(newClusterName)) break block2;
                                        ODistributedServerLog.error((Object)this, (String)ODistributedAbstractPlugin.this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on creating cluster '%s' in class '%s': ", (Object[])new Object[]{newClusterName, clazz, e});
                                        throw OException.wrapException((OException)new ODistributedException("Error on creating cluster '" + newClusterName + "' in class '" + clazz + "'"), (Throwable)e);
                                    }
                                }
                                return null;
                            }
                        });
                    }
                }
                return null;
            }
        });
    }

    public ODistributedStrategy getDistributedStrategy() {
        return this.responseManagerFactory;
    }

    public void setDistributedStrategy(ODistributedStrategy streatgy) {
        this.responseManagerFactory = streatgy;
    }

    /*
     * Exception decompiling
     */
    public <T> T executeInDistributedDatabaseLock(String databaseName, long timeoutLocking, OModifiableDistributedConfiguration lastCfg, OCallable<T, OModifiableDistributedConfiguration> iCallback) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void onDatabaseEvent(String nodeName, String databaseName, ODistributedServerManager.DB_STATUS status) {
        this.updateLastClusterChange();
        this.dumpServersStatus();
    }

    protected void rebalanceClusterOwnership(String iNode, ODatabaseInternal iDatabase, OModifiableDistributedConfiguration cfg) {
        ODistributedConfiguration.ROLES role = cfg.getServerRole(iNode);
        if (role != ODistributedConfiguration.ROLES.MASTER) {
            return;
        }
        if (iDatabase.isClosed()) {
            this.getServerInstance().openDatabase(iDatabase);
        }
        ODistributedServerLog.info((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Reassigning ownership of clusters for database %s...", (Object[])new Object[]{iDatabase.getName()});
        Set<String> availableNodes = this.getAvailableNodeNames(iDatabase.getName());
        iDatabase.activateOnCurrentThread();
        OSchema schema = iDatabase.getDatabaseOwner().getMetadata().getSchema();
        HashMap<OClass, List<String>> cluster2CreateMap = new HashMap<OClass, List<String>>(1);
        for (OClass clazz : schema.getClasses()) {
            List<String> cluster2Create = this.clusterAssignmentStrategy.assignClusterOwnershipOfClass(iDatabase, cfg, clazz, availableNodes);
            cluster2CreateMap.put(clazz, cluster2Create);
        }
        this.createClusters(iDatabase, cluster2CreateMap, cfg);
        ODistributedServerLog.info((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Reassignment of clusters for database '%s' completed (classes=%d)", (Object[])new Object[]{iDatabase.getName(), cluster2CreateMap.size()});
    }

    protected void installDbClustersLocalStrategy(ODatabaseInternal iDatabase) {
        OSchema schema = iDatabase.getDatabaseOwner().getMetadata().getSchema();
        for (OClass c : schema.getClasses()) {
            if (c.getClusterSelection() instanceof OLocalClusterWrapperStrategy) continue;
            ((OClassImpl)c).setClusterSelectionInternal((OClusterSelectionStrategy)new OLocalClusterWrapperStrategy(this, iDatabase.getName(), c, c.getClusterSelection()));
        }
    }

    protected void assignNodeName() {
        this.nodeName = OSystemVariableResolver.resolveVariable((String)NODE_NAME_ENV);
        if (this.nodeName != null) {
            this.nodeName = this.nodeName.trim();
            if (this.nodeName.isEmpty()) {
                this.nodeName = null;
            }
        }
        if (this.nodeName == null) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.out.println();
            System.out.println();
            System.out.println(OAnsiCode.format((String)"$ANSI{yellow +---------------------------------------------------------------+}"));
            System.out.println(OAnsiCode.format((String)"$ANSI{yellow |         WARNING: FIRST DISTRIBUTED RUN CONFIGURATION          |}"));
            System.out.println(OAnsiCode.format((String)"$ANSI{yellow +---------------------------------------------------------------+}"));
            System.out.println(OAnsiCode.format((String)"$ANSI{yellow | This is the first time that the server is running as          |}"));
            System.out.println(OAnsiCode.format((String)"$ANSI{yellow | distributed. Please type the name you want to assign to the   |}"));
            System.out.println(OAnsiCode.format((String)"$ANSI{yellow | current server node.                                          |}"));
            System.out.println(OAnsiCode.format((String)"$ANSI{yellow |                                                               |}"));
            System.out.println(OAnsiCode.format((String)"$ANSI{yellow | To avoid this message set the environment variable or JVM     |}"));
            System.out.println(OAnsiCode.format((String)"$ANSI{yellow | setting ORIENTDB_NODE_NAME to the server node name to use.    |}"));
            System.out.println(OAnsiCode.format((String)"$ANSI{yellow +---------------------------------------------------------------+}"));
            System.out.print(OAnsiCode.format((String)"\n$ANSI{yellow Node name [BLANK=auto generate it]: }"));
            ODefaultConsoleReader reader = new ODefaultConsoleReader();
            try {
                this.nodeName = reader.readLine();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.nodeName != null) {
                this.nodeName = this.nodeName.trim();
                if (this.nodeName.isEmpty()) {
                    this.nodeName = null;
                }
            }
        }
        if (this.nodeName == null) {
            this.nodeName = "node" + System.currentTimeMillis();
        }
        OLogManager.instance().warn((Object)this, "Assigning distributed node name: %s", new Object[]{this.nodeName});
        boolean found = false;
        OServerConfiguration cfg = this.serverInstance.getConfiguration();
        for (OServerHandlerConfiguration h : cfg.handlers) {
            if (!h.clazz.equals(((Object)((Object)this)).getClass().getName())) continue;
            for (OServerParameterConfiguration p : h.parameters) {
                if (!p.name.equals("nodeName")) continue;
                found = true;
                p.value = this.nodeName;
                break;
            }
            if (!found) {
                h.parameters = (OServerParameterConfiguration[])OArrays.copyOf((Object[])h.parameters, (int)(h.parameters.length + 1));
                h.parameters[h.parameters.length - 1] = new OServerParameterConfiguration("nodeName", this.nodeName);
            }
            try {
                this.serverInstance.saveConfiguration();
                break;
            }
            catch (IOException e) {
                throw OException.wrapException((OException)new OConfigurationException("Cannot save server configuration"), (Throwable)e);
            }
        }
    }

    protected long writeDatabaseChunk(int iChunkId, ODistributedDatabaseChunk chunk, OutputStream out) throws IOException {
        ODistributedServerLog.info((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"- writing chunk #%d offset=%d size=%s", (Object[])new Object[]{iChunkId, chunk.offset, OFileUtils.getSizeAsString((long)chunk.buffer.length)});
        out.write(chunk.buffer);
        return chunk.buffer.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ODatabaseDocumentTx installDatabaseOnLocalNode(String databaseName, final String dbPath, final String iNode, String iDatabaseCompressedFile, final boolean delta, final File uniqueClustersBackupDirectory, OModifiableDistributedConfiguration cfg) {
        ODistributedServerLog.info((Object)((Object)this), (String)this.nodeName, (String)iNode, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Installing database '%s' to: %s...", (Object[])new Object[]{databaseName, dbPath});
        try {
            File f = new File(iDatabaseCompressedFile);
            final File fCompleted = new File(iDatabaseCompressedFile + ".completed");
            new File(dbPath).mkdirs();
            final ODatabaseDocumentTx db = new ODatabaseDocumentTx("plocal:" + dbPath);
            final FileInputStream in = new FileInputStream(f){

                @Override
                public int read() throws IOException {
                    int read;
                    while ((read = super.read()) <= -1) {
                        if (fCompleted.exists()) {
                            return 0;
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                    return read;
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    int read;
                    while ((read = super.read(b, off, len)) <= 0) {
                        if (fCompleted.exists()) {
                            return 0;
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                    return read;
                }

                @Override
                public int available() throws IOException {
                    int avail;
                    while ((avail = super.available()) <= 0) {
                        if (fCompleted.exists()) {
                            return 0;
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                    return avail;
                }
            };
            try {
                final ODistributedAbstractPlugin me = this;
                this.executeInDistributedDatabaseLock(databaseName, 0L, cfg, new OCallable<Void, OModifiableDistributedConfiguration>(){

                    public Void call(OModifiableDistributedConfiguration cfg) {
                        try {
                            if (delta) {
                                new OIncrementalServerSync().importDelta(ODistributedAbstractPlugin.this.serverInstance, (ODatabaseDocumentInternal)db, in, iNode);
                            } else {
                                db.restore((InputStream)in, null, (Callable)new Callable<Object>(){

                                    @Override
                                    public Object call() throws Exception {
                                        if (uniqueClustersBackupDirectory != null && uniqueClustersBackupDirectory.exists()) {
                                            for (File f : uniqueClustersBackupDirectory.listFiles()) {
                                                File oldFile = new File(dbPath + "/" + f.getName());
                                                if (oldFile.exists()) {
                                                    oldFile.delete();
                                                }
                                                if (f.renameTo(oldFile)) continue;
                                                throw new ODistributedException("Cannot restore exclusive cluster file '" + f.getAbsolutePath() + "' into " + oldFile.getAbsolutePath());
                                            }
                                            uniqueClustersBackupDirectory.delete();
                                        }
                                        return null;
                                    }
                                }, (OCommandOutputListener)(ODistributedServerLog.isDebugEnabled() ? me : null));
                            }
                            return null;
                        }
                        catch (IOException e) {
                            throw OException.wrapException((OException)new OIOException("Error on distributed sync of database"), (Throwable)e);
                        }
                    }
                });
            }
            finally {
                in.close();
            }
            this.getServerInstance().openDatabase(db, "internal", "internal", null, true);
            db.reload();
            ODistributedServerLog.info((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Installed database '%s' (LSN=%s)", (Object[])new Object[]{databaseName, ((OAbstractPaginatedStorage)db.getStorage().getUnderlying()).getLSN()});
            return db;
        }
        catch (IOException e) {
            ODistributedServerLog.warn((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Error on copying database '%s' on local server", (Throwable)e, (Object[])new Object[]{databaseName});
            return null;
        }
    }

    public void onMessage(String iText) {
        if (iText.startsWith("\r\n")) {
            iText = iText.substring(2);
        } else if (iText.startsWith("\n")) {
            iText = iText.substring(1);
        }
        OLogManager.instance().debug((Object)this, iText, new Object[0]);
    }

    public void stopNode(String iNode) throws IOException {
        ODistributedServerLog.warn((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Sending request of stopping node '%s'...", (Object[])new Object[]{iNode});
        ODistributedRequest request = new ODistributedRequest(this.taskFactory, this.nodeId, this.getNextMessageIdCounter(), null, (ORemoteTask)new OStopServerTask());
        this.getRemoteServer(iNode).sendRequest(request);
    }

    public void restartNode(String iNode) throws IOException {
        ODistributedServerLog.warn((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Sending request of restarting node '%s'...", (Object[])new Object[]{iNode});
        ODistributedRequest request = new ODistributedRequest(this.taskFactory, this.nodeId, this.getNextMessageIdCounter(), null, (ORemoteTask)new ORestartServerTask());
        this.getRemoteServer(iNode).sendRequest(request);
    }

    public Set<String> getAvailableNodeNames(String iDatabaseName) {
        HashSet<String> nodes = new HashSet<String>();
        for (Map.Entry<String, Member> entry : this.activeNodes.entrySet()) {
            if (!this.isNodeAvailable(entry.getKey(), iDatabaseName)) continue;
            nodes.add(entry.getKey());
        }
        return nodes;
    }

    public long getNextMessageIdCounter() {
        long v = this.localMessageIdCounter.getAndIncrement();
        return v;
    }

    public void closeRemoteServer(String node) {
        ORemoteServerController c = (ORemoteServerController)this.remoteServers.remove(node);
        if (c != null) {
            c.close();
        }
    }

    protected boolean isRelatedToLocalServer(ODatabaseInternal iDatabase) {
        String dbUrl = OSystemVariableResolver.resolveSystemVariables((String)iDatabase.getURL());
        if (iDatabase.getName().equalsIgnoreCase("OSystem")) {
            return false;
        }
        if (dbUrl.startsWith("plocal:")) {
            String dbDirectory = this.serverInstance.getDatabaseDirectory();
            if (!dbUrl.substring("plocal:".length()).startsWith(dbDirectory)) {
                return false;
            }
        } else if (dbUrl.startsWith("remote:")) {
            return false;
        }
        return true;
    }

    protected void dumpServersStatus() {
        ODocument cfg = this.getClusterConfiguration();
        String compactStatus = ODistributedOutput.getCompactServerStatus(this, cfg);
        if (!this.lastServerDump.equals(compactStatus)) {
            this.lastServerDump = compactStatus;
            ODistributedServerLog.info((Object)((Object)this), (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed servers status:\n%s", (Object[])new Object[]{ODistributedOutput.formatServerStatus(this, cfg)});
        }
    }

    public ODistributedStorage getStorageIfExists(String dbName) {
        return this.storages.get(dbName);
    }

    public ODistributedStorage getStorage(String dbName) {
        ODistributedStorage oldStorage;
        ODistributedStorage storage = this.storages.get(dbName);
        if (storage == null && (oldStorage = this.storages.putIfAbsent(dbName, storage = new ODistributedStorage(this.serverInstance, dbName))) != null) {
            storage = oldStorage;
        }
        return storage;
    }

    public ODistributedConflictResolverFactory getConflictResolverFactory() {
        return this.conflictResolverFactory;
    }

    public static String getListeningBinaryAddress(ODocument cfg) {
        String url = (String)cfg.field("publicAddress");
        Collection listeners = (Collection)cfg.field("listeners");
        if (listeners == null) {
            throw new ODatabaseException("Cannot connect to a remote node because bad distributed configuration: missing 'listeners' array field");
        }
        String listenUrl = null;
        for (Map listener : listeners) {
            if (!listener.get("protocol").equals("ONetworkProtocolBinary")) continue;
            listenUrl = (String)listener.get("listen");
            break;
        }
        if (url == null) {
            url = listenUrl;
        } else {
            int pos = listenUrl.lastIndexOf(":");
            String port = pos != -1 ? listenUrl.substring(pos + 1) : "2424";
            url = url + ":" + port;
        }
        return url;
    }
}

