/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.orientechnologies.common.concur.lock.OLockException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.server.distributed.ODistributedLockManager;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class ODistributedLockManagerExecutor
implements ODistributedLockManager {
    private final ODistributedServerManager manager;
    private final ConcurrentHashMap<String, ODistributedLock> lockManager = new ConcurrentHashMap(256);

    public ODistributedLockManagerExecutor(ODistributedServerManager manager) {
        this.manager = manager;
    }

    public void handleUnreachableServer(String nodeLeftName) {
        ArrayList<String> unlockedResources = new ArrayList<String>();
        Iterator<Map.Entry<String, ODistributedLock>> it = this.lockManager.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, ODistributedLock> entry = it.next();
            ODistributedLock lock = entry.getValue();
            if (lock == null || lock.server == null || !lock.server.equals(nodeLeftName)) continue;
            OLogManager.instance().info((Object)this, "Forcing unlocking resource '%s' acquired by '%s'", new Object[]{entry.getKey(), lock.server});
            unlockedResources.add(entry.getKey());
            it.remove();
        }
        if (unlockedResources.size() > 0) {
            ODistributedServerLog.info((Object)this, (String)this.manager.getLocalNodeName(), (String)nodeLeftName, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Forced unlocked %d resources %s owned by server '%s'", (Object[])new Object[]{unlockedResources.size(), unlockedResources, nodeLeftName});
        }
    }

    public void acquireExclusiveLock(String resource, String nodeSource, long timeout) {
        ODistributedLock lock = new ODistributedLock(nodeSource);
        ODistributedLock currentLock = this.lockManager.putIfAbsent(resource, lock);
        if (currentLock != null) {
            if (currentLock.server.equals(nodeSource)) {
                currentLock = null;
            } else {
                long startTime = System.currentTimeMillis();
                do {
                    try {
                        ODistributedServerLog.info((Object)this, (String)this.manager.getLocalNodeName(), (String)nodeSource, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Waiting to acquire distributed lock on resource '%s' (threadId=%d timeout=%d)...", (Object[])new Object[]{resource, Thread.currentThread().getId(), timeout});
                        if (timeout > 0L) {
                            if (!currentLock.lock.await(timeout, TimeUnit.MILLISECONDS)) {
                                continue;
                            }
                        } else {
                            currentLock.lock.await();
                        }
                        currentLock = this.lockManager.putIfAbsent(resource, lock);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                } while (currentLock != null && (timeout == 0L || System.currentTimeMillis() - startTime < timeout));
            }
        }
        if (!(currentLock == null || currentLock.server != null && this.manager.isNodeAvailable(currentLock.server))) {
            ODistributedServerLog.info((Object)this, (String)this.manager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Forcing unlock of resource '%s' because the owner server '%s' is offline", (Object[])new Object[]{resource, currentLock.server});
            this.lockManager.put(resource, lock);
            currentLock = null;
        }
        if (ODistributedServerLog.isDebugEnabled()) {
            if (currentLock == null) {
                ODistributedServerLog.debug((Object)this, (String)this.manager.getLocalNodeName(), (String)nodeSource, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Resource '%s' locked by server '%s' (threadId=%d)", (Object[])new Object[]{resource, nodeSource, Thread.currentThread().getId()});
            } else {
                ODistributedServerLog.debug((Object)this, (String)this.manager.getLocalNodeName(), (String)nodeSource, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Cannot lock resource '%s' owned by server '%s' (timeout=%d threadId=%d)", (Object[])new Object[]{resource, nodeSource, timeout, Thread.currentThread().getId()});
            }
        }
        if (currentLock != null) {
            throw new OLockException("Cannot lock resource '" + resource + "' owned by server '" + nodeSource + "' (timeout=" + timeout + " threadId=" + Thread.currentThread().getId() + ")");
        }
    }

    public void releaseExclusiveLock(String resource, String nodeSource) {
        if (resource == null) {
            return;
        }
        ODistributedLock owner = this.lockManager.remove(resource);
        if (owner != null) {
            if (!owner.server.equals(nodeSource)) {
                ODistributedServerLog.error((Object)this, (String)this.manager.getLocalNodeName(), (String)nodeSource, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Cannot unlock resource %s because owner server '%s' <> current '%s'", (Object[])new Object[]{resource, owner.server, this.manager.getLocalNodeName()});
                return;
            }
            if (ODistributedServerLog.isDebugEnabled()) {
                ODistributedServerLog.debug((Object)this, (String)this.manager.getLocalNodeName(), (String)owner.server, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Unlocked resource '%s' (owner=%s elapsed=%s)", (Object[])new Object[]{resource, owner.server, System.currentTimeMillis() - owner.acquiredOn});
            }
            owner.lock.countDown();
        }
    }

    public String dumpLocks() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("HA RESOURCE LOCKS FOR SERVER '" + this.manager.getLocalNodeName() + "'");
        long now = System.currentTimeMillis();
        for (Map.Entry<String, ODistributedLock> entry : this.lockManager.entrySet()) {
            buffer.append("\n  - '" + entry.getKey() + "' by server " + entry.getValue().server + " (acquiredOn=" + (now - entry.getValue().acquiredOn) + "ms ago - count=" + entry.getValue().lock.getCount() + ")");
        }
        return buffer.toString();
    }

    private class ODistributedLock {
        final String server;
        final CountDownLatch lock;
        final long acquiredOn;

        private ODistributedLock(String server) {
            this.server = server;
            this.lock = new CountDownLatch(1);
            this.acquiredOn = System.currentTimeMillis();
        }
    }
}

