/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.orientechnologies.common.concur.lock.OLockException;
import com.orientechnologies.orient.server.distributed.ODistributedLockManager;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.impl.task.ODistributedLockTask;
import com.orientechnologies.orient.server.distributed.task.ODistributedOperationException;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ODistributedLockManagerRequester
implements ODistributedLockManager {
    private final ODistributedServerManager manager;
    private volatile String coordinatorServer;
    private Map<String, Long> acquiredResources = new HashMap<String, Long>();

    public ODistributedLockManagerRequester(ODistributedServerManager manager) {
        this.manager = manager;
    }

    public void acquireExclusiveLock(String resource, String nodeSource, long timeout) {
        block8: {
            Object result;
            while (true) {
                if (this.coordinatorServer == null || this.coordinatorServer.equals(this.manager.getLocalNodeName())) {
                    this.manager.getLockManagerExecutor().acquireExclusiveLock(resource, this.manager.getLocalNodeName(), timeout);
                    break block8;
                }
                HashSet<String> servers = new HashSet<String>();
                servers.add(this.coordinatorServer);
                ODistributedServerLog.debug((Object)this, (String)this.manager.getLocalNodeName(), (String)this.coordinatorServer, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Server '%s' is acquiring distributed lock on resource '%s'...", (Object[])new Object[]{nodeSource, resource});
                ODistributedResponse dResponse = this.manager.sendRequest("OSystem", null, servers, (ORemoteTask)new ODistributedLockTask(resource, timeout, true), this.manager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null);
                if (dResponse == null) {
                    ODistributedServerLog.warn((Object)this, (String)this.manager.getLocalNodeName(), (String)this.coordinatorServer, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Server '%s' cannot acquire distributed lock on resource '%s' (timeout=%d)...", (Object[])new Object[]{nodeSource, resource, timeout});
                    throw new OLockException("Server '" + nodeSource + "' cannot acquire exclusive lock on resource '" + resource + "' (timeout=" + timeout + ")");
                }
                result = dResponse.getPayload();
                if (!(result instanceof ODistributedOperationException)) break;
                if (this.manager.getActiveServers().contains(this.coordinatorServer)) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (!this.manager.getActiveServers().contains(this.coordinatorServer)) {
                    ODistributedServerLog.warn((Object)this, (String)this.manager.getLocalNodeName(), (String)this.coordinatorServer, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Coordinator server '%s' went down during the request of locking resource '%s'. Assigning new coordinator...", (Object[])new Object[]{this.coordinatorServer, resource});
                    this.coordinatorServer = this.manager.getCoordinatorServer();
                    continue;
                }
                break block8;
                break;
            }
            if (result instanceof RuntimeException) {
                throw (RuntimeException)result;
            }
        }
        ODistributedServerLog.debug((Object)this, (String)this.manager.getLocalNodeName(), (String)this.coordinatorServer, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Server '%s' has acquired distributed lock on resource '%s'", (Object[])new Object[]{nodeSource, resource});
        this.acquiredResources.put(resource, System.currentTimeMillis());
    }

    public void releaseExclusiveLock(String resource, String nodeSource) {
        if (this.coordinatorServer == null || this.coordinatorServer.equals(this.manager.getLocalNodeName())) {
            this.manager.getLockManagerExecutor().releaseExclusiveLock(resource, this.manager.getLocalNodeName());
        } else {
            ODistributedServerLog.debug((Object)this, (String)this.manager.getLocalNodeName(), (String)this.coordinatorServer, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Releasing distributed lock on resource '%s'", (Object[])new Object[]{resource});
            HashSet<String> servers = new HashSet<String>();
            servers.add(this.coordinatorServer);
            ODistributedResponse dResponse = this.manager.sendRequest("OSystem", null, servers, (ORemoteTask)new ODistributedLockTask(resource, 0L, false), this.manager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null);
            if (dResponse == null) {
                throw new OLockException("Cannot release exclusive lock on resource '" + resource + "'");
            }
            Object result = dResponse.getPayload();
            if (result instanceof RuntimeException) {
                throw (RuntimeException)result;
            }
        }
        ODistributedServerLog.debug((Object)this, (String)this.manager.getLocalNodeName(), (String)this.coordinatorServer, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Released distributed lock on resource '%s'", (Object[])new Object[]{resource});
        this.acquiredResources.remove(resource);
    }

    public void setCoordinatorServer(String coordinatorServer) {
        this.coordinatorServer = coordinatorServer;
    }

    public void handleUnreachableServer(String nodeLeftName) {
        if (nodeLeftName.equals(this.coordinatorServer)) {
            this.coordinatorServer = this.manager.getCoordinatorServer();
            try {
                for (String resource : this.acquiredResources.keySet()) {
                    this.acquireExclusiveLock(resource, this.manager.getLocalNodeName(), 10000L);
                }
                ODistributedServerLog.info((Object)this, (String)this.manager.getLocalNodeName(), (String)this.coordinatorServer, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Re-acquired %d locks against the new coordinator server '%s'", (Object[])new Object[]{this.acquiredResources.size(), this.coordinatorServer});
            }
            catch (OLockException e) {
                ODistributedServerLog.error((Object)this, (String)this.manager.getLocalNodeName(), (String)this.coordinatorServer, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Error on re-acquiring %d locks against the new coordinator '%s'", (Object[])new Object[]{this.acquiredResources.size(), this.coordinatorServer});
            }
        }
    }

    public String getCoordinatorServer() {
        return this.coordinatorServer;
    }
}

