/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OAnsiCode;
import com.orientechnologies.orient.console.OTableFormatter;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.impl.ODistributedAbstractPlugin;
import com.orientechnologies.orient.server.distributed.impl.ODistributedDatabaseImpl;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ODistributedOutput {
    public static String formatServerStatus(ODistributedServerManager manager, ODocument distribCfg) {
        ArrayList<ODocument> rows = new ArrayList<ODocument>();
        Collection members = (Collection)distribCfg.field("members");
        if (members != null) {
            for (ODocument m : members) {
                Long usedMem;
                Collection listeners;
                if (m == null) continue;
                ODocument serverRow = new ODocument();
                String serverName = (String)m.field("name");
                serverRow.field("Name", (Object)(serverName + (manager.getLocalNodeName().equals(serverName) ? "*" : "")));
                serverRow.field("Status", m.field("status"));
                serverRow.field("Databases", (Object)null);
                serverRow.field("Conns", m.field("connections"));
                Date date = (Date)m.field("startedOn");
                if (date != null) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
                    if (sdf.format(date).equals(sdf.format(new Date()))) {
                        serverRow.field("StartedOn", (Object)new SimpleDateFormat("HH:mm:ss").format(date));
                    } else {
                        serverRow.field("StartedOn", (Object)date);
                    }
                }
                if ((listeners = (Collection)m.field("listeners")) != null) {
                    for (Map l : listeners) {
                        String protocol = (String)l.get("protocol");
                        if (protocol.equals("ONetworkProtocolBinary")) {
                            serverRow.field("Binary", l.get("listen"));
                            continue;
                        }
                        if (!protocol.equals("ONetworkProtocolHttpDb")) continue;
                        serverRow.field("HTTP", l.get("listen"));
                    }
                }
                if ((usedMem = (Long)m.field("usedMemory")) != null) {
                    long maxMem = (Long)m.field("maxMemory");
                    serverRow.field("UsedMemory", (Object)String.format("%s/%s (%.2f%%)", OFileUtils.getSizeAsString((long)usedMem), OFileUtils.getSizeAsString((long)maxMem), Float.valueOf((float)usedMem.longValue() / (float)maxMem * 100.0f)));
                }
                rows.add(serverRow);
                Collection databases = (Collection)m.field("databases");
                if (databases == null) continue;
                int serverNum = 0;
                for (String dbName : databases) {
                    StringBuilder buffer = new StringBuilder();
                    ODistributedConfiguration dbCfg = manager.getDatabaseConfiguration(dbName, false);
                    if (dbCfg == null) continue;
                    buffer.append(dbName);
                    buffer.append("=");
                    buffer.append(manager.getDatabaseStatus(serverName, dbName));
                    buffer.append(" (");
                    buffer.append(dbCfg.getServerRole(serverName));
                    buffer.append(")");
                    if (serverNum++ == 0) {
                        serverRow.field("Databases", (Object)buffer.toString());
                        continue;
                    }
                    rows.add(new ODocument().field("Databases", (Object)buffer.toString()));
                }
            }
        }
        final StringBuilder buffer = new StringBuilder();
        OTableFormatter table = new OTableFormatter(new OTableFormatter.OTableOutput(){

            public void onMessage(String text, Object ... args) {
                buffer.append(String.format(text, args));
            }
        });
        table.setColumnHidden("#");
        table.writeRecords(rows, -1);
        buffer.append("\n");
        return buffer.toString();
    }

    public static String formatLatency(ODistributedAbstractPlugin manager, ODocument distribCfg) {
        ArrayList<ODocument> rows = new ArrayList<ODocument>();
        List members = (List)distribCfg.field("members");
        final StringBuilder buffer = new StringBuilder();
        buffer.append("\nREPLICATION LATENCY AVERAGE (in milliseconds)");
        OTableFormatter table = new OTableFormatter(new OTableFormatter.OTableOutput(){

            public void onMessage(String text, Object ... args) {
                buffer.append(String.format(text, args));
            }
        });
        table.setColumnHidden("#");
        if (members != null) {
            ArrayList<String> orderedServers = new ArrayList<String>(members.size());
            for (ODocument fromMember : members) {
                if (fromMember == null) continue;
                String serverName = (String)fromMember.field("name");
                orderedServers.add(serverName);
                table.setColumnAlignment(ODistributedOutput.formatServerName(manager, serverName), OTableFormatter.ALIGNMENT.RIGHT);
            }
            Collections.sort(orderedServers);
            for (String fromServer : orderedServers) {
                ODocument fromMember = null;
                for (ODocument m : members) {
                    if (m == null || !fromServer.equals(m.field("name"))) continue;
                    fromMember = m;
                    break;
                }
                if (fromMember == null) continue;
                ODocument row = new ODocument();
                rows.add(row);
                row.field("Servers", (Object)ODistributedOutput.formatServerName(manager, fromServer));
                ODocument latencies = (ODocument)fromMember.field("latencies");
                if (latencies == null) continue;
                for (String toServer : orderedServers) {
                    ODocument latency;
                    String value = "";
                    if (toServer != null && !toServer.equals(fromServer) && (latency = (ODocument)latencies.field(toServer)) != null) {
                        value = String.format("%.2f", Float.valueOf(((Float)latency.field("average")).floatValue() / 1000000.0f));
                    }
                    row.field(ODistributedOutput.formatServerName(manager, toServer), (Object)value);
                }
            }
        }
        table.writeRecords(rows, -1);
        buffer.append("\n");
        return buffer.toString();
    }

    public static String formatMessages(ODistributedAbstractPlugin manager, ODocument distribCfg) {
        return ODistributedOutput.formatMessageBetweenServers(manager, distribCfg) + ODistributedOutput.formatMessageStats(manager, distribCfg);
    }

    public static String formatMessageBetweenServers(ODistributedAbstractPlugin manager, ODocument distribCfg) {
        ArrayList<ODocument> rows = new ArrayList<ODocument>();
        List members = (List)distribCfg.field("members");
        final StringBuilder buffer = new StringBuilder();
        buffer.append("\nREPLICATION MESSAGE COUNTERS (servers: source on the row and destination on the column)");
        OTableFormatter table = new OTableFormatter(new OTableFormatter.OTableOutput(){

            public void onMessage(String text, Object ... args) {
                buffer.append(String.format(text, args));
            }
        });
        table.setColumnHidden("#");
        if (members != null) {
            ArrayList<String> orderedServers = new ArrayList<String>(members.size());
            for (ODocument fromMember : members) {
                if (fromMember == null) continue;
                String serverName = (String)fromMember.field("name");
                orderedServers.add(serverName);
                table.setColumnAlignment(ODistributedOutput.formatServerName(manager, serverName), OTableFormatter.ALIGNMENT.RIGHT);
            }
            Collections.sort(orderedServers);
            ODocument rowTotals = new ODocument();
            for (String fromServer : orderedServers) {
                ODocument fromMember = null;
                for (ODocument m : members) {
                    if (!fromServer.equals(m.field("name"))) continue;
                    fromMember = m;
                    break;
                }
                if (fromMember == null) continue;
                ODocument row = new ODocument();
                rows.add(row);
                row.field("Servers", (Object)ODistributedOutput.formatServerName(manager, fromServer));
                ODocument latencies = (ODocument)fromMember.field("latencies");
                if (latencies == null) continue;
                long total = 0L;
                for (String toServer : orderedServers) {
                    ODocument latency;
                    String serverLabel = ODistributedOutput.formatServerName(manager, toServer);
                    if (toServer != null && !toServer.equals(fromServer) && (latency = (ODocument)latencies.field(toServer)) != null) {
                        Long entries = (Long)latency.field("entries");
                        row.field(serverLabel, (Object)String.format("%,d", entries));
                        ODistributedOutput.sumTotal(rowTotals, serverLabel, total += entries.longValue());
                        continue;
                    }
                    row.field(serverLabel, (Object)"");
                }
                row.field("TOTAL", (Object)String.format("%,d", total));
                ODistributedOutput.sumTotal(rowTotals, "TOTAL", total);
            }
            table.setFooter(rowTotals);
            rowTotals.field("Servers", (Object)"TOTAL");
            for (String fromServer : orderedServers) {
                fromServer = ODistributedOutput.formatServerName(manager, fromServer);
                rowTotals.field(fromServer, (Object)String.format("%,d", rowTotals.field(fromServer)));
            }
            rowTotals.field("TOTAL", (Object)String.format("%,d", rowTotals.field("TOTAL")));
            table.setColumnAlignment("TOTAL", OTableFormatter.ALIGNMENT.RIGHT);
        }
        table.writeRecords(rows, -1);
        buffer.append("\n");
        return buffer.toString();
    }

    public static String formatMessageStats(ODistributedAbstractPlugin manager, ODocument distribCfg) {
        ArrayList<ODocument> rows = new ArrayList<ODocument>();
        List members = (List)distribCfg.field("members");
        final StringBuilder buffer = new StringBuilder();
        buffer.append("\nREPLICATION MESSAGE COORDINATOR STATS");
        OTableFormatter table = new OTableFormatter(new OTableFormatter.OTableOutput(){

            public void onMessage(String text, Object ... args) {
                buffer.append(String.format(text, args));
            }
        });
        table.setColumnHidden("#");
        if (members != null) {
            ArrayList<String> orderedServers = new ArrayList<String>(members.size());
            LinkedHashSet<String> operations = new LinkedHashSet<String>();
            for (ODocument fromMember : members) {
                if (fromMember == null) continue;
                String serverName = (String)fromMember.field("name");
                orderedServers.add(serverName);
                ODocument messages = (ODocument)fromMember.field("messages");
                if (messages == null) continue;
                for (String opName : messages.fieldNames()) {
                    operations.add(opName);
                }
            }
            Collections.sort(orderedServers);
            ODocument rowTotals = new ODocument();
            for (String server : orderedServers) {
                ODocument member = null;
                for (ODocument m : members) {
                    if (!server.equals(m.field("name"))) continue;
                    member = m;
                    break;
                }
                if (member == null) continue;
                ODocument row = new ODocument();
                rows.add(row);
                row.field("Servers", (Object)ODistributedOutput.formatServerName(manager, server));
                ODocument messages = (ODocument)member.field("messages");
                if (messages == null) continue;
                long total = 0L;
                for (String opName : operations) {
                    Long counter = (Long)messages.field(opName);
                    if (counter == null) {
                        row.field(opName, (Object)"");
                        continue;
                    }
                    total += counter.longValue();
                    String value = String.format("%,d", counter);
                    row.field(opName, (Object)value);
                    ODistributedOutput.sumTotal(rowTotals, opName, counter);
                    table.setColumnAlignment(opName, OTableFormatter.ALIGNMENT.RIGHT);
                }
                row.field("TOTAL", (Object)String.format("%,d", total));
                ODistributedOutput.sumTotal(rowTotals, "TOTAL", total);
            }
            table.setFooter(rowTotals);
            rowTotals.field("Servers", (Object)"TOTAL");
            for (String opName : operations) {
                rowTotals.field(opName, (Object)String.format("%,d", rowTotals.field(opName)));
            }
            rowTotals.field("TOTAL", (Object)String.format("%,d", rowTotals.field("TOTAL")));
        }
        table.setColumnAlignment("TOTAL", OTableFormatter.ALIGNMENT.RIGHT);
        table.writeRecords(rows, -1);
        buffer.append("\n");
        return buffer.toString();
    }

    protected static void sumTotal(ODocument rowTotals, String column, long total) {
        Long totValue = (Long)rowTotals.field(column);
        if (totValue == null) {
            totValue = 0L;
        }
        rowTotals.field(column, (Object)(total + totValue));
    }

    public static String getCompactServerStatus(ODistributedServerManager manager, ODocument distribCfg) {
        StringBuilder buffer = new StringBuilder();
        Collection members = (Collection)distribCfg.field("members");
        if (members != null) {
            buffer.append(members.size());
            buffer.append(":[");
            int memberCount = 0;
            for (ODocument m : members) {
                if (m == null) continue;
                if (memberCount++ > 0) {
                    buffer.append(",");
                }
                String serverName = (String)m.field("name");
                buffer.append(serverName);
                buffer.append(m.field("status"));
                Collection databases = (Collection)m.field("databases");
                if (databases == null) continue;
                buffer.append("{");
                int dbCount = 0;
                for (String dbName : databases) {
                    ODistributedConfiguration dbCfg = manager.getDatabaseConfiguration(dbName, false);
                    if (dbCfg == null) continue;
                    if (dbCount++ > 0) {
                        buffer.append(",");
                    }
                    buffer.append(dbName);
                    buffer.append("=");
                    buffer.append(manager.getDatabaseStatus(serverName, dbName));
                    buffer.append(" (");
                    buffer.append(dbCfg.getServerRole(serverName));
                    buffer.append(")");
                }
                buffer.append("}");
            }
            buffer.append("]");
        }
        return buffer.toString();
    }

    public static String formatClusterTable(ODistributedServerManager manager, String databaseName, ODistributedConfiguration cfg, int availableNodes) {
        OTableFormatter table;
        final StringBuilder buffer = new StringBuilder();
        if (cfg.hasDataCenterConfiguration()) {
            buffer.append("\n\nDATA CENTER CONFIGURATION");
            table = new OTableFormatter(new OTableFormatter.OTableOutput(){

                public void onMessage(String text, Object ... args) {
                    buffer.append(String.format(text, args));
                }
            });
            table.setColumnSorting("NAME", true);
            table.setColumnHidden("#");
            table.setColumnAlignment("SERVERS", OTableFormatter.ALIGNMENT.LEFT);
            table.setColumnAlignment("writeQuorum", OTableFormatter.ALIGNMENT.CENTER);
            ArrayList<ODocument> rows = new ArrayList<ODocument>();
            for (String dcName : cfg.getDataCenters()) {
                ODocument row = new ODocument();
                rows.add(row);
                String dcServers = cfg.getDataCenterServers(dcName).toString();
                row.field("NAME", (Object)dcName);
                row.field("SERVERS", (Object)dcServers.substring(1, dcServers.length() - 1));
                row.field("writeQuorum", (Object)cfg.getDataCenterWriteQuorum(dcName));
            }
            table.writeRecords(rows, -1);
        }
        buffer.append("\n\nCLUSTER CONFIGURATION (LEGEND: X = Owner, o = Copy)");
        table = new OTableFormatter(new OTableFormatter.OTableOutput(){

            public void onMessage(String text, Object ... args) {
                buffer.append(String.format(text, args));
            }
        });
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        if (db != null && db.isClosed()) {
            db = null;
        }
        table.setColumnSorting("CLUSTER", true);
        table.setColumnHidden("#");
        if (db != null) {
            table.setColumnAlignment("id", OTableFormatter.ALIGNMENT.RIGHT);
        }
        table.setColumnAlignment("writeQuorum", OTableFormatter.ALIGNMENT.CENTER);
        table.setColumnAlignment("readQuorum", OTableFormatter.ALIGNMENT.CENTER);
        String localNodeName = manager.getLocalNodeName();
        String defaultWQ = cfg.isLocalDataCenterWriteQuorum() ? "localDataCenter" : "" + cfg.getWriteQuorum("*", availableNodes, localNodeName);
        int defaultRQ = cfg.getReadQuorum("*", availableNodes, localNodeName);
        String defaultOwner = "" + cfg.getClusterOwner("*");
        List defaultServers = cfg.getConfiguredServers("*");
        ArrayList<ODocument> rows = new ArrayList<ODocument>();
        HashSet<String> allServers = new HashSet<String>();
        for (String cluster : cfg.getClusterNames()) {
            String wQ = cfg.isLocalDataCenterWriteQuorum() ? "localDataCenter" : "" + cfg.getWriteQuorum(cluster, availableNodes, localNodeName);
            int rQ = cfg.getReadQuorum(cluster, availableNodes, localNodeName);
            String owner = cfg.getClusterOwner(cluster);
            List servers = cfg.getConfiguredServers(cluster);
            if (!cluster.equals("*") && defaultWQ.equals(wQ) && defaultRQ == rQ && defaultOwner.equals(owner) && defaultServers.size() == servers.size() && defaultServers.containsAll(servers)) continue;
            ODocument row = new ODocument();
            rows.add(row);
            row.field("CLUSTER", (Object)cluster);
            if (db != null) {
                int clId = db.getClusterIdByName(cluster);
                row.field("id", clId > -1 ? Integer.valueOf(clId) : "");
            }
            row.field("writeQuorum", (Object)wQ);
            row.field("readQuorum", (Object)rQ);
            if (servers == null) continue;
            for (String server : servers) {
                if (server.equalsIgnoreCase("<NEW_NODE>")) continue;
                allServers.add(server);
                row.field(server, (Object)OAnsiCode.format((String)(server.equals(owner) ? "X" : "o")));
                table.setColumnAlignment(server, OTableFormatter.ALIGNMENT.CENTER);
            }
        }
        Set registeredServers = cfg.getRegisteredServers();
        Iterator iterator = allServers.iterator();
        while (iterator.hasNext()) {
            String server;
            table.setColumnMetadata(server, "CFG", registeredServers.contains(server = (String)iterator.next()) ? "static" : "dynamic");
            table.setColumnMetadata(server, "ROLE", cfg.getServerRole(server).toString());
            table.setColumnMetadata(server, "STATUS", manager.getDatabaseStatus(server, databaseName).toString());
            if (!cfg.hasDataCenterConfiguration()) continue;
            table.setColumnMetadata(server, "DC", "DC(" + cfg.getDataCenterOfServer(server) + ")");
        }
        table.writeRecords(rows, -1);
        buffer.append("\n");
        return buffer.toString();
    }

    public static String formatClasses(ODistributedConfiguration cfg, ODatabaseDocument db) {
        final StringBuilder buffer = new StringBuilder();
        OTableFormatter table = new OTableFormatter(new OTableFormatter.OTableOutput(){

            public void onMessage(String text, Object ... args) {
                buffer.append(String.format(text, args));
            }
        });
        Set allServers = cfg.getAllConfiguredServers();
        ArrayList<ODocument> rows = new ArrayList<ODocument>();
        for (OClass cls : db.getMetadata().getSchema().getClasses()) {
            ODocument row = new ODocument();
            rows.add(row);
            row.field("CLASS", (Object)cls.getName());
            StringBuilder serverBuffer = new StringBuilder();
            for (String server : allServers) {
                Set clustersOnServer = cfg.getClustersOnServer(server);
                for (String clusterName : clustersOnServer) {
                    if (serverBuffer.length() > 0) {
                        serverBuffer.append(',');
                    }
                    serverBuffer.append(clusterName);
                    serverBuffer.append('(');
                    serverBuffer.append(db.getClusterIdByName(clusterName));
                    serverBuffer.append(')');
                }
                row.field(server, (Object)serverBuffer.toString());
            }
        }
        table.writeRecords(rows, -1);
        return buffer.toString();
    }

    protected static String formatServerName(ODistributedAbstractPlugin manager, String fromServer) {
        return fromServer + (manager.getLocalNodeName().equals(fromServer) ? "*" : "");
    }

    public static Object formatRecordLocks(ODistributedAbstractPlugin manager, String db) {
        ConcurrentHashMap<ORID, ODistributedDatabaseImpl.ODistributedLock> lockManager = manager.getMessageService().getDatabase((String)db).lockManager;
        final StringBuilder buffer = new StringBuilder();
        buffer.append("HA RECORD LOCKS FOR DATABASE '" + db + "'");
        OTableFormatter table = new OTableFormatter(new OTableFormatter.OTableOutput(){

            public void onMessage(String text, Object ... args) {
                buffer.append(String.format(text, args));
            }
        });
        table.setColumnHidden("#");
        ArrayList<ODocument> rows = new ArrayList<ODocument>();
        if (lockManager != null) {
            ArrayList<ORID> orderedRIDs = new ArrayList<ORID>(lockManager.size());
            for (ORID rid : lockManager.keySet()) {
                orderedRIDs.add(rid);
            }
            Collections.sort(orderedRIDs);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
            for (ORID rid : orderedRIDs) {
                ODocument row = new ODocument();
                rows.add(row);
                ODistributedDatabaseImpl.ODistributedLock lock = lockManager.get(rid);
                if (lock == null) continue;
                row.field("rid", (Object)rid);
                row.field("server", (Object)manager.getNodeNameById(lock.reqId.getNodeId()));
                row.field("acquiredOn", (Object)dateFormat.format(new Date(lock.acquiredOn)));
                row.field("reqId", (Object)lock.reqId);
                row.field("threadCount", (Object)lock.lock.getCount());
            }
        }
        table.writeRecords(rows, -1);
        buffer.append("\n");
        return buffer.toString();
    }
}

