/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OExecutionThreadLocal;
import com.orientechnologies.orient.core.db.OScenarioThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OPlaceholder;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.OConcurrentCreateException;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.exception.OValidationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.ORecordVersionHelper;
import com.orientechnologies.orient.core.replication.OAsyncReplicationError;
import com.orientechnologies.orient.core.replication.OAsyncReplicationOk;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionAbstract;
import com.orientechnologies.orient.core.tx.OTransactionInternal;
import com.orientechnologies.orient.server.distributed.OAsynchDistributedOperation;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ODistributedTxContext;
import com.orientechnologies.orient.server.distributed.impl.ODistributedStorage;
import com.orientechnologies.orient.server.distributed.impl.ODistributedStorageEventListener;
import com.orientechnologies.orient.server.distributed.impl.task.OCompleted2pcTask;
import com.orientechnologies.orient.server.distributed.impl.task.OCreateRecordTask;
import com.orientechnologies.orient.server.distributed.impl.task.ODeleteRecordTask;
import com.orientechnologies.orient.server.distributed.impl.task.OFixCreateRecordTask;
import com.orientechnologies.orient.server.distributed.impl.task.OFixUpdateRecordTask;
import com.orientechnologies.orient.server.distributed.impl.task.OResurrectRecordTask;
import com.orientechnologies.orient.server.distributed.impl.task.OTxTask;
import com.orientechnologies.orient.server.distributed.impl.task.OTxTaskResult;
import com.orientechnologies.orient.server.distributed.impl.task.OUpdateRecordTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractRecordReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.ODistributedOperationException;
import com.orientechnologies.orient.server.distributed.task.ODistributedRecordLockedException;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class ODistributedTransactionManager {
    private final ODistributedServerManager dManager;
    private final ODistributedStorage storage;
    private final ODistributedDatabase localDistributedDatabase;
    private static final boolean SYNC_TX_COMPLETED = false;

    public ODistributedTransactionManager(ODistributedStorage storage, ODistributedServerManager manager, ODistributedDatabase iDDatabase) {
        this.dManager = manager;
        this.storage = storage;
        this.localDistributedDatabase = iDDatabase;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ORecordOperation> commit(ODatabaseDocumentTx database, final OTransaction iTx, final Runnable callback, ODistributedStorageEventListener eventListener) {
        String localNodeName = this.dManager.getLocalNodeName();
        try {
            OTransactionInternal.setStatus((OTransactionAbstract)((OTransactionAbstract)iTx), (OTransaction.TXSTATUS)OTransaction.TXSTATUS.BEGUN);
            ODistributedConfiguration dbCfg = this.dManager.getDatabaseConfiguration(this.storage.getName());
            this.checkForClusterIds(iTx, localNodeName, dbCfg);
            List<OAbstractRemoteTask> undoTasks = this.createUndoTasksFromTx(iTx);
            int maxAutoRetry = OGlobalConfiguration.DISTRIBUTED_CONCURRENT_TX_MAX_AUTORETRY.getValueAsInteger();
            int autoRetryDelay = OGlobalConfiguration.DISTRIBUTED_CONCURRENT_TX_AUTORETRY_DELAY.getValueAsInteger();
            Boolean executionModeSynch = dbCfg.isExecutionModeSynchronous(null);
            if (executionModeSynch == null) {
                executionModeSynch = Boolean.TRUE;
            }
            boolean finalExecutionModeSynch = executionModeSynch;
            final ODistributedRequestId requestId = new ODistributedRequestId(this.dManager.getLocalNodeId(), this.dManager.getNextMessageIdCounter());
            final ODistributedTxContext ctx = this.localDistributedDatabase.registerTxContext(requestId);
            final AtomicBoolean lockReleased = new AtomicBoolean(true);
            try {
                this.acquireMultipleRecordLocks(iTx, maxAutoRetry, autoRetryDelay, eventListener, ctx);
                lockReleased.set(false);
                List uResult = (List)OScenarioThreadLocal.executeAsDistributed((Callable)new Callable(){

                    public Object call() throws Exception {
                        return ODistributedTransactionManager.this.storage.commit(iTx, callback);
                    }
                });
                try {
                    this.localDistributedDatabase.getSyncConfiguration().setLastLSN(localNodeName, ((OLocalPaginatedStorage)this.storage.getUnderlying()).getLSN(), true);
                }
                catch (IOException e) {
                    ODistributedServerLog.debug((Object)this, (String)(this.dManager != null ? this.dManager.getLocalNodeName() : "?"), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on updating local LSN configuration for database '%s'", (Object[])new Object[]{this.storage.getName()});
                }
                database.setDefaultTransactionMode();
                for (ORecordOperation ent : iTx.getAllRecordEntries()) {
                    ORecordInternal.getDirtyManager((ORecord)ent.getRecord()).clear();
                }
                Set<String> involvedClusters = this.getInvolvedClusters(uResult);
                Set<String> nodes = this.getAvailableNodesButLocal(dbCfg, involvedClusters, localNodeName);
                if (nodes.isEmpty()) {
                    executionModeSynch = true;
                    List<ORecordOperation> list = null;
                    return list;
                }
                this.updateUndoTaskWithCreatedRecords(uResult, undoTasks);
                OTxTaskResult localResult = this.createLocalTxResult(uResult);
                OTxTask txTask = this.createTxTask(uResult);
                txTask.setLocalUndoTasks(undoTasks);
                try {
                    ODistributedResponse lastResult;
                    txTask.setLastLSN(((OAbstractPaginatedStorage)this.storage.getUnderlying()).getLSN());
                    OTransactionInternal.setStatus((OTransactionAbstract)((OTransactionAbstract)iTx), (OTransaction.TXSTATUS)OTransaction.TXSTATUS.COMMITTING);
                    if (finalExecutionModeSynch) {
                        lastResult = null;
                    } else {
                        OCallable<Void, ODistributedRequestId> unlockCallback = new OCallable<Void, ODistributedRequestId>(){

                            public Void call(ODistributedRequestId reqId) {
                                if (lockReleased.compareAndSet(false, true)) {
                                    ODistributedTransactionManager.this.localDistributedDatabase.popTxContext(requestId);
                                    ctx.destroy();
                                }
                                return null;
                            }
                        };
                        this.executeAsyncTx(nodes, localResult, involvedClusters, txTask, requestId.getMessageId(), localNodeName, unlockCallback);
                        return null;
                    }
                    for (int retry = 1; retry <= maxAutoRetry; ++retry) {
                        boolean isLastRetry;
                        boolean bl = isLastRetry = maxAutoRetry == retry;
                        if (retry > 1) {
                            nodes = this.getAvailableNodesButLocal(dbCfg, involvedClusters, localNodeName);
                            if (nodes.isEmpty()) {
                                executionModeSynch = true;
                                List<ORecordOperation> list = null;
                                return list;
                            }
                            ODistributedServerLog.debug((Object)this, (String)localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Retrying (%d/%d) transaction reqId=%s...", (Object[])new Object[]{retry, maxAutoRetry, requestId});
                        }
                        if (this.processCommitResult(localNodeName, iTx, txTask, involvedClusters, uResult, nodes, autoRetryDelay, (lastResult = this.dManager.sendRequest(this.storage.getName(), involvedClusters, nodes, (ORemoteTask)txTask, requestId.getMessageId(), ODistributedRequest.EXECUTION_MODE.RESPONSE, (Object)localResult, null)).getRequestId(), lastResult, isLastRetry)) {
                            ODistributedServerLog.debug((Object)this, (String)localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction succeeded. Tasks: %s", (Object[])new Object[]{txTask.getTasks()});
                            List<ORecordOperation> list = null;
                            return list;
                        }
                        Orient.instance().getProfiler().updateCounter("db." + database.getName() + ".distributedTxRetries", "Number of retries executed in distributed transaction", 1L, "db.*.distributedTxRetries");
                    }
                    ODistributedServerLog.debug((Object)this, (String)localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction retries exceed maximum auto-retries (%d). Task: %s - Tasks: %s", (Object[])new Object[]{maxAutoRetry, txTask, txTask.getTasks()});
                    this.storage.executeUndoOnLocalServer(requestId, txTask);
                    this.sendTxCompleted(localNodeName, involvedClusters, nodes, lastResult.getRequestId(), false, txTask.getPartitionKey());
                    throw (RuntimeException)lastResult.getPayload();
                }
                catch (Throwable e) {
                    this.storage.executeUndoOnLocalServer(requestId, txTask);
                    executionModeSynch = true;
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    if (!(e instanceof InterruptedException)) throw OException.wrapException((OException)new ODistributedException("Cannot commit transaction"), (Throwable)e);
                    throw OException.wrapException((OException)new ODistributedOperationException("Cannot commit transaction"), (Throwable)e);
                }
            }
            catch (RuntimeException e) {
                executionModeSynch = true;
                throw e;
            }
            catch (InterruptedException e) {
                executionModeSynch = true;
                throw OException.wrapException((OException)new ODistributedOperationException("Cannot commit transaction"), (Throwable)e);
            }
            catch (Exception e) {
                executionModeSynch = true;
                throw OException.wrapException((OException)new ODistributedException("Cannot commit transaction"), (Throwable)e);
            }
            finally {
                if (executionModeSynch.booleanValue() && lockReleased.compareAndSet(false, true)) {
                    this.localDistributedDatabase.popTxContext(requestId);
                    ctx.destroy();
                }
            }
        }
        catch (OValidationException e) {
            throw e;
        }
        catch (ODistributedRecordLockedException e) {
            throw e;
        }
        catch (OConcurrentCreateException e) {
            this.localDistributedDatabase.getDatabaseRepairer().enqueueRepairCluster(e.getActualRid().getClusterId());
            throw e;
        }
        catch (OConcurrentModificationException e) {
            this.localDistributedDatabase.getDatabaseRepairer().enqueueRepairRecord((ORecordId)e.getRid());
            throw e;
        }
        catch (Exception e) {
            for (ORecordOperation op : iTx.getAllRecordEntries()) {
                if (iTx.hasRecordCreation()) {
                    ORecordId lockEntireCluster = (ORecordId)op.getRID().copy();
                    this.localDistributedDatabase.getDatabaseRepairer().enqueueRepairCluster(lockEntireCluster.getClusterId());
                }
                this.localDistributedDatabase.getDatabaseRepairer().enqueueRepairRecord((ORecordId)op.getRID());
            }
            this.storage.handleDistributedException("Cannot route TX operation against distributed node", e, new Object[0]);
        }
        return null;
    }

    protected void checkForClusterIds(OTransaction iTx, String localNodeName, ODistributedConfiguration dbCfg) {
        for (ORecordOperation op : iTx.getAllRecordEntries()) {
            ORecordId rid = (ORecordId)op.getRecord().getIdentity();
            switch (op.type) {
                case 3: {
                    String clusterName;
                    ORecordId newRid = rid.copy();
                    if (rid.getClusterId() < 1 && (clusterName = ((OTransactionAbstract)iTx).getClusterName(op.getRecord())) != null) {
                        newRid.setClusterId(ODatabaseRecordThreadLocal.INSTANCE.get().getClusterIdByName(clusterName));
                        iTx.updateIdentityAfterCommit((ORID)rid, (ORID)newRid);
                    }
                    if (this.storage.checkForCluster(op.getRecord(), localNodeName, dbCfg) == null) break;
                    iTx.updateIdentityAfterCommit((ORID)rid, (ORID)newRid);
                }
            }
        }
    }

    protected Set<String> getAvailableNodesButLocal(ODistributedConfiguration dbCfg, Set<String> involvedClusters, String localNodeName) {
        Set nodes = dbCfg.getServers(involvedClusters);
        nodes.remove(localNodeName);
        return nodes;
    }

    protected void executeAsyncTx(final Set<String> nodes, OTxTaskResult localResult, final Set<String> involvedClusters, final OAbstractReplicatedTask txTask, long messageId, final String localNodeName, final OCallable<Void, ODistributedRequestId> afterSendCallback) {
        final OAsyncReplicationOk onAsyncReplicationOk = ((OExecutionThreadLocal.OExecutionThreadData)OExecutionThreadLocal.INSTANCE.get()).onAsyncReplicationOk;
        final OAsyncReplicationError onAsyncReplicationError = this.storage.getAsyncReplicationError();
        this.storage.asynchronousExecution(new OAsynchDistributedOperation(this.storage.getName(), involvedClusters, nodes, (ORemoteTask)txTask, messageId, (Object)localResult, afterSendCallback, (OCallable)new OCallable<Object, OPair<ODistributedRequestId, Object>>(){

            public Object call(OPair<ODistributedRequestId, Object> iArgument) {
                try {
                    Object value = iArgument.getValue();
                    ODistributedRequestId reqId = (ODistributedRequestId)iArgument.getKey();
                    if (value instanceof OTxTaskResult) {
                        ODistributedTransactionManager.this.sendTxCompleted(localNodeName, involvedClusters, nodes, reqId, true, txTask.getPartitionKey());
                        if (onAsyncReplicationOk != null) {
                            onAsyncReplicationOk.onAsyncReplicationOk();
                        }
                        Object var4_4 = null;
                        return var4_4;
                    }
                    if (value instanceof Exception) {
                        try {
                            ODistributedTransactionManager.this.storage.executeUndoOnLocalServer(reqId, txTask);
                            if (ODistributedServerLog.isDebugEnabled()) {
                                ODistributedServerLog.debug((Object)this, (String)localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Async distributed transaction failed: %s", (Object[])new Object[]{value});
                            }
                            ODistributedTransactionManager.this.sendTxCompleted(localNodeName, involvedClusters, nodes, reqId, false, txTask.getPartitionKey());
                            if (value instanceof RuntimeException) {
                                throw (RuntimeException)value;
                            }
                            throw OException.wrapException((OException)new OTransactionException("Error on execution async distributed transaction"), (Throwable)((Exception)value));
                        }
                        catch (Throwable throwable) {
                            if (onAsyncReplicationError != null) {
                                onAsyncReplicationError.onAsyncReplicationError((Throwable)value, 0);
                            }
                            throw throwable;
                        }
                    }
                    if (ODistributedServerLog.isDebugEnabled()) {
                        ODistributedServerLog.debug((Object)this, (String)localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Async distributed transaction error, received unknown response type: %s", (Object[])new Object[]{iArgument});
                    }
                    throw new OTransactionException("Error on committing async distributed transaction, received unknown response type " + iArgument);
                }
                finally {
                    try {
                        afterSendCallback.call((Object)iArgument.getKey());
                    }
                    catch (Exception e) {
                        ODistributedServerLog.debug((Object)this, (String)localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on unlocking Async distributed transaction", (Throwable)e, (Object[])new Object[0]);
                    }
                }
            }
        }));
    }

    protected void updateUndoTaskWithCreatedRecords(List<ORecordOperation> uResult, List<OAbstractRemoteTask> undoTasks) {
        for (ORecordOperation op : uResult) {
            ORecord record = op.getRecord();
            switch (op.type) {
                case 3: {
                    undoTasks.add((OAbstractRemoteTask)new OFixCreateRecordTask(record));
                }
            }
        }
    }

    protected Set<String> getInvolvedClusters(List<ORecordOperation> uResult) {
        HashSet<String> involvedClusters = new HashSet<String>();
        for (ORecordOperation op : uResult) {
            ORecord record = op.getRecord();
            involvedClusters.add(this.storage.getClusterNameByRID((ORecordId)record.getIdentity()));
        }
        return involvedClusters;
    }

    protected OTxTask createTxTask(List<ORecordOperation> uResult) {
        OTxTask txTask = new OTxTask();
        block5: for (ORecordOperation op : uResult) {
            OAbstractRecordReplicatedTask task;
            ORecord record = op.getRecord();
            switch (op.type) {
                case 3: {
                    task = new OCreateRecordTask(record);
                    break;
                }
                case 1: {
                    task = new OUpdateRecordTask(record);
                    break;
                }
                case 2: {
                    task = new ODeleteRecordTask(record);
                    break;
                }
                default: {
                    continue block5;
                }
            }
            txTask.add(task);
        }
        return txTask;
    }

    protected OTxTaskResult createLocalTxResult(List<ORecordOperation> uResult) {
        OTxTaskResult localResult = new OTxTaskResult();
        block5: for (ORecordOperation op : uResult) {
            ORecord record = op.getRecord();
            switch (op.type) {
                case 3: {
                    localResult.results.add(new OPlaceholder((ORecordId)record.getIdentity(), record.getVersion()));
                    continue block5;
                }
                case 1: {
                    localResult.results.add(record.getVersion());
                    continue block5;
                }
                case 2: {
                    localResult.results.add(Boolean.TRUE);
                    continue block5;
                }
            }
        }
        return localResult;
    }

    private void sendTxCompleted(String localNodeName, Set<String> involvedClusters, Collection<String> nodes, ODistributedRequestId reqId, boolean status, int[] partitionKey) {
        if (nodes.isEmpty()) {
            return;
        }
        try {
            ODistributedServerLog.debug((Object)this, (String)localNodeName, (String)nodes.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Sending distributed end of transaction status=%s reqId=%s waitForFinalResponse=%s", (Object[])new Object[]{status, reqId, false});
            ODistributedTxContext ctx = this.localDistributedDatabase.popTxContext(reqId);
            if (ctx != null) {
                ctx.destroy();
            }
            ODistributedResponse oDistributedResponse = this.dManager.sendRequest(this.storage.getName(), involvedClusters, nodes, (ORemoteTask)new OCompleted2pcTask(reqId, status, partitionKey), this.dManager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.NO_RESPONSE, null, null);
        }
        catch (ODistributedException e) {
            ODistributedServerLog.warn((Object)this, (String)localNodeName, (String)nodes.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Distributed transaction complete error: %s", (Object[])new Object[]{e.toString()});
        }
    }

    protected void acquireMultipleRecordLocks(OTransaction iTx, int maxAutoRetry, int autoRetryDelay, ODistributedStorageEventListener eventListener, ODistributedTxContext reqContext) throws InterruptedException {
        ArrayList<ORecordId> recordsToLock = new ArrayList<ORecordId>();
        for (ORecordOperation op : iTx.getAllRecordEntries()) {
            recordsToLock.add((ORecordId)op.record.getIdentity());
        }
        ODistributedTransactionManager.acquireMultipleRecordLocks(this, this.dManager, this.localDistributedDatabase, recordsToLock, maxAutoRetry, autoRetryDelay, eventListener, reqContext, -1L);
    }

    public static void acquireMultipleRecordLocks(Object iThis, ODistributedServerManager dManager, ODistributedDatabase localDistributedDatabase, List<ORecordId> recordsToLock, int maxAutoRetry, int autoRetryDelay, ODistributedStorageEventListener eventListener, ODistributedTxContext reqContext, long timeout) throws InterruptedException {
        Collections.sort(recordsToLock);
        ORecordId lastRecordCannotLock = null;
        ODistributedRequestId lastLockHolder = null;
        long begin = System.currentTimeMillis();
        for (int retry = 1; retry <= maxAutoRetry; ++retry) {
            lastRecordCannotLock = null;
            lastLockHolder = null;
            for (ORecordId rid : recordsToLock) {
                try {
                    reqContext.lock((ORID)rid, timeout);
                }
                catch (ODistributedRecordLockedException e) {
                    lastRecordCannotLock = rid;
                    lastLockHolder = e.getLockHolder();
                    reqContext.unlock();
                    if (autoRetryDelay > -1 && retry + 1 <= maxAutoRetry) {
                        Thread.sleep(autoRetryDelay / 2 + new Random().nextInt(autoRetryDelay));
                    }
                    ODistributedServerLog.debug((Object)iThis, (String)dManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction: %s cannot lock records %s because owned by %s (retry %d/%d, thread=%d)", (Object[])new Object[]{reqContext.getReqId(), recordsToLock, lastLockHolder, retry, maxAutoRetry, Thread.currentThread().getId()});
                    break;
                }
            }
            if (lastRecordCannotLock != null) continue;
            if (eventListener == null) break;
            for (ORecordId rid : recordsToLock) {
                try {
                    eventListener.onAfterRecordLock(rid);
                }
                catch (Throwable t) {
                    ODistributedServerLog.error((Object)iThis, (String)dManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Caught exception during ODistributedStorageEventListener.onAfterRecordLock", (Throwable)t, (Object[])new Object[0]);
                }
            }
            break;
        }
        if (lastRecordCannotLock != null) {
            throw new ODistributedRecordLockedException(dManager.getLocalNodeName(), lastRecordCannotLock, lastLockHolder, System.currentTimeMillis() - begin);
        }
    }

    protected List<OAbstractRemoteTask> createUndoTasksFromTx(OTransaction iTx) {
        ArrayList<OAbstractRemoteTask> undoTasks = new ArrayList<OAbstractRemoteTask>();
        block4: for (ORecordOperation op : iTx.getAllRecordEntries()) {
            OUpdateRecordTask undoTask = null;
            ORecord record = op.getRecord();
            switch (op.type) {
                case 3: {
                    break;
                }
                case 1: 
                case 2: {
                    final ORecordId rid = (ORecordId)record.getIdentity();
                    final AtomicReference previousRecord = new AtomicReference();
                    OScenarioThreadLocal.executeAsDefault((Callable)new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.INSTANCE.get();
                            ORecordOperation txEntry = db.getTransaction().getRecordEntry((ORID)rid);
                            if (txEntry != null && txEntry.type == 2) {
                                previousRecord.set(txEntry.getRecord());
                            } else {
                                OStorageOperationResult loadedBuffer = ODatabaseRecordThreadLocal.INSTANCE.get().getStorage().getUnderlying().readRecord(rid, null, true, false, null);
                                if (loadedBuffer != null) {
                                    ORecord loaded = Orient.instance().getRecordFactoryManager().newInstance(((ORawBuffer)loadedBuffer.getResult()).recordType);
                                    ORecordInternal.fill((ORecord)loaded, (ORID)rid, (int)((ORawBuffer)loadedBuffer.getResult()).version, (byte[])((ORawBuffer)loadedBuffer.getResult()).getBuffer(), (boolean)false);
                                    previousRecord.set(loaded);
                                } else {
                                    previousRecord.set(db.load((ORID)rid));
                                }
                            }
                            return null;
                        }
                    });
                    if (previousRecord.get() == null) {
                        throw new ORecordNotFoundException((ORID)rid);
                    }
                    if (op.type == 1) {
                        undoTask = new OFixUpdateRecordTask((ORecord)previousRecord.get(), ORecordVersionHelper.clearRollbackMode((int)((ORecord)previousRecord.get()).getVersion()));
                        break;
                    }
                    undoTask = new OResurrectRecordTask((ORecord)previousRecord.get());
                    break;
                }
                default: {
                    continue block4;
                }
            }
            if (undoTask == null) continue;
            undoTasks.add((OAbstractRemoteTask)undoTask);
        }
        return undoTasks;
    }

    protected boolean processCommitResult(String localNodeName, OTransaction iTx, OTxTask txTask, Set<String> involvedClusters, Iterable<ORecordOperation> tmpEntries, Collection<String> nodes, int autoRetryDelay, ODistributedRequestId reqId, ODistributedResponse dResponse, boolean isLastRetry) throws InterruptedException {
        Object result = dResponse.getPayload();
        if (result instanceof OTxTaskResult) {
            OTxTaskResult txResult = (OTxTaskResult)result;
            List<Object> list = txResult.results;
            for (int i = 0; i < txTask.getTasks().size(); ++i) {
                OAbstractRecordReplicatedTask t;
                Object o = list.get(i);
                OAbstractRecordReplicatedTask task = txTask.getTasks().get(i);
                if (task instanceof OCreateRecordTask) {
                    t = (OCreateRecordTask)task;
                    iTx.updateIdentityAfterCommit((ORID)t.getRid(), ((OPlaceholder)o).getIdentity());
                    ORecord rec = iTx.getRecord((ORID)t.getRid());
                    if (rec == null) continue;
                    ORecordInternal.setVersion((ORecord)rec, (int)((OPlaceholder)o).getVersion());
                    continue;
                }
                if (task instanceof OUpdateRecordTask) {
                    t = (OUpdateRecordTask)task;
                    ORecordInternal.setVersion((ORecord)iTx.getRecord((ORID)t.getRid()), (int)((Integer)o));
                    continue;
                }
                if (!(task instanceof ODeleteRecordTask)) continue;
            }
            for (ORecordOperation op : tmpEntries) {
                ORecord record = op.getRecord();
                if (record == null) continue;
                ORecordInternal.unsetDirty((ORecord)record);
            }
            if (ODistributedServerLog.isDebugEnabled()) {
                ODistributedServerLog.debug((Object)this, (String)localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction %s completed", (Object[])new Object[]{reqId});
            }
        } else {
            if (result instanceof ODistributedRecordLockedException) {
                if (ODistributedServerLog.isDebugEnabled()) {
                    ODistributedServerLog.debug((Object)this, (String)localNodeName, (String)nodes.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Distributed transaction %s error: record %s is locked by %s", (Object[])new Object[]{reqId, ((ODistributedRecordLockedException)((Object)result)).getRid(), ((ODistributedRecordLockedException)((Object)result)).getLockHolder()});
                }
                if (autoRetryDelay > 0 && !isLastRetry) {
                    Thread.sleep(autoRetryDelay / 2 + new Random().nextInt(autoRetryDelay));
                }
                return false;
            }
            if (result instanceof Exception) {
                if (ODistributedServerLog.isDebugEnabled()) {
                    ODistributedServerLog.debug((Object)this, (String)localNodeName, (String)nodes.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Distributed transaction %s received error: %s", (Object[])new Object[]{reqId, result, result.toString()});
                }
                if (result instanceof OTransactionException || result instanceof ONeedRetryException) {
                    throw (RuntimeException)result;
                }
                if (result instanceof ORecordNotFoundException) {
                    this.localDistributedDatabase.getDatabaseRepairer().repairRecord((ORecordId)((ORecordNotFoundException)((Object)result)).getRid());
                    return false;
                }
                throw OException.wrapException((OException)new OTransactionException("Error on committing distributed transaction"), (Throwable)((Exception)result));
            }
            if (ODistributedServerLog.isDebugEnabled()) {
                ODistributedServerLog.info((Object)this, (String)localNodeName, (String)nodes.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Distributed transaction %s error, received unknown response type: %s", (Object[])new Object[]{reqId, result});
            }
            this.storage.executeUndoOnLocalServer(dResponse.getRequestId(), txTask);
            this.sendTxCompleted(localNodeName, involvedClusters, nodes, dResponse.getRequestId(), false, txTask.getPartitionKey());
            throw new OTransactionException("Error on committing distributed transaction, received unknown response type " + result);
        }
        this.sendTxCompleted(localNodeName, involvedClusters, nodes, reqId, true, txTask.getPartitionKey());
        return true;
    }
}

