/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedTxContext;
import com.orientechnologies.orient.server.distributed.task.OAbstractRecordReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.util.ArrayList;
import java.util.List;

public class ODistributedTxContextImpl
implements ODistributedTxContext {
    private final ODistributedDatabase db;
    private final ODistributedRequestId reqId;
    private final List<ORemoteTask> undoTasks = new ArrayList<ORemoteTask>();
    private final List<ORID> acquiredLocks = new ArrayList<ORID>();
    private final long startedOn = System.currentTimeMillis();

    public ODistributedTxContextImpl(ODistributedDatabase iDatabase, ODistributedRequestId iRequestId) {
        this.db = iDatabase;
        this.reqId = iRequestId;
    }

    public String toString() {
        return "reqId=" + this.reqId + " undoTasks=" + this.undoTasks.size() + " startedOn=" + this.startedOn;
    }

    public synchronized void lock(ORID rid) {
        this.lock(rid, -1L);
    }

    public synchronized void lock(ORID rid, long timeout) {
        if (timeout < 0L) {
            timeout = OGlobalConfiguration.DISTRIBUTED_ATOMIC_LOCK_TIMEOUT.getValueAsInteger();
        }
        if (!rid.isPersistent()) {
            rid = new ORecordId(rid.getClusterId(), -1L);
        }
        if (this.db.lockRecord(rid, this.reqId, timeout)) {
            this.acquiredLocks.add(rid);
        }
    }

    public ODistributedRequestId getReqId() {
        return this.reqId;
    }

    public synchronized void addUndoTask(ORemoteTask undoTask) {
        this.undoTasks.add(undoTask);
    }

    public synchronized void commit() {
        ODistributedServerLog.debug((Object)this, (String)this.db.getManager().getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction %s: committing transaction", (Object[])new Object[]{this.reqId});
    }

    public synchronized void fix(ODatabaseDocumentInternal database, List<ORemoteTask> fixTasks) {
        ODistributedServerLog.debug((Object)this, (String)this.db.getManager().getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction %s: fixing transaction (db=%s tasks=%d)", (Object[])new Object[]{this.reqId, this.db.getDatabaseName(), fixTasks.size()});
        for (ORemoteTask fixTask : fixTasks) {
            try {
                if (fixTask instanceof OAbstractRecordReplicatedTask) {
                    ((OAbstractRecordReplicatedTask)fixTask).setLockRecords(false);
                }
                fixTask.execute(this.reqId, this.db.getManager().getServerInstance(), this.db.getManager(), database);
            }
            catch (Exception e) {
                ODistributedServerLog.error((Object)this, (String)this.db.getManager().getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on fixing transaction %s db=%s task=%s", (Throwable)e, (Object[])new Object[]{this.reqId, this.db.getDatabaseName(), fixTask});
            }
        }
    }

    public synchronized int rollback(ODatabaseDocumentInternal database) {
        ODistributedServerLog.debug((Object)this, (String)this.db.getManager().getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction %s: rolling back transaction (%d ops) on database '%s'", (Object[])new Object[]{this.reqId, this.undoTasks.size(), database});
        for (ORemoteTask task : this.undoTasks) {
            try {
                if (task == null) continue;
                this.db.getManager().executeOnLocalNode(this.reqId, task, database);
            }
            catch (Exception e) {
                ODistributedServerLog.error((Object)this, (String)this.db.getManager().getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on rolling back transaction %s task %s", (Throwable)e, (Object[])new Object[]{this.reqId, task});
            }
        }
        return this.undoTasks.size();
    }

    public synchronized void destroy() {
        this.unlock();
        this.undoTasks.clear();
    }

    public synchronized void unlock() {
        if (!this.acquiredLocks.isEmpty()) {
            for (ORID lockedRID : this.acquiredLocks) {
                this.db.unlockRecord((OIdentifiable)lockedRID, this.reqId);
            }
            this.acquiredLocks.clear();
        }
    }

    public long getStartedOn() {
        return this.startedOn;
    }
}

