/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.task.OAbstractReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.ODatabaseIsOldException;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;

public abstract class OAbstractSyncDatabaseTask
extends OAbstractReplicatedTask
implements OCommandOutputListener {
    public static final int CHUNK_MAX_SIZE = 0x800000;
    public static final String DEPLOYDB = "deploydb.";
    public static final int FACTORYID = 14;
    protected long lastOperationTimestamp;
    protected long random;

    public OAbstractSyncDatabaseTask() {
    }

    protected OAbstractSyncDatabaseTask(long lastOperationTimestamp) {
        this.random = UUID.randomUUID().getLeastSignificantBits();
        this.lastOperationTimestamp = lastOperationTimestamp;
    }

    public ORemoteTask.RESULT_STRATEGY getResultStrategy() {
        return ORemoteTask.RESULT_STRATEGY.UNION;
    }

    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.ALL;
    }

    public long getDistributedTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_DEPLOYDB_TASK_SYNCH_TIMEOUT.getValueAsLong();
    }

    public void onMessage(String iText) {
        if (iText.startsWith("\r\n")) {
            iText = iText.substring(2);
        }
        if (iText.startsWith("\n")) {
            iText = iText.substring(1);
        }
        OLogManager.instance().info((Object)this, iText, new Object[0]);
    }

    public boolean isNodeOnlineRequired() {
        return false;
    }

    protected ODistributedDatabase checkIfCurrentDatabaseIsNotOlder(ODistributedServerManager iManager, String databaseName, OLogSequenceNumber startLSN) {
        OLogSequenceNumber currentLSN;
        ODistributedDatabase dDatabase = iManager.getMessageService().getDatabase(databaseName);
        if (startLSN != null && startLSN.equals((Object)(currentLSN = dDatabase.getSyncConfiguration().getLastLSN(iManager.getLocalNodeName())))) {
            return dDatabase;
        }
        if (dDatabase.getSyncConfiguration().getLastOperationTimestamp() < this.lastOperationTimestamp) {
            currentLSN = dDatabase.getSyncConfiguration().getLastLSN(this.getNodeSource());
            if (currentLSN == null) {
                return dDatabase;
            }
            if (this.lastLSN != null && this.lastLSN.equals((Object)currentLSN)) {
                return dDatabase;
            }
            this.databaseIsOld(iManager, databaseName, dDatabase);
        }
        return dDatabase;
    }

    private void databaseIsOld(ODistributedServerManager iManager, String databaseName, ODistributedDatabase dDatabase) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        String msg = String.format("Skip deploying delta database '%s' because the requesting server has a most recent database (requester LastOperationOn=%s current LastOperationOn=%s)", databaseName, df.format(new Date(this.lastOperationTimestamp)), df.format(new Date(dDatabase.getSyncConfiguration().getLastOperationTimestamp())));
        ODistributedServerLog.error((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)msg, (Object[])new Object[0]);
        throw new ODatabaseIsOldException(msg);
    }

    protected void readOptionalLSN(DataInput in) throws IOException {
        boolean lastLSNPresent = in.readBoolean();
        if (lastLSNPresent) {
            this.lastLSN = new OLogSequenceNumber(in);
        }
    }

    protected void writeOptionalLSN(DataOutput out) throws IOException {
        if (this.lastLSN != null) {
            out.writeBoolean(true);
            this.lastLSN.toStream(out);
        } else {
            out.writeBoolean(false);
        }
    }
}

