/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ODistributedTxContext;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.task.OAbstractReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OCompleted2pcTask
extends OAbstractReplicatedTask {
    private static final long serialVersionUID = 1L;
    public static final int FACTORYID = 8;
    private ODistributedRequestId requestId;
    private boolean success;
    private List<ORemoteTask> fixTasks = new ArrayList<ORemoteTask>();
    private int[] partitionKey;

    public OCompleted2pcTask() {
        this.partitionKey = ALL;
    }

    public OCompleted2pcTask(ODistributedRequestId iRequestId, boolean iSuccess, int[] partitionKey) {
        this.requestId = iRequestId;
        this.success = iSuccess;
        this.partitionKey = partitionKey != null ? partitionKey : ALL;
    }

    public int[] getPartitionKey() {
        return this.partitionKey;
    }

    public void addFixTask(ORemoteTask fixTask) {
        this.fixTasks.add(fixTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(ODistributedRequestId msgId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        block12: {
            ODistributedServerLog.debug((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"%s transaction db=%s originalReqId=%s...", (Object[])new Object[]{this.success ? "Committing" : (this.fixTasks.isEmpty() ? "Rolling back" : "Fixing"), database.getName(), this.requestId, this.requestId});
            ODatabaseRecordThreadLocal.INSTANCE.set(database);
            ODistributedDatabase ddb = iManager.getMessageService().getDatabase(database.getName());
            if (ddb == null) {
                throw new ODatabaseException("Database '" + database.getName() + " is not available on server '" + iManager.getLocalNodeName() + "'");
            }
            ODistributedTxContext pRequest = ddb.popTxContext(this.requestId);
            try {
                if (this.success) {
                    if (pRequest != null) {
                        pRequest.commit();
                        break block12;
                    }
                    ODistributedServerLog.debug((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Error on committing distributed transaction %s db=%s", (Object[])new Object[]{this.requestId, database.getName()});
                    Boolean bl = Boolean.FALSE;
                    return bl;
                }
                if (this.fixTasks.isEmpty()) {
                    if (pRequest != null) {
                        pRequest.rollback(database);
                        break block12;
                    }
                    ODistributedServerLog.debug((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Error on rolling back distributed transaction %s db=%s", (Object[])new Object[]{this.requestId, database.getName()});
                    Boolean bl = Boolean.FALSE;
                    return bl;
                }
                if (pRequest != null) {
                    pRequest.fix(database, this.fixTasks);
                    break block12;
                }
                ODistributedServerLog.debug((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Error on fixing distributed transaction %s db=%s", (Object[])new Object[]{this.requestId, database.getName()});
                Boolean bl = Boolean.FALSE;
                return bl;
            }
            finally {
                if (pRequest != null) {
                    pRequest.destroy();
                }
            }
        }
        return Boolean.TRUE;
    }

    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.NONE;
    }

    public void toStream(DataOutput out) throws IOException {
        this.requestId.toStream(out);
        out.writeBoolean(this.success);
        out.writeInt(this.fixTasks.size());
        for (ORemoteTask task : this.fixTasks) {
            out.writeByte(task.getFactoryId());
            task.toStream(out);
        }
        out.writeInt(this.partitionKey.length);
        for (Object pk : (Object)this.partitionKey) {
            out.writeInt((int)pk);
        }
    }

    public void fromStream(DataInput in, ORemoteTaskFactory taskFactory) throws IOException {
        this.requestId = new ODistributedRequestId();
        this.requestId.fromStream(in);
        this.success = in.readBoolean();
        int tasksSize = in.readInt();
        for (int i = 0; i < tasksSize; ++i) {
            ORemoteTask task = taskFactory.createTask((int)in.readByte());
            task.fromStream(in, taskFactory);
            this.fixTasks.add(task);
        }
        int pkSize = in.readInt();
        this.partitionKey = new int[pkSize];
        for (int i = 0; i < pkSize; ++i) {
            this.partitionKey[i] = in.readInt();
        }
    }

    public long getDistributedTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_CRUD_TASK_SYNCH_TIMEOUT.getValueAsLong();
    }

    public String getName() {
        return "tx-completed";
    }

    public int getFactoryId() {
        return 8;
    }

    public String toString() {
        return this.getName() + " origReqId: " + this.requestId + " type: " + (this.success ? "commit" : (this.fixTasks.isEmpty() ? "rollback" : "fix (" + this.fixTasks.size() + " ops) [" + this.fixTasks + "]"));
    }

    public List<ORemoteTask> getFixTasks() {
        return this.fixTasks;
    }
}

