/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OPlaceholder;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OPaginatedCluster;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.impl.task.ODeleteRecordTask;
import com.orientechnologies.orient.server.distributed.impl.task.OFixCreateRecordTask;
import com.orientechnologies.orient.server.distributed.impl.task.OFixUpdateRecordTask;
import com.orientechnologies.orient.server.distributed.impl.task.OReadRecordTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractRecordReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.ODistributedOperationException;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class OCreateRecordTask
extends OAbstractRecordReplicatedTask {
    private static final long serialVersionUID = 1L;
    public static final int FACTORYID = 0;
    protected byte[] content;
    protected byte recordType;
    protected int clusterId = -1;
    private transient ORecord record;

    public OCreateRecordTask() {
    }

    public OCreateRecordTask(ORecordId iRid, byte[] iContent, int iVersion, byte iRecordType) {
        super(iRid, iVersion);
        this.content = iContent;
        this.recordType = iRecordType;
    }

    public OCreateRecordTask(ORecord record) {
        this((ORecordId)record.getIdentity(), record.toStream(), record.getVersion() - 1, ORecordInternal.getRecordType((ORecord)record));
        if (this.rid.getClusterId() == -1) {
            ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.INSTANCE.get();
            this.clusterId = db.assignAndCheckCluster(record, null);
            ((ORecordId)record.getIdentity()).setClusterId(-1);
        }
    }

    public ORecord prepareUndoOperation() {
        return null;
    }

    public void checkRecordExists() {
    }

    public ORecord getRecord() {
        if (this.record == null) {
            this.record = Orient.instance().getRecordFactoryManager().newInstance(this.recordType);
            ORecordInternal.fill((ORecord)this.record, (ORID)this.rid, (int)this.version, (byte[])this.content, (boolean)true);
        }
        return this.record;
    }

    public Object executeRecordTask(ODistributedRequestId requestId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        if (ODistributedServerLog.isDebugEnabled()) {
            ODistributedServerLog.debug((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Creating record %s/%s v.%d reqId=%s...", (Object[])new Object[]{database.getName(), this.rid.toString(), this.version, requestId});
        }
        if (!this.rid.isPersistent()) {
            throw new ODistributedException("Record " + this.rid + " has not been saved on owner node first (temporary rid)");
        }
        OPaginatedCluster cluster = (OPaginatedCluster)ODatabaseRecordThreadLocal.INSTANCE.get().getStorage().getClusterById(this.rid.getClusterId());
        OPaginatedCluster.RECORD_STATUS recordStatus = cluster.getRecordStatus(this.rid.getClusterPosition());
        switch (recordStatus) {
            case REMOVED: {
                ODatabaseRecordThreadLocal.INSTANCE.get().getStorage().recyclePosition(this.rid, new byte[0], this.version, this.recordType);
                ORecord loadedRecordInstance = Orient.instance().getRecordFactoryManager().newInstance(this.recordType);
                ORecordInternal.fill((ORecord)loadedRecordInstance, (ORID)this.rid, (int)this.version, (byte[])this.content, (boolean)true);
                loadedRecordInstance.save();
                return new OPlaceholder(this.rid, loadedRecordInstance.getVersion());
            }
            case ALLOCATED: 
            case PRESENT: {
                OStorageOperationResult loadedRecord = ODatabaseRecordThreadLocal.INSTANCE.get().getStorage().readRecord(this.rid, null, true, false, null);
                if (loadedRecord.getResult() != null) {
                    this.record = this.forceUpdate(iManager, database, requestId, (ORawBuffer)loadedRecord.getResult());
                    return new OPlaceholder(this.record);
                }
            }
            case NOT_EXISTENT: {
                ORecordId newRid;
                do {
                    this.getRecord();
                    if (this.clusterId > -1) {
                        this.record.save(database.getClusterNameById(this.clusterId), true);
                    } else if (this.rid.getClusterId() != -1) {
                        this.record.save(database.getClusterNameById(this.rid.getClusterId()), true);
                    } else {
                        this.record.save();
                    }
                    newRid = (ORecordId)this.record.getIdentity();
                    if (newRid.getClusterPosition() >= this.rid.getClusterPosition()) break;
                    this.record.delete();
                    this.record = null;
                } while (newRid.getClusterPosition() < this.rid.getClusterPosition());
                if (!this.rid.equals((Object)newRid)) {
                    ODistributedServerLog.warn((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Record %s has been saved with the RID %s instead of the expected %s reqId=%s", (Object[])new Object[]{this.record, newRid, this.rid, requestId});
                    this.record.delete();
                    throw new ODistributedException("Record " + this.rid + " has been saved with the different RID " + newRid + " on server " + iManager.getLocalNodeName());
                }
                ODistributedServerLog.debug((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"+-> assigned new rid %s/%s v.%d reqId=%s", (Object[])new Object[]{database.getName(), this.rid.toString(), this.record.getVersion(), requestId});
            }
        }
        return new OPlaceholder(this.record);
    }

    protected ORecord forceUpdate(ODistributedServerManager manager, ODatabaseDocumentInternal database, ODistributedRequestId requestId, ORawBuffer loadedRecord) {
        ORecord loadedRecordInstance = Orient.instance().getRecordFactoryManager().newInstance(loadedRecord.recordType);
        ORecordInternal.fill((ORecord)loadedRecordInstance, (ORID)this.rid, (int)loadedRecord.version, (byte[])loadedRecord.getBuffer(), (boolean)false);
        if (Arrays.equals(loadedRecord.getBuffer(), this.content)) {
            return loadedRecordInstance;
        }
        ODistributedServerLog.debug((Object)((Object)this), (String)manager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Error on creating record in an existent position. toStore=%s stored=%s reqId=%s", (Object[])new Object[]{this.getRecord(), loadedRecordInstance, requestId});
        throw new ODistributedOperationException("Cannot create the record " + this.rid + " in an already existent position");
    }

    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.WRITE;
    }

    public ORemoteTask getFixTask(ODistributedRequest iRequest, ORemoteTask iOriginalTask, Object iBadResponse, Object iGoodResponse, String executorNode, ODistributedServerManager dManager) {
        if (iBadResponse == null || iBadResponse instanceof Throwable) {
            return null;
        }
        OPlaceholder badResult = (OPlaceholder)iBadResponse;
        OPlaceholder goodResult = (OPlaceholder)iGoodResponse;
        OAbstractRecordReplicatedTask result = null;
        if (!badResult.equals((Object)goodResult)) {
            if (badResult.getIdentity().getClusterId() == goodResult.getIdentity().getClusterId() && badResult.getIdentity().getClusterPosition() < goodResult.getIdentity().getClusterPosition()) {
                long minPos;
                for (long pos = minPos = Math.max(badResult.getIdentity().getClusterPosition() - 1L, 0L); pos < goodResult.getIdentity().getClusterPosition(); ++pos) {
                    ORecord toUpdateRecord;
                    ORecordId toUpdateRid = new ORecordId(goodResult.getIdentity().getClusterId(), pos);
                    if (dManager.getLocalNodeName().equals(executorNode)) {
                        ODistributedConfiguration dCfg = dManager.getDatabaseConfiguration(iRequest.getDatabaseName());
                        List nodes = dCfg.getServers(ODatabaseRecordThreadLocal.INSTANCE.get().getClusterNameById(this.clusterId), dManager.getLocalNodeName());
                        ODistributedResponse response = dManager.sendRequest(iRequest.getDatabaseName(), null, (Collection)nodes, (ORemoteTask)new OReadRecordTask(toUpdateRid), dManager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null);
                        ORawBuffer remoteReadRecord = (ORawBuffer)response.getPayload();
                        if (remoteReadRecord != null) {
                            toUpdateRecord = Orient.instance().getRecordFactoryManager().newInstance(this.recordType);
                            ORecordInternal.fill((ORecord)toUpdateRecord, (ORID)toUpdateRid, (int)remoteReadRecord.version, (byte[])remoteReadRecord.buffer, (boolean)false);
                        } else {
                            toUpdateRecord = null;
                        }
                    } else {
                        toUpdateRecord = toUpdateRid.getRecord();
                    }
                    if (toUpdateRecord == null) continue;
                    result = new OFixUpdateRecordTask(toUpdateRid, toUpdateRecord.toStream(), toUpdateRecord.getVersion(), ORecordInternal.getRecordType((ORecord)toUpdateRecord));
                }
                result = new OCreateRecordTask((ORecordId)goodResult.getIdentity(), this.content, this.version, this.recordType);
            } else if (badResult.getIdentity().getClusterId() != goodResult.getIdentity().getClusterId() || badResult.getIdentity().getClusterPosition() <= goodResult.getIdentity().getClusterPosition()) {
                result = new OFixCreateRecordTask(new ORecordId(badResult.getIdentity()), badResult.getVersion());
            }
        }
        return result;
    }

    public ODeleteRecordTask getUndoTask(ODistributedRequestId reqId) {
        OFixCreateRecordTask task = new OFixCreateRecordTask(this.rid, -1);
        task.setLockRecords(false);
        return task;
    }

    public void toStream(DataOutput out) throws IOException {
        super.toStream(out);
        if (this.content == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.content.length);
            out.write(this.content);
        }
        out.writeByte(this.recordType);
        out.writeInt(this.clusterId);
    }

    public void fromStream(DataInput in, ORemoteTaskFactory factory) throws IOException {
        super.fromStream(in, factory);
        int contentSize = in.readInt();
        if (contentSize == 0) {
            this.content = null;
        } else {
            this.content = new byte[contentSize];
            in.readFully(this.content);
        }
        this.recordType = in.readByte();
        this.clusterId = in.readInt();
    }

    public String getName() {
        return "record_create";
    }

    public int getFactoryId() {
        return 0;
    }
}

