/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.OPaginatedClusterException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.impl.task.OUpdateRecordTask;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.util.Arrays;

public class OResurrectRecordTask
extends OUpdateRecordTask {
    private static final long serialVersionUID = 1L;
    public static final int FACTORYID = 11;

    public OResurrectRecordTask() {
    }

    public OResurrectRecordTask(ORecord record) {
        super(record);
    }

    @Override
    public Object executeRecordTask(ODistributedRequestId requestId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        ODistributedServerLog.debug((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Resurrecting deleted record %s/%s v.%d reqId=%s", (Object[])new Object[]{database.getName(), this.rid.toString(), this.version, requestId});
        try {
            database.getStorage().recyclePosition(this.rid, new byte[0], this.version, this.recordType);
            ORecord loadedRecordInstance = Orient.instance().getRecordFactoryManager().newInstance(this.recordType);
            ORecordInternal.fill((ORecord)loadedRecordInstance, (ORID)this.rid, (int)this.version, (byte[])this.content, (boolean)true);
            loadedRecordInstance.save();
            ODistributedServerLog.debug((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"+-> resurrected deleted record", (Object[])new Object[0]);
            return Boolean.TRUE;
        }
        catch (OPaginatedClusterException e) {
            ODistributedServerLog.debug((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"+-> no resurrection, because the record was not deleted", (Object[])new Object[0]);
            OStorageOperationResult storedRecord = database.getStorage().readRecord(this.rid, null, true, false, null);
            return Arrays.equals(this.content, ((ORawBuffer)storedRecord.getResult()).getBuffer());
        }
        catch (Exception e) {
            ODistributedServerLog.error((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"+-> error on resurrecting deleted record: the record is already deleted", (Object[])new Object[0]);
            return Boolean.FALSE;
        }
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.NONE;
    }

    @Override
    public ORemoteTask getUndoTask(ODistributedRequestId reqId) {
        return null;
    }

    @Override
    public ORemoteTask getFixTask(ODistributedRequest iRequest, ORemoteTask iOriginalTask, Object iBadResponse, Object iGoodResponse, String executorNodeName, ODistributedServerManager dManager) {
        return null;
    }

    @Override
    public String getName() {
        return "fix_record_delete";
    }

    @Override
    public int getFactoryId() {
        return 11;
    }
}

