/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.task.OAbstractReplicatedTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.TimerTask;

public class OStartReplicationTask
extends OAbstractReplicatedTask {
    public static final int FACTORYID = 22;
    private String databaseName;
    private boolean tryWithDeltaFirst;

    public OStartReplicationTask() {
    }

    public OStartReplicationTask(String databaseName, boolean tryWithDeltaFirst) {
        this.databaseName = databaseName;
        this.tryWithDeltaFirst = tryWithDeltaFirst;
    }

    public Object execute(ODistributedRequestId requestId, OServer iServer, final ODistributedServerManager dManager, ODatabaseDocumentInternal database) throws Exception {
        if (dManager.getDatabaseStatus(dManager.getLocalNodeName(), this.databaseName) == ODistributedServerManager.DB_STATUS.ONLINE) {
            return false;
        }
        dManager.setDatabaseStatus(dManager.getLocalNodeName(), this.databaseName, ODistributedServerManager.DB_STATUS.SYNCHRONIZING);
        Orient.instance().scheduleTask(new TimerTask(){

            @Override
            public void run() {
                dManager.installDatabase(true, OStartReplicationTask.this.databaseName, true, OStartReplicationTask.this.tryWithDeltaFirst);
            }
        }, 1000L, 0L);
        return true;
    }

    public void toStream(DataOutput out) throws IOException {
        out.writeUTF(this.databaseName);
        out.writeBoolean(this.tryWithDeltaFirst);
    }

    public void fromStream(DataInput in, ORemoteTaskFactory factory) throws IOException {
        this.databaseName = in.readUTF();
        this.tryWithDeltaFirst = in.readBoolean();
    }

    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.NONE;
    }

    public long getDistributedTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_COMMAND_QUICK_TASK_SYNCH_TIMEOUT.getValueAsLong();
    }

    public String getName() {
        return "start_replication";
    }

    public boolean isNodeOnlineRequired() {
        return false;
    }

    public int getFactoryId() {
        return 22;
    }
}

