/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import com.orientechnologies.orient.server.hazelcast.OHazelcastDistributedMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class OUpdateDatabaseStatusTask
extends OAbstractRemoteTask {
    public static final int FACTORYID = 25;
    private String databaseName;
    private String status;

    public OUpdateDatabaseStatusTask() {
    }

    public OUpdateDatabaseStatusTask(String databaseName, String status) {
        this.databaseName = databaseName;
        this.status = status;
    }

    public Object execute(ODistributedRequestId msgId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        ((OHazelcastDistributedMap)iManager.getConfigurationMap()).putInLocalCache(this.databaseName, this.status);
        return true;
    }

    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.ALL;
    }

    public boolean isUsingDatabase() {
        return false;
    }

    public ORemoteTask.RESULT_STRATEGY getResultStrategy() {
        return ORemoteTask.RESULT_STRATEGY.UNION;
    }

    public void toStream(DataOutput out) throws IOException {
        out.writeUTF(this.databaseName);
        out.writeUTF(this.status);
    }

    public void fromStream(DataInput in, ORemoteTaskFactory factory) throws IOException {
        this.databaseName = in.readUTF();
        this.status = in.readUTF();
    }

    public boolean isNodeOnlineRequired() {
        return false;
    }

    public boolean isIdempotent() {
        return true;
    }

    public long getDistributedTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_HEARTBEAT_TIMEOUT.getValueAsLong();
    }

    public String getName() {
        return "upd_db_status";
    }

    public int getFactoryId() {
        return 25;
    }

    public String toString() {
        return this.getName();
    }
}

