/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OPlaceholder;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.ORecordVersionHelper;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.impl.task.OCreateRecordTask;
import com.orientechnologies.orient.server.distributed.impl.task.OFixUpdateRecordTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractRecordReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

public class OUpdateRecordTask
extends OAbstractRecordReplicatedTask {
    private static final long serialVersionUID = 1L;
    public static final int FACTORYID = 3;
    protected byte recordType;
    protected byte[] content;
    private transient ORecord record;
    private byte[] previousRecordContent;

    public OUpdateRecordTask() {
    }

    public OUpdateRecordTask(ORecord iRecord) {
        super((ORecordId)iRecord.getIdentity(), iRecord.getVersion() - 1);
        this.content = iRecord.toStream();
        this.recordType = ORecordInternal.getRecordType((ORecord)iRecord);
    }

    public OUpdateRecordTask(ORecord iRecord, int version) {
        super((ORecordId)iRecord.getIdentity(), version);
        this.content = iRecord.toStream();
        this.recordType = ORecordInternal.getRecordType((ORecord)iRecord);
    }

    public OUpdateRecordTask(ORecordId iRecordId, byte[] iContent, int iVersion, byte iRecordType) {
        super(iRecordId, iVersion);
        this.content = iContent;
        this.recordType = iRecordType;
    }

    public ORecord getRecord() {
        if (this.record == null) {
            this.record = Orient.instance().getRecordFactoryManager().newInstance(this.recordType);
            ORecordInternal.fill((ORecord)this.record, (ORID)this.rid, (int)this.version, (byte[])this.content, (boolean)true);
        }
        return this.record;
    }

    public Object executeRecordTask(ODistributedRequestId requestId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        if (ODistributedServerLog.isDebugEnabled()) {
            ODistributedServerLog.debug((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Updating record %s/%s v.%d reqId=%s...", (Object[])new Object[]{database.getName(), this.rid.toString(), this.version, requestId});
        }
        this.prepareUndoOperation();
        if (this.previousRecord == null) {
            OPlaceholder ph = (OPlaceholder)new OCreateRecordTask(this.rid, this.content, this.version, this.recordType).executeRecordTask(requestId, iServer, iManager, database);
            this.record = ph.getRecord();
            if (this.record == null) {
                ODistributedServerLog.debug((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"+-> Error on updating record %s", (Object[])new Object[]{this.rid});
            }
        } else {
            int loadedVersion = this.previousRecord.getVersion();
            if (loadedVersion == this.version + 1 && Arrays.equals(this.content, this.previousRecordContent)) {
                this.record = this.previousRecord;
            } else {
                ORecord loadedRecord = this.previousRecord.copy();
                if (loadedRecord instanceof ODocument) {
                    ODocument newDocument = (ODocument)this.getRecord();
                    ODocument loadedDocument = (ODocument)loadedRecord;
                    loadedDocument.merge(newDocument, false, false).getVersion();
                    ORecordInternal.setVersion((ORecord)loadedDocument, (int)this.version);
                } else {
                    ORecordInternal.fill((ORecord)loadedRecord, (ORID)this.rid, (int)this.version, (byte[])this.content, (boolean)true);
                }
                loadedRecord.setDirty();
                this.record = (ORecord)database.save((Object)loadedRecord);
                if (this.record == null) {
                    ODistributedServerLog.debug((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"+-> Error on updating record %s", (Object[])new Object[]{this.rid});
                }
                if (this.version < 0 && ODistributedServerLog.isDebugEnabled()) {
                    ODistributedServerLog.debug((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"+-> Reverted %s from version %d to %d", (Object[])new Object[]{this.rid, loadedVersion, this.record.getVersion()});
                }
            }
        }
        if (ODistributedServerLog.isDebugEnabled()) {
            ODistributedServerLog.debug((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"+-> updated record %s/%s v.%d [%s]", (Object[])new Object[]{database.getName(), this.rid.toString(), this.record.getVersion(), this.record});
        }
        return this.record.getVersion();
    }

    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.WRITE;
    }

    public ORemoteTask getFixTask(ODistributedRequest iRequest, ORemoteTask iOriginalTask, Object iBadResponse, Object iGoodResponse, String executorNodeName, ODistributedServerManager dManager) {
        if (iGoodResponse instanceof Integer) {
            int versionCopy = ORecordVersionHelper.setRollbackMode((int)((Integer)iGoodResponse));
            return new OFixUpdateRecordTask(this.rid, this.content, versionCopy, this.recordType);
        }
        if (iGoodResponse instanceof ORecord) {
            ORecord goodRecord = (ORecord)iGoodResponse;
            int versionCopy = ORecordVersionHelper.setRollbackMode((int)goodRecord.getVersion());
            return new OFixUpdateRecordTask(this.rid, goodRecord.toStream(), versionCopy, this.recordType);
        }
        return null;
    }

    public ORemoteTask getUndoTask(ODistributedRequestId reqId) {
        if (this.previousRecord == null) {
            return null;
        }
        int versionCopy = ORecordVersionHelper.setRollbackMode((int)this.previousRecord.getVersion());
        OFixUpdateRecordTask task = new OFixUpdateRecordTask(this.rid, this.previousRecord.toStream(), versionCopy, this.recordType);
        task.setLockRecords(false);
        return task;
    }

    public void toStream(DataOutput out) throws IOException {
        super.toStream(out);
        out.writeInt(this.content.length);
        out.write(this.content);
        out.writeByte(this.recordType);
    }

    public void fromStream(DataInput in, ORemoteTaskFactory factory) throws IOException {
        super.fromStream(in, factory);
        int contentSize = in.readInt();
        this.content = new byte[contentSize];
        in.readFully(this.content);
        this.recordType = in.readByte();
    }

    public String getName() {
        return "record_update";
    }

    public String toString() {
        if (ORecordVersionHelper.isTemporary((int)this.version)) {
            return this.getName() + "(" + this.rid + " v." + (this.version - Integer.MIN_VALUE) + " realV." + this.version + ")";
        }
        return super.toString();
    }

    public byte[] getContent() {
        return this.content;
    }

    public int getFactoryId() {
        return 3;
    }

    public ORecord prepareUndoOperation() {
        if (this.previousRecord == null) {
            OStorageOperationResult loaded = ODatabaseRecordThreadLocal.INSTANCE.get().getStorage().getUnderlying().readRecord(this.rid, null, true, false, null);
            if (loaded == null || loaded.getResult() == null) {
                return null;
            }
            this.previousRecordContent = ((ORawBuffer)loaded.getResult()).buffer;
            this.previousRecord = Orient.instance().getRecordFactoryManager().newInstance(((ORawBuffer)loaded.getResult()).recordType);
            ORecordInternal.fill((ORecord)this.previousRecord, (ORID)this.rid, (int)((ORawBuffer)loaded.getResult()).version, (byte[])((ORawBuffer)loaded.getResult()).getBuffer(), (boolean)false);
        }
        return this.previousRecord;
    }
}

