/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.sql;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.parser.OHaStatusStatement;
import com.orientechnologies.orient.core.sql.parser.OStatementCache;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.impl.ODistributedOutput;
import com.orientechnologies.orient.server.hazelcast.OHazelcastPlugin;
import java.util.Map;

public class OCommandExecutorSQLHAStatus
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest {
    public static final String NAME = "HA STATUS";
    public static final String KEYWORD_HA = "HA";
    public static final String KEYWORD_STATUS = "STATUS";
    OHaStatusStatement parsedStatement;

    public OCommandExecutorSQLHAStatus parse(OCommandRequest iRequest) {
        this.init((OCommandRequestText)iRequest);
        try {
            this.parsedStatement = (OHaStatusStatement)OStatementCache.get((String)this.parserText, (ODatabaseDocumentInternal)OCommandExecutorSQLHAStatus.getDatabase());
            this.preParsedStatement = this.parsedStatement;
        }
        catch (OCommandSQLParsingException sqlx) {
            throw sqlx;
        }
        catch (Exception e) {
            this.throwParsingException("Error parsing query: \n" + this.parserText + "\n" + e.getMessage(), e);
        }
        return this;
    }

    public Object execute(Map<Object, Object> iArgs) {
        ODatabaseDocumentInternal database = OCommandExecutorSQLHAStatus.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SERVER, "status", ORole.PERMISSION_READ);
        String dbUrl = database.getURL();
        String path = dbUrl.substring(dbUrl.indexOf(":") + 1);
        OServer serverInstance = OServer.getInstanceByPath((String)path);
        OHazelcastPlugin dManager = (OHazelcastPlugin)serverInstance.getDistributedManager();
        if (dManager == null || !dManager.isEnabled()) {
            throw new OCommandExecutionException("OrientDB is not started in distributed mode");
        }
        String databaseName = database.getName();
        ODistributedConfiguration cfg = dManager.getDatabaseConfiguration(databaseName);
        if (this.parsedStatement.outputText) {
            StringBuilder output = new StringBuilder();
            if (this.parsedStatement.servers) {
                output.append(ODistributedOutput.formatServerStatus(dManager, dManager.getClusterConfiguration()));
            }
            if (this.parsedStatement.db) {
                output.append(ODistributedOutput.formatClusterTable(dManager, databaseName, cfg, dManager.getAvailableNodes(databaseName)));
            }
            if (this.parsedStatement.latency) {
                output.append(ODistributedOutput.formatLatency(dManager, dManager.getClusterConfiguration()));
            }
            if (this.parsedStatement.messages) {
                output.append(ODistributedOutput.formatMessages(dManager, dManager.getClusterConfiguration()));
            }
            return output.toString();
        }
        ODocument output = new ODocument();
        if (this.parsedStatement.servers) {
            output.field("servers", (Object)dManager.getClusterConfiguration(), new OType[]{OType.EMBEDDED});
        }
        if (this.parsedStatement.db) {
            output.field("database", (Object)cfg.getDocument(), new OType[]{OType.EMBEDDED});
        }
        return output;
    }

    public OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE.LOCAL;
    }

    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.NONE;
    }

    public String getSyntax() {
        return "HA STATUS [-servers] [-db] [-latency] [-messages] [-all] [-output=text]";
    }
}

