/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.orientechnologies.common.concur.lock.OModificationOperationProhibitedException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.cache.OCommandCacheSoftRefs;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.db.OrientDBEmbedded;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.OServerAware;
import com.orientechnologies.orient.server.distributed.impl.ODistributedStorage;
import com.orientechnologies.orient.server.hazelcast.OHazelcastPlugin;
import java.io.InputStream;
import java.util.HashMap;

public class OrientDBDistributed
extends OrientDBEmbedded
implements OServerAware {
    private OServer server;
    private volatile OHazelcastPlugin plugin;

    public OrientDBDistributed(String directoryPath, OrientDBConfig config, Orient instance) {
        super(directoryPath, config, instance);
    }

    public void init(OServer server) {
        this.server = server;
    }

    public synchronized OHazelcastPlugin getPlugin() {
        if (this.plugin == null && this.server != null && this.server.isActive()) {
            this.plugin = (OHazelcastPlugin)this.server.getPlugin("cluster");
        }
        return this.plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OStorage fullSync(String dbName, InputStream backupStream, OrientDBConfig config) {
        OAbstractPaginatedStorage storage = null;
        OrientDBDistributed orientDBDistributed = this;
        synchronized (orientDBDistributed) {
            try {
                storage = (OAbstractPaginatedStorage)this.storages.get(dbName);
                if (storage != null) {
                    OCommandCacheSoftRefs.clearFiles((OAbstractPaginatedStorage)storage);
                    ODistributedStorage.dropStorageFiles(storage);
                    storage.delete();
                    this.storages.remove(dbName);
                }
                int storageId = this.generateStorageId();
                storage = (OAbstractPaginatedStorage)this.disk.createStorage(this.buildName(dbName), new HashMap(), this.maxWALSegmentSize, storageId);
                this.internalCreate(config, storage);
                this.storages.put(dbName, storage);
            }
            catch (OModificationOperationProhibitedException e) {
                throw e;
            }
            catch (Exception e) {
                if (storage != null) {
                    storage.delete();
                }
                throw OException.wrapException((OException)new ODatabaseException("Cannot restore database '" + dbName + "'"), (Throwable)e);
            }
        }
        try {
            storage.restoreFullIncrementalBackup(backupStream);
        }
        catch (RuntimeException e) {
            storage.delete();
            throw e;
        }
        ODatabaseRecordThreadLocal.instance().remove();
        return storage;
    }
}

