/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabasePoolInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.server.distributed.impl.ODatabaseDocumentDistributed;
import com.orientechnologies.orient.server.hazelcast.OHazelcastPlugin;

public class ODatabaseDocumentDistributedPooled
extends ODatabaseDocumentDistributed {
    private ODatabasePoolInternal pool;

    public ODatabaseDocumentDistributedPooled(ODatabasePoolInternal pool, OStorage storage, OHazelcastPlugin hazelcastPlugin) {
        super(storage, hazelcastPlugin);
        this.pool = pool;
    }

    public void close() {
        if (this.isClosed()) {
            return;
        }
        this.internalClose(true);
        this.pool.release((ODatabaseDocumentInternal)this);
    }

    @Override
    public ODatabaseDocumentInternal copy() {
        return (ODatabaseDocumentInternal)this.pool.acquire();
    }

    public void reuse() {
        this.activateOnCurrentThread();
        this.setStatus(ODatabase.STATUS.OPEN);
    }

    public void realClose() {
        ODatabaseDocumentInternal old = ODatabaseRecordThreadLocal.instance().getIfDefined();
        try {
            this.activateOnCurrentThread();
            super.close();
        }
        finally {
            if (old == null) {
                ODatabaseRecordThreadLocal.instance().remove();
            } else {
                ODatabaseRecordThreadLocal.instance().set(old);
            }
        }
    }
}

