/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ODistributedTxContext;
import com.orientechnologies.orient.server.distributed.impl.ODistributedStorageEventListener;
import com.orientechnologies.orient.server.distributed.task.ODistributedRecordLockedException;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class ODistributedTransactionManager {
    public static void acquireMultipleRecordLocks(Object iThis, ODistributedServerManager dManager, List<ORecordId> recordsToLock, ODistributedStorageEventListener eventListener, ODistributedTxContext reqContext, long timeout) throws InterruptedException {
        Collections.sort(recordsToLock);
        ORecordId lastRecordCannotLock = null;
        ODistributedRequestId lastLockHolder = null;
        long begin = System.currentTimeMillis();
        int maxAutoRetry = OGlobalConfiguration.DISTRIBUTED_CONCURRENT_TX_MAX_AUTORETRY.getValueAsInteger();
        int autoRetryDelay = OGlobalConfiguration.DISTRIBUTED_CONCURRENT_TX_AUTORETRY_DELAY.getValueAsInteger();
        for (int retry = 1; retry <= maxAutoRetry; ++retry) {
            lastRecordCannotLock = null;
            lastLockHolder = null;
            for (ORecordId rid : recordsToLock) {
                try {
                    reqContext.lock((ORID)rid, timeout);
                }
                catch (ODistributedRecordLockedException e) {
                    lastRecordCannotLock = rid;
                    lastLockHolder = e.getLockHolder();
                    reqContext.unlock();
                    if (autoRetryDelay > -1 && retry + 1 <= maxAutoRetry) {
                        Thread.sleep(autoRetryDelay / 2 + new Random().nextInt(autoRetryDelay));
                    }
                    ODistributedServerLog.debug((Object)iThis, (String)dManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction: %s cannot lock records %s because owned by %s (retry %d/%d, thread=%d)", (Object[])new Object[]{reqContext.getReqId(), recordsToLock, lastLockHolder, retry, maxAutoRetry, Thread.currentThread().getId()});
                    break;
                }
            }
            if (lastRecordCannotLock != null) continue;
            if (eventListener == null) break;
            for (ORecordId rid : recordsToLock) {
                try {
                    eventListener.onAfterRecordLock(rid);
                }
                catch (Exception t) {
                    ODistributedServerLog.error((Object)iThis, (String)dManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Caught exception during ODistributedStorageEventListener.onAfterRecordLock", (Throwable)t, (Object[])new Object[0]);
                }
            }
            break;
        }
        if (lastRecordCannotLock != null) {
            throw new ODistributedRecordLockedException(dManager.getLocalNodeName(), lastRecordCannotLock, lastLockHolder, System.currentTimeMillis() - begin);
        }
    }
}

