/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class OExecuteOnce {
    private final CountDownLatch start;
    private final ORemoteTask toRun;
    private volatile boolean toExecute = true;
    private volatile Object result;
    private volatile boolean finished = false;

    public OExecuteOnce(CountDownLatch start, ORemoteTask toRun) {
        this.start = start;
        this.toRun = toRun;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(ODistributedRequestId requestId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        OExecuteOnce oExecuteOnce;
        this.start.countDown();
        while (!this.start.await(1L, TimeUnit.SECONDS)) {
            oExecuteOnce = this;
            synchronized (oExecuteOnce) {
                if (this.finished) {
                    return false;
                }
            }
        }
        oExecuteOnce = this;
        synchronized (oExecuteOnce) {
            if (this.toExecute) {
                this.toExecute = false;
                this.result = this.toRun.execute(requestId, iServer, iManager, database);
                return true;
            }
        }
        return false;
    }

    public Object getResult() {
        return this.result;
    }

    public ORemoteTask getToRun() {
        return this.toRun;
    }

    public synchronized void finished() {
        this.finished = true;
        this.toRun.finished();
    }
}

