/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ODistributedTxContext;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.task.OAbstractReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class OClusterRepairInfoTask
extends OAbstractReplicatedTask {
    private static final long serialVersionUID = 1L;
    public static final int FACTORYID = 19;
    private int clusterId;

    public OClusterRepairInfoTask() {
    }

    public OClusterRepairInfoTask(int clusterId) {
        this.clusterId = clusterId;
    }

    public Object execute(ODistributedRequestId requestId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        String clusterName = database.getClusterNameById(this.clusterId);
        ODistributedServerLog.debug((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Repair cluster acquiring information about cluster '%s' db=%s (reqId=%s)...", (Object[])new Object[]{clusterName, database.getName(), requestId});
        ODatabaseRecordThreadLocal.instance().set(database);
        ODistributedDatabase ddb = iManager.getMessageService().getDatabase(database.getName());
        ODistributedTxContext reqContext = ddb.registerTxContext(requestId);
        reqContext.lock((ORID)new ORecordId(this.clusterId, -1L), OGlobalConfiguration.DISTRIBUTED_ATOMIC_LOCK_TIMEOUT.getValueAsLong() * 3L);
        long nextPosition = database.getStorage().getUnderlying().getClusterNextPosition(this.clusterId);
        return nextPosition - 1L;
    }

    public void toStream(DataOutput out) throws IOException {
        out.writeInt(this.clusterId);
    }

    public void fromStream(DataInput in, ORemoteTaskFactory factory) throws IOException {
        this.clusterId = in.readInt();
    }

    public long getDistributedTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_ATOMIC_LOCK_TIMEOUT.getValueAsLong() * 6L;
    }

    public String getName() {
        return "repair_cluster_info";
    }

    public ORemoteTask.RESULT_STRATEGY getResultStrategy() {
        return ORemoteTask.RESULT_STRATEGY.UNION;
    }

    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.ALL;
    }

    public int getFactoryId() {
        return 19;
    }

    public boolean isIdempotent() {
        return false;
    }

    public int getClusterId() {
        return this.clusterId;
    }
}

