/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ORestartServerTask
extends OAbstractRemoteTask {
    private static final long serialVersionUID = 1L;
    public static final int FACTORYID = 10;

    public Object execute(ODistributedRequestId requestId, final OServer iServer, final ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        ODistributedServerLog.warn((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Restarting server...", (Object[])new Object[0]);
        iManager.setNodeStatus(ODistributedServerManager.NODE_STATUS.OFFLINE);
        Orient.instance().scheduleTask(new Runnable(){

            @Override
            public void run() {
                try {
                    iServer.restart();
                }
                catch (Exception e) {
                    ODistributedServerLog.error((Object)this, (String)iManager.getLocalNodeName(), (String)ORestartServerTask.this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Error on restarting server", (Throwable)e, (Object[])new Object[0]);
                }
            }
        }, 1L, 0L);
        return true;
    }

    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.NONE;
    }

    public String getName() {
        return "restart_server";
    }

    public void toStream(DataOutput out) throws IOException {
    }

    public void fromStream(DataInput in, ORemoteTaskFactory factory) throws IOException {
    }

    public int getFactoryId() {
        return 10;
    }

    public boolean isUsingDatabase() {
        return false;
    }
}

