/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.command.script.OCommandScript;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.serialization.OStreamableHelper;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.task.OAbstractCommandTask;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;

public class OScriptTask
extends OAbstractCommandTask {
    private static final long serialVersionUID = 1L;
    public static final int FACTORYID = 6;
    protected String text;
    protected Map<Object, Object> params;
    protected ORemoteTask.RESULT_STRATEGY resultStrategy;

    public OScriptTask() {
    }

    public OScriptTask(OCommandRequestText iCommand) {
        this.text = iCommand.getText();
        this.params = iCommand.getParameters();
    }

    public Object execute(ODistributedRequestId requestId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        ODistributedServerLog.debug((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"execute command=%s db=%s", (Object[])new Object[]{this.text.toString(), database.getName()});
        OCommandRequest cmd = database.command((OCommandRequest)new OCommandScript(this.text));
        Object res = this.params != null ? cmd.execute(new Object[]{this.params}) : cmd.execute(new Object[0]);
        return res;
    }

    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.WRITE;
    }

    public ORemoteTask.RESULT_STRATEGY getResultStrategy() {
        return this.resultStrategy;
    }

    public void setResultStrategy(ORemoteTask.RESULT_STRATEGY resultStrategy) {
        this.resultStrategy = resultStrategy;
    }

    public long getDistributedTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_COMMAND_TASK_SYNCH_TIMEOUT.getValueAsLong();
    }

    public void toStream(DataOutput out) throws IOException {
        out.writeUTF(this.text);
        OStreamableHelper.toStream((DataOutput)out, this.params);
    }

    public void fromStream(DataInput in, ORemoteTaskFactory factory) throws IOException {
        this.text = in.readUTF();
        this.params = (Map)OStreamableHelper.fromStream((DataInput)in);
    }

    public String getName() {
        return "script";
    }

    public String toString() {
        return super.toString() + "(" + this.text + ")";
    }

    public int getFactoryId() {
        return 6;
    }
}

