/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.disk.OLocalPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.OBackgroundDelta;
import com.orientechnologies.orient.core.storage.impl.local.OSyncSource;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedMomentum;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.impl.ODistributedDatabaseChunk;
import com.orientechnologies.orient.server.distributed.impl.ODistributedStorage;
import com.orientechnologies.orient.server.distributed.impl.task.OAbstractSyncDatabaseTask;
import com.orientechnologies.orient.server.distributed.task.ODistributedDatabaseDeltaSyncException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class OSyncDatabaseDeltaTask
extends OAbstractSyncDatabaseTask {
    public static final int FACTORYID = 13;
    protected Set<String> includeClusterNames = new HashSet<String>();

    public OSyncDatabaseDeltaTask() {
    }

    public OSyncDatabaseDeltaTask(OLogSequenceNumber iFirstLSN, long lastOperationTimestamp) {
        super(lastOperationTimestamp);
        this.lastLSN = iFirstLSN;
    }

    public Object execute(ODistributedRequestId requestId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        if (!this.getNodeSource().equals(iManager.getLocalNodeName())) {
            if (database == null) {
                throw new ODistributedException("Database instance is null");
            }
            String databaseName = database.getName();
            Object chunk = this.deltaBackup(requestId, iManager, database, databaseName);
            if (chunk != null) {
                return chunk;
            }
        } else {
            ODistributedServerLog.debug((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Skip deploying database from the same node", (Object[])new Object[0]);
        }
        return Boolean.FALSE;
    }

    public void includeClusterName(String name) {
        this.includeClusterNames.add(name);
    }

    protected Object deltaBackup(ODistributedRequestId requestId, final ODistributedServerManager iManager, ODatabaseDocumentInternal database, String databaseName) throws IOException, InterruptedException {
        Long lastDeployment = (Long)iManager.getConfigurationMap().get("deploydb." + databaseName);
        if (lastDeployment != null && lastDeployment == this.random) {
            ODistributedServerLog.debug((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Skip deploying of delta database '%s' because already executed", (Object[])new Object[]{databaseName});
            return Boolean.FALSE;
        }
        iManager.getConfigurationMap().put("deploydb." + databaseName, this.random);
        ODistributedDatabase dDatabase = this.checkIfCurrentDatabaseIsNotOlder(iManager, databaseName, database);
        iManager.setDatabaseStatus(this.getNodeSource(), databaseName, ODistributedServerManager.DB_STATUS.SYNCHRONIZING);
        ODistributedServerLog.info((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Deploying database '%s' with delta of changes...", (Object[])new Object[]{databaseName});
        File backupFile = new File(Orient.getTempPath() + "/backup_" + this.getNodeSource() + "_" + database.getName() + "_server" + iManager.getLocalNodeId() + ".zip");
        ODistributedServerLog.info((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Creating delta backup of database '%s' (startLSN=%s) in directory: %s...", (Object[])new Object[]{databaseName, this.lastLSN, backupFile.getAbsolutePath()});
        if (backupFile.exists()) {
            backupFile.delete();
        } else {
            backupFile.getParentFile().mkdirs();
        }
        backupFile.createNewFile();
        OStorage storage = database.getStorage().getUnderlying();
        if (!(storage instanceof OAbstractPaginatedStorage)) {
            throw new UnsupportedOperationException("Storage '" + storage.getName() + "' does not support distributed delta backup");
        }
        try {
            final AtomicLong counter = new AtomicLong(0L);
            OBackgroundDelta delta = ((OAbstractPaginatedStorage)storage).recordsChangedAfterLSN(this.lastLSN, new OCommandOutputListener(){

                public void onMessage(String iText) {
                    if (iText.startsWith("read")) {
                        if (counter.incrementAndGet() % 100000L == 0L) {
                            ODistributedServerLog.info((Object)this, (String)iManager.getLocalNodeName(), (String)OSyncDatabaseDeltaTask.this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"- %s", (Object[])new Object[]{iText});
                        }
                    } else if (counter.incrementAndGet() % 10000L == 0L) {
                        ODistributedServerLog.info((Object)this, (String)iManager.getLocalNodeName(), (String)OSyncDatabaseDeltaTask.this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"- %s", (Object[])new Object[]{iText});
                    }
                }
            });
            if (delta == null) {
                throw new ODistributedDatabaseDeltaSyncException(this.lastLSN);
            }
            if (delta.getEndLsn().equals((Object)this.lastLSN)) {
                return Boolean.FALSE;
            }
            ODistributedServerLog.info((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Delta backup of database '%s' completed. range=%s-%s", (Object[])new Object[]{databaseName, this.lastLSN, delta.getEndLsn()});
            ODistributedServerLog.info((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Deploy delta database task completed", (Object[])new Object[0]);
            ODistributedMomentum momentum = dDatabase.getSyncConfiguration().getMomentum().copy();
            momentum.setLSN(iManager.getLocalNodeName(), delta.getEndLsn());
            ODistributedDatabaseChunk chunk = new ODistributedDatabaseChunk((OSyncSource)delta, 0x800000, momentum);
            ODistributedServerLog.info((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"- transferring chunk #%d offset=%d size=%s...", (Object[])new Object[]{1, 0, OFileUtils.getSizeAsNumber((Object)chunk.buffer.length)});
            if (chunk.last) {
                iManager.setDatabaseStatus(iManager.getLocalNodeName(), databaseName, ODistributedServerManager.DB_STATUS.ONLINE);
            }
            ((ODistributedStorage)database.getStorage()).setLastValidBackup((OSyncSource)delta);
            return chunk;
        }
        catch (Exception e) {
            throw new ODistributedDatabaseDeltaSyncException(this.lastLSN, e.getMessage());
        }
    }

    protected ODistributedDatabase checkIfCurrentDatabaseIsNotOlder(ODistributedServerManager iManager, String databaseName, ODatabaseDocumentInternal database) {
        ODistributedDatabase dDatabase = iManager.getMessageService().getDatabase(databaseName);
        if (this.lastLSN != null) {
            OLogSequenceNumber currentLSN = ((OLocalPaginatedStorage)database.getStorage().getUnderlying()).getLSN();
            if (currentLSN != null) {
                if (this.lastLSN.compareTo(currentLSN) <= 0) {
                    return dDatabase;
                }
                throw new ODistributedDatabaseDeltaSyncException(this.lastLSN);
            }
        } else if (this.lastOperationTimestamp > -1L) {
            if (this.lastOperationTimestamp <= dDatabase.getSyncConfiguration().getLastOperationTimestamp()) {
                return dDatabase;
            }
        } else {
            return dDatabase;
        }
        return this.databaseIsOld(iManager, databaseName, dDatabase);
    }

    public String getName() {
        return "deploy_delta_db";
    }

    public void toStream(DataOutput out) throws IOException {
        this.lastLSN.toStream(out);
        out.writeLong(this.lastOperationTimestamp);
        out.writeLong(this.random);
        out.writeInt(this.includeClusterNames.size());
        for (String clName : this.includeClusterNames) {
            out.writeUTF(clName);
        }
    }

    public void fromStream(DataInput in, ORemoteTaskFactory factory) throws IOException {
        this.lastLSN = new OLogSequenceNumber(in);
        this.lastOperationTimestamp = in.readLong();
        this.random = in.readLong();
        this.includeClusterNames.clear();
        int total = in.readInt();
        for (int i = 0; i < total; ++i) {
            this.includeClusterNames.add(in.readUTF());
        }
    }

    public int getFactoryId() {
        return 13;
    }
}

