/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.orient.client.remote.message.OMessageHelper;
import com.orientechnologies.orient.client.remote.message.tx.ORecordOperationRequest;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.OConcurrentCreateException;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerNetworkDistributed;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionInternal;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.impl.ODatabaseDocumentDistributed;
import com.orientechnologies.orient.server.distributed.impl.ODistributedWorker;
import com.orientechnologies.orient.server.distributed.impl.OTransactionOptimisticDistributed;
import com.orientechnologies.orient.server.distributed.impl.task.OTransactionPhase1TaskResult;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTransactionResultPayload;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxConcurrentCreation;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxConcurrentModification;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxException;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxKeyLockTimeout;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxRecordLockTimeout;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxStillRunning;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxSuccess;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxUniqueIndex;
import com.orientechnologies.orient.server.distributed.task.OAbstractReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.ODistributedKeyLockedException;
import com.orientechnologies.orient.server.distributed.task.ODistributedRecordLockedException;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;

public class OTransactionPhase1Task
extends OAbstractReplicatedTask {
    public static final int FACTORYID = 43;
    private volatile boolean hasResponse;
    private OLogSequenceNumber lastLSN;
    private List<ORecordOperation> ops;
    private List<ORecordOperationRequest> operations;
    private OCommandDistributedReplicateRequest.QUORUM_TYPE quorumType = OCommandDistributedReplicateRequest.QUORUM_TYPE.WRITE;
    private transient int retryCount = 0;
    private volatile boolean finished;
    private TimerTask notYetFinishedTask;

    public OTransactionPhase1Task() {
        this.ops = new ArrayList<ORecordOperation>();
        this.operations = new ArrayList<ORecordOperationRequest>();
    }

    public OTransactionPhase1Task(List<ORecordOperation> ops) {
        this.ops = ops;
        this.operations = new ArrayList<ORecordOperationRequest>();
        this.genOps(ops);
    }

    public void genOps(List<ORecordOperation> ops) {
        for (ORecordOperation txEntry : ops) {
            if (txEntry.type == 0) continue;
            ORecordOperationRequest request = new ORecordOperationRequest();
            request.setType(txEntry.type);
            request.setVersion(txEntry.getRecord().getVersion());
            request.setId(txEntry.getRecord().getIdentity());
            request.setRecordType(ORecordInternal.getRecordType((ORecord)txEntry.getRecord()));
            switch (txEntry.type) {
                case 1: 
                case 3: {
                    request.setRecord(ORecordSerializerNetworkDistributed.INSTANCE.toStream(txEntry.getRecord(), false));
                    request.setContentChanged(ORecordInternal.isContentChanged((ORecord)txEntry.getRecord()));
                    break;
                }
            }
            this.operations.add(request);
        }
    }

    public String getName() {
        return "TxPhase1";
    }

    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return this.quorumType;
    }

    public Object execute(ODistributedRequestId requestId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        OTransactionResultPayload res1;
        if (iManager != null) {
            iManager.messageBeforeOp("prepare1Phase", requestId);
        }
        this.convert(database);
        if (iManager != null) {
            iManager.messageAfterOp("prepare1Phase", requestId);
        }
        OTransactionOptimisticDistributed tx = new OTransactionOptimisticDistributed(database, this.ops);
        try {
            res1 = OTransactionPhase1Task.executeTransaction(requestId, (ODatabaseDocumentDistributed)database, (OTransactionInternal)tx, false, this.retryCount);
        }
        catch (Exception e) {
            this.finished = true;
            if (this.notYetFinishedTask != null) {
                this.notYetFinishedTask.cancel();
            }
            throw e;
        }
        if (res1 == null) {
            int autoRetryDelay = OGlobalConfiguration.DISTRIBUTED_CONCURRENT_TX_AUTORETRY_DELAY.getValueAsInteger();
            ++this.retryCount;
            ((ODatabaseDocumentDistributed)database).getStorageDistributed().getLocalDistributedDatabase().reEnqueue(requestId.getNodeId(), requestId.getMessageId(), database.getName(), (ORemoteTask)this, this.retryCount, autoRetryDelay);
            this.hasResponse = false;
            return null;
        }
        this.hasResponse = true;
        this.finished = true;
        if (this.notYetFinishedTask != null) {
            this.notYetFinishedTask.cancel();
        }
        return new OTransactionPhase1TaskResult(res1);
    }

    public boolean hasResponse() {
        return this.hasResponse;
    }

    public static OTransactionResultPayload executeTransaction(ODistributedRequestId requestId, ODatabaseDocumentDistributed database, OTransactionInternal tx, boolean local, int retryCount) {
        OTransactionResultPayload payload;
        try {
            if (!database.beginDistributedTx(requestId, tx, local, retryCount)) {
                return null;
            }
            payload = new OTxSuccess();
        }
        catch (OConcurrentModificationException ex) {
            payload = new OTxConcurrentModification((ORecordId)ex.getRid(), ex.getEnhancedDatabaseVersion());
        }
        catch (ODistributedRecordLockedException ex) {
            payload = new OTxRecordLockTimeout(ex.getNode(), ex.getRid());
        }
        catch (ODistributedKeyLockedException ex) {
            payload = new OTxKeyLockTimeout(ex.getNode(), ex.getKey());
        }
        catch (ORecordDuplicatedException ex) {
            payload = new OTxUniqueIndex((ORecordId)ex.getRid(), ex.getIndexName(), ex.getKey());
        }
        catch (OConcurrentCreateException ex) {
            payload = new OTxConcurrentCreation(ex.getActualRid(), ex.getExpectedRid());
        }
        catch (RuntimeException ex) {
            payload = new OTxException(ex);
        }
        return payload;
    }

    public void fromStream(DataInput in, ORemoteTaskFactory factory) throws IOException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            ORecordOperationRequest req = OMessageHelper.readTransactionEntry((DataInput)in);
            this.operations.add(req);
        }
        this.lastLSN = new OLogSequenceNumber(in);
        if (this.lastLSN.getSegment() == -1L && this.lastLSN.getSegment() == -1L) {
            this.lastLSN = null;
        }
    }

    private void convert(ODatabaseDocumentInternal database) {
        for (ORecordOperationRequest req : this.operations) {
            byte type = req.getType();
            if (type == 0) continue;
            ORecord record = null;
            switch (type) {
                case 1: 
                case 3: {
                    record = ORecordSerializerNetworkDistributed.INSTANCE.fromStream(req.getRecord(), null, null);
                    ORecordInternal.setRecordSerializer((ORecord)record, (ORecordSerializer)database.getSerializer());
                    break;
                }
                case 2: {
                    record = database.getRecord((OIdentifiable)req.getId());
                    if (record != null) break;
                    record = Orient.instance().getRecordFactoryManager().newInstance(req.getRecordType(), req.getId().getClusterId(), database);
                }
            }
            ORecordInternal.setIdentity((ORecord)record, (ORecordId)((ORecordId)req.getId()));
            ORecordInternal.setVersion((ORecord)record, (int)req.getVersion());
            ORecordOperation op = new ORecordOperation((OIdentifiable)record, type);
            this.ops.add(op);
        }
        this.operations.clear();
    }

    public void toStream(DataOutput out) throws IOException {
        out.writeInt(this.operations.size());
        for (ORecordOperationRequest operation : this.operations) {
            OMessageHelper.writeTransactionEntry((DataOutput)out, (ORecordOperationRequest)operation);
        }
        if (this.lastLSN == null) {
            new OLogSequenceNumber(-1L, -1L).toStream(out);
        } else {
            this.lastLSN.toStream(out);
        }
    }

    public int getFactoryId() {
        return 43;
    }

    public void init(OTransactionInternal operations) {
        for (Map.Entry indexOp : operations.getIndexOperations().entrySet()) {
            if (!((OTransactionIndexChanges)indexOp.getValue()).resolveAssociatedIndex((String)indexOp.getKey(), operations.getDatabase().getMetadata().getIndexManager()).isUnique()) continue;
            this.quorumType = OCommandDistributedReplicateRequest.QUORUM_TYPE.WRITE_ALL_MASTERS;
            break;
        }
        this.ops = new ArrayList<ORecordOperation>(operations.getRecordOperations());
        this.genOps(this.ops);
    }

    public void setLastLSN(OLogSequenceNumber lastLSN) {
        this.lastLSN = lastLSN;
    }

    public OLogSequenceNumber getLastLSN() {
        return this.lastLSN;
    }

    public boolean isIdempotent() {
        return false;
    }

    public int[] getPartitionKey() {
        if (this.operations.size() > 0) {
            return this.operations.stream().mapToInt(x -> x.getId().getClusterId()).toArray();
        }
        return this.ops.stream().mapToInt(x -> x.getRID().getClusterId()).toArray();
    }

    public long getDistributedTimeout() {
        return super.getDistributedTimeout() + (long)(this.operations.size() / 10);
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public List<ORecordOperationRequest> getOperations() {
        return this.operations;
    }

    public List<ORecordOperation> getOps() {
        return this.ops;
    }

    public void received(final ODistributedRequest request, final ODistributedDatabase distributedDatabase) {
        if (this.notYetFinishedTask == null) {
            this.notYetFinishedTask = Orient.instance().scheduleTask(new Runnable(){

                @Override
                public void run() {
                    Orient.instance().submit(() -> {
                        if (!OTransactionPhase1Task.this.finished) {
                            ODistributedWorker.sendResponseBack(this, distributedDatabase.getManager(), request, new OTransactionPhase1TaskResult(new OTxStillRunning()));
                        }
                    });
                }
            }, this.getDistributedTimeout(), this.getDistributedTimeout());
        }
    }

    public void finished() {
        if (this.notYetFinishedTask != null) {
            this.notYetFinishedTask.cancel();
        }
    }
}

