/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.orientechnologies.common.concur.OOfflineNodeException;
import com.orientechnologies.common.concur.lock.OModificationOperationProhibitedException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentEmbeddedPooled;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.ODatabaseLifecycleListener;
import com.orientechnologies.orient.core.db.ODatabasePoolInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OSharedContext;
import com.orientechnologies.orient.core.db.OSharedContextEmbedded;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.db.OrientDBEmbedded;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentEmbedded;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.disk.OLocalPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinary;
import com.orientechnologies.orient.server.OClientConnection;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.OServerAware;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.impl.ODatabaseDocumentDistributed;
import com.orientechnologies.orient.server.distributed.impl.ODatabaseDocumentDistributedPooled;
import com.orientechnologies.orient.server.distributed.impl.ODistributedPlugin;
import com.orientechnologies.orient.server.distributed.impl.metadata.OSharedContextDistributed;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;

public class OrientDBDistributed
extends OrientDBEmbedded
implements OServerAware {
    private volatile OServer server;
    private volatile ODistributedPlugin plugin;

    public OrientDBDistributed(String directoryPath, OrientDBConfig config, Orient instance) {
        super(directoryPath, config, instance);
    }

    public void init(OServer server) {
        this.server = server;
    }

    public synchronized ODistributedPlugin getPlugin() {
        if (this.plugin == null && this.server != null && this.server.isActive()) {
            this.plugin = (ODistributedPlugin)this.server.getPlugin("cluster");
        }
        return this.plugin;
    }

    protected OSharedContext createSharedContext(OAbstractPaginatedStorage storage) {
        if ("OSystem".equals(storage.getName()) || this.plugin == null || !this.plugin.isEnabled()) {
            return new OSharedContextEmbedded((OStorage)storage, (OrientDBEmbedded)this);
        }
        return new OSharedContextDistributed((OStorage)storage, this);
    }

    protected ODatabaseDocumentEmbedded newSessionInstance(OAbstractPaginatedStorage storage) {
        if ("OSystem".equals(storage.getName()) || this.plugin == null || !this.plugin.isEnabled()) {
            return new ODatabaseDocumentEmbedded((OStorage)storage);
        }
        this.plugin.registerNewDatabaseIfNeeded(storage.getName());
        return new ODatabaseDocumentDistributed((OStorage)storage, this.plugin);
    }

    protected ODatabaseDocumentEmbedded newPooledSessionInstance(ODatabasePoolInternal pool, OAbstractPaginatedStorage storage) {
        if ("OSystem".equals(storage.getName()) || this.plugin == null || !this.plugin.isEnabled()) {
            return new ODatabaseDocumentEmbeddedPooled(pool, (OStorage)storage);
        }
        this.plugin.registerNewDatabaseIfNeeded(storage.getName());
        return new ODatabaseDocumentDistributedPooled(pool, (OStorage)storage, this.plugin);
    }

    public void setPlugin(ODistributedPlugin plugin) {
        this.plugin = plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OStorage fullSync(String dbName, InputStream backupStream, OrientDBConfig config) {
        ODatabaseDocumentEmbedded embedded;
        OAbstractPaginatedStorage storage = null;
        OrientDBDistributed orientDBDistributed = this;
        synchronized (orientDBDistributed) {
            try {
                storage = (OAbstractPaginatedStorage)this.storages.get(dbName);
                if (storage != null) {
                    ODatabaseDocumentEmbedded deleteInstance = this.newSessionInstance(storage);
                    deleteInstance.init(config, this.getOrCreateSharedContext(storage));
                    OrientDBDistributed.dropStorageFiles((OLocalPaginatedStorage)storage);
                    OSharedContext context = (OSharedContext)this.sharedContexts.remove(dbName);
                    context.close();
                    storage.delete();
                    this.storages.remove(dbName);
                    ODatabaseRecordThreadLocal.instance().remove();
                }
                storage = (OAbstractPaginatedStorage)this.disk.createStorage(this.buildName(dbName), new HashMap(), this.maxWALSegmentSize, this.doubleWriteLogMaxSegSize, this.generateStorageId());
                embedded = this.internalCreate(config, storage);
                this.storages.put(dbName, storage);
            }
            catch (OModificationOperationProhibitedException e) {
                throw e;
            }
            catch (Exception e) {
                if (storage != null) {
                    storage.delete();
                }
                throw OException.wrapException((OException)new ODatabaseException("Cannot restore database '" + dbName + "'"), (Throwable)e);
            }
        }
        try {
            storage.restoreFullIncrementalBackup(backupStream);
        }
        catch (RuntimeException e) {
            try {
                if (storage != null) {
                    storage.delete();
                }
            }
            catch (Exception e1) {
                OLogManager.instance().warn((Object)this, "Error doing cleanups, should be safe do progress anyway", (Throwable)e1, new Object[0]);
            }
            OrientDBDistributed e1 = this;
            synchronized (e1) {
                this.sharedContexts.remove(dbName);
                this.storages.remove(dbName);
            }
            OContextConfiguration configs = this.getConfigurations().getConfigurations();
            OLocalPaginatedStorage.deleteFilesFromDisc((String)dbName, (int)configs.getValueAsInteger(OGlobalConfiguration.FILE_DELETE_RETRY), (int)configs.getValueAsInteger(OGlobalConfiguration.FILE_DELETE_DELAY), (String)this.buildName(dbName));
            throw e;
        }
        embedded.getSharedContext().reInit(storage, (ODatabaseDocumentInternal)embedded);
        ODatabaseRecordThreadLocal.instance().remove();
        return storage;
    }

    public ODatabaseDocumentInternal poolOpen(String name, String user, String password, ODatabasePoolInternal pool) {
        ODatabaseDocumentInternal session = super.poolOpen(name, user, password, pool);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalDrop(String name) {
        OrientDBDistributed orientDBDistributed = this;
        synchronized (orientDBDistributed) {
            this.checkOpen();
            OSharedContext sharedContext = (OSharedContext)this.sharedContexts.get(name);
            if (sharedContext != null) {
                sharedContext.getViewManager().close();
            }
        }
        ODatabaseDocumentInternal current = ODatabaseRecordThreadLocal.instance().getIfDefined();
        try {
            ODatabaseDocumentEmbedded db = this.openNoAuthenticate(name, null);
            Iterator it = this.orient.getDbLifecycleListeners();
            while (it.hasNext()) {
                ((ODatabaseLifecycleListener)it.next()).onDrop((ODatabaseInternal)db);
            }
            db.close();
        }
        finally {
            ODatabaseRecordThreadLocal.instance().set(current);
        }
        OrientDBDistributed orientDBDistributed2 = this;
        synchronized (orientDBDistributed2) {
            if (this.exists(name, null, null)) {
                OAbstractPaginatedStorage storage = this.getOrInitStorage(name);
                OSharedContext sharedContext = (OSharedContext)this.sharedContexts.get(name);
                if (sharedContext != null) {
                    sharedContext.close();
                }
                if (storage instanceof OLocalPaginatedStorage) {
                    OrientDBDistributed.dropStorageFiles((OLocalPaginatedStorage)storage);
                }
                storage.delete();
                this.storages.remove(name);
                this.sharedContexts.remove(name);
            }
        }
    }

    public void drop(String name, String user, String password) {
        if (this.getPlugin() != null && this.getPlugin().isEnabled()) {
            this.plugin.executeInDistributedDatabaseLock(name, 20000L, null, cfg -> {
                this.plugin.dropOnAllServers(name);
                return null;
            });
            this.plugin.dropConfig(name);
        } else {
            super.drop(name, user, password);
        }
    }

    private boolean checkDbAvailable(String name) {
        if (this.getPlugin() == null || !this.getPlugin().isEnabled()) {
            return true;
        }
        if ("OSystem".equals(name)) {
            return true;
        }
        ODistributedServerManager.DB_STATUS dbStatus = this.plugin.getDatabaseStatus(this.plugin.getLocalNodeName(), name);
        return dbStatus == ODistributedServerManager.DB_STATUS.ONLINE || dbStatus == ODistributedServerManager.DB_STATUS.BACKUP;
    }

    public ODatabaseDocumentInternal open(String name, String user, String password) {
        if (this.checkDbAvailable(name)) {
            return super.open(name, user, password);
        }
        if (this.exists(name, user, password)) {
            super.open(name, user, password);
        }
        throw new OOfflineNodeException("database " + name + " not online on " + this.plugin.getLocalNodeName());
    }

    public ODatabaseDocumentInternal open(String name, String user, String password, OrientDBConfig config) {
        if (this.checkDbAvailable(name)) {
            return super.open(name, user, password, config);
        }
        if (this.exists(name, user, password)) {
            super.open(name, user, password, config);
        }
        throw new OOfflineNodeException("database " + name + " not online on " + this.plugin.getLocalNodeName());
    }

    public void coordinatedRequest(OClientConnection connection, int requestType, int clientTxId, OChannelBinary channel) throws IOException {
        throw new UnsupportedOperationException("old implementation do not support new flow");
    }

    public static void dropStorageFiles(OLocalPaginatedStorage storage) {
        File dCfg = new File(storage.getStoragePath() + "/" + "distributed-config.json");
        try {
            File dCfg2;
            if (dCfg.exists()) {
                for (int i = 0; i < 10 && !dCfg.delete(); ++i) {
                    Thread.sleep(100L);
                }
            }
            if ((dCfg2 = new File(storage.getStoragePath() + "/" + "distributed-sync.json")).exists()) {
                for (int i = 0; i < 10 && !dCfg2.delete(); ++i) {
                    Thread.sleep(100L);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public ODistributedServerManager getDistributedManager() {
        return this.plugin;
    }
}

