/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed;

import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.OModifiableDistributedConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;

public class ODistributedConfigurationManager {
    private final ODistributedServerManager distributedManager;
    private volatile ODistributedConfiguration distributedConfiguration;
    private final String databaseName;

    public ODistributedConfigurationManager(ODistributedServerManager distributedManager, String name) {
        this.distributedManager = distributedManager;
        this.databaseName = name;
    }

    public ODistributedConfiguration getDistributedConfiguration() {
        if (this.distributedConfiguration == null) {
            Map map = this.distributedManager.getConfigurationMap();
            if (map == null) {
                return null;
            }
            ODocument doc = (ODocument)map.get("database." + this.databaseName);
            if (doc != null) {
                ODistributedServerLog.info((Object)this, (String)this.distributedManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Downloaded configuration for database '%s' from the cluster", (Object[])new Object[]{this.databaseName});
                this.setDistributedConfiguration(new OModifiableDistributedConfiguration(doc));
            } else {
                doc = this.loadDatabaseConfiguration(this.getDistributedConfigFile());
                if (doc == null) {
                    doc = this.loadDatabaseConfiguration(this.distributedManager.getDefaultDatabaseConfigFile());
                    if (doc == null) {
                        throw new OConfigurationException("Cannot load default distributed for database '" + this.databaseName + "' config file: " + this.distributedManager.getDefaultDatabaseConfigFile());
                    }
                    this.setDistributedConfiguration(new OModifiableDistributedConfiguration(doc));
                } else {
                    this.distributedConfiguration = new ODistributedConfiguration(doc);
                }
                this.distributedManager.updateCachedDatabaseConfiguration(this.databaseName, new OModifiableDistributedConfiguration(doc), true);
            }
        }
        return this.distributedConfiguration;
    }

    public void setDistributedConfiguration(OModifiableDistributedConfiguration distributedConfiguration) {
        if (this.distributedConfiguration == null || distributedConfiguration.getVersion() > this.distributedConfiguration.getVersion()) {
            this.distributedConfiguration = new ODistributedConfiguration(distributedConfiguration.getDocument().copy());
            ODistributedServerLog.info((Object)this, (String)this.distributedManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Setting new distributed configuration for database: %s (version=%d)\n", (Object[])new Object[]{this.databaseName, distributedConfiguration.getVersion()});
            this.saveDatabaseConfiguration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODocument loadDatabaseConfiguration(File file) {
        if (!file.exists() || file.length() == 0L) {
            return null;
        }
        ODistributedServerLog.info((Object)this, (String)this.distributedManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Loaded configuration for database '%s' from disk: %s", (Object[])new Object[]{this.databaseName, file});
        FileInputStream f = null;
        try {
            f = new FileInputStream(file);
            byte[] buffer = new byte[(int)file.length()];
            f.read(buffer);
            ODocument doc = new ODocument().fromJSON(new String(buffer), "noMap");
            doc.field("version", (Object)1);
            ODocument oDocument = doc;
            return oDocument;
        }
        catch (Exception e) {
            ODistributedServerLog.error((Object)this, (String)this.distributedManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on loading distributed configuration file in: %s", (Throwable)e, (Object[])new Object[]{file.getAbsolutePath()});
        }
        finally {
            if (f != null) {
                try {
                    f.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public void saveDatabaseConfiguration() {
        FileOutputStream f = null;
        try {
            File file = this.getDistributedConfigFile();
            ODistributedServerLog.debug((Object)this, (String)this.distributedManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Saving distributed configuration file for database '%s' to: %s", (Object[])new Object[]{this.databaseName, file});
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            f = new FileOutputStream(file);
            f.write(this.distributedConfiguration.getDocument().toJSON().getBytes());
            f.flush();
        }
        catch (Exception e) {
            ODistributedServerLog.error((Object)this, (String)this.distributedManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on saving distributed configuration file", (Throwable)e, (Object[])new Object[0]);
        }
        finally {
            if (f != null) {
                try {
                    f.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected File getDistributedConfigFile() {
        return new File(this.distributedManager.getServerInstance().getDatabaseDirectory() + this.databaseName + "/" + "distributed-config.json");
    }
}

