/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed;

import com.orientechnologies.orient.server.distributed.ORemoteServerAvailabilityCheck;
import com.orientechnologies.orient.server.distributed.ORemoteServerController;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ORemoteServerManager {
    private final ConcurrentMap<String, ORemoteServerController> remoteServers = new ConcurrentHashMap<String, ORemoteServerController>();
    private final String localNodeName;
    private final ORemoteServerAvailabilityCheck check;

    public ORemoteServerManager(String localNodeName, ORemoteServerAvailabilityCheck check) {
        this.localNodeName = localNodeName;
        this.check = check;
    }

    public ORemoteServerController getRemoteServer(String rNodeName) {
        return (ORemoteServerController)this.remoteServers.get(rNodeName);
    }

    public ORemoteServerController connectRemoteServer(String rNodeName, String host, String user, String password) throws IOException {
        ORemoteServerController remoteServer = new ORemoteServerController(this.check, this.localNodeName, rNodeName, host, user, password);
        ORemoteServerController old = this.remoteServers.putIfAbsent(rNodeName, remoteServer);
        if (old != null) {
            remoteServer.close();
            remoteServer = old;
        }
        return remoteServer;
    }

    public void closeRemoteServer(String node) {
        ORemoteServerController c = (ORemoteServerController)this.remoteServers.remove(node);
        if (c != null) {
            c.close();
        }
    }

    public void closeAll() {
        for (ORemoteServerController server : this.remoteServers.values()) {
            server.close();
        }
        this.remoteServers.clear();
    }
}

