/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.orientechnologies.common.concur.OOfflineNodeException;
import com.orientechnologies.common.concur.lock.OInterruptedException;
import com.orientechnologies.common.concur.lock.OModificationOperationProhibitedException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.OScenarioThreadLocal;
import com.orientechnologies.orient.core.db.OSharedContext;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentEmbedded;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.enterprise.OEnterpriseEndpoint;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.OConcurrentCreateException;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OLowDiskSpaceException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.exception.OValidationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OImmutableSchema;
import com.orientechnologies.orient.core.metadata.schema.OView;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.metadata.sequence.OSequenceAction;
import com.orientechnologies.orient.core.query.live.OLiveQueryHook;
import com.orientechnologies.orient.core.query.live.OLiveQueryHookV2;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import com.orientechnologies.orient.core.storage.ORecordMetadata;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.tx.OTransactionData;
import com.orientechnologies.orient.core.tx.OTransactionId;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;
import com.orientechnologies.orient.core.tx.OTransactionInternal;
import com.orientechnologies.orient.core.tx.OTransactionOptimistic;
import com.orientechnologies.orient.core.tx.OTxMetadataHolder;
import com.orientechnologies.orient.core.tx.ValidationResult;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ODistributedTxContext;
import com.orientechnologies.orient.server.distributed.OWriteOperationNotPermittedException;
import com.orientechnologies.orient.server.distributed.exception.ODistributedTxPromiseRequestIsOldException;
import com.orientechnologies.orient.server.distributed.exception.OTransactionAlreadyPresentException;
import com.orientechnologies.orient.server.distributed.impl.ODDLContextImpl;
import com.orientechnologies.orient.server.distributed.impl.ODistributedDatabaseImpl;
import com.orientechnologies.orient.server.distributed.impl.ODistributedOutput;
import com.orientechnologies.orient.server.distributed.impl.ODistributedPlugin;
import com.orientechnologies.orient.server.distributed.impl.ODistributedTxCoordinator;
import com.orientechnologies.orient.server.distributed.impl.ODistributedTxResponseManagerImpl;
import com.orientechnologies.orient.server.distributed.impl.OInvalidSequentialException;
import com.orientechnologies.orient.server.distributed.impl.ONewDistributedTxContextImpl;
import com.orientechnologies.orient.server.distributed.impl.OTransactionOptimisticDistributed;
import com.orientechnologies.orient.server.distributed.impl.TxContextStatus;
import com.orientechnologies.orient.server.distributed.impl.lock.OTxPromise;
import com.orientechnologies.orient.server.distributed.impl.metadata.OClassDistributed;
import com.orientechnologies.orient.server.distributed.impl.metadata.OSharedContextDistributed;
import com.orientechnologies.orient.server.distributed.impl.task.ORunQueryExecutionPlanTask;
import com.orientechnologies.orient.server.distributed.impl.task.OSQLCommandTaskFirstPhase;
import com.orientechnologies.orient.server.distributed.impl.task.OSQLCommandTaskSecondPhase;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTransactionResultPayload;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxException;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxInvalidSequential;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxSuccess;
import com.orientechnologies.orient.server.distributed.task.ODistributedKeyLockedException;
import com.orientechnologies.orient.server.distributed.task.ODistributedOperationException;
import com.orientechnologies.orient.server.distributed.task.ODistributedRecordLockedException;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import com.orientechnologies.orient.server.plugin.OServerPluginInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;

public class ODatabaseDocumentDistributed
extends ODatabaseDocumentEmbedded {
    private final ODistributedPlugin distributedManager;

    public ODatabaseDocumentDistributed(OStorage storage, ODistributedPlugin distributedPlugin) {
        super(storage);
        this.distributedManager = distributedPlugin;
    }

    public String getLocalNodeName() {
        return this.distributedManager.getLocalNodeName();
    }

    public Map<String, Set<String>> getActiveClusterMap() {
        if (this.distributedManager.isOffline() || !this.distributedManager.isNodeOnline(this.distributedManager.getLocalNodeName(), this.getName()) || OScenarioThreadLocal.INSTANCE.isRunModeDistributed()) {
            return super.getActiveClusterMap();
        }
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        ODistributedConfiguration cfg = this.getDistributedConfiguration();
        for (String server : this.distributedManager.getActiveServers()) {
            if (this.getClustersOnServer(cfg, server).contains("*")) {
                result.put(server, new HashSet(this.getClusterNames()));
                continue;
            }
            result.put(server, this.getClustersOnServer(cfg, server));
        }
        return result;
    }

    public Set<String> getClustersOnServer(ODistributedConfiguration cfg, String server) {
        Set result = cfg.getClustersOnServer(server);
        if (result.contains("*")) {
            result.remove("*");
            HashSet more = new HashSet();
            more.addAll(this.getClusterNames());
            for (String s : cfg.getClusterNames()) {
                if (cfg.getServers(s, null).contains(s)) continue;
                more.remove(s);
            }
            result.addAll(more);
        }
        return result;
    }

    public Map<String, Set<String>> getActiveDataCenterMap() {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        ODistributedConfiguration cfg = this.getDistributedConfiguration();
        Set servers = cfg.getRegisteredServers();
        for (String server : servers) {
            String dc = cfg.getDataCenterOfServer(server);
            HashSet<String> dcConfig = (HashSet<String>)result.get(dc);
            if (dcConfig == null) {
                dcConfig = new HashSet<String>();
                result.put(dc, dcConfig);
            }
            dcConfig.add(server);
        }
        return result;
    }

    public boolean isSharded() {
        Map<String, Set<String>> clusterMap = this.getActiveClusterMap();
        Iterator<Set<String>> iter = clusterMap.values().iterator();
        Set<String> firstClusterSet = null;
        if (iter.hasNext()) {
            firstClusterSet = iter.next();
        }
        while (iter.hasNext()) {
            if (firstClusterSet.equals(iter.next())) continue;
            return true;
        }
        return false;
    }

    public boolean isDistributed() {
        return true;
    }

    public ODatabaseDocumentInternal copy() {
        ODatabaseDocumentDistributed database = new ODatabaseDocumentDistributed(this.getStorage(), this.distributedManager);
        database.init(this.getConfig(), this.getSharedContext());
        String user = this.getUser() != null ? this.getUser().getName() : null;
        database.internalOpen(user, null, false);
        database.callOnOpenListeners();
        this.activateOnCurrentThread();
        return database;
    }

    public boolean sync(boolean forceDeployment, boolean tryWithDelta) {
        this.checkSecurity(ORule.ResourceGeneric.DATABASE, "sync", ORole.PERMISSION_UPDATE);
        String databaseName = this.getName();
        return this.distributedManager.installDatabase(true, databaseName, forceDeployment, tryWithDelta);
    }

    public Map<String, Object> getHaStatus(boolean servers, boolean db, boolean latency, boolean messages) {
        this.checkSecurity(ORule.ResourceGeneric.SERVER, "status", ORole.PERMISSION_READ);
        if (this.distributedManager == null || !this.distributedManager.isEnabled()) {
            throw new OCommandExecutionException("OrientDB is not started in distributed mode");
        }
        String databaseName = this.getName();
        ODistributedConfiguration cfg = this.distributedManager.getDatabaseConfiguration(databaseName);
        HashMap<String, Object> row = new HashMap<String, Object>();
        StringBuilder output = new StringBuilder();
        if (servers) {
            row.put("servers", this.distributedManager.getClusterConfiguration());
        }
        if (db) {
            row.put("database", cfg.getDocument());
        }
        if (latency) {
            row.put("latency", ODistributedOutput.formatLatency(this.distributedManager, this.distributedManager.getClusterConfiguration()));
        }
        if (messages) {
            row.put("messages", ODistributedOutput.formatMessages(this.distributedManager, this.distributedManager.getClusterConfiguration()));
        }
        return row;
    }

    public boolean removeHaServer(String serverName) {
        this.checkSecurity(ORule.ResourceGeneric.SERVER, "remove", ORole.PERMISSION_EXECUTE);
        if (this.distributedManager == null || !this.distributedManager.isEnabled()) {
            throw new OCommandExecutionException("OrientDB is not started in distributed mode");
        }
        String databaseName = this.getName();
        return this.distributedManager.removeNodeFromConfiguration(serverName, databaseName, false, true);
    }

    public OResultSet queryOnNode(String nodeName, OExecutionPlan executionPlan, Map<Object, Object> inputParameters) {
        ORunQueryExecutionPlanTask task = new ORunQueryExecutionPlanTask(executionPlan, inputParameters, nodeName);
        ODistributedResponse result = this.executeTaskOnNode((ORemoteTask)task, nodeName);
        return task.getResult(result, this);
    }

    public ODistributedResponse executeTaskOnNode(ORemoteTask task, String nodeName) {
        if (this.distributedManager == null || !this.distributedManager.isEnabled()) {
            throw new ODistributedException("OrientDB is not started in distributed mode");
        }
        String databaseName = this.getName();
        return this.distributedManager.sendRequest(databaseName, null, Collections.singletonList(nodeName), task, this.distributedManager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null);
    }

    public void init(OrientDBConfig config, OSharedContext sharedContext) {
        OScenarioThreadLocal.executeAsDistributed(() -> {
            super.init(config, sharedContext);
            return null;
        });
    }

    protected void createMetadata(OSharedContext ctx) {
        OSharedContext shared = ctx;
        this.metadata.init(shared);
        ((OSharedContextDistributed)shared).create((ODatabaseDocumentInternal)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int assignAndCheckCluster(ORecord record, String iClusterName) {
        ORecordId rid = (ORecordId)record.getIdentity();
        if ((long)rid.getClusterId() <= -1L && iClusterName != null) {
            rid.setClusterId(this.getClusterIdByName(iClusterName));
            if (rid.getClusterId() == -1) {
                throw new IllegalArgumentException("Cluster name '" + iClusterName + "' is not configured");
            }
        }
        OClass schemaClass = null;
        if (rid.getClusterId() <= -1 && this.getStorage().isAssigningClusterIds()) {
            if (!(record instanceof ODocument)) throw new ODatabaseException("Cannot save (5) document " + record + ": no class or cluster defined");
            schemaClass = ((ODocument)record).getSchemaClass();
            if (schemaClass == null) throw new ODatabaseException("Cannot save (4) document " + record + ": no class or cluster defined");
            if (schemaClass.isAbstract()) {
                throw new OSchemaException("Document belongs to abstract class " + schemaClass.getName() + " and cannot be saved");
            }
            rid.setClusterId(((OClassDistributed)schemaClass).getClusterForNewInstance(this, (ODocument)record));
        } else if (record instanceof ODocument) {
            schemaClass = ((ODocument)record).getSchemaClass();
        }
        if (rid.getClusterId() <= -1 || schemaClass == null) return rid.getClusterId();
        String messageClusterName = this.getClusterNameById(rid.getClusterId());
        this.checkRecordClass(schemaClass, messageClusterName, rid);
        if (schemaClass.hasClusterId(rid.getClusterId())) return rid.getClusterId();
        throw new IllegalArgumentException("Cluster name '" + messageClusterName + "' (id=" + rid.getClusterId() + ") is not configured to store the class '" + schemaClass.getName() + "', valid are " + Arrays.toString(schemaClass.getClusterIds()));
    }

    public void internalCommit(OTransactionInternal iTx) {
        int protocolVersion = OGlobalConfiguration.DISTRIBUTED_REPLICATION_PROTOCOL_VERSION.getValueAsInteger();
        if (OScenarioThreadLocal.INSTANCE.isRunModeDistributed() || iTx.isSequenceTransaction() && protocolVersion == 2) {
            super.internalCommit(iTx);
        } else {
            switch (protocolVersion) {
                case 1: {
                    this.distributedCommitV1(iTx);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid distributed replicaiton protocol version: " + OGlobalConfiguration.DISTRIBUTED_REPLICATION_PROTOCOL_VERSION.getValueAsInteger());
                }
            }
        }
    }

    public <T> T sendSequenceAction(OSequenceAction action) throws ExecutionException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    public void distributedCommitV1(OTransactionInternal iTx) {
        try {
            for (ORecordOperation txEntry : iTx.getRecordOperations()) {
                ORecord record;
                if (txEntry.type != 3 && txEntry.type != 1 || !((record = txEntry.getRecord()) instanceof ODocument)) continue;
                ((ODocument)record).validate();
            }
            ODistributedDatabase localDistributedDatabase = this.getDistributedShared();
            ODistributedConfiguration dbCfg = localDistributedDatabase.getDistributedConfiguration();
            ODistributedServerManager dManager = this.getDistributedManager();
            String localNodeName = dManager.getLocalNodeName();
            this.checkNodeIsMaster(localNodeName, dbCfg, "Transaction Commit");
            int nretry = this.getConfiguration().getValueAsInteger(OGlobalConfiguration.DISTRIBUTED_CONCURRENT_TX_MAX_AUTORETRY);
            int delay = this.getConfiguration().getValueAsInteger(OGlobalConfiguration.DISTRIBUTED_CONCURRENT_TX_AUTORETRY_DELAY);
            ODistributedTxCoordinator txManager = new ODistributedTxCoordinator(this.getStorage(), dManager, localDistributedDatabase, dManager.getMessageService(), dManager.getLocalNodeId(), dManager.getLocalNodeName(), nretry, delay);
            int quorum = 0;
            Set<String> clusters = this.getInvolvedClusters(iTx.getRecordOperations());
            for (String clusterName : clusters) {
                List clusterServers = dbCfg.getServers(clusterName, null);
                int writeQuorum = dbCfg.getWriteQuorum(clusterName, clusterServers.size(), localNodeName);
                quorum = Math.max(quorum, writeQuorum);
            }
            int availableNodes = dManager.getAvailableNodes(this.getName());
            if (quorum > availableNodes) {
                Set online = dManager.getAvailableNodeNames(this.getName());
                throw new ODistributedException(String.format("Not enough nodes online to execute the operation. Available nodes:%s, quorum:%s", online, quorum));
            }
            txManager.commit(this, iTx, clusters);
            return;
        }
        catch (OValidationException e) {
            throw e;
        }
        catch (HazelcastInstanceNotActiveException e) {
            throw new OOfflineNodeException("Hazelcast instance is not available");
        }
        catch (HazelcastException e) {
            throw new OOfflineNodeException("Hazelcast instance is not available");
        }
        catch (Exception e) {
            this.handleDistributedException("Cannot route TX operation against distributed node", e, new Object[0]);
            return;
        }
    }

    private int getVersionForIndexKey(OTransactionInternal tx, String index, Object key, boolean isCoordinator) {
        if (isCoordinator) {
            return ((OAbstractPaginatedStorage)tx.getDatabase().getStorage()).getVersionForKey(index, key);
        }
        return ((OTransactionOptimisticDistributed)tx).getVersionForKey(index, key);
    }

    public void acquireLocksForTx(OTransactionInternal tx, ODistributedTxContext txContext, boolean isCoordinator, boolean force) {
        HashSet<OTransactionId> txsWithBrokenPromises = new HashSet<OTransactionId>();
        TreeSet<OPair> rids = new TreeSet<OPair>();
        for (ORecordOperation entry : tx.getRecordOperations()) {
            if (!ORecordInternal.isContentChanged((ORecord)entry.getRecord())) continue;
            rids.add(new OPair((Comparable)entry.getRID().copy(), (Object)entry.getRecord().getVersion()));
        }
        for (OPair rid : rids) {
            OTransactionId txId = txContext.acquirePromise((ORID)rid.getKey(), ((Integer)rid.getValue()).intValue(), force);
            if (txId == null) continue;
            txsWithBrokenPromises.add(txId);
        }
        TreeSet<OPair> keys = new TreeSet<OPair>();
        for (Map.Entry change : tx.getIndexOperations().entrySet()) {
            OIndex index = this.getMetadata().getIndexManagerInternal().getIndex((ODatabaseDocumentInternal)this, (String)change.getKey());
            if (!OClass.INDEX_TYPE.UNIQUE.name().equals(index.getType()) && !OClass.INDEX_TYPE.UNIQUE_HASH_INDEX.name().equals(index.getType()) && !OClass.INDEX_TYPE.DICTIONARY.name().equals(index.getType()) && !OClass.INDEX_TYPE.DICTIONARY_HASH_INDEX.name().equals(index.getType())) continue;
            String name = index.getName();
            for (OTransactionIndexChangesPerKey changesPerKey : ((OTransactionIndexChanges)change.getValue()).changesPerKey.values()) {
                int keyVersion = this.getVersionForIndexKey(tx, name, changesPerKey.key, isCoordinator);
                keys.add(new OPair((Comparable)((Object)(name + "#" + changesPerKey.key)), (Object)keyVersion));
            }
            if (((OTransactionIndexChanges)change.getValue()).nullKeyChanges.isEmpty()) continue;
            int keyVersion = this.getVersionForIndexKey(tx, name, null, isCoordinator);
            keys.add(new OPair((Comparable)((Object)(name + "#null")), (Object)keyVersion));
        }
        for (OPair key : keys) {
            OTransactionId txId = txContext.acquireIndexKeyPromise((Object)key.getKey(), ((Integer)key.getValue()).intValue(), force);
            if (txId == null) continue;
            txsWithBrokenPromises.add(txId);
        }
        if (!txsWithBrokenPromises.isEmpty() && OLogManager.instance().isDebugEnabled()) {
            OLogManager.instance().debug((Object)this, "Tx '%s' forcefully took over promises from transactions '%s'.", new Object[]{txContext.getTransactionId(), ((Object)txsWithBrokenPromises).toString()});
        }
    }

    public boolean beginDistributedTx(ODistributedRequestId requestId, OTransactionId id, OTransactionInternal tx, boolean isCoordinator, int retryCount) {
        ODistributedDatabase localDistributedDatabase = this.getDistributedShared();
        ONewDistributedTxContextImpl txContext = new ONewDistributedTxContextImpl((ODistributedDatabaseImpl)localDistributedDatabase, requestId, tx, id);
        try {
            this.internalBegin2pc(txContext, isCoordinator);
            txContext.setStatus(TxContextStatus.SUCCESS);
            this.register(requestId, localDistributedDatabase, txContext);
        }
        catch (OConcurrentCreateException ex) {
            if (retryCount >= 0 && retryCount < this.getConfiguration().getValueAsInteger(OGlobalConfiguration.DISTRIBUTED_CONCURRENT_TX_MAX_AUTORETRY) && ex.getExpectedRid().getClusterPosition() > ex.getActualRid().getClusterPosition()) {
                OLogManager.instance().debug((Object)this, "Allocation of rid not match, expected:%s actual:%s waiting for re-enqueue request", new Object[]{ex.getExpectedRid(), ex.getActualRid()});
                txContext.releasePromises();
                return false;
            }
            txContext.setStatus(TxContextStatus.FAILED);
            this.register(requestId, localDistributedDatabase, txContext);
            throw ex;
        }
        catch (OConcurrentModificationException ex) {
            if (retryCount >= 0 && retryCount < this.getConfiguration().getValueAsInteger(OGlobalConfiguration.DISTRIBUTED_CONCURRENT_TX_MAX_AUTORETRY) && ex.getEnhancedRecordVersion() > ex.getEnhancedDatabaseVersion()) {
                OLogManager.instance().info((Object)this, "Persistent version not match, record:%s expected:%s actual:%s waiting for re-enqueue request", new Object[]{ex.getRid(), ex.getEnhancedRecordVersion(), ex.getEnhancedDatabaseVersion()});
                txContext.releasePromises();
                return false;
            }
            txContext.setStatus(TxContextStatus.FAILED);
            this.register(requestId, localDistributedDatabase, txContext);
            throw ex;
        }
        catch (ORecordNotFoundException e) {
            if (retryCount >= 0 && retryCount < this.getConfiguration().getValueAsInteger(OGlobalConfiguration.DISTRIBUTED_CONCURRENT_TX_MAX_AUTORETRY)) {
                return false;
            }
            txContext.setStatus(TxContextStatus.FAILED);
            this.register(requestId, localDistributedDatabase, txContext);
            throw e;
        }
        catch (OInvalidSequentialException | ODistributedKeyLockedException | ODistributedRecordLockedException ex) {
            txContext.setStatus(TxContextStatus.TIMEDOUT);
            this.register(requestId, localDistributedDatabase, txContext);
            throw ex;
        }
        catch (ORecordDuplicatedException ex) {
            txContext.setStatus(TxContextStatus.FAILED);
            this.register(requestId, localDistributedDatabase, txContext);
            throw ex;
        }
        catch (OLowDiskSpaceException ex) {
            this.distributedManager.setDatabaseStatus(this.getLocalNodeName(), this.getName(), ODistributedServerManager.DB_STATUS.OFFLINE);
            throw ex;
        }
        catch (OModificationOperationProhibitedException e) {
            txContext.setStatus(TxContextStatus.FAILED);
            this.register(requestId, localDistributedDatabase, txContext);
            throw e;
        }
        return true;
    }

    public ODistributedDatabase getDistributedShared() {
        return this.getDistributedManager().getMessageService().getDatabase(this.getName());
    }

    public void register(ODistributedRequestId requestId, ODistributedDatabase localDistributedDatabase, ODistributedTxContext txContext) {
        localDistributedDatabase.registerTxContext(requestId, txContext);
    }

    public void commit2pcLocal(ODistributedRequestId transactionId) {
        this.commit2pc(transactionId, true, transactionId);
    }

    public boolean commit2pc(ODistributedRequestId transactionId, boolean isCoordinator, ODistributedRequestId requestId) {
        ODistributedDatabaseImpl localDistributedDatabase = (ODistributedDatabaseImpl)this.getDistributedShared();
        localDistributedDatabase.resetLastValidBackup();
        ODistributedServerManager manager = this.getDistributedManager();
        ONewDistributedTxContextImpl txContext = (ONewDistributedTxContextImpl)localDistributedDatabase.getTxContext(transactionId);
        if (txContext != null) {
            int i;
            if (TxContextStatus.SUCCESS.equals((Object)txContext.getStatus())) {
                try {
                    for (OTxPromise<ORID> oTxPromise : txContext.getPromisedRids()) {
                        txContext.acquirePromise(oTxPromise.getKey(), oTxPromise.getVersion(), false);
                    }
                    for (OTxPromise<Object> oTxPromise : txContext.getPromisedKeys()) {
                        txContext.acquireIndexKeyPromise(oTxPromise.getKey(), oTxPromise.getVersion(), false);
                    }
                }
                catch (ODistributedKeyLockedException | ODistributedRecordLockedException e) {
                    throw new ODistributedException(String.format("Locks for tx '%s' are no longer valid in the second phase despite successful first phase", transactionId));
                }
                try {
                    if (manager != null) {
                        manager.messageCurrentPayload(requestId, (Object)txContext);
                        manager.messageBeforeOp("commit", requestId);
                    }
                    txContext.commit((ODatabaseDocumentInternal)this);
                    localDistributedDatabase.popTxContext(transactionId);
                    OLiveQueryHook.notifyForTxChanges((ODatabase)this);
                    OLiveQueryHookV2.notifyForTxChanges((ODatabaseDocument)this);
                }
                catch (OTransactionAlreadyPresentException e) {
                    txContext.destroy();
                    localDistributedDatabase.popTxContext(transactionId);
                }
                catch (Error | RuntimeException e) {
                    txContext.destroy();
                    localDistributedDatabase.popTxContext(transactionId);
                    Orient.instance().submit(() -> this.getDistributedManager().installDatabase(false, this.getName(), true, true));
                    throw e;
                }
                finally {
                    if (manager != null) {
                        manager.messageAfterOp("commit", requestId);
                    }
                    OLiveQueryHook.removePendingDatabaseOps((ODatabase)this);
                    OLiveQueryHookV2.removePendingDatabaseOps((ODatabaseDocument)this);
                }
                return true;
            }
            int nretry = this.getConfiguration().getValueAsInteger(OGlobalConfiguration.DISTRIBUTED_CONCURRENT_TX_MAX_AUTORETRY);
            int n = this.getConfiguration().getValueAsInteger(OGlobalConfiguration.DISTRIBUTED_CONCURRENT_TX_AUTORETRY_DELAY);
            for (i = 0; i < nretry; i += 1) {
                try {
                    ValidationResult validateResult;
                    if (i > 0) {
                        try {
                            Thread.sleep(new Random().nextInt(n));
                        }
                        catch (InterruptedException e) {
                            OException.wrapException((OException)new OInterruptedException(e.getMessage()), (Throwable)e);
                        }
                    }
                    if ((validateResult = localDistributedDatabase.validate(txContext.getTransactionId())) == ValidationResult.ALREADY_PRESENT) {
                        txContext.destroy();
                        localDistributedDatabase.popTxContext(transactionId);
                        return true;
                    }
                    if (validateResult == ValidationResult.MISSING_PREVIOUS) continue;
                    this.internalBegin2pc(txContext, isCoordinator, true);
                    txContext.setStatus(TxContextStatus.SUCCESS);
                    break;
                }
                catch (ODistributedKeyLockedException | ODistributedRecordLockedException validateResult) {
                    continue;
                }
                catch (ODistributedTxPromiseRequestIsOldException ex) {
                    OLogManager.instance().warn((Object)this, "Error committing transaction %s ", (Throwable)((Object)ex), new Object[]{transactionId});
                    return true;
                }
                catch (Exception ex) {
                    OLogManager.instance().warn((Object)this, "Error beginning timed out transaction: %s ", (Throwable)ex, new Object[]{transactionId});
                    break;
                }
            }
            if (TxContextStatus.SUCCESS.equals((Object)txContext.getStatus())) {
                try {
                    txContext.commit((ODatabaseDocumentInternal)this);
                    localDistributedDatabase.popTxContext(transactionId);
                    OLiveQueryHook.notifyForTxChanges((ODatabase)this);
                    OLiveQueryHookV2.notifyForTxChanges((ODatabaseDocument)this);
                    i = 1;
                    return i != 0;
                }
                catch (OTransactionAlreadyPresentException e) {
                    txContext.destroy();
                    localDistributedDatabase.popTxContext(transactionId);
                }
                catch (Error | RuntimeException e) {
                    txContext.destroy();
                    localDistributedDatabase.popTxContext(transactionId);
                    Orient.instance().submit(() -> this.getDistributedManager().installDatabase(false, this.getName(), true, true));
                    throw e;
                }
                finally {
                    OLiveQueryHook.removePendingDatabaseOps((ODatabase)this);
                    OLiveQueryHookV2.removePendingDatabaseOps((ODatabaseDocument)this);
                }
            } else {
                txContext.destroy();
                localDistributedDatabase.popTxContext(transactionId);
                Orient.instance().submit(() -> {
                    OLogManager.instance().warn((Object)this, "Reached limit of retry for commit tx:%s forcing database re-install", new Object[]{transactionId});
                    this.distributedManager.installDatabase(false, this.getName(), true, true);
                });
                return true;
            }
        }
        return false;
    }

    public boolean rollback2pc(ODistributedRequestId transactionId) {
        ODistributedDatabase localDistributedDatabase = this.getDistributedShared();
        ODistributedTxContext txContext = localDistributedDatabase.popTxContext(transactionId);
        if (txContext != null) {
            txContext.destroy();
            OLiveQueryHook.removePendingDatabaseOps((ODatabase)this);
            OLiveQueryHookV2.removePendingDatabaseOps((ODatabaseDocument)this);
            return true;
        }
        return false;
    }

    public void internalCommit2pc(ONewDistributedTxContextImpl txContext) {
        try {
            OTransactionInternal tx = txContext.getTransaction();
            tx.setDatabase((ODatabaseDocumentInternal)this);
            ((OAbstractPaginatedStorage)this.getStorage()).commitPreAllocated(tx);
        }
        catch (OLowDiskSpaceException ex) {
            this.distributedManager.setDatabaseStatus(this.getLocalNodeName(), this.getName(), ODistributedServerManager.DB_STATUS.OFFLINE);
            throw ex;
        }
        finally {
            txContext.destroy();
        }
    }

    public void internalBegin2pc(ONewDistributedTxContextImpl txContext, boolean isCoordinator) {
        this.internalBegin2pc(txContext, isCoordinator, false);
    }

    public void internalBegin2pc(ONewDistributedTxContextImpl txContext, boolean isCoordinator, boolean force) {
        ODistributedDatabaseImpl localDb = (ODistributedDatabaseImpl)this.getDistributedShared();
        OTransactionInternal transaction = txContext.getTransaction();
        if (!isCoordinator) {
            ((OTransactionOptimisticDistributed)transaction).setDatabase((ODatabaseDocumentInternal)this);
            ((OTransactionOptimistic)transaction).begin();
        }
        localDb.getManager().messageBeforeOp("locks", txContext.getReqId());
        if (isCoordinator) {
            this.getDistributedShared().getManager().messageBeforeOp("allocate", txContext.getReqId());
            ((OAbstractPaginatedStorage)this.getStorage()).preallocateRids(transaction);
            this.getDistributedShared().getManager().messageAfterOp("allocate", txContext.getReqId());
        }
        this.acquireLocksForTx(transaction, txContext, isCoordinator, force);
        this.firstPhaseDataChecks(isCoordinator, transaction, txContext);
    }

    private void firstPhaseDataChecks(boolean isCoordinator, OTransactionInternal transaction, ONewDistributedTxContextImpl txContext) {
        this.getDistributedShared().getManager().messageAfterOp("locks", txContext.getReqId());
        if (!isCoordinator) {
            this.getDistributedShared().getManager().messageBeforeOp("allocate", txContext.getReqId());
            ((OAbstractPaginatedStorage)this.getStorage()).preallocateRids(transaction);
            this.getDistributedShared().getManager().messageAfterOp("allocate", txContext.getReqId());
        }
        this.getDistributedShared().getManager().messageBeforeOp("indexCheck", txContext.getReqId());
        for (Map.Entry change : transaction.getIndexOperations().entrySet()) {
            String indexName = (String)change.getKey();
            OIndex index = this.getSharedContext().getIndexManager().getRawIndex(indexName);
            if (!OClass.INDEX_TYPE.UNIQUE.name().equals(index.getType()) && !OClass.INDEX_TYPE.UNIQUE_HASH_INDEX.name().equals(index.getType())) continue;
            OTransactionIndexChangesPerKey nullKeyChanges = ((OTransactionIndexChanges)change.getValue()).nullKeyChanges;
            if (!nullKeyChanges.isEmpty()) {
                OIdentifiable old;
                try (Stream stream = index.getInternal().getRids(null);){
                    old = stream.findFirst().orElse(null);
                }
                OIdentifiable newValue = ((OTransactionIndexChangesPerKey.OTransactionIndexEntry)nullKeyChanges.getEntriesAsList().get(nullKeyChanges.size() - 1)).getValue();
                if (old != null && !old.equals(newValue)) {
                    boolean oldValueRemoved = false;
                    for (OTransactionIndexChangesPerKey.OTransactionIndexEntry entry : nullKeyChanges.getEntriesAsList()) {
                        if (entry.getValue() == null || !entry.getValue().equals(old) || entry.getOperation() != OTransactionIndexChanges.OPERATION.REMOVE) continue;
                        oldValueRemoved = true;
                        break;
                    }
                    if (!oldValueRemoved) {
                        throw new ORecordDuplicatedException(String.format("Cannot index record %s: found duplicated key '%s' in index '%s' previously assigned to the record %s", newValue, null, this.getName(), old.getIdentity()), this.getName(), old.getIdentity(), null);
                    }
                }
            }
            for (OTransactionIndexChangesPerKey changesPerKey : ((OTransactionIndexChanges)change.getValue()).changesPerKey.values()) {
                OIdentifiable old;
                int sourceVersion;
                long version;
                if (!isCoordinator && (version = (long)((OAbstractPaginatedStorage)this.getStorage()).getVersionForKey(indexName, changesPerKey.key)) != (long)(sourceVersion = ((OTransactionOptimisticDistributed)transaction).getVersionForKey(indexName, changesPerKey.key))) {
                    throw new OInvalidSequentialException();
                }
                try (Stream rids = index.getInternal().getRids(changesPerKey.key);){
                    old = rids.findFirst().orElse(null);
                }
                if (changesPerKey.isEmpty()) continue;
                OIdentifiable newValue = ((OTransactionIndexChangesPerKey.OTransactionIndexEntry)changesPerKey.getEntriesAsList().get(changesPerKey.size() - 1)).getValue();
                if (old == null || old.equals(newValue)) continue;
                boolean oldValueRemoved = false;
                for (OTransactionIndexChangesPerKey.OTransactionIndexEntry entry : changesPerKey.getEntriesAsList()) {
                    if (entry.getValue() == null || !entry.getValue().equals(old) || entry.getOperation() != OTransactionIndexChanges.OPERATION.REMOVE) continue;
                    oldValueRemoved = true;
                    break;
                }
                if (oldValueRemoved) continue;
                throw new ORecordDuplicatedException(String.format("Cannot index record %s: found duplicated key '%s' in index '%s' previously assigned to the record %s", newValue, changesPerKey.key, this.getName(), old.getIdentity()), this.getName(), old.getIdentity(), changesPerKey.key);
            }
        }
        this.getDistributedShared().getManager().messageAfterOp("indexCheck", txContext.getReqId());
        this.getDistributedShared().getManager().messageBeforeOp("mvccCheck", txContext.getReqId());
        for (ORecordOperation entry : transaction.getRecordOperations()) {
            if (entry.getType() == 3) continue;
            int changeVersion = entry.getRecord().getVersion();
            ORecordMetadata metadata = this.getStorage().getRecordMetadata(entry.getRID());
            if (metadata == null) {
                if (((OAbstractPaginatedStorage)this.getStorage()).isDeleted(entry.getRID())) {
                    throw new OConcurrentModificationException(entry.getRID(), changeVersion, changeVersion, (int)entry.getType());
                }
                throw new OConcurrentCreateException((ORID)new ORecordId(-1, -1L), entry.getRID());
            }
            int persistentVersion = metadata.getVersion();
            if (changeVersion == persistentVersion) continue;
            throw new OConcurrentModificationException(entry.getRID(), persistentVersion, changeVersion, (int)entry.getType());
        }
        this.getDistributedShared().getManager().messageAfterOp("mvccCheck", txContext.getReqId());
    }

    public OView getViewFromCluster(int cluster) {
        String viewName;
        OImmutableSchema schema = this.getMetadata().getImmutableSchemaSnapshot();
        OView view = schema.getViewByClusterId(cluster);
        if (view == null && (viewName = ((OSharedContextDistributed)this.getSharedContext()).getViewManager().getViewFromOldCluster(cluster)) != null) {
            view = schema.getView(viewName);
        }
        return view;
    }

    public OEnterpriseEndpoint getEnterpriseEndpoint() {
        OServer server = this.distributedManager.getServerInstance();
        return server.getPlugins().stream().map(OServerPluginInfo::getInstance).filter(OEnterpriseEndpoint.class::isInstance).findFirst().map(OEnterpriseEndpoint.class::cast).orElse(null);
    }

    public ODistributedServerManager getDistributedManager() {
        return this.distributedManager;
    }

    public ODistributedConfiguration getDistributedConfiguration() {
        ODistributedDatabaseImpl local = this.distributedManager.getMessageService().getDatabase(this.getName());
        return local.getDistributedConfiguration();
    }

    public void sendDDLCommand(String command, boolean excludeLocal) {
        this.twoPhaseDDL(command);
    }

    public void twoPhaseDDL(String command) {
        if (this.isLocalEnv()) {
            super.command(command, new Object[0]).close();
            return;
        }
        this.checkNodeIsMaster(this.getLocalNodeName(), this.getDistributedConfiguration(), "Command '" + command + "'");
        ODistributedDatabase local = this.getDistributedShared();
        int nretry = this.getConfiguration().getValueAsInteger(OGlobalConfiguration.DISTRIBUTED_CONCURRENT_TX_MAX_AUTORETRY) + 1;
        block10: for (int i = 0; i < nretry; ++i) {
            Object results;
            Optional beforeId = local.nextId();
            Optional afterId = local.nextId();
            OSQLCommandTaskFirstPhase task = new OSQLCommandTaskFirstPhase(command, (OTransactionId)beforeId.get(), (OTransactionId)afterId.get());
            ODistributedServerManager dManager = this.getDistributedManager();
            Set nodes = dManager.getAvailableNodeNames(this.getName());
            long next = dManager.getNextMessageIdCounter();
            ODistributedRequestId reqId = new ODistributedRequestId(dManager.getLocalNodeId(), next);
            ODistributedTxResponseManagerImpl responseManager = this.sendTask(nodes, (ORemoteTask)task, null, next);
            if (responseManager.isQuorumReached()) {
                results = responseManager.getDistributedTxFinalResponse();
                assert (((Optional)results).isPresent());
                OTransactionResultPayload resultPayload = (OTransactionResultPayload)((Optional)results).get();
                switch (resultPayload.getResponseType()) {
                    case 1: {
                        this.confirmPhase2DDL(nodes, reqId, true);
                        return;
                    }
                    case 5: {
                        this.confirmPhase2DDL(nodes, reqId, false);
                        throw ((OTxException)resultPayload).getException();
                    }
                    case 9: {
                        this.confirmPhase2DDL(nodes, reqId, false);
                        break;
                    }
                    default: {
                        for (OTransactionResultPayload oTransactionResultPayload : responseManager.getAllResponses()) {
                            if (oTransactionResultPayload.getResponseType() != 5) continue;
                            OLogManager.instance().warn((Object)this, "One node on error", (Throwable)((OTxException)oTransactionResultPayload).getException(), new Object[0]);
                        }
                        continue block10;
                    }
                }
                continue;
            }
            results = responseManager.getAllResponses();
            ArrayList<RuntimeException> exceptions = new ArrayList<RuntimeException>();
            ArrayList<String> messages = new ArrayList<String>();
            Iterator iterator = results.iterator();
            while (iterator.hasNext()) {
                OTransactionResultPayload result3 = (OTransactionResultPayload)iterator.next();
                String string = responseManager.getNodeNameFromPayload(result3);
                switch (result3.getResponseType()) {
                    case 1: {
                        messages.add("node: " + string + " success");
                        break;
                    }
                    case 5: {
                        exceptions.add(((OTxException)result3).getException());
                        OLogManager.instance().debug((Object)this, "distributed exception", (Throwable)((OTxException)result3).getException(), new Object[0]);
                        messages.add(String.format("exception (node " + string + "): '%s'", ((OTxException)result3).getException().getMessage()));
                        break;
                    }
                    case 9: {
                        this.confirmPhase2DDL(nodes, reqId, false);
                        continue block10;
                    }
                }
            }
            this.confirmPhase2DDL(nodes, reqId, false);
            ODistributedOperationException oDistributedOperationException = new ODistributedOperationException(String.format("Request `%s` didn't reach the quorum of '%d', responses: [%s]", reqId, responseManager.getQuorum(), String.join((CharSequence)",", messages)));
            for (Exception exception : exceptions) {
                oDistributedOperationException.addSuppressed((Throwable)exception);
            }
            if (i != nretry) continue;
            throw oDistributedOperationException;
        }
        throw new ODistributedOperationException("Reached number of retry to execute ddl");
    }

    private void confirmPhase2DDL(Set<String> nodes, ODistributedRequestId messageId, boolean apply) {
        ODistributedServerManager dManager = this.getDistributedManager();
        dManager.sendRequest(this.getName(), null, nodes, (ORemoteTask)new OSQLCommandTaskSecondPhase(messageId, apply), dManager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null);
    }

    private ODistributedTxResponseManagerImpl sendTask(Collection<String> nodes, ORemoteTask task, Object localResult, long next) {
        ODistributedServerManager dManager = this.getDistributedManager();
        final class HoldResponseManager {
            ODistributedTxResponseManagerImpl responseManager;

            HoldResponseManager() {
            }
        }
        HoldResponseManager holder = new HoldResponseManager();
        ((ODistributedPlugin)dManager).sendRequest(this.getName(), null, nodes, task, next, ODistributedRequest.EXECUTION_MODE.RESPONSE, localResult, (iRequest, iNodes, iTask, nodesConcurToTheQuorum, availableNodes, expectedResponses, quorum, groupByResponse, waitLocalNode) -> {
            holder.responseManager = new ODistributedTxResponseManagerImpl(iTask, iNodes, nodesConcurToTheQuorum, availableNodes, expectedResponses, quorum);
            return holder.responseManager;
        });
        return holder.responseManager;
    }

    public int addCluster(String iClusterName, Object ... iParameters) {
        if (!this.isLocalEnv()) {
            StringBuilder cmd = new StringBuilder("create cluster `");
            cmd.append(iClusterName);
            cmd.append("`");
            this.sendDDLCommand(cmd.toString(), false);
            return this.getClusterIdByName(iClusterName);
        }
        return super.addCluster(iClusterName, iParameters);
    }

    public int addCluster(String iClusterName, int iRequestedId) {
        if (!this.isLocalEnv()) {
            StringBuilder cmd = new StringBuilder("create cluster `");
            cmd.append(iClusterName);
            cmd.append("`");
            cmd.append(" ID ");
            cmd.append(iRequestedId);
            this.sendDDLCommand(cmd.toString(), false);
            return iRequestedId;
        }
        return super.addCluster(iClusterName, iRequestedId);
    }

    protected boolean dropClusterInternal(String clusterName) {
        if (!this.isLocalEnv()) {
            String cmd = "drop cluster `" + clusterName + "`";
            this.sendDDLCommand(cmd, false);
            return true;
        }
        return super.dropClusterInternal(clusterName);
    }

    public boolean dropClusterInternal(int clusterId) {
        if (!this.isLocalEnv()) {
            String cmd = "drop cluster " + clusterId + "";
            this.sendDDLCommand(cmd, false);
            return true;
        }
        return super.dropClusterInternal(clusterId);
    }

    public boolean isLocalEnv() {
        return OScenarioThreadLocal.INSTANCE.isRunModeDistributed();
    }

    public void acquireDistributedExclusiveLock(int timeout) {
        this.distributedManager.getLockManagerRequester().acquireExclusiveLock(this.getName(), this.distributedManager.getLocalNodeName(), (long)timeout);
    }

    public void releaseDistributedExclusiveLock() {
        this.distributedManager.getLockManagerRequester().releaseExclusiveLock(this.getName(), this.distributedManager.getLocalNodeName());
    }

    public void freeze(boolean throwException) {
        ((ODistributedDatabaseImpl)this.getDistributedShared()).freezeStatus();
        super.freeze(throwException);
    }

    public void release() {
        ((ODistributedDatabaseImpl)this.getDistributedShared()).releaseStatus();
        super.release();
    }

    public List<String> backup(OutputStream out, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener, int compressionLevel, int bufferSize) throws IOException {
        String localNode = this.distributedManager.getLocalNodeName();
        ODistributedServerManager.DB_STATUS prevStatus = this.distributedManager.getDatabaseStatus(localNode, this.getName());
        if (prevStatus == ODistributedServerManager.DB_STATUS.ONLINE) {
            this.distributedManager.setDatabaseStatus(localNode, this.getName(), ODistributedServerManager.DB_STATUS.BACKUP);
        }
        try {
            List list = super.backup(out, options, callable, iListener, compressionLevel, bufferSize);
            return list;
        }
        catch (IOException e) {
            throw OException.wrapException((OException)new OIOException("Error on executing backup"), (Throwable)e);
        }
        finally {
            this.distributedManager.setDatabaseStatus(localNode, this.getName(), prevStatus);
        }
    }

    protected void checkNodeIsMaster(String localNodeName, ODistributedConfiguration dbCfg, String operation) {
        ODistributedConfiguration.ROLES nodeRole = dbCfg.getServerRole(localNodeName);
        if (nodeRole != ODistributedConfiguration.ROLES.MASTER) {
            throw new OWriteOperationNotPermittedException("Cannot execute write operation (" + operation + ") on node '" + localNodeName + "' because is non a master");
        }
    }

    protected void handleDistributedException(String iMessage, Exception e, Object ... iParams) {
        if (e != null) {
            if (e instanceof OException) {
                throw (OException)e;
            }
            if (e.getCause() instanceof OException) {
                throw (OException)e.getCause();
            }
            if (e.getCause() != null && e.getCause().getCause() instanceof OException) {
                throw (OException)e.getCause().getCause();
            }
        }
        OLogManager.instance().error((Object)this, iMessage, (Throwable)e, iParams);
        throw OException.wrapException((OException)new OStorageException(String.format(iMessage, iParams)), (Throwable)e);
    }

    public String getStorageId() {
        return this.getDistributedManager().getLocalNodeName() + "." + this.getName();
    }

    protected Set<String> getInvolvedClusters(Iterable<ORecordOperation> uResult) {
        HashSet<String> involvedClusters = new HashSet<String>();
        for (ORecordOperation op : uResult) {
            ORecord record = op.getRecord();
            involvedClusters.add(this.getClusterNameById(record.getIdentity().getClusterId()));
        }
        return involvedClusters;
    }

    public void syncCommit(OTransactionData data) {
        OScenarioThreadLocal.executeAsDistributed(() -> {
            assert (!this.getTransaction().isActive());
            OTransactionOptimistic tx = new OTransactionOptimistic((ODatabaseDocumentInternal)this);
            data.fill((OTransactionInternal)tx, (ODatabaseDocumentInternal)this);
            ODistributedDatabaseImpl ddb = (ODistributedDatabaseImpl)this.getDistributedShared();
            ONewDistributedTxContextImpl txContext = new ONewDistributedTxContextImpl(ddb, new ODistributedRequestId(-1, -1L), (OTransactionInternal)tx, data.getTransactionId());
            ddb.validate(data.getTransactionId());
            ((OAbstractPaginatedStorage)this.getStorage().getUnderlying()).preallocateRids((OTransactionInternal)tx);
            txContext.commit((ODatabaseDocumentInternal)this);
            return null;
        });
    }

    public OTransactionResultPayload firstPhaseDDL(String query, OTransactionId preChangeId, OTransactionId afterChangeId, ODistributedRequestId requestId) {
        ODistributedDatabase localDistributedDatabase = this.getDistributedShared();
        ODDLContextImpl ddlContext = new ODDLContextImpl(query, preChangeId, afterChangeId, requestId);
        ValidationResult first = localDistributedDatabase.validate(preChangeId);
        ValidationResult second = localDistributedDatabase.validate(afterChangeId);
        if (!(first != ValidationResult.ALREADY_PROMISED && first != ValidationResult.MISSING_PREVIOUS || second != ValidationResult.ALREADY_PROMISED && second != ValidationResult.MISSING_PREVIOUS)) {
            ddlContext.setStatus(TxContextStatus.TIMEDOUT);
            return new OTxInvalidSequential();
        }
        if (first == ValidationResult.ALREADY_PRESENT || second == ValidationResult.ALREADY_PRESENT) {
            ddlContext.setStatus(TxContextStatus.TIMEDOUT);
            return new OTxInvalidSequential();
        }
        ddlContext.setStatus(TxContextStatus.SUCCESS);
        this.register(requestId, localDistributedDatabase, ddlContext);
        return new OTxSuccess();
    }

    public void secondPhaseDDL(ODistributedRequestId confirmSentRequest, boolean apply) {
        ODistributedDatabase localDistributedDatabase = this.getDistributedShared();
        ODDLContextImpl context = (ODDLContextImpl)localDistributedDatabase.popTxContext(confirmSentRequest);
        OAbstractPaginatedStorage storage = (OAbstractPaginatedStorage)this.getStorage().getUnderlying();
        if (apply) {
            ((ODistributedDatabaseImpl)localDistributedDatabase).resetLastValidBackup();
            if (context.getStatus() == TxContextStatus.SUCCESS) {
                OTxMetadataHolder preMetadata = localDistributedDatabase.commit(context.getPreChangeId());
                storage.metadataOnly(preMetadata.metadata());
                preMetadata.notifyMetadataRead();
                String query = context.getQuery();
                OScenarioThreadLocal.executeAsDistributed(() -> {
                    this.command(query, new Object[0]);
                    return null;
                });
                OTxMetadataHolder afterMetadata = localDistributedDatabase.commit(context.getAfterChangeId());
                storage.metadataOnly(afterMetadata.metadata());
                afterMetadata.notifyMetadataRead();
            } else {
                int nretry = this.getConfiguration().getValueAsInteger(OGlobalConfiguration.DISTRIBUTED_CONCURRENT_TX_MAX_AUTORETRY);
                int delay = this.getConfiguration().getValueAsInteger(OGlobalConfiguration.DISTRIBUTED_CONCURRENT_TX_AUTORETRY_DELAY);
                for (int i = 0; i < nretry; ++i) {
                    try {
                        if (i > 0) {
                            try {
                                Thread.sleep(new Random().nextInt(delay));
                            }
                            catch (InterruptedException e) {
                                OException.wrapException((OException)new OInterruptedException(e.getMessage()), (Throwable)e);
                            }
                        }
                        OTransactionResultPayload firstPhase = this.firstPhaseDDL(context.getQuery(), context.getPreChangeId(), context.getAfterChangeId(), context.getReqId());
                        context = (ODDLContextImpl)localDistributedDatabase.popTxContext(confirmSentRequest);
                        if (!(firstPhase instanceof OTxSuccess)) continue;
                    }
                    catch (Exception ex) {
                        OLogManager.instance().warn((Object)this, "Error beginning timed out transaction: %s ", (Throwable)ex, new Object[]{context.getReqId()});
                    }
                    break;
                }
                if (TxContextStatus.SUCCESS.equals((Object)context.getStatus())) {
                    try {
                        String query = context.getQuery();
                        OScenarioThreadLocal.executeAsDistributed(() -> {
                            this.command(query, new Object[0]);
                            return null;
                        });
                    }
                    catch (Error | RuntimeException e) {
                        Orient.instance().submit(() -> this.getDistributedManager().installDatabase(false, this.getName(), true, true));
                        throw e;
                    }
                } else {
                    ODistributedRequestId id = context.getReqId();
                    Orient.instance().submit(() -> {
                        OLogManager.instance().warn((Object)this, "Reached limit of retry for commit tx:%s forcing database re-install", new Object[]{id});
                        this.distributedManager.installDatabase(false, this.getName(), true, true);
                    });
                }
            }
        }
    }
}

