/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.orientechnologies.orient.core.serialization.OStreamable;
import com.orientechnologies.orient.core.storage.impl.local.OSyncSource;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;

public class ODistributedDatabaseChunk
implements OStreamable {
    public String filePath;
    public long offset;
    public byte[] buffer;
    public boolean gzipCompressed;
    public boolean last;
    public boolean incremental;
    public long walSegment;
    public int walPosition;

    public ODistributedDatabaseChunk() {
    }

    public ODistributedDatabaseChunk(OSyncSource backgroundBackup, int iMaxSize) throws IOException {
        this.filePath = "";
        this.gzipCompressed = false;
        this.incremental = backgroundBackup.getIncremental();
        this.walSegment = -1L;
        this.walPosition = -1;
        try {
            InputStream in = backgroundBackup.getInputStream();
            byte[] local = new byte[iMaxSize];
            int read = 0;
            read = in.read(local);
            if (read == -1) {
                this.buffer = new byte[0];
                this.last = true;
            } else {
                if (local.length == read) {
                    this.buffer = local;
                } else {
                    this.buffer = new byte[read];
                    System.arraycopy(local, 0, this.buffer, 0, read);
                }
                if (in.available() == 0 && backgroundBackup.getFinished().await(0L, TimeUnit.NANOSECONDS)) {
                    this.last = true;
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public ODistributedDatabaseChunk(File iFile, long iOffset, int iMaxSize, boolean gzipCompressed, boolean incremental) throws IOException {
        this(iFile, iOffset, iMaxSize, gzipCompressed, incremental, -1L, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODistributedDatabaseChunk(File iFile, long iOffset, int iMaxSize, boolean gzipCompressed, boolean incremental, long walSegment, int walPosition) throws IOException {
        this.filePath = iFile.getAbsolutePath();
        this.offset = iOffset;
        this.gzipCompressed = gzipCompressed;
        this.incremental = incremental;
        this.walSegment = walSegment;
        this.walPosition = walPosition;
        long fileSize = iFile.length();
        File completedFile = new File(iFile.getAbsolutePath() + ".completed");
        int retry = 0;
        while (fileSize <= iOffset) {
            if (fileSize == 0L || iOffset > fileSize) {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            fileSize = iFile.length();
            if (completedFile.exists()) break;
            ++retry;
        }
        int toRead = (int)Math.min((long)iMaxSize, fileSize - this.offset);
        this.buffer = new byte[toRead];
        InputStream in = gzipCompressed ? new GZIPInputStream(new FileInputStream(iFile)) : new FileInputStream(iFile);
        try {
            in.skip(this.offset);
            in.read(this.buffer);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        fileSize = iFile.length();
        if (completedFile.exists() && fileSize - (this.offset + (long)toRead) == 0L) {
            this.last = true;
        }
    }

    public String toString() {
        return this.filePath + "[" + this.offset + "-" + this.buffer.length + "] (last=" + this.last + ")";
    }

    public void toStream(DataOutput out) throws IOException {
        out.writeUTF(this.filePath);
        out.writeLong(this.offset);
        out.writeInt(this.buffer.length);
        out.write(this.buffer);
        out.writeBoolean(false);
        out.writeBoolean(this.gzipCompressed);
        out.writeBoolean(this.last);
        out.writeBoolean(this.incremental);
        out.writeLong(this.walSegment);
        out.writeInt(this.walPosition);
    }

    public void fromStream(DataInput in) throws IOException {
        this.filePath = in.readUTF();
        this.offset = in.readLong();
        int size = in.readInt();
        this.buffer = new byte[size];
        in.readFully(this.buffer);
        in.readBoolean();
        this.gzipCompressed = in.readBoolean();
        this.last = in.readBoolean();
        this.incremental = in.readBoolean();
        this.walSegment = in.readLong();
        this.walPosition = in.readInt();
    }

    public OLogSequenceNumber getLastWal() {
        return new OLogSequenceNumber(this.walSegment, this.walPosition);
    }
}

