/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.orientechnologies.common.concur.OOfflineNodeException;
import com.orientechnologies.common.concur.lock.OInterruptedException;
import com.orientechnologies.common.profiler.OAbstractProfiler;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.common.thread.OThreadPoolExecutors;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.OrientDBDistributed;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.OSyncSource;
import com.orientechnologies.orient.core.tx.OTransactionId;
import com.orientechnologies.orient.core.tx.OTransactionSequenceStatus;
import com.orientechnologies.orient.core.tx.OTxMetadataHolder;
import com.orientechnologies.orient.core.tx.ValidationResult;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedConfigurationManager;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ODistributedTxContext;
import com.orientechnologies.orient.server.distributed.OModifiableDistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ORemoteServerController;
import com.orientechnologies.orient.server.distributed.impl.ODistributedMessageServiceImpl;
import com.orientechnologies.orient.server.distributed.impl.ODistributedPlugin;
import com.orientechnologies.orient.server.distributed.impl.ODistributedSynchronizedSequence;
import com.orientechnologies.orient.server.distributed.impl.lock.OFreezeGuard;
import com.orientechnologies.orient.server.distributed.impl.lock.OLockGuard;
import com.orientechnologies.orient.server.distributed.impl.lock.OLockManager;
import com.orientechnologies.orient.server.distributed.impl.lock.OLockManagerImpl;
import com.orientechnologies.orient.server.distributed.impl.lock.OTxPromiseManager;
import com.orientechnologies.orient.server.distributed.impl.lock.OnLocksAcquired;
import com.orientechnologies.orient.server.distributed.impl.task.OLockKeySource;
import com.orientechnologies.orient.server.distributed.impl.task.OUnreachableServerLocalTask;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTransactionUniqueKey;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class ODistributedDatabaseImpl
implements ODistributedDatabase {
    public static final String DISTRIBUTED_SYNC_JSON_FILENAME = "distributed-sync.json";
    protected final ODistributedPlugin manager;
    protected final ODistributedMessageServiceImpl msgService;
    protected final String databaseName;
    private final String localNodeName;
    private final OTxPromiseManager<ORID> recordPromiseManager;
    private final OTxPromiseManager<Object> indexKeyPromiseManager;
    private final AtomicLong pending = new AtomicLong();
    private final ODistributedConfigurationManager configurationManager;
    protected Map<ODistributedRequestId, ODistributedTxContext> activeTxContexts = new ConcurrentHashMap<ODistributedRequestId, ODistributedTxContext>(64);
    private AtomicLong totalSentRequests = new AtomicLong();
    private AtomicLong totalReceivedRequests = new AtomicLong();
    private TimerTask txTimeoutTask = null;
    private volatile boolean running = true;
    private volatile boolean parsing = true;
    private AtomicLong operationsRunnig = new AtomicLong(0L);
    private ODistributedSynchronizedSequence sequenceManager;
    private ThreadPoolExecutor requestExecutor;
    private OLockManager lockManager = new OLockManagerImpl();
    private Set<OTransactionId> inQueue = Collections.newSetFromMap(new ConcurrentHashMap());
    private OSyncSource lastValidBackup;
    private volatile ODistributedServerManager.DB_STATUS freezePrevStatus;
    private OFreezeGuard freezeGuard;

    public ODistributedDatabaseImpl(ODistributedPlugin manager, ODistributedMessageServiceImpl msgService, String iDatabaseName, OServer server) {
        this.manager = manager;
        this.msgService = msgService;
        this.databaseName = iDatabaseName;
        this.localNodeName = manager.getLocalNodeName();
        this.configurationManager = new ODistributedConfigurationManager(manager, iDatabaseName);
        ODistributedDatabaseImpl prev = msgService.databases.put(iDatabaseName, this);
        if (prev != null) {
            prev.shutdown();
        }
        this.startAcceptingRequests();
        if (iDatabaseName.equals("OSystem")) {
            this.recordPromiseManager = null;
            this.indexKeyPromiseManager = null;
            return;
        }
        this.startTxTimeoutTimerTask();
        Orient.instance().getProfiler().registerHookValue("distributed.db." + this.databaseName + ".msgSent", "Number of replication messages sent from current node", OProfiler.METRIC_TYPE.COUNTER, new OAbstractProfiler.OProfilerHookValue(){

            public Object getValue() {
                return ODistributedDatabaseImpl.this.totalSentRequests.get();
            }
        }, "distributed.db.*.msgSent");
        Orient.instance().getProfiler().registerHookValue("distributed.db." + this.databaseName + ".msgReceived", "Number of replication messages received from external nodes", OProfiler.METRIC_TYPE.COUNTER, new OAbstractProfiler.OProfilerHookValue(){

            public Object getValue() {
                return ODistributedDatabaseImpl.this.totalReceivedRequests.get();
            }
        }, "distributed.db.*.msgReceived");
        Orient.instance().getProfiler().registerHookValue("distributed.db." + this.databaseName + ".activeContexts", "Number of active distributed transactions", OProfiler.METRIC_TYPE.COUNTER, new OAbstractProfiler.OProfilerHookValue(){

            public Object getValue() {
                return (long)ODistributedDatabaseImpl.this.activeTxContexts.size();
            }
        }, "distributed.db.*.activeContexts");
        Orient.instance().getProfiler().registerHookValue("distributed.db." + this.databaseName + ".workerThreads", "Number of worker threads", OProfiler.METRIC_TYPE.COUNTER, new OAbstractProfiler.OProfilerHookValue(){

            public Object getValue() {
                return (long)ODistributedDatabaseImpl.this.requestExecutor.getPoolSize();
            }
        }, "distributed.db.*.workerThreads");
        Orient.instance().getProfiler().registerHookValue("distributed.db." + this.databaseName + ".recordLocks", "Number of records locked", OProfiler.METRIC_TYPE.COUNTER, new OAbstractProfiler.OProfilerHookValue(){

            public Object getValue() {
                return ODistributedDatabaseImpl.this.recordPromiseManager.size() + ODistributedDatabaseImpl.this.indexKeyPromiseManager.size();
            }
        }, "distributed.db.*.recordLocks");
        long timeout = manager.getServerInstance().getContextConfiguration().getValueAsLong(OGlobalConfiguration.DISTRIBUTED_ATOMIC_LOCK_TIMEOUT);
        int sequenceSize = manager.getServerInstance().getContextConfiguration().getValueAsInteger(OGlobalConfiguration.DISTRIBUTED_TRANSACTION_SEQUENCE_SET_SIZE);
        this.recordPromiseManager = new OTxPromiseManager();
        this.indexKeyPromiseManager = new OTxPromiseManager();
        this.sequenceManager = new ODistributedSynchronizedSequence(this.localNodeName, sequenceSize);
    }

    public static boolean sendResponseBack(Object current, ODistributedServerManager manager, ODistributedRequestId iRequestId, Object responsePayload) {
        if (iRequestId.getMessageId() < 0L) {
            return true;
        }
        String local = manager.getLocalNodeName();
        String sender = manager.getNodeNameById(iRequestId.getNodeId());
        ODistributedResponse response = new ODistributedResponse(null, iRequestId, local, sender, responsePayload);
        try {
            ORemoteServerController remoteSenderServer = manager.getRemoteServer(sender);
            ODistributedServerLog.debug((Object)current, (String)local, (String)sender, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Sending response %s back (reqId=%s)", (Object[])new Object[]{response, iRequestId});
            remoteSenderServer.sendResponse(response);
        }
        catch (Exception e) {
            ODistributedServerLog.debug((Object)current, (String)local, (String)sender, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Error on sending response '%s' back (reqId=%s err=%s)", (Throwable)e, (Object[])new Object[]{response, iRequestId, e.toString()});
            return false;
        }
        return true;
    }

    public OTxPromiseManager<ORID> getRecordPromiseManager() {
        return this.recordPromiseManager;
    }

    public OTxPromiseManager<Object> getIndexKeyPromiseManager() {
        return this.indexKeyPromiseManager;
    }

    public void startOperation() {
        this.waitDistributedIsReady();
        this.operationsRunnig.incrementAndGet();
    }

    public void endOperation() {
        this.operationsRunnig.decrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForOnline() {
        try {
            ODistributedDatabaseImpl oDistributedDatabaseImpl = this;
            synchronized (oDistributedDatabaseImpl) {
                if (!this.parsing) {
                    this.wait(OGlobalConfiguration.DISTRIBUTED_MAX_STARTUP_DELAY.getValueAsLong());
                    if (!this.parsing) {
                        throw new OOfflineNodeException("Node is offline");
                    }
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void reEnqueue(int senderNodeId, long msgSequence, String databaseName, ORemoteTask payload, int retryCount, int autoRetryDelay) {
        this.pending.incrementAndGet();
        Orient.instance().scheduleTask(() -> {
            try {
                this.processRequest(new ODistributedRequest(this.getManager(), senderNodeId, msgSequence, databaseName, payload), false);
            }
            finally {
                this.pending.decrementAndGet();
            }
        }, (long)(autoRetryDelay * retryCount), 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequest(ODistributedRequest request, boolean waitForAcceptingRequests) {
        if (!this.running) {
            throw new ODistributedException("Server is going down or is removing the database:'" + this.getDatabaseName() + "' discarding");
        }
        ORemoteTask task = request.getTask();
        if (waitForAcceptingRequests) {
            this.waitIsReady(task);
            if (!this.running) {
                throw new ODistributedException("Server is going down or is removing the database:'" + this.getDatabaseName() + "' discarding");
            }
        }
        ODistributedDatabaseImpl oDistributedDatabaseImpl = this;
        synchronized (oDistributedDatabaseImpl) {
            task.received(request, (ODistributedDatabase)this);
            this.manager.messageReceived(request);
            this.totalReceivedRequests.incrementAndGet();
            if (task instanceof OLockKeySource) {
                SortedSet<ORID> rids = ((OLockKeySource)task).getRids();
                SortedSet<OTransactionUniqueKey> uniqueKeys = ((OLockKeySource)task).getUniqueKeys();
                OTransactionId txId = ((OLockKeySource)task).getTransactionId();
                OnLocksAcquired acquired = guards -> {
                    Runnable executeTask = () -> {
                        try {
                            this.execute(request);
                        }
                        finally {
                            this.lockManager.unlock(guards);
                        }
                    };
                    try {
                        this.requestExecutor.submit(executeTask);
                    }
                    catch (RejectedExecutionException e) {
                        task.finished((ODistributedDatabase)this);
                        this.lockManager.unlock(guards);
                        throw e;
                    }
                };
                try {
                    this.lockManager.lock(rids, uniqueKeys, txId, acquired);
                }
                catch (OOfflineNodeException e) {
                    task.finished((ODistributedDatabase)this);
                    throw e;
                }
            }
            try {
                this.requestExecutor.submit(() -> this.execute(request));
            }
            catch (RejectedExecutionException e) {
                task.finished((ODistributedDatabase)this);
                throw e;
            }
        }
    }

    public void trackTransactions(OTransactionId id) {
        this.inQueue.add(id);
    }

    public void untrackTransactions(OTransactionId id) {
        this.inQueue.remove(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(ODistributedRequest request) {
        ORemoteTask task = request.getTask();
        try {
            Object response;
            this.manager.messageProcessStart(request);
            if (task.isUsingDatabase()) {
                try (ODatabaseDocumentInternal db = this.manager.getServerInstance().getDatabases().openNoAuthorization(this.databaseName);){
                    response = this.manager.executeOnLocalNode(request.getId(), task, db);
                }
            } else {
                response = this.manager.executeOnLocalNode(request.getId(), task, null);
            }
            if (task.hasResponse()) {
                ODistributedDatabaseImpl.sendResponseBack(this, this.manager, request.getId(), response);
            }
            this.manager.messageProcessEnd(request, response);
        }
        finally {
            task.finished((ODistributedDatabase)this);
        }
    }

    public void waitIsReady(ORemoteTask task) {
        if (task.isNodeOnlineRequired()) {
            this.waitDistributedIsReady();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitDistributedIsReady() {
        ODistributedDatabaseImpl oDistributedDatabaseImpl = this;
        synchronized (oDistributedDatabaseImpl) {
            if (!this.parsing) {
                while (!this.parsing && this.running) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                        break;
                    }
                }
            }
        }
    }

    public void setOnline() {
        this.fillStatus();
        ODistributedServerLog.info((Object)this, (String)this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Publishing ONLINE status for database %s.%s...", (Object[])new Object[]{this.localNodeName, this.databaseName});
        this.manager.setDatabaseStatus(this.localNodeName, this.databaseName, ODistributedServerManager.DB_STATUS.ONLINE);
        this.resume();
    }

    public void fillStatus() {
        OAbstractPaginatedStorage storage = ((OrientDBDistributed)this.manager.getServerInstance().getDatabases()).getStorage(this.databaseName);
        if (storage != null) {
            this.sequenceManager.fill(storage.getLastMetadata());
        }
    }

    public void unlockResourcesOfServer(ODatabaseDocumentInternal database, String serverName) {
        int nodeLeftId = this.manager.getNodeIdByName(serverName);
        Iterator<ODistributedTxContext> pendingReqIterator = this.activeTxContexts.values().iterator();
        while (pendingReqIterator.hasNext()) {
            ODistributedTxContext pReq = pendingReqIterator.next();
            if (pReq == null || pReq.getReqId().getNodeId() != nodeLeftId) continue;
            ODistributedServerLog.debug((Object)this, (String)this.manager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction: rolling back transaction (req=%s)", (Object[])new Object[]{pReq.getReqId()});
            try {
                pReq.rollback(database);
                pReq.destroy();
            }
            catch (Error | Exception t) {
                ODistributedServerLog.error((Object)this, (String)this.manager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction: error on rolling back transaction (req=%s)", (Object[])new Object[]{pReq.getReqId()});
            }
            pendingReqIterator.remove();
        }
    }

    public ValidationResult validate(OTransactionId id) {
        return this.sequenceManager.validateTransactionId(id);
    }

    public OTxMetadataHolder commit(OTransactionId id) {
        return this.sequenceManager.notifySuccess(id);
    }

    public void rollback(OTransactionId id) {
        this.sequenceManager.notifyFailure(id);
    }

    public ODistributedTxContext registerTxContext(ODistributedRequestId reqId, ODistributedTxContext ctx) {
        ODistributedTxContext prevCtx = this.activeTxContexts.put(reqId, ctx);
        if (prevCtx != ctx && prevCtx != null) {
            prevCtx.destroy();
        }
        return ctx;
    }

    public Optional<OTransactionId> nextId() {
        return this.sequenceManager.next();
    }

    public List<OTransactionId> missingTransactions(OTransactionSequenceStatus lastState) {
        return this.sequenceManager.missingTransactions(lastState);
    }

    public ODistributedTxContext popTxContext(ODistributedRequestId requestId) {
        ODistributedTxContext ctx = this.activeTxContexts.remove(requestId);
        ODistributedServerLog.debug((Object)this, (String)this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction: pop request %s for database %s -> %s", (Object[])new Object[]{requestId, this.databaseName, ctx});
        return ctx;
    }

    public ODistributedTxContext getTxContext(ODistributedRequestId requestId) {
        ODistributedTxContext ctx = this.activeTxContexts.get(requestId);
        ODistributedServerLog.debug((Object)this, (String)this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction: pop request %s for database %s -> %s", (Object[])new Object[]{requestId, this.databaseName, ctx});
        return ctx;
    }

    public ODistributedServerManager getManager() {
        return this.manager;
    }

    public boolean exists() {
        return this.manager.getServerInstance().existsDatabase(this.databaseName);
    }

    public void handleUnreachableNode(String nodeName) {
        if (!this.running) {
            return;
        }
        ODistributedServerLog.debug((Object)this, (String)this.manager.getLocalNodeName(), (String)nodeName, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Distributed transaction: rolling back all the pending transactions coordinated by the unreachable server '%s'", (Object[])new Object[]{nodeName});
        OUnreachableServerLocalTask task = new OUnreachableServerLocalTask(nodeName);
        ODistributedRequest rollbackRequest = new ODistributedRequest(null, this.manager.getLocalNodeId(), this.manager.getNextMessageIdCounter(), null, (ORemoteTask)task);
        this.processRequest(rollbackRequest, false);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public ODatabaseDocumentInternal getDatabaseInstance() {
        return this.manager.getServerInstance().getDatabases().openNoAuthorization(this.databaseName);
    }

    public long getReceivedRequests() {
        return this.totalReceivedRequests.get();
    }

    public long getProcessedRequests() {
        return this.requestExecutor.getCompletedTaskCount();
    }

    public void onDropShutdown() {
        this.shutdown(false);
    }

    public void shutdown() {
        this.shutdown(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean wait) {
        this.waitPending();
        this.running = false;
        try {
            if (this.txTimeoutTask != null) {
                this.txTimeoutTask.cancel();
            }
            this.requestExecutor.shutdown();
            if (wait) {
                try {
                    this.requestExecutor.awaitTermination(1L, TimeUnit.MINUTES);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.activeTxContexts.clear();
            Orient.instance().getProfiler().unregisterHookValue("distributed.db." + this.databaseName + ".msgSent");
            Orient.instance().getProfiler().unregisterHookValue("distributed.db." + this.databaseName + ".msgReceived");
            Orient.instance().getProfiler().unregisterHookValue("distributed.db." + this.databaseName + ".activeContexts");
            Orient.instance().getProfiler().unregisterHookValue("distributed.db." + this.databaseName + ".workerThreads");
            Orient.instance().getProfiler().unregisterHookValue("distributed.db." + this.databaseName + ".recordLocks");
        }
        finally {
            ODistributedServerManager.DB_STATUS serverStatus = this.manager.getDatabaseStatus(this.manager.getLocalNodeName(), this.databaseName);
            if (serverStatus == ODistributedServerManager.DB_STATUS.ONLINE || serverStatus == ODistributedServerManager.DB_STATUS.SYNCHRONIZING) {
                try {
                    this.manager.setDatabaseStatus(this.manager.getLocalNodeName(), this.databaseName, ODistributedServerManager.DB_STATUS.NOT_AVAILABLE);
                }
                catch (Exception exception) {}
            }
        }
    }

    private void waitPending() {
        while (this.pending.get() > 0L) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    public void checkNodeInConfiguration(final String serverName, ODistributedConfiguration cfg) {
        this.manager.executeInDistributedDatabaseLock(this.databaseName, 20000L, cfg != null ? cfg.modify() : null, new OCallable<Void, OModifiableDistributedConfiguration>(){

            public Void call(OModifiableDistributedConfiguration lastCfg) {
                List foundPartition = lastCfg.addNewNodeInServerList(serverName);
                if (foundPartition != null) {
                    ODistributedServerLog.info((Object)this, (String)ODistributedDatabaseImpl.this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Adding node '%s' in partition: %s db=%s v=%d", (Object[])new Object[]{serverName, foundPartition, ODistributedDatabaseImpl.this.databaseName, lastCfg.getVersion()});
                }
                return null;
            }
        });
    }

    public void checkNodeInConfiguration(String serverName) {
        ODistributedConfiguration cfg = this.getDistributedConfiguration();
        this.checkNodeInConfiguration(serverName, cfg);
    }

    protected String getLocalNodeName() {
        return this.localNodeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAcceptingRequests() {
        int totalWorkers = OGlobalConfiguration.DISTRIBUTED_DB_WORKERTHREADS.getValueAsInteger();
        if (totalWorkers < 0) {
            throw new ODistributedException("Cannot create configured distributed workers (" + totalWorkers + ")");
        }
        if (totalWorkers == 0) {
            int totalDatabases = this.manager.getManagedDatabases().size() + 1;
            int cpus = Runtime.getRuntime().availableProcessors();
            if (cpus > 1) {
                totalWorkers = cpus / totalDatabases;
            }
            if (totalWorkers == 0) {
                totalWorkers = 1;
            }
        }
        ODistributedDatabaseImpl oDistributedDatabaseImpl = this;
        synchronized (oDistributedDatabaseImpl) {
            this.requestExecutor = (ThreadPoolExecutor)OThreadPoolExecutors.newScalingThreadPool((String)String.format("OrientDB DistributedWorker node=%s db=%s", this.getLocalNodeName(), this.databaseName), (int)0, (int)totalWorkers, (int)0, (long)1L, (TimeUnit)TimeUnit.HOURS);
        }
    }

    private void startTxTimeoutTimerTask() {
        this.txTimeoutTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ODatabaseDocumentInternal database = null;
                try {
                    long now = System.currentTimeMillis();
                    long timeout = OGlobalConfiguration.DISTRIBUTED_TX_EXPIRE_TIMEOUT.getValueAsLong();
                    Iterator<ODistributedTxContext> it = ODistributedDatabaseImpl.this.activeTxContexts.values().iterator();
                    while (it.hasNext()) {
                        long started;
                        long elapsed;
                        if (!ODistributedDatabaseImpl.this.isRunning()) {
                            break;
                        }
                        ODistributedTxContext ctx = it.next();
                        if (ctx == null || (elapsed = now - (started = ctx.getStartedOn())) <= timeout) continue;
                        if (database == null) {
                            database = ODistributedDatabaseImpl.this.getDatabaseInstance();
                        }
                        ODistributedServerLog.debug((Object)this, (String)ODistributedDatabaseImpl.this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction %s on database '%s' is expired after %dms", (Object[])new Object[]{ctx.getReqId(), ODistributedDatabaseImpl.this.databaseName, elapsed});
                        if (database != null) {
                            database.activateOnCurrentThread();
                        }
                        try {
                            ctx.cancel((ODistributedServerManager)ODistributedDatabaseImpl.this.manager, database);
                            if (ctx.getReqId().getNodeId() != ODistributedDatabaseImpl.this.manager.getLocalNodeId()) continue;
                            ODistributedDatabaseImpl.this.msgService.timeoutRequest(ctx.getReqId().getMessageId());
                        }
                        catch (Exception t) {
                            ODistributedServerLog.info((Object)this, (String)ODistributedDatabaseImpl.this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on rolling back distributed transaction %s on database '%s' (err=%s)", (Object[])new Object[]{ctx.getReqId(), ODistributedDatabaseImpl.this.databaseName, t});
                        }
                        finally {
                            it.remove();
                        }
                    }
                }
                catch (Exception t) {
                    ODistributedServerLog.info((Object)this, (String)ODistributedDatabaseImpl.this.localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on checking for expired distributed transaction on database '%s'", (Object[])new Object[]{ODistributedDatabaseImpl.this.databaseName});
                }
                finally {
                    if (database != null) {
                        database.activateOnCurrentThread();
                        database.close();
                    }
                }
            }
        };
    }

    private boolean isRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        boolean parsing;
        ODistributedDatabaseImpl oDistributedDatabaseImpl = this;
        synchronized (oDistributedDatabaseImpl) {
            parsing = this.parsing;
            this.parsing = false;
        }
        if (parsing) {
            while (this.operationsRunnig.get() != 0L) {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            this.recordPromiseManager.reset();
            this.indexKeyPromiseManager.reset();
        }
        LinkedBlockingQueue latch = new LinkedBlockingQueue(1);
        this.lockManager.freeze(guards -> {
            try {
                latch.put(guards);
            }
            catch (InterruptedException e) {
                throw new OInterruptedException(e.getMessage());
            }
        });
        try {
            this.freezeGuard = (OFreezeGuard)latch.take();
        }
        catch (InterruptedException e) {
            throw new OInterruptedException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        ODistributedDatabaseImpl oDistributedDatabaseImpl = this;
        synchronized (oDistributedDatabaseImpl) {
            this.parsing = true;
            this.notifyAll();
        }
        if (this.freezeGuard != null) {
            this.freezeGuard.release();
        }
    }

    public String dump() {
        StringBuilder buffer = new StringBuilder(1024);
        buffer.append("\n\nDATABASE '" + this.databaseName + "' ON SERVER '" + this.manager.getLocalNodeName() + "'");
        buffer.append("\n- MESSAGES IN QUEUES");
        buffer.append(" (" + this.requestExecutor.getPoolSize() + " WORKERS):");
        return buffer.toString();
    }

    public Map<ODistributedRequestId, ODistributedTxContext> getActiveTxContexts() {
        return this.activeTxContexts;
    }

    public void validateStatus(OTransactionSequenceStatus status) {
        List<OTransactionId> res = this.sequenceManager.checkSelfStatus(status);
        res.removeAll(this.inQueue);
        if (!res.isEmpty()) {
            Orient.instance().submit(() -> this.manager.installDatabase(false, this.databaseName, true, true));
        }
    }

    public Optional<OTransactionSequenceStatus> status() {
        if (this.sequenceManager == null) {
            return Optional.empty();
        }
        return Optional.of(this.sequenceManager.currentStatus());
    }

    public void checkReverseSync(OTransactionSequenceStatus lastState) {
        List<OTransactionId> res = this.sequenceManager.checkSelfStatus(lastState);
        if (!res.isEmpty()) {
            new Thread(() -> this.manager.installDatabase(false, this.databaseName, true, true)).start();
        }
    }

    public List<OLockGuard> localLock(OLockKeySource keySource) {
        SortedSet<ORID> rids = keySource.getRids();
        SortedSet<OTransactionUniqueKey> uniqueKeys = keySource.getUniqueKeys();
        OTransactionId txId = keySource.getTransactionId();
        LinkedBlockingQueue latch = new LinkedBlockingQueue(1);
        this.lockManager.lock(rids, uniqueKeys, txId, guards -> {
            try {
                latch.put(guards);
            }
            catch (InterruptedException e) {
                throw new OInterruptedException(e.getMessage());
            }
        });
        try {
            return (List)latch.take();
        }
        catch (InterruptedException e) {
            throw new OInterruptedException(e.getMessage());
        }
    }

    public void localUnlock(List<OLockGuard> guards) {
        this.lockManager.unlock(guards);
    }

    public ODistributedConfiguration getDistributedConfiguration() {
        return this.configurationManager.getDistributedConfiguration();
    }

    public void setDistributedConfiguration(OModifiableDistributedConfiguration distributedConfiguration) {
        this.configurationManager.setDistributedConfiguration(distributedConfiguration);
    }

    public OSyncSource getLastValidBackup() {
        return this.lastValidBackup;
    }

    public void setLastValidBackup(OSyncSource lastValidBackup) {
        this.lastValidBackup = lastValidBackup;
    }

    public void resetLastValidBackup() {
        if (this.lastValidBackup != null) {
            this.lastValidBackup.invalidate();
        }
    }

    public void clearLastValidBackup() {
        if (this.lastValidBackup != null) {
            this.lastValidBackup = null;
        }
    }

    public void saveDatabaseConfiguration() {
        this.configurationManager.saveDatabaseConfiguration();
    }

    public synchronized void freezeStatus() {
        String localNode = this.manager.getLocalNodeName();
        this.freezePrevStatus = this.manager.getDatabaseStatus(localNode, this.databaseName);
        if (this.freezePrevStatus == ODistributedServerManager.DB_STATUS.ONLINE) {
            this.manager.setDatabaseStatus(localNode, this.databaseName, ODistributedServerManager.DB_STATUS.BACKUP);
        }
    }

    public synchronized void releaseStatus() {
        if (this.freezePrevStatus != null) {
            String localNode = this.manager.getLocalNodeName();
            this.manager.setDatabaseStatus(localNode, this.databaseName, this.freezePrevStatus);
        }
    }

    public void incSentRequest() {
        this.totalSentRequests.incrementAndGet();
    }

    public Set<String> getAvailableNodesButLocal(Set<String> involvedClusters) {
        Set nodes = this.getDistributedConfiguration().getServers(involvedClusters);
        nodes.remove(this.localNodeName);
        return nodes;
    }
}

