/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.Member;
import com.orientechnologies.common.concur.OOfflineNodeException;
import com.orientechnologies.common.concur.lock.OInterruptedException;
import com.orientechnologies.common.console.ODefaultConsoleReader;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OAnsiCode;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.common.util.OArrays;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.core.OConstants;
import com.orientechnologies.orient.core.OSignalHandler;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.ODatabaseLifecycleListener;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OScenarioThreadLocal;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.db.OrientDBDistributed;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.schema.OView;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.disk.OLocalPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.tx.OTxMetadataHolder;
import com.orientechnologies.orient.core.tx.OTxMetadataHolderImpl;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerConfiguration;
import com.orientechnologies.orient.server.config.OServerHandlerConfiguration;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedLifecycleListener;
import com.orientechnologies.orient.server.distributed.ODistributedLockManager;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedResponseManager;
import com.orientechnologies.orient.server.distributed.ODistributedResponseManagerFactory;
import com.orientechnologies.orient.server.distributed.ODistributedResponseManagerImpl;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ODistributedStartupException;
import com.orientechnologies.orient.server.distributed.ODistributedStrategy;
import com.orientechnologies.orient.server.distributed.OModifiableDistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ORemoteServerAvailabilityCheck;
import com.orientechnologies.orient.server.distributed.ORemoteServerController;
import com.orientechnologies.orient.server.distributed.ORemoteServerManager;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactoryManager;
import com.orientechnologies.orient.server.distributed.impl.OClusterHealthChecker;
import com.orientechnologies.orient.server.distributed.impl.OClusterOwnershipAssignmentStrategy;
import com.orientechnologies.orient.server.distributed.impl.ODefaultClusterOwnershipAssignmentStrategy;
import com.orientechnologies.orient.server.distributed.impl.ODefaultDistributedStrategy;
import com.orientechnologies.orient.server.distributed.impl.ODistributedDatabaseChunk;
import com.orientechnologies.orient.server.distributed.impl.ODistributedDatabaseImpl;
import com.orientechnologies.orient.server.distributed.impl.ODistributedMessageServiceImpl;
import com.orientechnologies.orient.server.distributed.impl.ODistributedOutput;
import com.orientechnologies.orient.server.distributed.impl.ONewDeltaSyncImporter;
import com.orientechnologies.orient.server.distributed.impl.OSyncReceiver;
import com.orientechnologies.orient.server.distributed.impl.task.ODropDatabaseTask;
import com.orientechnologies.orient.server.distributed.impl.task.ONewDeltaTaskResponse;
import com.orientechnologies.orient.server.distributed.impl.task.ORemoteTaskFactoryManagerImpl;
import com.orientechnologies.orient.server.distributed.impl.task.OSyncDatabaseNewDeltaTask;
import com.orientechnologies.orient.server.distributed.impl.task.OSyncDatabaseTask;
import com.orientechnologies.orient.server.distributed.impl.task.OUpdateDatabaseConfigurationTask;
import com.orientechnologies.orient.server.distributed.sql.OCommandExecutorSQLHASyncCluster;
import com.orientechnologies.orient.server.distributed.task.ODatabaseIsOldException;
import com.orientechnologies.orient.server.distributed.task.ODistributedDatabaseDeltaSyncException;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import com.orientechnologies.orient.server.hazelcast.OHazelcastClusterMetadataManager;
import com.orientechnologies.orient.server.network.OServerNetworkListener;
import com.orientechnologies.orient.server.plugin.OServerPluginAbstract;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import sun.misc.Signal;

public class ODistributedPlugin
extends OServerPluginAbstract
implements ODistributedServerManager,
ODatabaseLifecycleListener,
OCommandOutputListener {
    public static final String REPLICATOR_USER = "_CrossServerTempUser";
    protected static final String PAR_DEF_DISTRIB_DB_CONFIG = "configuration.db.default";
    protected static final String NODE_NAME_ENV = "ORIENTDB_NODE_NAME";
    private OServer serverInstance;
    private String nodeName = null;
    protected File defaultDatabaseConfigFile;
    protected List<ODistributedLifecycleListener> listeners = new ArrayList<ODistributedLifecycleListener>();
    protected ORemoteServerManager remoteServerManager;
    protected AtomicLong localMessageIdCounter = new AtomicLong();
    protected OClusterOwnershipAssignmentStrategy clusterAssignmentStrategy = new ODefaultClusterOwnershipAssignmentStrategy(this);
    protected static final int DEPLOY_DB_MAX_RETRIES = 10;
    protected Set<String> installingDatabases = Collections.newSetFromMap(new ConcurrentHashMap());
    protected volatile ODistributedMessageServiceImpl messageService;
    protected Date startedOn = new Date();
    protected ODistributedStrategy responseManagerFactory = new ODefaultDistributedStrategy();
    protected ORemoteTaskFactoryManager taskFactoryManager = new ORemoteTaskFactoryManagerImpl(this);
    private volatile String lastServerDump = "";
    protected CountDownLatch serverStarted = new CountDownLatch(1);
    private TimerTask haStatsTask = null;
    private TimerTask healthCheckerTask = null;
    protected OSignalHandler.OSignalListener signalListener;
    private final OHazelcastClusterMetadataManager clusterManager = new OHazelcastClusterMetadataManager(this);

    protected ODistributedPlugin() {
    }

    public void waitUntilNodeOnline() throws InterruptedException {
        this.serverStarted.await();
    }

    public void waitUntilNodeOnline(String nodeName, String databaseName) throws InterruptedException {
        while (this.messageService == null || this.messageService.getDatabase(databaseName) == null || !this.isNodeOnline(nodeName, databaseName)) {
            Thread.sleep(100L);
        }
    }

    public ODatabaseLifecycleListener.PRIORITY getPriority() {
        return ODatabaseLifecycleListener.PRIORITY.LAST;
    }

    public void config(OServer oServer, OServerParameterConfiguration[] iParams) {
        this.serverInstance = oServer;
        oServer.setVariable("ODistributedAbstractPlugin", (Object)this);
        for (OServerParameterConfiguration param : iParams) {
            if (param.name.equalsIgnoreCase("enabled")) {
                if (Boolean.parseBoolean(OSystemVariableResolver.resolveSystemVariables((String)param.value))) continue;
                this.enabled = false;
                return;
            }
            if (param.name.equalsIgnoreCase("nodeName")) {
                this.nodeName = param.value;
                if (!this.nodeName.contains(".")) continue;
                throw new OConfigurationException("Illegal node name '" + this.nodeName + "'. '.' is not allowed in node name");
            }
            if (!param.name.startsWith(PAR_DEF_DISTRIB_DB_CONFIG)) continue;
            this.setDefaultDatabaseConfigFile(param.value);
        }
        this.remoteServerManager = new ORemoteServerManager(this.nodeName, new ORemoteServerAvailabilityCheck(){

            public boolean isNodeAvailable(String node) {
                return ODistributedPlugin.this.isNodeAvailable(node);
            }

            public void nodeDisconnected(String node) {
                ODistributedPlugin.this.removeServer(node, true);
            }
        });
        if (this.nodeName == null) {
            this.assignNodeName();
        }
        this.clusterManager.configHazelcastPlugin(oServer, iParams, this.nodeName);
    }

    @Deprecated
    public String getCoordinatorServer() {
        return "";
    }

    public File getDefaultDatabaseConfigFile() {
        return this.defaultDatabaseConfigFile;
    }

    public ODistributedLockManager getLockManagerRequester() {
        return this.clusterManager.getLockManagerRequester();
    }

    public ODistributedLockManager getLockManagerExecutor() {
        return this.clusterManager.getLockManagerExecutor();
    }

    public <T> T executeInDistributedDatabaseLock(String databaseName, long timeoutLocking, OModifiableDistributedConfiguration lastCfg, OCallable<T, OModifiableDistributedConfiguration> iCallback) {
        return this.clusterManager.executeInDistributedDatabaseLock(databaseName, timeoutLocking, lastCfg, iCallback);
    }

    public boolean isWriteQuorumPresent(String databaseName) {
        return this.clusterManager.isWriteQuorumPresent(databaseName);
    }

    public void setDefaultDatabaseConfigFile(String iFile) {
        this.defaultDatabaseConfigFile = new File(OSystemVariableResolver.resolveSystemVariables((String)iFile));
        if (!this.defaultDatabaseConfigFile.exists()) {
            throw new OConfigurationException("Cannot find distributed database config file: " + this.defaultDatabaseConfigFile);
        }
    }

    public void startup() {
        if (!this.enabled) {
            return;
        }
        if (this.serverInstance.getDatabases() instanceof OrientDBDistributed) {
            ((OrientDBDistributed)this.serverInstance.getDatabases()).setPlugin(this);
        }
        OGlobalConfiguration.STORAGE_TRACK_CHANGED_RECORDS_IN_WAL.setValue((Object)true);
        this.serverInstance.addTemporaryUser(REPLICATOR_USER, "" + new SecureRandom().nextLong(), "*");
        Orient.instance().addDbLifecycleListener((ODatabaseLifecycleListener)this);
        this.remoteServerManager.closeAll();
        this.messageService = new ODistributedMessageServiceImpl(this);
        try {
            long healthChecker;
            this.clusterManager.startupHazelcastPlugin();
            long statsDelay = OGlobalConfiguration.DISTRIBUTED_DUMP_STATS_EVERY.getValueAsLong();
            if (statsDelay > 0L) {
                this.haStatsTask = Orient.instance().scheduleTask(this::dumpStats, statsDelay, statsDelay);
            }
            if ((healthChecker = OGlobalConfiguration.DISTRIBUTED_CHECK_HEALTH_EVERY.getValueAsLong()) > 0L) {
                this.healthCheckerTask = Orient.instance().scheduleTask((Runnable)new OClusterHealthChecker(this, healthChecker), healthChecker, healthChecker);
            }
            this.signalListener = new OSignalHandler.OSignalListener(){

                public void onSignal(Signal signal) {
                    if (signal.toString().trim().equalsIgnoreCase("SIGTRAP")) {
                        ODistributedPlugin.this.dumpStats();
                    }
                }
            };
            Orient.instance().getSignalHandler().registerListener(this.signalListener);
        }
        catch (Exception e) {
            ODistributedServerLog.error((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on starting distributed plugin", (Throwable)e, (Object[])new Object[0]);
            throw OException.wrapException((OException)new ODistributedStartupException("Error on starting distributed plugin"), (Throwable)e);
        }
        this.dumpServersStatus();
    }

    public ODistributedPlugin registerLifecycleListener(ODistributedLifecycleListener iListener) {
        if (iListener == null) {
            throw new NullPointerException();
        }
        this.listeners.add(iListener);
        return this;
    }

    public ODistributedPlugin unregisterLifecycleListener(ODistributedLifecycleListener iListener) {
        this.listeners.remove(iListener);
        return this;
    }

    public void shutdown() {
        if (!this.enabled) {
            return;
        }
        OSignalHandler signalHandler = Orient.instance().getSignalHandler();
        if (signalHandler != null) {
            signalHandler.unregisterListener(this.signalListener);
        }
        OLogManager.instance().warn((Object)this, "Shutting down node '%s'...", new Object[]{this.nodeName});
        this.setNodeStatus(ODistributedServerManager.NODE_STATUS.SHUTTINGDOWN);
        this.clusterManager.prepareHazelcastPluginShutdown();
        try {
            if (this.healthCheckerTask != null) {
                this.healthCheckerTask.cancel();
            }
            if (this.haStatsTask != null) {
                this.haStatsTask.cancel();
            }
            this.remoteServerManager.closeAll();
            if (this.messageService != null) {
                this.messageService.shutdown();
            }
            this.setNodeStatus(ODistributedServerManager.NODE_STATUS.OFFLINE);
            Orient.instance().removeDbLifecycleListener((ODatabaseLifecycleListener)this);
        }
        catch (HazelcastInstanceNotActiveException hazelcastInstanceNotActiveException) {
            // empty catch block
        }
        this.clusterManager.hazelcastPluginShutdown();
    }

    public void onOpen(ODatabaseInternal iDatabase) {
    }

    public void registerNewDatabaseIfNeeded(String dbName) {
        ODistributedDatabaseImpl distribDatabase = this.getMessageService().getDatabase(dbName);
        if (distribDatabase == null) {
            distribDatabase = this.messageService.registerDatabase(dbName);
            distribDatabase.checkNodeInConfiguration(this.getLocalNodeName());
            distribDatabase.resume();
            distribDatabase.setOnline();
        }
    }

    public void onClose(ODatabaseInternal iDatabase) {
    }

    public void onDrop(ODatabaseInternal iDatabase) {
        if (!this.isRelatedToLocalServer(iDatabase)) {
            return;
        }
        String dbName = iDatabase.getName();
        ODistributedServerLog.info((Object)((Object)this), (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Dropping database %s...", (Object[])new Object[]{dbName});
        ODistributedMessageServiceImpl msgService = this.getMessageService();
        if (msgService != null) {
            msgService.unregisterDatabase(iDatabase.getName());
        }
        this.clusterManager.removeDbFromClusterMetadata(iDatabase);
    }

    public void dropOnAllServers(String dbName) {
        Set<String> servers = this.clusterManager.dropDbFromConfiguration(dbName);
        if (!servers.isEmpty() && this.messageService.getDatabase(dbName) != null) {
            this.sendRequest(dbName, null, servers, (ORemoteTask)new ODropDatabaseTask(), this.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null);
        }
    }

    public void dropConfig(String dbName) {
        this.clusterManager.dropDatabaseConfiguration(dbName);
    }

    public void onDropClass(ODatabaseInternal iDatabase, OClass iClass) {
    }

    public String getName() {
        return "cluster";
    }

    public void sendShutdown() {
        this.shutdown();
    }

    public OServer getServerInstance() {
        return this.serverInstance;
    }

    public ODocument getLocalNodeConfiguration() {
        ODocument nodeCfg = new ODocument();
        nodeCfg.setTrackingChanges(false);
        nodeCfg.field("id", (Object)this.getLocalNodeId());
        nodeCfg.field("uuid", (Object)this.clusterManager.getLocalNodeUuid());
        nodeCfg.field("name", (Object)this.nodeName);
        nodeCfg.field("version", (Object)OConstants.getRawVersion());
        nodeCfg.field("publicAddress", (Object)this.clusterManager.getPublicAddress());
        nodeCfg.field("startedOn", (Object)this.startedOn);
        nodeCfg.field("status", (Object)this.getNodeStatus());
        nodeCfg.field("connections", (Object)this.serverInstance.getClientConnectionManager().getTotal());
        ArrayList listeners = new ArrayList();
        nodeCfg.field("listeners", listeners, new OType[]{OType.EMBEDDEDLIST});
        for (OServerNetworkListener listener : this.serverInstance.getNetworkListeners()) {
            HashMap<String, String> listenerCfg = new HashMap<String, String>();
            listeners.add(listenerCfg);
            listenerCfg.put("protocol", listener.getProtocolType().getSimpleName());
            listenerCfg.put("listen", listener.getListeningAddress(true));
        }
        OSecurityUser user = this.serverInstance.getSecurity().getUser(REPLICATOR_USER);
        if (user != null) {
            nodeCfg.field("user_replicator", (Object)this.serverInstance.getSecurity().getUser(REPLICATOR_USER).getPassword());
        }
        nodeCfg.field("databases", this.getManagedDatabases());
        long maxMem = Runtime.getRuntime().maxMemory();
        long totMem = Runtime.getRuntime().totalMemory();
        long freeMem = Runtime.getRuntime().freeMemory();
        long usedMem = totMem - freeMem;
        nodeCfg.field("usedMemory", (Object)usedMem);
        nodeCfg.field("freeMemory", (Object)freeMem);
        nodeCfg.field("maxMemory", (Object)maxMem);
        nodeCfg.field("latencies", (Object)this.getMessageService().getLatencies(), new OType[]{OType.EMBEDDED});
        nodeCfg.field("messages", (Object)this.getMessageService().getMessageStats(), new OType[]{OType.EMBEDDED});
        Iterator it = Orient.instance().getDbLifecycleListeners();
        while (it.hasNext()) {
            ODatabaseLifecycleListener listener = (ODatabaseLifecycleListener)it.next();
            if (listener == null) continue;
            listener.onLocalNodeConfigurationRequest(nodeCfg);
        }
        return nodeCfg;
    }

    public ODistributedConfiguration getDatabaseConfiguration(String iDatabaseName) {
        return this.clusterManager.getDatabaseConfiguration(iDatabaseName);
    }

    public ODistributedConfiguration getDatabaseConfiguration(String iDatabaseName, boolean createIfNotPresent) {
        return this.clusterManager.getDatabaseConfiguration(iDatabaseName, createIfNotPresent);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public ODistributedResponse sendRequest(String iDatabaseName, Collection<String> iClusterNames, Collection<String> iTargetNodes, ORemoteTask iTask, long reqId, ODistributedRequest.EXECUTION_MODE iExecutionMode, Object localResult) {
        return this.sendRequest(iDatabaseName, iClusterNames, iTargetNodes, iTask, reqId, iExecutionMode, localResult, null);
    }

    public ODistributedResponse sendRequest(String iDatabaseName, Collection<String> iClusterNames, Collection<String> iTargetNodes, ORemoteTask iTask, long reqId, ODistributedRequest.EXECUTION_MODE iExecutionMode, Object localResult, ODistributedResponseManagerFactory responseManagerFactory) {
        ODistributedRequest req = new ODistributedRequest((ODistributedServerManager)this, this.getLocalNodeId(), reqId, iDatabaseName, iTask);
        ODatabaseDocumentInternal currentDatabase = ODatabaseRecordThreadLocal.instance().getIfDefined();
        if (currentDatabase != null && currentDatabase.getUser() != null && currentDatabase.getUser().getIdentity().getIdentity().isValid()) {
            req.setUserRID((ORecordId)currentDatabase.getUser().getIdentity().getIdentity());
        }
        if (iTargetNodes == null || iTargetNodes.isEmpty()) {
            ODistributedServerLog.error((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"No nodes configured for partition '%s.%s' request: %s", (Object[])new Object[]{iDatabaseName, iClusterNames, req});
            throw new ODistributedException("No nodes configured '" + iDatabaseName + "." + iClusterNames + "' request: " + req);
        }
        this.messageService.updateMessageStats(iTask.getName());
        if (responseManagerFactory != null) {
            return this.send2Nodes(req, iClusterNames, iTargetNodes, iExecutionMode, localResult, responseManagerFactory);
        }
        return this.send2Nodes(req, iClusterNames, iTargetNodes, iExecutionMode, localResult);
    }

    protected void checkForServerOnline(ODistributedRequest iRequest) throws ODistributedException {
        ODistributedServerManager.NODE_STATUS srvStatus = this.getNodeStatus();
        if (srvStatus == ODistributedServerManager.NODE_STATUS.OFFLINE || srvStatus == ODistributedServerManager.NODE_STATUS.SHUTTINGDOWN) {
            ODistributedServerLog.error((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Local server is not online (status='%s'). Request %s will be ignored", (Object[])new Object[]{srvStatus, iRequest});
            throw new OOfflineNodeException("Local server is not online (status='" + srvStatus + "'). Request " + iRequest + " will be ignored");
        }
    }

    public ODistributedResponse send2Nodes(ODistributedRequest iRequest, Collection<String> iClusterNames, Collection<String> iNodes, ODistributedRequest.EXECUTION_MODE iExecutionMode, Object localResult, ODistributedResponseManagerFactory responseManagerFactory) {
        try {
            ODistributedDatabaseImpl shared;
            int onlineMasters;
            Set<String> nodesConcurToTheQuorum;
            ODistributedConfiguration cfg;
            this.checkForServerOnline(iRequest);
            String databaseName = iRequest.getDatabaseName();
            if (iNodes.isEmpty()) {
                ODistributedServerLog.error((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"No nodes configured for database '%s' request: %s", (Object[])new Object[]{databaseName, iRequest});
                throw new ODistributedException("No nodes configured for partition '" + databaseName + "' request: " + iRequest);
            }
            ORemoteTask task = iRequest.getTask();
            boolean checkNodesAreOnline = task.isNodeOnlineRequired();
            int availableNodes = iNodes.size();
            if (databaseName != null) {
                cfg = this.getDatabaseConfiguration(databaseName);
                nodesConcurToTheQuorum = this.getDistributedStrategy().getNodesConcurInQuorum((ODistributedServerManager)this, cfg, iRequest, iNodes, localResult);
                if (checkNodesAreOnline) {
                    availableNodes = this.getNodesWithStatus(iNodes, databaseName, ODistributedServerManager.DB_STATUS.ONLINE, ODistributedServerManager.DB_STATUS.BACKUP, ODistributedServerManager.DB_STATUS.SYNCHRONIZING);
                }
                onlineMasters = this.getOnlineNodes(databaseName).stream().filter(f -> cfg.getServerRole(f) == ODistributedConfiguration.ROLES.MASTER).collect(Collectors.toSet()).size();
            } else {
                cfg = null;
                nodesConcurToTheQuorum = new HashSet<String>(iNodes);
                onlineMasters = availableNodes;
            }
            int expectedResponses = localResult != null ? availableNodes + 1 : availableNodes;
            int quorum = this.calculateQuorum(task.getQuorumType(), iClusterNames, cfg, expectedResponses, nodesConcurToTheQuorum.size(), onlineMasters, checkNodesAreOnline, this.nodeName);
            boolean groupByResponse = task.getResultStrategy() != ORemoteTask.RESULT_STRATEGY.UNION;
            boolean waitLocalNode = this.waitForLocalNode(cfg, iClusterNames, iNodes);
            ODistributedResponseManager currentResponseMgr = responseManagerFactory.newResponseManager(iRequest, iNodes, task, nodesConcurToTheQuorum, availableNodes, expectedResponses, quorum, groupByResponse, waitLocalNode);
            if (localResult != null && currentResponseMgr.setLocalResult(this.nodeName, localResult)) {
                return currentResponseMgr.getFinalResponse();
            }
            if (!(iNodes instanceof List)) {
                iNodes = new ArrayList<String>(iNodes);
            }
            if (iNodes.size() > 1) {
                Collections.sort((List)iNodes);
            }
            this.messageService.registerRequest(iRequest.getId().getMessageId(), currentResponseMgr);
            if (ODistributedServerLog.isDebugEnabled()) {
                ODistributedServerLog.debug((Object)((Object)this), (String)this.nodeName, (String)iNodes.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Sending request %s...", (Object[])new Object[]{iRequest});
            }
            for (String node : iNodes) {
                try {
                    ORemoteServerController remoteServer = this.getRemoteServer(node);
                    remoteServer.sendRequest(iRequest);
                }
                catch (Exception e) {
                    currentResponseMgr.removeServerBecauseUnreachable(node);
                    String reason = e.getMessage();
                    if (e instanceof ODistributedException && e.getCause() instanceof IOException) {
                        reason = e.getCause().getMessage();
                        this.closeRemoteServer(node);
                    } else if (e instanceof OSecurityAccessException) {
                        this.closeRemoteServer(node);
                        try {
                            ORemoteServerController remoteServer = this.getRemoteServer(node);
                            remoteServer.sendRequest(iRequest);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!this.isNodeAvailable(node)) {
                        ODistributedServerLog.debug((Object)((Object)this), (String)this.nodeName, (String)node, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Error on sending distributed request %s. The target node is not available. Active nodes: %s", (Throwable)e, (Object[])new Object[]{iRequest, this.getAvailableNodeNames(databaseName)});
                        continue;
                    }
                    ODistributedServerLog.error((Object)((Object)this), (String)this.nodeName, (String)node, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Error on sending distributed request %s (err=%s). Active nodes: %s", (Object[])new Object[]{iRequest, reason, this.getAvailableNodeNames(databaseName)});
                }
            }
            if (currentResponseMgr.getExpectedNodes().isEmpty()) {
                throw new ODistributedException("No server active for distributed request (" + iRequest + ") against database '" + databaseName + (iClusterNames != null ? "." + iClusterNames : "") + "' to nodes " + iNodes);
            }
            if (ODistributedServerLog.isDebugEnabled()) {
                ODistributedServerLog.debug((Object)((Object)this), (String)this.nodeName, (String)iNodes.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Sent request %s", (Object[])new Object[]{iRequest});
            }
            if (databaseName != null && (shared = this.getMessageService().getDatabase(databaseName)) != null) {
                shared.incSentRequest();
            }
            if (iExecutionMode == ODistributedRequest.EXECUTION_MODE.RESPONSE) {
                return this.waitForResponse(iRequest, currentResponseMgr);
            }
            return null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            String names = iClusterNames != null ? "." + iClusterNames : "";
            throw OException.wrapException((OException)((Object)new ODistributedException("Error on executing distributed request (" + iRequest + ") against database '" + this.nodeName + names + "' to nodes " + iNodes)), (Throwable)e);
        }
    }

    protected ODistributedResponse waitForResponse(ODistributedRequest iRequest, ODistributedResponseManager currentResponseMgr) throws InterruptedException {
        long elapsed;
        long beginTime = System.currentTimeMillis();
        if (!currentResponseMgr.waitForSynchronousResponses() && (elapsed = System.currentTimeMillis() - beginTime) > currentResponseMgr.getSynchTimeout()) {
            ODistributedServerLog.warn((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Timeout (%dms) on waiting for synchronous responses from nodes=%s responsesSoFar=%s request=(%s)", (Object[])new Object[]{elapsed, currentResponseMgr.getExpectedNodes(), currentResponseMgr.getRespondingNodes(), iRequest});
        }
        return currentResponseMgr.getFinalResponse();
    }

    protected int calculateQuorum(OCommandDistributedReplicateRequest.QUORUM_TYPE quorumType, Collection<String> clusterNames, ODistributedConfiguration cfg, int totalServers, int totalMasterServers, int onlineMasters, boolean checkNodesAreOnline, String localNodeName) {
        int quorum = 1;
        if (clusterNames == null || clusterNames.isEmpty()) {
            clusterNames = new ArrayList<String>(1);
            clusterNames.add(null);
        }
        int totalServerInQuorum = totalServers;
        for (String cluster : clusterNames) {
            int clusterQuorum = 0;
            switch (quorumType) {
                case NONE: {
                    break;
                }
                case READ: {
                    if (cfg != null) {
                        clusterQuorum = cfg.getReadQuorum(cluster, totalServers, localNodeName);
                        break;
                    }
                    clusterQuorum = 1;
                    break;
                }
                case WRITE: {
                    if (cfg != null) {
                        clusterQuorum = cfg.getWriteQuorum(cluster, totalMasterServers, localNodeName);
                        totalServerInQuorum = totalMasterServers;
                        break;
                    }
                    clusterQuorum = totalMasterServers / 2 + 1;
                    totalServerInQuorum = totalMasterServers;
                    break;
                }
                case WRITE_ALL_MASTERS: {
                    if (cfg != null) {
                        int cfgQuorum = cfg.getWriteQuorum(cluster, totalMasterServers, localNodeName);
                        clusterQuorum = Math.max(cfgQuorum, onlineMasters);
                        break;
                    }
                    clusterQuorum = totalMasterServers;
                    totalServerInQuorum = totalMasterServers;
                    break;
                }
                case ALL: {
                    clusterQuorum = totalServers;
                }
            }
            quorum = Math.max(quorum, clusterQuorum);
        }
        if (quorum < 0) {
            quorum = 0;
        }
        if (checkNodesAreOnline && quorum > totalServerInQuorum) {
            throw new ODistributedException("Quorum (" + quorum + ") cannot be reached on server '" + localNodeName + "' database '" + this.nodeName + "' because it is major than available nodes (" + totalServerInQuorum + ")");
        }
        return quorum;
    }

    private long adjustTimeoutWithLatency(Collection<String> iNodes, long timeout, ODistributedRequestId requestId) {
        long delta = 0L;
        if (iNodes != null) {
            for (String n : iNodes) {
                long l = this.messageService.getCurrentLatency(n);
                delta = Math.max(delta, l);
            }
        }
        if (delta > 500L) {
            ODistributedServerLog.debug((Object)((Object)this), (String)this.nodeName, (String)iNodes.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Adjusted timeouts by adding +%dms because this is the maximum latency recorded against servers %s (reqId=%s)", (Object[])new Object[]{delta, iNodes, requestId});
        }
        return timeout + delta;
    }

    public ODistributedResponse send2Nodes(ODistributedRequest iRequest, Collection<String> iClusterNames, Collection<String> iNodes, ODistributedRequest.EXECUTION_MODE iExecutionMode, Object localResult) {
        return this.send2Nodes(iRequest, iClusterNames, iNodes, iExecutionMode, localResult, (iRequest1, iNodes1, task, nodesConcurToTheQuorum, availableNodes, expectedResponses, quorum, groupByResponse, waitLocalNode) -> new ODistributedResponseManagerImpl((ODistributedServerManager)this, iRequest, iNodes, nodesConcurToTheQuorum, expectedResponses, quorum, waitLocalNode, this.adjustTimeoutWithLatency(iNodes, task.getSynchronousTimeout(expectedResponses), iRequest.getId()), this.adjustTimeoutWithLatency(iNodes, task.getTotalTimeout(availableNodes), iRequest.getId()), groupByResponse));
    }

    protected boolean waitForLocalNode(ODistributedConfiguration cfg, Collection<String> iClusterNames, Collection<String> iNodes) {
        boolean waitLocalNode = false;
        if (iNodes.contains(this.nodeName)) {
            if (cfg != null) {
                if (iClusterNames == null || iClusterNames.isEmpty()) {
                    if (cfg.isReadYourWrites(null).booleanValue()) {
                        waitLocalNode = true;
                    }
                } else {
                    for (String clName : iClusterNames) {
                        if (!cfg.isReadYourWrites(clName).booleanValue()) continue;
                        waitLocalNode = true;
                        break;
                    }
                }
            } else {
                waitLocalNode = true;
            }
        }
        return waitLocalNode;
    }

    public void executeOnLocalNodeFromRemote(ODistributedRequest request) {
        Object response = this.executeOnLocalNode(request.getId(), request.getTask(), null);
        ODistributedDatabaseImpl.sendResponseBack((Object)this, this, request.getId(), response);
    }

    public Object executeOnLocalNode(final ODistributedRequestId reqId, final ORemoteTask task, final ODatabaseDocumentInternal database) {
        final ODistributedPlugin manager = this;
        return OScenarioThreadLocal.executeAsDistributed((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    Object result = task.execute(reqId, ODistributedPlugin.this.serverInstance, (ODistributedServerManager)manager, database);
                    if (result instanceof Throwable && !(result instanceof OException)) {
                        ODistributedServerLog.debug((Object)this, (String)ODistributedPlugin.this.nodeName, (String)ODistributedPlugin.this.getNodeNameById(reqId.getNodeId()), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Error on executing request %d (%s) on local node: ", (Throwable)((Throwable)result), (Object[])new Object[]{reqId, task});
                    }
                    return result;
                }
                catch (InterruptedException e) {
                    ODistributedServerLog.debug((Object)this, (String)ODistributedPlugin.this.nodeName, (String)ODistributedPlugin.this.getNodeNameById(reqId.getNodeId()), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Interrupted execution on executing distributed request %s on local node: %s", (Throwable)e, (Object[])new Object[]{reqId, task});
                    return e;
                }
                catch (Exception e) {
                    if (!(e instanceof OException)) {
                        ODistributedServerLog.error((Object)this, (String)ODistributedPlugin.this.nodeName, (String)ODistributedPlugin.this.getNodeNameById(reqId.getNodeId()), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Error on executing distributed request %s on local node: %s", (Throwable)e, (Object[])new Object[]{reqId, task});
                    }
                    return e;
                }
            }
        });
    }

    public Set<String> getManagedDatabases() {
        return this.messageService != null ? this.messageService.getDatabases() : Collections.EMPTY_SET;
    }

    public String getLocalNodeName() {
        return this.nodeName;
    }

    public void onLocalNodeConfigurationRequest(ODocument iConfiguration) {
    }

    public void onCreateClass(ODatabaseInternal iDatabase, OClass iClass) {
        if (((ODatabaseDocumentInternal)iDatabase).isLocalEnv()) {
            return;
        }
        if (this.isOffline() && this.getNodeStatus() != ODistributedServerManager.NODE_STATUS.STARTING) {
            return;
        }
        if (!this.isRelatedToLocalServer(iDatabase)) {
            return;
        }
        if (this.messageService == null || this.messageService.getDatabase(iDatabase.getName()) == null) {
            return;
        }
        ODistributedConfiguration cfg = this.getDatabaseConfiguration(iDatabase.getName());
        this.installClustersOfClass(iDatabase, iClass, cfg.modify());
    }

    public void onCreateView(ODatabaseInternal iDatabase, OView view) {
        OLogManager.instance().error((Object)this, "Implement ODistributedAbstractPlugin.onCreateView()!!!", null, new Object[0]);
    }

    public ODocument getStats() {
        ODocument doc = new ODocument();
        HashMap nodes = new HashMap();
        doc.field("nodes", nodes);
        HashMap<String, Object> localNode = new HashMap<String, Object>();
        doc.field("localNode", localNode);
        localNode.put("name", this.nodeName);
        localNode.put("averageResponseTime", this.messageService.getAverageResponseTime());
        HashMap databases = new HashMap();
        localNode.put("databases", databases);
        for (String dbName : this.messageService.getDatabases()) {
            HashMap db = new HashMap();
            databases.put(dbName, db);
        }
        return doc;
    }

    public Throwable convertException(Throwable original) {
        if (!Orient.instance().isActive() || this.isOffline()) {
            return new OOfflineNodeException("Server " + this.nodeName + " is offline");
        }
        if (original instanceof HazelcastException || original instanceof HazelcastInstanceNotActiveException) {
            return new IOException("Hazelcast wrapped exception: " + original.getMessage(), original.getCause());
        }
        if (original instanceof IllegalMonitorStateException) {
            return new IOException("Illegal monitor state: " + original.getMessage(), original.getCause());
        }
        return original;
    }

    public List<String> getOnlineNodes(String iDatabaseName) {
        return this.clusterManager.getOnlineNodes(iDatabaseName);
    }

    public void reassignClustersOwnership(final String iNode, final String databaseName, OModifiableDistributedConfiguration cfg, final boolean canCreateNewClusters) {
        this.executeInDistributedDatabaseLock(databaseName, 20000L, cfg, new OCallable<Boolean, OModifiableDistributedConfiguration>(){

            public Boolean call(OModifiableDistributedConfiguration cfg) {
                ODistributedPlugin.this.rebalanceClusterOwnership(iNode, databaseName, cfg, canCreateNewClusters);
                return null;
            }
        });
    }

    public boolean isNodeAvailable(String iNodeName, String databaseName) {
        return this.clusterManager.isNodeAvailable(iNodeName, databaseName);
    }

    public boolean isNodeOnline(String iNodeName, String databaseName) {
        return this.clusterManager.isNodeOnline(iNodeName, databaseName);
    }

    public boolean isNodeStatusEqualsTo(String iNodeName, String iDatabaseName, ODistributedServerManager.DB_STATUS ... statuses) {
        ODistributedServerManager.DB_STATUS s = this.getDatabaseStatus(iNodeName, iDatabaseName);
        for (ODistributedServerManager.DB_STATUS st : statuses) {
            if (s != st) continue;
            return true;
        }
        return false;
    }

    public boolean isNodeAvailable(String iNodeName) {
        return this.clusterManager.isNodeAvailable(iNodeName);
    }

    public Set<String> getAvailableNodeNames(String databaseName) {
        return this.clusterManager.getAvailableNodeNames(databaseName);
    }

    public boolean isOffline() {
        return this.getNodeStatus() != ODistributedServerManager.NODE_STATUS.ONLINE;
    }

    public int getLocalNodeId() {
        return this.clusterManager.getLocalNodeId();
    }

    public int getNodesWithStatus(Collection<String> iNodes, String databaseName, ODistributedServerManager.DB_STATUS ... statuses) {
        Iterator<String> it = iNodes.iterator();
        while (it.hasNext()) {
            String node = it.next();
            if (this.isNodeStatusEqualsTo(node, databaseName, statuses)) continue;
            it.remove();
        }
        return iNodes.size();
    }

    public String toString() {
        return this.nodeName;
    }

    public ODistributedMessageServiceImpl getMessageService() {
        while (this.messageService == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw OException.wrapException((OException)((Object)new OOfflineNodeException("Message Service is not available")), (Throwable)e);
            }
        }
        return this.messageService;
    }

    public int getTotalNodes(String iDatabaseName) {
        ODistributedConfiguration cfg = this.getDatabaseConfiguration(iDatabaseName);
        if (cfg != null) {
            return cfg.getAllConfiguredServers().size();
        }
        return 0;
    }

    public int getAvailableNodes(String iDatabaseName) {
        return this.clusterManager.getAvailableNodes(iDatabaseName);
    }

    public int getAvailableNodes(Collection<String> iNodes, String databaseName) {
        return this.clusterManager.getAvailableNodes(iNodes, databaseName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean installDatabase(final boolean iStartup, final String databaseName, final boolean forceDeployment, final boolean tryWithDeltaFirst) {
        if (this.getDatabaseStatus(this.getLocalNodeName(), databaseName) == ODistributedServerManager.DB_STATUS.OFFLINE) {
            return false;
        }
        if (databaseName.equalsIgnoreCase("OSystem")) {
            return false;
        }
        if (this.installingDatabases.contains(databaseName)) {
            return false;
        }
        final ODistributedDatabaseImpl distrDatabase = this.messageService.registerDatabase(databaseName);
        try {
            this.installingDatabases.add(databaseName);
            boolean bl = this.executeInDistributedDatabaseLock(databaseName, 20000L, null, new OCallable<Boolean, OModifiableDistributedConfiguration>(){

                public Boolean call(OModifiableDistributedConfiguration cfg) {
                    boolean databaseInstalled;
                    distrDatabase.checkNodeInConfiguration(ODistributedPlugin.this.nodeName, (ODistributedConfiguration)cfg);
                    List nodes = cfg.getServers(null, ODistributedPlugin.this.nodeName);
                    ODistributedPlugin.this.getAvailableNodes(nodes, databaseName);
                    if (nodes.size() == 0) {
                        ODistributedServerLog.error((Object)this, (String)ODistributedPlugin.this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Cannot install database '%s' on local node, because no servers are available", (Object[])new Object[]{databaseName});
                        return false;
                    }
                    ODistributedServerLog.info((Object)this, (String)ODistributedPlugin.this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Current node is a %s for database '%s'", (Object[])new Object[]{cfg.getServerRole(ODistributedPlugin.this.nodeName), databaseName});
                    if (!forceDeployment && ODistributedPlugin.this.getDatabaseStatus(ODistributedPlugin.this.getLocalNodeName(), databaseName) == ODistributedServerManager.DB_STATUS.ONLINE) {
                        return false;
                    }
                    distrDatabase.setDistributedConfiguration(cfg);
                    distrDatabase.suspend();
                    Boolean deploy = forceDeployment ? Boolean.TRUE : Boolean.valueOf(cfg.isAutoDeploy());
                    try {
                        if (!distrDatabase.exists()) {
                            if (deploy == null || !deploy.booleanValue()) {
                                ODistributedServerLog.debug((Object)this, (String)ODistributedPlugin.this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Skipping download of database '%s' from the cluster because autoDeploy=false", (Object[])new Object[]{databaseName});
                                distrDatabase.setOnline();
                                distrDatabase.resume();
                                return false;
                            }
                            databaseInstalled = ODistributedPlugin.this.requestFullDatabase(distrDatabase, databaseName, iStartup, cfg);
                        } else if (tryWithDeltaFirst) {
                            try {
                                databaseInstalled = ODistributedPlugin.this.requestNewDatabaseDelta(distrDatabase, databaseName, cfg);
                            }
                            catch (ODistributedDatabaseDeltaSyncException e) {
                                if (deploy == null || !deploy.booleanValue()) {
                                    ODistributedServerLog.debug((Object)this, (String)ODistributedPlugin.this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Skipping download of the entire database '%s' from the cluster because autoDeploy=false", (Object[])new Object[]{databaseName});
                                    distrDatabase.setOnline();
                                    distrDatabase.resume();
                                    return false;
                                }
                                databaseInstalled = ODistributedPlugin.this.requestFullDatabase(distrDatabase, databaseName, iStartup, cfg);
                            }
                        } else {
                            databaseInstalled = ODistributedPlugin.this.requestFullDatabase(distrDatabase, databaseName, iStartup, cfg);
                        }
                        if (!databaseInstalled) {
                            ODistributedPlugin.this.setDatabaseStatus(ODistributedPlugin.this.getLocalNodeName(), databaseName, ODistributedServerManager.DB_STATUS.NOT_AVAILABLE);
                        }
                    }
                    catch (ODatabaseIsOldException e) {
                        distrDatabase.setOnline();
                        ODistributedServerLog.info((Object)this, (String)ODistributedPlugin.this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Current copy of database '%s' is newer than the copy present in the cluster. Use the local copy and force other nodes to download this", (Object[])new Object[]{databaseName});
                        databaseInstalled = true;
                        distrDatabase.resume();
                    }
                    catch (RuntimeException e) {
                        distrDatabase.resume();
                        throw e;
                    }
                    return databaseInstalled;
                }
            });
            return bl;
        }
        finally {
            this.installingDatabases.remove(databaseName);
        }
    }

    private boolean requestNewDatabaseDelta(ODistributedDatabaseImpl distrDatabase, String databaseName, OModifiableDistributedConfiguration cfg) {
        List nodes = cfg.getServers(null, this.nodeName);
        this.getAvailableNodes(nodes, databaseName);
        if (nodes.size() == 0) {
            return false;
        }
        ODistributedServerLog.warn((Object)((Object)this), (String)this.nodeName, (String)nodes.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"requesting delta database sync for '%s' on local server...", (Object[])new Object[]{databaseName});
        boolean databaseInstalledCorrectly = false;
        for (String targetNode : nodes) {
            OTxMetadataHolder metadata;
            block19: {
                if (!this.isNodeOnline(targetNode, databaseName)) continue;
                try (ODatabaseDocumentInternal inst = distrDatabase.getDatabaseInstance();){
                    Optional read = ((OAbstractPaginatedStorage)inst.getStorage()).getLastMetadata();
                    if (read.isPresent()) {
                        metadata = OTxMetadataHolderImpl.read((byte[])((byte[])read.get()));
                        break block19;
                    }
                    throw new ODistributedDatabaseDeltaSyncException("Trigger full sync");
                }
            }
            OSyncDatabaseNewDeltaTask deployTask = new OSyncDatabaseNewDeltaTask(metadata.getStatus());
            ArrayList<String> targetNodes = new ArrayList<String>(1);
            targetNodes.add(targetNode);
            try {
                ODistributedResponse response = this.sendRequest(databaseName, null, targetNodes, (ORemoteTask)deployTask, this.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null);
                if (response == null) {
                    throw new ODistributedDatabaseDeltaSyncException("Error requesting delta sync");
                }
                databaseInstalledCorrectly = this.installResponseNewDeltaSync(distrDatabase, databaseName, cfg, targetNode, (ONewDeltaTaskResponse)response.getPayload());
            }
            catch (ODistributedDatabaseDeltaSyncException e) {
                throw e;
            }
            catch (Exception e) {
                ODistributedServerLog.error((Object)((Object)this), (String)this.nodeName, (String)targetNode, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Error on asking delta backup of database '%s' (err=%s)", (Object[])new Object[]{databaseName, e.getMessage()});
                throw OException.wrapException((OException)((Object)new ODistributedDatabaseDeltaSyncException(e.toString())), (Throwable)e);
            }
            if (!databaseInstalledCorrectly) continue;
            distrDatabase.resume();
            return true;
        }
        throw new ODistributedDatabaseDeltaSyncException("Requested database delta sync error");
    }

    protected boolean requestFullDatabase(ODistributedDatabaseImpl distrDatabase, String databaseName, boolean backupDatabase, OModifiableDistributedConfiguration cfg) {
        ODistributedServerLog.info((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Requesting full sync for database '%s'...", (Object[])new Object[]{databaseName});
        for (int retry = 0; retry < 10; ++retry) {
            if (this.requestDatabaseFullSync(distrDatabase, backupDatabase, databaseName, retry > 0, cfg)) {
                return true;
            }
            try {
                Thread.sleep(this.serverInstance.getContextConfiguration().getValueAsLong(OGlobalConfiguration.DISTRIBUTED_MAX_STARTUP_DELAY));
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        return false;
    }

    private boolean installResponseNewDeltaSync(ODistributedDatabaseImpl distrDatabase, String databaseName, OModifiableDistributedConfiguration cfg, String targetNode, ONewDeltaTaskResponse results) {
        String dbPath = this.serverInstance.getDatabaseDirectory() + databaseName;
        boolean databaseInstalledCorrectly = false;
        if (results.getResponseType() == ONewDeltaTaskResponse.ResponseType.CHUNK) {
            ODistributedDatabaseChunk firstChunk = results.getChunk().get();
            try {
                OSyncReceiver receiver = new OSyncReceiver(this, databaseName, firstChunk, targetNode, dbPath);
                receiver.spawnReceiverThread();
                receiver.getStarted().await();
                this.executeInDistributedDatabaseLock(databaseName, 20000L, cfg, cfg1 -> {
                    try (PipedInputStream in = receiver.getInputStream();){
                        new ONewDeltaSyncImporter().importDelta(this.serverInstance, databaseName, in, targetNode);
                    }
                    catch (IOException e) {
                        throw OException.wrapException((OException)new OIOException("Error on distributed sync of database"), (Throwable)e);
                    }
                    return null;
                });
                distrDatabase.setOnline();
                try {
                    this.rebalanceClusterOwnership(this.nodeName, databaseName, cfg, false);
                }
                catch (Exception e) {
                    ODistributedServerLog.warn((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on re-balancing the cluster for database '%s'", (Throwable)e, (Object[])new Object[]{databaseName});
                }
                ODistributedServerLog.info((Object)((Object)this), (String)this.nodeName, (String)targetNode, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Installed delta of database '%s'", (Object[])new Object[]{databaseName});
                databaseInstalledCorrectly = true;
            }
            catch (OException | InterruptedException e) {
                OLogManager.instance().error((Object)this, "Error installing database from network", e, new Object[0]);
                databaseInstalledCorrectly = false;
            }
        } else {
            if (results.getResponseType() == ONewDeltaTaskResponse.ResponseType.FULL_SYNC) {
                throw new ODistributedDatabaseDeltaSyncException("Full sync required");
            }
            if (results.getResponseType() == ONewDeltaTaskResponse.ResponseType.NO_CHANGES) {
                distrDatabase.setOnline();
                return true;
            }
        }
        return databaseInstalledCorrectly;
    }

    protected boolean requestDatabaseFullSync(ODistributedDatabaseImpl distrDatabase, boolean backupDatabase, String databaseName, boolean iAskToAllNodes, OModifiableDistributedConfiguration cfg) {
        List nodes = cfg.getServers(null, this.nodeName);
        if (nodes.isEmpty()) {
            ODistributedServerLog.warn((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Cannot request full deploy of database '%s' because there are no nodes available with such database", (Object[])new Object[]{databaseName});
            return false;
        }
        ArrayList<String> selectedNodes = new ArrayList<String>();
        if (!iAskToAllNodes) {
            for (String n : nodes) {
                if (!this.isNodeStatusEqualsTo(n, databaseName, ODistributedServerManager.DB_STATUS.BACKUP)) continue;
                selectedNodes.add(n);
                break;
            }
            if (selectedNodes.isEmpty()) {
                for (String f : nodes) {
                    if (!this.isNodeStatusEqualsTo(f, databaseName, ODistributedServerManager.DB_STATUS.ONLINE, ODistributedServerManager.DB_STATUS.BACKUP)) continue;
                    selectedNodes.add(f);
                    break;
                }
            }
        }
        if (selectedNodes.isEmpty()) {
            selectedNodes.addAll(nodes);
        }
        Iterator iter = selectedNodes.iterator();
        while (iter.hasNext()) {
            if (this.isNodeAvailable((String)iter.next())) continue;
            iter.remove();
        }
        ODistributedServerLog.info((Object)((Object)this), (String)this.nodeName, (String)((Object)selectedNodes).toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Requesting deploy of database '%s' on local server...", (Object[])new Object[]{databaseName});
        for (String noteToSend : selectedNodes) {
            OSyncDatabaseTask deployTask = new OSyncDatabaseTask();
            ArrayList<String> singleNode = new ArrayList<String>();
            singleNode.add(noteToSend);
            Map results = (Map)this.sendRequest(databaseName, null, singleNode, (ORemoteTask)deployTask, this.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null).getPayload();
            if (results == null) {
                ODistributedServerLog.error((Object)((Object)this), (String)this.nodeName, (String)((Object)selectedNodes).toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Timeout waiting the sync database please set the `distributed.deployDbTaskTimeout` to appropriate value", (Object[])new Object[0]);
                this.setDatabaseStatus(this.nodeName, databaseName, ODistributedServerManager.DB_STATUS.NOT_AVAILABLE);
                return false;
            }
            ODistributedServerLog.debug((Object)((Object)this), (String)this.nodeName, (String)((Object)selectedNodes).toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Deploy returned: %s", (Object[])new Object[]{results});
            String dbPath = this.serverInstance.getDatabaseDirectory() + databaseName;
            for (Map.Entry r : results.entrySet()) {
                Object value = r.getValue();
                if (value instanceof Boolean) {
                    distrDatabase.setOnline();
                    continue;
                }
                if (value instanceof ODatabaseIsOldException) {
                    throw (ODatabaseIsOldException)((Object)value);
                }
                if (value instanceof Throwable) {
                    ODistributedServerLog.error((Object)((Object)this), (String)this.nodeName, (String)((String)r.getKey()), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Error on installing database '%s' in %s", (Throwable)((Throwable)value), (Object[])new Object[]{databaseName, dbPath});
                    this.setDatabaseStatus(this.nodeName, databaseName, ODistributedServerManager.DB_STATUS.NOT_AVAILABLE);
                    if (!(value instanceof ODistributedException)) continue;
                    throw (ODistributedException)((Object)value);
                }
                if (value instanceof ODistributedDatabaseChunk) {
                    File uniqueClustersBackupDirectory = this.getClusterOwnedExclusivelyByCurrentNode(dbPath, databaseName);
                    if (backupDatabase) {
                        this.backupCurrentDatabase(databaseName);
                    }
                    try {
                        this.installDatabaseFromNetwork(dbPath, databaseName, distrDatabase, (String)r.getKey(), (ODistributedDatabaseChunk)value, uniqueClustersBackupDirectory, cfg);
                    }
                    catch (OException e) {
                        OLogManager.instance().error((Object)this, "Error installing database from network", (Throwable)e, new Object[0]);
                        return false;
                    }
                    distrDatabase.resume();
                    return true;
                }
                throw new IllegalArgumentException("Type " + value + " not supported");
            }
        }
        throw new ODistributedException("No response received from remote nodes for auto-deploy of database '" + databaseName + "'");
    }

    protected File getClusterOwnedExclusivelyByCurrentNode(String dbPath, String iDatabaseName) {
        ODistributedConfiguration cfg = this.getDatabaseConfiguration(iDatabaseName);
        HashSet<String> clusters = new HashSet<String>();
        for (String clName : cfg.getClusterNames()) {
            List servers = cfg.getServers(clName, null);
            if (servers == null || servers.size() != 1 || !((String)servers.get(0)).equals(this.getLocalNodeName())) continue;
            clusters.add(clName);
        }
        if (!clusters.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            Orient.instance();
            String backupDirectory = stringBuilder.append(Orient.getHomePath()).append("/temp/db_").append(iDatabaseName).toString();
            File backupFullPath = new File(backupDirectory);
            if (backupFullPath.exists()) {
                OFileUtils.deleteRecursively((File)backupFullPath);
            } else {
                backupFullPath.mkdirs();
            }
            ODistributedServerLog.warn((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Saving clusters %s to directory '%s' to be replaced after distributed full backup...", (Object[])new Object[]{clusters, backupFullPath});
            for (String clName : clusters) {
                File oldFile = new File(dbPath + "/" + clName + ".pcl");
                File newFile = new File(backupFullPath + "/" + clName + ".pcl");
                if (oldFile.exists() && !oldFile.renameTo(newFile)) {
                    ODistributedServerLog.error((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Cannot make a safe copy of exclusive clusters. Error on moving file %s -> %s: restore of database '%s' has been aborted because unsafe", (Object[])new Object[]{oldFile, newFile, iDatabaseName});
                    throw new ODistributedException("Cannot make a safe copy of exclusive clusters");
                }
                oldFile = new File(dbPath + "/" + clName + ".cpm");
                newFile = new File(backupFullPath + "/" + clName + ".cpm");
                if (!oldFile.exists() || oldFile.renameTo(newFile)) continue;
                ODistributedServerLog.error((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Cannot make a safe copy of exclusive clusters. Error on moving file %s -> %s: restore of database '%s' has been aborted because unsafe", (Object[])new Object[]{oldFile, newFile, iDatabaseName});
                throw new ODistributedException("Cannot make a safe copy of exclusive clusters");
            }
            return backupFullPath;
        }
        return null;
    }

    protected void backupCurrentDatabase(String iDatabaseName) {
        block14: {
            this.serverInstance.getDatabases().forceDatabaseClose(iDatabaseName);
            String backupDirectory = this.serverInstance.getContextConfiguration().getValueAsString(OGlobalConfiguration.DISTRIBUTED_BACKUP_DIRECTORY);
            if (backupDirectory == null || OIOUtils.getStringContent((Object)backupDirectory).trim().isEmpty()) {
                return;
            }
            String backupPath = backupDirectory.startsWith("/") ? backupDirectory : (backupDirectory.startsWith("../") ? new File(this.serverInstance.getDatabaseDirectory()).getParent() + backupDirectory.substring("..".length()) : this.serverInstance.getDatabaseDirectory() + backupDirectory);
            if (!backupPath.endsWith("/")) {
                backupPath = backupPath + "/";
            }
            backupPath = backupPath + iDatabaseName;
            String dbpath = this.serverInstance.getDatabaseDirectory() + iDatabaseName;
            File backupFullPath = new File(backupPath);
            try {
                if (backupFullPath.exists()) {
                    this.deleteRecursively(backupFullPath);
                }
                Files.createDirectories(backupFullPath.toPath(), new FileAttribute[0]);
                ODistributedServerLog.warn((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Moving existent database '%s' in '%s' to '%s' and get a fresh copy from a remote node...", (Object[])new Object[]{iDatabaseName, dbpath, backupPath});
                File oldDirectory = new File(dbpath);
                if (!oldDirectory.exists() || !oldDirectory.isDirectory()) break block14;
                if (oldDirectory.getCanonicalPath().equals(backupFullPath.getCanonicalPath())) {
                    throw new ODistributedException(String.format("Backup folder configured as same of database folder:'%s'", oldDirectory.getAbsolutePath()));
                }
                try {
                    try {
                        Files.move(oldDirectory.toPath(), backupFullPath.toPath(), StandardCopyOption.ATOMIC_MOVE);
                    }
                    catch (AtomicMoveNotSupportedException e) {
                        OLogManager.instance().errorNoDb((Object)this, "Atomic moves not supported during database backup, will try not atomic move", null, new Object[0]);
                        if (backupFullPath.exists()) {
                            this.deleteRecursively(backupFullPath);
                        }
                        Files.createDirectories(backupFullPath.toPath(), new FileAttribute[0]);
                        Files.move(oldDirectory.toPath(), Paths.get(backupPath, oldDirectory.getName()), new CopyOption[0]);
                    }
                }
                catch (DirectoryNotEmptyException e) {
                    OLogManager.instance().errorNoDb((Object)this, "File rename not supported during database backup, will try coping files", null, new Object[0]);
                    if (backupFullPath.exists()) {
                        this.deleteRecursively(backupFullPath);
                    }
                    Files.createDirectories(backupFullPath.toPath(), new FileAttribute[0]);
                    try {
                        OFileUtils.copyDirectory((File)oldDirectory, (File)Paths.get(backupPath, oldDirectory.getName()).toFile());
                        this.deleteRecursively(oldDirectory);
                    }
                    catch (IOException ioe) {
                        OLogManager.instance().errorNoDb((Object)this, "Error moving old database removing it", (Throwable)ioe, new Object[0]);
                        this.deleteRecursively(oldDirectory);
                    }
                }
            }
            catch (IOException e) {
                ODistributedServerLog.warn((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on moving existent database '%s' located in '%s' to '%s' (error=%s).", (Throwable)e, (Object[])new Object[]{iDatabaseName, dbpath, backupFullPath, e});
            }
        }
    }

    private void deleteRecursively(File path) throws IOException {
        Files.walkFileTree(path.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    protected void installDatabaseFromNetwork(String dbPath, String databaseName, ODistributedDatabaseImpl distrDatabase, String iNode, ODistributedDatabaseChunk firstChunk, File uniqueClustersBackupDirectory, OModifiableDistributedConfiguration cfg) {
        String localNodeName = this.nodeName;
        OSyncReceiver receiver = new OSyncReceiver(this, databaseName, firstChunk, iNode, dbPath);
        receiver.spawnReceiverThread();
        this.installDatabaseOnLocalNode(databaseName, dbPath, iNode, uniqueClustersBackupDirectory, cfg, firstChunk.incremental, receiver);
        receiver.close();
        distrDatabase.setOnline();
        Set localManagedClusters = cfg.getClustersOnServer(localNodeName);
        Set sourceNodeClusters = cfg.getClustersOnServer(iNode);
        localManagedClusters.removeAll(sourceNodeClusters);
        HashSet<String> toSynchClusters = new HashSet<String>();
        for (String cl : localManagedClusters) {
            List servers = cfg.getServers(cl, localNodeName);
            this.getAvailableNodes(servers, databaseName);
            if (servers.isEmpty()) continue;
            toSynchClusters.add(cl);
        }
        for (String cl : toSynchClusters) {
            OCommandExecutorSQLHASyncCluster.replaceCluster(this, this.serverInstance, databaseName, cl);
        }
        try {
            this.rebalanceClusterOwnership(this.nodeName, databaseName, cfg, false);
        }
        catch (Exception e) {
            ODistributedServerLog.warn((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on re-balancing the cluster for database '%s'", (Throwable)e, (Object[])new Object[]{databaseName});
        }
    }

    public ORemoteTaskFactoryManager getTaskFactoryManager() {
        return this.taskFactoryManager;
    }

    public Set<String> getActiveServers() {
        return this.clusterManager.getActiveServers();
    }

    public boolean installClustersOfClass(final ODatabaseInternal iDatabase, final OClass iClass, OModifiableDistributedConfiguration cfg) {
        String databaseName = iDatabase.getName();
        if (iClass.isAbstract()) {
            return false;
        }
        this.getMessageService().registerDatabase(databaseName);
        return this.executeInDistributedDatabaseLock(databaseName, 20000L, cfg, new OCallable<Boolean, OModifiableDistributedConfiguration>(){

            public Boolean call(OModifiableDistributedConfiguration lastCfg) {
                Set<String> availableNodes = ODistributedPlugin.this.getAvailableNodeNames(iDatabase.getName());
                List<String> cluster2Create = ODistributedPlugin.this.clusterAssignmentStrategy.assignClusterOwnershipOfClass(iDatabase, lastCfg, iClass, availableNodes, true);
                HashMap<OClass, List<String>> cluster2CreateMap = new HashMap<OClass, List<String>>(1);
                cluster2CreateMap.put(iClass, cluster2Create);
                ODistributedPlugin.this.createClusters(iDatabase, cluster2CreateMap, lastCfg);
                return true;
            }
        });
    }

    private void createClusters(final ODatabaseInternal iDatabase, final Map<OClass, List<String>> cluster2Create, OModifiableDistributedConfiguration cfg) {
        if (cluster2Create.isEmpty()) {
            return;
        }
        this.executeInDistributedDatabaseLock(iDatabase.getName(), 20000L, cfg, new OCallable<Object, OModifiableDistributedConfiguration>(){

            public Object call(OModifiableDistributedConfiguration cfg) {
                ODistributedPlugin.this.updateCachedDatabaseConfiguration(iDatabase.getName(), cfg, true);
                for (Map.Entry entry : cluster2Create.entrySet()) {
                    final OClass clazz = (OClass)entry.getKey();
                    for (final String newClusterName : (List)entry.getValue()) {
                        ODistributedServerLog.info((Object)this, (String)ODistributedPlugin.this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Class '%s', creation of new local cluster '%s' (id=%d)", (Object[])new Object[]{clazz, newClusterName, iDatabase.getClusterIdByName(newClusterName)});
                        OScenarioThreadLocal.executeAsDefault((Callable)new Callable<Object>(){

                            @Override
                            public Object call() throws Exception {
                                block2: {
                                    try {
                                        clazz.addCluster(newClusterName);
                                    }
                                    catch (Exception e) {
                                        if (iDatabase.getClusterNames().contains(newClusterName)) break block2;
                                        ODistributedServerLog.error((Object)this, (String)ODistributedPlugin.this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on creating cluster '%s' in class '%s': ", (Object[])new Object[]{newClusterName, clazz, e});
                                        throw OException.wrapException((OException)((Object)new ODistributedException("Error on creating cluster '" + newClusterName + "' in class '" + clazz + "'")), (Throwable)e);
                                    }
                                }
                                return null;
                            }
                        });
                    }
                }
                return null;
            }
        });
    }

    public ODistributedStrategy getDistributedStrategy() {
        return this.responseManagerFactory;
    }

    public void setDistributedStrategy(ODistributedStrategy streatgy) {
        this.responseManagerFactory = streatgy;
    }

    public boolean updateCachedDatabaseConfiguration(String iDatabaseName, OModifiableDistributedConfiguration cfg, boolean iDeployToCluster) {
        return this.clusterManager.updateCachedDatabaseConfiguration(iDatabaseName, cfg, iDeployToCluster);
    }

    public void notifyClients(String databaseName) {
        ArrayList<String> hosts = new ArrayList<String>();
        for (String name : this.getActiveServers()) {
            Collection listeners;
            ODocument memberConfig = this.clusterManager.getNodeConfigurationByName(name, true);
            if (memberConfig == null) continue;
            String nodeStatus = (String)memberConfig.field("status");
            if (memberConfig == null || "OFFLINE".equals(nodeStatus) || (listeners = (Collection)memberConfig.field("listeners")) == null) continue;
            for (Map listener : listeners) {
                if (!listener.get("protocol").equals("ONetworkProtocolBinary")) continue;
                String url = (String)listener.get("listen");
                hosts.add(url);
            }
        }
        this.serverInstance.getPushManager().pushDistributedConfig(databaseName, hosts);
    }

    public void onDatabaseEvent(String nodeName, String databaseName, ODistributedServerManager.DB_STATUS status) {
        this.notifyClients(databaseName);
        this.updateLastClusterChange();
        this.dumpServersStatus();
    }

    public void invokeOnDatabaseStatusChange(String iNode, String iDatabaseName, ODistributedServerManager.DB_STATUS iStatus) {
        for (ODistributedLifecycleListener l : this.listeners) {
            try {
                l.onDatabaseChangeStatus(iNode, iDatabaseName, iStatus);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rebalanceClusterOwnership(String iNode, String databaseName, OModifiableDistributedConfiguration cfg, boolean canCreateNewClusters) {
        ODistributedConfiguration.ROLES role = cfg.getServerRole(iNode);
        if (role != ODistributedConfiguration.ROLES.MASTER) {
            return;
        }
        ODatabaseDocumentInternal current = ODatabaseRecordThreadLocal.instance().getIfDefined();
        try (ODatabaseDocumentInternal iDatabase = this.getServerInstance().openDatabase(databaseName);){
            ODistributedServerLog.info((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Reassigning ownership of clusters for database %s...", (Object[])new Object[]{iDatabase.getName()});
            Set<String> availableNodes = this.getAvailableNodeNames(iDatabase.getName());
            iDatabase.activateOnCurrentThread();
            OSchema schema = iDatabase.getDatabaseOwner().getMetadata().getSchema();
            HashMap<OClass, List<String>> cluster2CreateMap = new HashMap<OClass, List<String>>(1);
            for (OClass clazz : schema.getClasses()) {
                List<String> cluster2Create = this.clusterAssignmentStrategy.assignClusterOwnershipOfClass((ODatabaseInternal)iDatabase, cfg, clazz, availableNodes, canCreateNewClusters);
                cluster2CreateMap.put(clazz, cluster2Create);
            }
            if (canCreateNewClusters) {
                this.createClusters((ODatabaseInternal)iDatabase, cluster2CreateMap, cfg);
            }
            ODistributedServerLog.info((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Reassignment of clusters for database '%s' completed (classes=%d)", (Object[])new Object[]{iDatabase.getName(), cluster2CreateMap.size()});
        }
        finally {
            ODatabaseRecordThreadLocal.instance().set(current);
        }
    }

    protected void assignNodeName() {
        this.nodeName = OSystemVariableResolver.resolveVariable((String)NODE_NAME_ENV);
        if (this.nodeName != null) {
            this.nodeName = this.nodeName.trim();
            if (this.nodeName.isEmpty()) {
                this.nodeName = null;
            }
        }
        if (this.nodeName == null) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.out.println();
            System.out.println();
            System.out.println(OAnsiCode.format((String)"$ANSI{yellow +---------------------------------------------------------------+}"));
            System.out.println(OAnsiCode.format((String)"$ANSI{yellow |         WARNING: FIRST DISTRIBUTED RUN CONFIGURATION          |}"));
            System.out.println(OAnsiCode.format((String)"$ANSI{yellow +---------------------------------------------------------------+}"));
            System.out.println(OAnsiCode.format((String)"$ANSI{yellow | This is the first time that the server is running as          |}"));
            System.out.println(OAnsiCode.format((String)"$ANSI{yellow | distributed. Please type the name you want to assign to the   |}"));
            System.out.println(OAnsiCode.format((String)"$ANSI{yellow | current server node.                                          |}"));
            System.out.println(OAnsiCode.format((String)"$ANSI{yellow |                                                               |}"));
            System.out.println(OAnsiCode.format((String)"$ANSI{yellow | To avoid this message set the environment variable or JVM     |}"));
            System.out.println(OAnsiCode.format((String)"$ANSI{yellow | setting ORIENTDB_NODE_NAME to the server node name to use.    |}"));
            System.out.println(OAnsiCode.format((String)"$ANSI{yellow +---------------------------------------------------------------+}"));
            System.out.print(OAnsiCode.format((String)"\n$ANSI{yellow Node name [BLANK=auto generate it]: }"));
            ODefaultConsoleReader reader = new ODefaultConsoleReader();
            try {
                this.nodeName = reader.readLine();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.nodeName != null) {
                this.nodeName = this.nodeName.trim();
                if (this.nodeName.isEmpty()) {
                    this.nodeName = null;
                }
            }
        }
        if (this.nodeName == null) {
            this.nodeName = "node" + System.currentTimeMillis();
        }
        OLogManager.instance().warn((Object)this, "Assigning distributed node name: %s", new Object[]{this.nodeName});
        boolean found = false;
        OServerConfiguration cfg = this.serverInstance.getConfiguration();
        for (OServerHandlerConfiguration h : cfg.handlers) {
            if (!h.clazz.equals(((Object)((Object)this)).getClass().getName())) continue;
            for (OServerParameterConfiguration p : h.parameters) {
                if (!p.name.equals("nodeName")) continue;
                found = true;
                p.value = this.nodeName;
                break;
            }
            if (!found) {
                h.parameters = (OServerParameterConfiguration[])OArrays.copyOf((Object[])h.parameters, (int)(h.parameters.length + 1));
                h.parameters[h.parameters.length - 1] = new OServerParameterConfiguration("nodeName", this.nodeName);
            }
            try {
                this.serverInstance.saveConfiguration();
                break;
            }
            catch (IOException e) {
                throw OException.wrapException((OException)new OConfigurationException("Cannot save server configuration"), (Throwable)e);
            }
        }
    }

    protected void installDatabaseOnLocalNode(final String databaseName, final String dbPath, final String iNode, final File uniqueClustersBackupDirectory, OModifiableDistributedConfiguration cfg, final boolean incremental, final OSyncReceiver receiver) {
        ODistributedServerLog.info((Object)((Object)this), (String)this.nodeName, (String)iNode, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Installing database '%s' to: %s...", (Object[])new Object[]{databaseName, dbPath});
        new File(dbPath).mkdirs();
        try {
            receiver.getStarted().await();
        }
        catch (InterruptedException e) {
            throw OException.wrapException((OException)new OInterruptedException("Interrupted waiting receive of sync"), (Throwable)e);
        }
        ODistributedPlugin me = this;
        this.executeInDistributedDatabaseLock(databaseName, 20000L, cfg, new OCallable<Void, OModifiableDistributedConfiguration>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public Void call(OModifiableDistributedConfiguration cfg) {
                try {
                    if (incremental) {
                        OStorage storage = ODistributedPlugin.this.serverInstance.getDatabases().fullSync(databaseName, (InputStream)receiver.getInputStream(), OrientDBConfig.defaultConfig());
                        ODistributedDatabaseImpl distrDatabase = ODistributedPlugin.this.messageService.getDatabase(databaseName);
                        distrDatabase.saveDatabaseConfiguration();
                        if (uniqueClustersBackupDirectory != null && uniqueClustersBackupDirectory.exists()) {
                            for (File f : uniqueClustersBackupDirectory.listFiles()) {
                                File oldFile = new File(dbPath + "/" + f.getName());
                                if (oldFile.exists()) {
                                    oldFile.delete();
                                }
                                if (f.renameTo(oldFile)) continue;
                                throw new ODistributedException("Cannot restore exclusive cluster file '" + f.getAbsolutePath() + "' into " + oldFile.getAbsolutePath());
                            }
                            uniqueClustersBackupDirectory.delete();
                        }
                        try (ODatabaseDocumentInternal inst = distrDatabase.getDatabaseInstance();){
                            Optional read = ((OAbstractPaginatedStorage)inst.getStorage()).getLastMetadata();
                            if (!read.isPresent()) return null;
                            OTxMetadataHolder metadata = OTxMetadataHolderImpl.read((byte[])((byte[])read.get()));
                            OSyncDatabaseNewDeltaTask deployTask = new OSyncDatabaseNewDeltaTask(metadata.getStatus());
                            ArrayList<String> targetNodes = new ArrayList<String>(1);
                            targetNodes.add(iNode);
                            ODistributedResponse response = ODistributedPlugin.this.sendRequest(databaseName, null, targetNodes, (ORemoteTask)deployTask, ODistributedPlugin.this.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null);
                            if (response == null) {
                                throw new ODistributedDatabaseDeltaSyncException("Error Requesting delta sync");
                            }
                            ODistributedPlugin.this.installResponseNewDeltaSync(distrDatabase, databaseName, cfg, iNode, (ONewDeltaTaskResponse)response.getPayload());
                            return null;
                        }
                    }
                    try (PipedInputStream in = receiver.getInputStream();){
                        ODistributedPlugin.this.serverInstance.getDatabases().networkRestore(databaseName, (InputStream)in, (Callable)new Callable<Object>(){

                            @Override
                            public Object call() throws Exception {
                                if (uniqueClustersBackupDirectory != null && uniqueClustersBackupDirectory.exists()) {
                                    for (File f : uniqueClustersBackupDirectory.listFiles()) {
                                        File oldFile = new File(dbPath + "/" + f.getName());
                                        if (oldFile.exists()) {
                                            oldFile.delete();
                                        }
                                        if (f.renameTo(oldFile)) continue;
                                        throw new ODistributedException("Cannot restore exclusive cluster file '" + f.getAbsolutePath() + "' into " + oldFile.getAbsolutePath());
                                    }
                                    uniqueClustersBackupDirectory.delete();
                                }
                                return null;
                            }
                        });
                        return null;
                    }
                }
                catch (IOException e) {
                    throw OException.wrapException((OException)new OIOException("Error on distributed sync of database"), (Throwable)e);
                }
            }
        });
    }

    public void onMessage(String iText) {
        if (iText.startsWith("\r\n")) {
            iText = iText.substring(2);
        } else if (iText.startsWith("\n")) {
            iText = iText.substring(1);
        }
        OLogManager.instance().debug((Object)this, iText, new Object[0]);
    }

    public void stopNode(String iNode) throws IOException {
        ODistributedServerLog.warn((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Sending request of stopping node '%s'...", (Object[])new Object[]{iNode});
        ODistributedRequest request = new ODistributedRequest((ODistributedServerManager)this, this.getLocalNodeId(), this.getNextMessageIdCounter(), null, this.getTaskFactoryManager().getFactoryByServerName(iNode).createTask(9));
        this.getRemoteServer(iNode).sendRequest(request);
    }

    public void restartNode(String iNode) throws IOException {
        ODistributedServerLog.warn((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Sending request of restarting node '%s'...", (Object[])new Object[]{iNode});
        ODistributedRequest request = new ODistributedRequest((ODistributedServerManager)this, this.getLocalNodeId(), this.getNextMessageIdCounter(), null, this.getTaskFactoryManager().getFactoryByServerName(iNode).createTask(10));
        this.getRemoteServer(iNode).sendRequest(request);
    }

    public long getNextMessageIdCounter() {
        return this.localMessageIdCounter.getAndIncrement();
    }

    public String getNodeUuidByName(String name) {
        return this.clusterManager.getNodeUuidByName(name);
    }

    public void updateLastClusterChange() {
        this.clusterManager.updateLastClusterChange();
    }

    public void closeRemoteServer(String node) {
        this.remoteServerManager.closeRemoteServer(node);
    }

    protected boolean isRelatedToLocalServer(ODatabaseInternal iDatabase) {
        String dbUrl = OSystemVariableResolver.resolveSystemVariables((String)iDatabase.getURL());
        if (iDatabase.getName().equalsIgnoreCase("OSystem")) {
            return false;
        }
        if (dbUrl.startsWith("plocal:")) {
            OLocalPaginatedStorage paginatedStorage = (OLocalPaginatedStorage)iDatabase.getStorage();
            Path storagePath = paginatedStorage.getStoragePath();
            Path dbDirectoryPath = Paths.get(this.serverInstance.getDatabaseDirectory(), new String[0]);
            return storagePath.startsWith(dbDirectoryPath);
        }
        return !dbUrl.startsWith("remote:");
    }

    public void dumpServersStatus() {
        ODocument cfg = this.getClusterConfiguration();
        String compactStatus = ODistributedOutput.getCompactServerStatus(this, cfg);
        if (!this.lastServerDump.equals(compactStatus)) {
            this.lastServerDump = compactStatus;
            ODistributedServerLog.info((Object)((Object)this), (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed servers status (*=current):\n%s", (Object[])new Object[]{ODistributedOutput.formatServerStatus(this, cfg)});
        }
    }

    public long getClusterTime() {
        return this.clusterManager.getClusterTime();
    }

    public static String getListeningBinaryAddress(ODocument cfg) {
        if (cfg == null) {
            return null;
        }
        String url = (String)cfg.field("publicAddress");
        Collection listeners = (Collection)cfg.field("listeners");
        if (listeners == null) {
            throw new ODatabaseException("Cannot connect to a remote node because bad distributed configuration: missing 'listeners' array field");
        }
        String listenUrl = null;
        for (Map listener : listeners) {
            if (!listener.get("protocol").equals("ONetworkProtocolBinary")) continue;
            listenUrl = (String)listener.get("listen");
            break;
        }
        if (url == null) {
            url = listenUrl;
        } else {
            int pos = listenUrl.lastIndexOf(":");
            String port = pos != -1 ? listenUrl.substring(pos + 1) : "2424";
            url = url + ":" + port;
        }
        return url;
    }

    public void messageReceived(ODistributedRequest request) {
        for (ODistributedLifecycleListener listener : this.listeners) {
            listener.onMessageReceived(request);
        }
    }

    public void messagePartitionCalculate(ODistributedRequest request, Set<Integer> involvedWorkerQueues) {
        for (ODistributedLifecycleListener listener : this.listeners) {
            listener.onMessagePartitionCalculated(request, involvedWorkerQueues);
        }
    }

    public void messageBeforeOp(String op, ODistributedRequestId request) {
        for (ODistributedLifecycleListener listener : this.listeners) {
            listener.onMessageBeforeOp(op, request);
        }
    }

    public void messageAfterOp(String op, ODistributedRequestId request) {
        for (ODistributedLifecycleListener listener : this.listeners) {
            listener.onMessageAfterOp(op, request);
        }
    }

    public void messageCurrentPayload(ODistributedRequestId requestId, Object responsePayload) {
        for (ODistributedLifecycleListener listener : this.listeners) {
            listener.onMessageCurrentPayload(requestId, responsePayload);
        }
    }

    public void messageProcessStart(ODistributedRequest message) {
        for (ODistributedLifecycleListener listener : this.listeners) {
            listener.onMessageProcessStart(message);
        }
    }

    public void messageProcessEnd(ODistributedRequest iRequest, Object responsePayload) {
        for (ODistributedLifecycleListener listener : this.listeners) {
            listener.onMessageProcessEnd(iRequest, responsePayload);
        }
    }

    public void loadLocalDatabases() {
        ArrayList dbs = new ArrayList(this.serverInstance.getAvailableStorageNames().keySet());
        Collections.sort(dbs);
        for (final String databaseName : dbs) {
            if (this.messageService.getDatabase(databaseName) != null) continue;
            ODistributedServerLog.info((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Opening database '%s'...", (Object[])new Object[]{databaseName});
            final ODistributedDatabaseImpl ddb = this.messageService.registerDatabase(databaseName);
            this.executeInDistributedDatabaseLock(databaseName, 60000L, null, new OCallable<Object, OModifiableDistributedConfiguration>(){

                public Object call(OModifiableDistributedConfiguration cfg) {
                    ODistributedServerLog.info((Object)this, (String)ODistributedPlugin.this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Current node started as %s for database '%s'", (Object[])new Object[]{cfg.getServerRole(ODistributedPlugin.this.nodeName), databaseName});
                    ddb.resume();
                    cfg.addNewNodeInServerList(ODistributedPlugin.this.nodeName);
                    ODistributedPlugin.this.reassignClustersOwnership(ODistributedPlugin.this.nodeName, databaseName, cfg, true);
                    ddb.setOnline();
                    return null;
                }
            });
        }
    }

    public void installNewDatabasesFromCluster() {
        if (this.getActiveServers().size() <= 1) {
            return;
        }
        ArrayList<String> dbs = new ArrayList<String>(this.clusterManager.getDatabases());
        Collections.sort(dbs);
        for (String databaseName : dbs) {
            Set<String> availableServers = this.getAvailableNodeNames(databaseName);
            if (availableServers.isEmpty()) continue;
            ODistributedServerManager.DB_STATUS currStatus = this.getDatabaseStatus(this.nodeName, databaseName);
            if (currStatus == ODistributedServerManager.DB_STATUS.SYNCHRONIZING || currStatus == ODistributedServerManager.DB_STATUS.ONLINE || currStatus == ODistributedServerManager.DB_STATUS.BACKUP) {
                this.setDatabaseStatus(this.nodeName, databaseName, ODistributedServerManager.DB_STATUS.NOT_AVAILABLE);
            }
            try {
                if (this.installDatabase(true, databaseName, false, OGlobalConfiguration.DISTRIBUTED_BACKUP_TRY_INCREMENTAL_FIRST.getValueAsBoolean())) continue;
                this.setDatabaseStatus(this.getLocalNodeName(), databaseName, ODistributedServerManager.DB_STATUS.NOT_AVAILABLE);
            }
            catch (Exception e) {
                ODistributedServerLog.error((Object)((Object)this), (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Error on installing database '%s' on local node (error=%s)", (Throwable)e, (Object[])new Object[]{databaseName, e.toString()});
            }
        }
    }

    public void notifyStarted() {
        this.serverStarted.countDown();
    }

    protected void dumpStats() {
        try {
            ODocument clusterCfg = this.getClusterConfiguration();
            Set<String> dbs = this.getManagedDatabases();
            StringBuilder buffer = new StringBuilder(8192);
            buffer.append(ODistributedOutput.formatLatency(this, clusterCfg));
            buffer.append(ODistributedOutput.formatMessages(this, clusterCfg));
            OLogManager.instance().flush();
            for (String db : dbs) {
                buffer.append(this.messageService.getDatabase(db).dump());
            }
            System.out.println(buffer);
        }
        catch (Exception e) {
            ODistributedServerLog.error((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on printing HA stats", (Throwable)e, (Object[])new Object[0]);
        }
    }

    public ORemoteServerController getRemoteServer(String rNodeName) throws IOException {
        if (rNodeName == null) {
            throw new IllegalArgumentException("Server name is NULL");
        }
        ORemoteServerController remoteServer = this.remoteServerManager.getRemoteServer(rNodeName);
        if (remoteServer == null) {
            Member member = this.clusterManager.getClusterMemberByName(rNodeName);
            for (int retry = 0; retry < 20; ++retry) {
                ODocument cfg = this.getNodeConfigurationByUuid(member.getUuid(), false);
                if (cfg == null || cfg.field("listeners") == null) {
                    try {
                        Thread.sleep(100L);
                        member = this.clusterManager.getClusterMemberByName(rNodeName);
                        continue;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw OException.wrapException((OException)((Object)new ODistributedException("Cannot find node '" + rNodeName + "'")), (Throwable)e);
                    }
                }
                String url = ODistributedPlugin.getListeningBinaryAddress(cfg);
                if (url == null) {
                    this.closeRemoteServer(rNodeName);
                    throw new ODatabaseException("Cannot connect to a remote node because the url was not found");
                }
                String userPassword = (String)cfg.field("user_replicator");
                if (userPassword != null) {
                    remoteServer = this.remoteServerManager.connectRemoteServer(rNodeName, url, REPLICATOR_USER, userPassword);
                    break;
                }
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw OException.wrapException((OException)new OInterruptedException("Cannot connect to remote server " + rNodeName), (Throwable)e);
                }
            }
        }
        if (remoteServer == null) {
            throw new ODistributedException("Cannot find node '" + rNodeName + "'");
        }
        return remoteServer;
    }

    public Map<String, Object> getConfigurationMap() {
        return this.clusterManager.getConfigurationMap();
    }

    public long getLastClusterChangeOn() {
        return this.clusterManager.getLastClusterChangeOn();
    }

    public ODistributedServerManager.NODE_STATUS getNodeStatus() {
        return this.clusterManager.getNodeStatus();
    }

    public void setNodeStatus(ODistributedServerManager.NODE_STATUS iStatus) {
        this.clusterManager.setNodeStatus(iStatus);
    }

    public boolean checkNodeStatus(ODistributedServerManager.NODE_STATUS status) {
        return this.clusterManager.checkNodeStatus(status);
    }

    public void onNodeJoined(String joinedNodeName, Member member) {
        try {
            this.getRemoteServer(joinedNodeName);
        }
        catch (IOException e) {
            ODistributedServerLog.error((Object)((Object)this), (String)this.nodeName, (String)joinedNodeName, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Error on connecting to node %s", (Object[])new Object[]{joinedNodeName});
        }
        ODistributedServerLog.info((Object)((Object)this), (String)this.nodeName, (String)this.clusterManager.getNodeName(member, true), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Added node configuration id=%s name=%s, now %d nodes are configured", (Object[])new Object[]{member, this.clusterManager.getNodeName(member, true), this.getActiveServers().size()});
        for (ODistributedLifecycleListener l : this.listeners) {
            l.onNodeJoined(joinedNodeName);
        }
        for (String db : this.messageService.getDatabases()) {
            if (!this.getDatabaseConfiguration(db).isAutoDeploy() || this.getDatabaseStatus(joinedNodeName, db) != ODistributedServerManager.DB_STATUS.ONLINE) continue;
            this.setDatabaseStatus(joinedNodeName, db, ODistributedServerManager.DB_STATUS.NOT_AVAILABLE);
        }
        this.dumpServersStatus();
    }

    public void connectToAllNodes(Set<String> clusterNodes) throws IOException {
        for (String m : clusterNodes) {
            if (m.equals(this.nodeName)) continue;
            this.getRemoteServer(m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServer(String nodeLeftName, boolean removeOnlyDynamicServers) {
        if (nodeLeftName == null) {
            return;
        }
        Member member = this.clusterManager.removeFromLocalActiveServerList(nodeLeftName);
        if (member == null) {
            return;
        }
        ODistributedServerLog.debug((Object)((Object)this), (String)this.nodeName, (String)nodeLeftName, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed server '%s' is unreachable", (Object[])new Object[]{nodeLeftName});
        try {
            this.closeRemoteServer(nodeLeftName);
            for (ODistributedLifecycleListener l : this.listeners) {
                try {
                    l.onNodeLeft(nodeLeftName);
                }
                catch (Exception e) {
                    ODistributedServerLog.debug((Object)((Object)this), (String)this.nodeName, (String)nodeLeftName, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on calling onNodeLeft event on '%s'", (Throwable)e, (Object[])new Object[]{l});
                }
            }
            if (this.messageService != null) {
                for (String dbName : this.messageService.getDatabases()) {
                    this.messageService.getDatabase(dbName).handleUnreachableNode(nodeLeftName);
                }
            }
            this.clusterManager.removeServerFromCluster(member, nodeLeftName, removeOnlyDynamicServers);
            for (String databaseName : this.getManagedDatabases()) {
                try {
                    if (this.getDatabaseConfiguration(databaseName).getServerRole(this.nodeName) != ODistributedConfiguration.ROLES.MASTER) continue;
                    this.reassignClustersOwnership(this.nodeName, databaseName, null, false);
                }
                catch (Exception e) {
                    ODistributedServerLog.error((Object)((Object)this), (String)this.nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Cannot re-balance the cluster for database '%s' because the Lock Manager is not available (err=%s)", (Object[])new Object[]{databaseName, e.getMessage()});
                }
            }
            if (nodeLeftName.equalsIgnoreCase(this.nodeName)) {
                System.exit(1);
            }
        }
        finally {
            if (this.messageService != null) {
                this.messageService.handleUnreachableNode(nodeLeftName);
            }
        }
    }

    public ODistributedServerManager.DB_STATUS getDatabaseStatus(String iNode, String iDatabaseName) {
        return this.clusterManager.getDatabaseStatus(iNode, iDatabaseName);
    }

    public void setDatabaseStatus(String iNode, String iDatabaseName, ODistributedServerManager.DB_STATUS iStatus) {
        this.clusterManager.setDatabaseStatus(iNode, iDatabaseName, iStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCreate(ODatabaseInternal iDatabase) {
        if (!this.isRelatedToLocalServer(iDatabase)) {
            return;
        }
        if (this.getNodeStatus() != ODistributedServerManager.NODE_STATUS.ONLINE) {
            return;
        }
        ODatabaseDocumentInternal currDb = ODatabaseRecordThreadLocal.instance().getIfDefined();
        try {
            String dbName = iDatabase.getName();
            ODistributedConfiguration cfg = this.getDatabaseConfiguration(dbName);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw OException.wrapException((OException)((Object)new ODistributedException("Error on creating database '" + dbName + "' on distributed nodes")), (Throwable)e);
            }
            Set servers = cfg.getAllConfiguredServers();
            if (servers.size() > 1) {
                int retry;
                for (retry = 0; retry < 100; ++retry) {
                    boolean allServersAreOnline = true;
                    for (String server : servers) {
                        if (this.isNodeOnline(server, dbName)) continue;
                        allServersAreOnline = false;
                        break;
                    }
                    if (allServersAreOnline) break;
                    try {
                        Thread.sleep(200L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw OException.wrapException((OException)((Object)new ODistributedException("Error on creating database '" + dbName + "' on distributed nodes")), (Throwable)e);
                    }
                }
                if (retry >= 100) {
                    ODistributedServerLog.warn((Object)((Object)this), (String)this.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Timeout waiting for all nodes to be up for database %s", (Object[])new Object[]{dbName});
                }
            }
            this.onOpen(iDatabase);
        }
        finally {
            ODatabaseRecordThreadLocal.instance().set(currDb);
        }
    }

    public void onServerRemoved(String nodeName) {
        this.closeRemoteServer(nodeName);
    }

    public void onDbStatusOnline(String databaseName) {
        ODistributedServerManager.DB_STATUS s = this.getDatabaseStatus(this.getLocalNodeName(), databaseName);
        if (s == ODistributedServerManager.DB_STATUS.NOT_AVAILABLE) {
            this.installDatabase(false, databaseName, false, OGlobalConfiguration.DISTRIBUTED_BACKUP_TRY_INCREMENTAL_FIRST.getValueAsBoolean());
        }
    }

    public void onDbConfigUpdated(String databaseName, ODocument config, boolean updated, boolean deployToCluster) {
        HashSet<String> servers = new HashSet<String>(this.getActiveServers());
        servers.remove(this.nodeName);
        if (!servers.isEmpty() && this.messageService.getDatabase(databaseName) != null) {
            ODistributedResponse oDistributedResponse = this.sendRequest(databaseName, null, servers, (ORemoteTask)new OUpdateDatabaseConfigurationTask(databaseName, config), this.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.NO_RESPONSE, null);
        }
    }

    public boolean onNodeJoining(String joinedNodeName) {
        for (ODistributedLifecycleListener l : this.listeners) {
            if (l.onNodeJoining(joinedNodeName)) continue;
            return false;
        }
        return true;
    }

    public ODocument getClusterConfiguration() {
        if (!this.enabled) {
            return null;
        }
        return this.clusterManager.getClusterConfiguration();
    }

    public String getNodeNameById(int id) {
        return this.clusterManager.getNodeNameById(id);
    }

    public int getNodeIdByName(String node) {
        return this.clusterManager.getNodeIdByName(node);
    }

    public ODocument getNodeConfigurationByUuid(String iNode, boolean useCache) {
        return this.clusterManager.getNodeConfigurationByUuid(iNode, useCache);
    }

    public void reloadRegisteredNodes(String registeredNodesFromClusterAsJson) {
        this.clusterManager.reloadRegisteredNodes(registeredNodesFromClusterAsJson);
    }

    public boolean removeNodeFromConfiguration(String nodeName, String databaseName, boolean removeOnlyDynamicServers, boolean statusOffline) {
        return this.clusterManager.removeNodeFromConfiguration(nodeName, databaseName, removeOnlyDynamicServers, statusOffline);
    }

    public HazelcastInstance getHazelcastInstance() {
        return this.clusterManager.getHazelcastInstance();
    }
}

