/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.orientechnologies.orient.core.tx.OTransactionId;
import com.orientechnologies.orient.core.tx.OTransactionSequenceStatus;
import com.orientechnologies.orient.core.tx.OTxMetadataHolderImpl;
import com.orientechnologies.orient.core.tx.ValidationResult;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.exception.OTransactionAlreadyPresentException;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTransactionSequenceManager;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;

public class ODistributedSynchronizedSequence {
    private final OTransactionSequenceManager sequenceManager;
    private CountDownLatch request;

    public ODistributedSynchronizedSequence(String node, int size) {
        this.sequenceManager = new OTransactionSequenceManager(node, size);
        this.request = new CountDownLatch(1);
        this.request.countDown();
    }

    public ValidationResult validateTransactionId(OTransactionId id) {
        return this.sequenceManager.validateTransactionId(id);
    }

    public void notifyFailure(OTransactionId id) {
        this.sequenceManager.notifyFailure(id);
    }

    public Optional<OTransactionId> next() {
        return this.sequenceManager.next();
    }

    public synchronized OTxMetadataHolderImpl notifySuccess(OTransactionId id) {
        try {
            this.request.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        ValidationResult status = this.sequenceManager.notifySuccess(id);
        if (status == ValidationResult.ALREADY_PRESENT) {
            throw new OTransactionAlreadyPresentException("Tx Already present in the current context");
        }
        if (status == ValidationResult.VALID) {
            this.request = new CountDownLatch(1);
            return new OTxMetadataHolderImpl(this.request, id, this.sequenceManager.currentStatus());
        }
        throw new ODistributedException("Failed transaction sequence need a reinstall");
    }

    public List<OTransactionId> missingTransactions(OTransactionSequenceStatus lastState) {
        return this.sequenceManager.checkOtherStatus(lastState);
    }

    public void fill(Optional<byte[]> lastMetadata) {
        lastMetadata.ifPresent(data -> this.sequenceManager.fill(OTxMetadataHolderImpl.read((byte[])data).getStatus()));
    }

    public OTransactionSequenceStatus currentStatus() {
        return this.sequenceManager.currentStatus();
    }

    public List<OTransactionId> checkSelfStatus(OTransactionSequenceStatus status) {
        return this.sequenceManager.checkSelfStatus(status);
    }
}

