/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.orientechnologies.common.concur.lock.OInterruptedException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.exception.OConcurrentCreateException;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionId;
import com.orientechnologies.orient.core.tx.OTransactionInternal;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedMessageService;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ODistributedTxContext;
import com.orientechnologies.orient.server.distributed.ODistributedTxResponseManager;
import com.orientechnologies.orient.server.distributed.impl.ODatabaseDocumentDistributed;
import com.orientechnologies.orient.server.distributed.impl.ODistributedDatabaseImpl;
import com.orientechnologies.orient.server.distributed.impl.ODistributedTxResponseManagerImpl;
import com.orientechnologies.orient.server.distributed.impl.OInvalidSequentialException;
import com.orientechnologies.orient.server.distributed.impl.OLocalKeySource;
import com.orientechnologies.orient.server.distributed.impl.lock.OLockGuard;
import com.orientechnologies.orient.server.distributed.impl.task.OLockKeySource;
import com.orientechnologies.orient.server.distributed.impl.task.OTransactionPhase1Task;
import com.orientechnologies.orient.server.distributed.impl.task.OTransactionPhase2Task;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTransactionResultPayload;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxConcurrentCreation;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxConcurrentModification;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxException;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxKeyLockTimeout;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxRecordLockTimeout;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxUniqueIndex;
import com.orientechnologies.orient.server.distributed.task.ODistributedKeyLockedException;
import com.orientechnologies.orient.server.distributed.task.ODistributedOperationException;
import com.orientechnologies.orient.server.distributed.task.ODistributedRecordLockedException;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;

public class ODistributedTxCoordinator {
    public static final String LOCAL_RESULT_SUCCESS = "OK";
    private final ODistributedServerManager dManager;
    private final OStorage storage;
    private final ODistributedDatabase localDistributedDatabase;
    private ODistributedTxResponseManager responseManager;
    private final ODistributedMessageService messageService;
    private final int nodeId;
    private final String nodeName;
    private final int maxRetries;
    private final int retryDelay;

    public ODistributedTxCoordinator(OStorage storage, ODistributedServerManager manager, ODistributedDatabase iDDatabase, ODistributedMessageService messageService, int nodeId, String nodeName, int maxRetries, int retryDelay) {
        this.dManager = manager;
        this.storage = storage;
        this.localDistributedDatabase = iDDatabase;
        this.messageService = messageService;
        this.nodeId = nodeId;
        this.nodeName = nodeName;
        this.maxRetries = maxRetries;
        this.retryDelay = retryDelay;
    }

    public void commit(ODatabaseDocumentDistributed database, OTransactionInternal iTx, Set<String> clusters) {
        ODistributedDatabaseImpl distributedDatabase = (ODistributedDatabaseImpl)this.messageService.getDatabase(database.getName());
        int count = 0;
        while (true) {
            ODistributedRequestId requestId = new ODistributedRequestId(this.nodeId, this.dManager.getNextMessageIdCounter());
            distributedDatabase.startOperation();
            try {
                Optional<OTransactionId> genId = distributedDatabase.nextId();
                if (genId.isPresent()) {
                    OTransactionId txId = genId.get();
                    this.tryCommit(database, iTx, txId, requestId, clusters);
                    return;
                }
                try {
                    Thread.sleep(new Random().nextInt(this.retryDelay));
                }
                catch (InterruptedException e) {
                    OException.wrapException((OException)new OInterruptedException(e.getMessage()), (Throwable)e);
                }
            }
            catch (OConcurrentCreateException | OInvalidSequentialException | ODistributedKeyLockedException | ODistributedRecordLockedException ex) {
                if (ex instanceof OConcurrentCreateException) {
                    iTx.resetAllocatedIds();
                }
                if (count > this.maxRetries) {
                    this.destroyContext(requestId);
                    throw ex;
                }
                try {
                    Thread.sleep(new Random().nextInt(this.retryDelay));
                }
                catch (InterruptedException e) {
                    OException.wrapException((OException)new OInterruptedException(e.getMessage()), (Throwable)e);
                }
            }
            catch (Error | RuntimeException ex) {
                this.destroyContext(requestId);
                throw ex;
            }
            finally {
                distributedDatabase.endOperation();
            }
            ++count;
        }
    }

    private void destroyContext(ODistributedRequestId requestId) {
        ODistributedTxContext context = this.localDistributedDatabase.getTxContext(requestId);
        if (context != null) {
            context.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryCommit(ODatabaseDocumentDistributed database, OTransactionInternal iTx, OTransactionId txId, ODistributedRequestId requestId, Set<String> clusters) {
        OTransactionResultPayload localResult;
        iTx.setStatus(OTransaction.TXSTATUS.BEGUN);
        ODistributedDatabaseImpl sharedDb = (ODistributedDatabaseImpl)this.messageService.getDatabase(database.getName());
        OLocalKeySource keySource = new OLocalKeySource(txId, iTx, database);
        List<OLockGuard> guards = sharedDb.localLock(keySource);
        try {
            localResult = OTransactionPhase1Task.executeTransaction(requestId, txId, database, iTx, true, -1);
        }
        finally {
            sharedDb.localUnlock(guards);
        }
        if (localResult.getResponseType() == 2) {
            sharedDb.popTxContext(requestId).destroy();
            throw new ODistributedRecordLockedException(this.nodeName, ((OTxRecordLockTimeout)localResult).getLockedId());
        }
        if (localResult.getResponseType() == 7) {
            sharedDb.popTxContext(requestId).destroy();
            throw new ODistributedKeyLockedException(this.nodeName, (Object)((OTxKeyLockTimeout)localResult).getKey());
        }
        Set<String> nodes = sharedDb.getAvailableNodesButLocal(clusters);
        if (nodes.isEmpty()) {
            switch (localResult.getResponseType()) {
                case 1: {
                    this.localOk(requestId, database, keySource);
                    break;
                }
                case 5: {
                    this.localKo(requestId, database, keySource);
                    throw ((OTxException)localResult).getException();
                }
                case 3: {
                    this.localKo(requestId, database, keySource);
                    ORecordId id = ((OTxUniqueIndex)localResult).getRecordId();
                    String index = ((OTxUniqueIndex)localResult).getIndex();
                    Object key = ((OTxUniqueIndex)localResult).getKey();
                    throw new ORecordDuplicatedException(String.format("Cannot index record %s: found duplicated key '%s' in index '%s' ", id, key, index), index, (ORID)id, key);
                }
                case 4: {
                    this.localKo(requestId, database, keySource);
                    ORecordId id = ((OTxConcurrentModification)localResult).getRecordId();
                    int version = ((OTxConcurrentModification)localResult).getVersion();
                    throw new OConcurrentModificationException((ORID)id, version, iTx.getRecordEntry((ORID)id).getRecord().getVersion(), (int)iTx.getRecordEntry((ORID)id).getType());
                }
                case 2: {
                    throw new ODistributedRecordLockedException(this.nodeName, ((OTxRecordLockTimeout)localResult).getLockedId());
                }
                case 7: {
                    throw new ODistributedKeyLockedException(this.nodeName, (Object)((OTxKeyLockTimeout)localResult).getKey());
                }
                case 9: {
                    throw new OInvalidSequentialException();
                }
            }
            return;
        }
        OTransactionPhase1Task txTask = this.createTxPhase1Task(txId, iTx);
        HashSet<String> sentNodes = new HashSet<String>(nodes);
        iTx.setStatus(OTransaction.TXSTATUS.COMMITTING);
        this.dManager.sendRequest(this.storage.getName(), clusters, nodes, (ORemoteTask)txTask, requestId.getMessageId(), ODistributedRequest.EXECUTION_MODE.RESPONSE, (Object)localResult, (iRequest, iNodes, task, nodesConcurToTheQuorum, availableNodes, expectedResponses, quorum, groupByResponse, waitLocalNode) -> {
            this.responseManager = new ODistributedTxResponseManagerImpl((ORemoteTask)txTask, iNodes, nodesConcurToTheQuorum, availableNodes, expectedResponses, quorum);
            return this.responseManager;
        });
        this.handleResponse(requestId, this.responseManager, clusters, sentNodes, database, iTx, txTask);
    }

    private void handleResponse(ODistributedRequestId requestId, ODistributedTxResponseManager responseManager, Set<String> involvedClusters, Set<String> nodes, ODatabaseDocumentDistributed database, OTransactionInternal iTx, OTransactionPhase1Task txTask) {
        int[] involvedClustersIds = new int[involvedClusters.size()];
        int i = 0;
        for (String involvedCluster : involvedClusters) {
            involvedClustersIds[i++] = database.getClusterIdByName(involvedCluster);
        }
        if (responseManager.isQuorumReached()) {
            Optional<OTransactionResultPayload> result = responseManager.getDistributedTxFinalResponse();
            assert (result.isPresent());
            OTransactionResultPayload resultPayload = result.get();
            switch (resultPayload.getResponseType()) {
                case 1: {
                    this.sendPhase2Task(involvedClusters, nodes, this.createTxPhase2Task(requestId, txTask, true));
                    this.localOk(requestId, database, txTask);
                    break;
                }
                case 5: {
                    this.sendPhase2Task(involvedClusters, nodes, this.createTxPhase2Task(requestId, txTask, false));
                    this.localKo(requestId, database, txTask);
                    throw ((OTxException)resultPayload).getException();
                }
                case 3: {
                    this.sendPhase2Task(involvedClusters, nodes, this.createTxPhase2Task(requestId, txTask, false));
                    this.localKo(requestId, database, txTask);
                    ORecordId id = ((OTxUniqueIndex)resultPayload).getRecordId();
                    String index = ((OTxUniqueIndex)resultPayload).getIndex();
                    Object key = ((OTxUniqueIndex)resultPayload).getKey();
                    throw new ORecordDuplicatedException(String.format("Cannot index record %s: found duplicated key '%s' in index '%s' ", id, key, index), index, (ORID)id, key);
                }
                case 4: {
                    this.sendPhase2Task(involvedClusters, nodes, this.createTxPhase2Task(requestId, txTask, false));
                    this.localKo(requestId, database, txTask);
                    ORecordId id = ((OTxConcurrentModification)resultPayload).getRecordId();
                    int version = ((OTxConcurrentModification)resultPayload).getVersion();
                    throw new OConcurrentModificationException((ORID)id, version, iTx.getRecordEntry((ORID)id).getRecord().getVersion(), (int)iTx.getRecordEntry((ORID)id).getType());
                }
                case 6: {
                    this.sendPhase2Task(involvedClusters, nodes, this.createTxPhase2Task(requestId, txTask, false));
                    this.localKo(requestId, database, txTask);
                    throw new OConcurrentCreateException(((OTxConcurrentCreation)resultPayload).getExpectedRid(), ((OTxConcurrentCreation)resultPayload).getActualRid());
                }
                case 2: {
                    this.sendPhase2Task(involvedClusters, nodes, this.createTxPhase2Task(requestId, txTask, false));
                    this.localKo(requestId, database, txTask);
                    throw new ODistributedRecordLockedException(((OTxRecordLockTimeout)resultPayload).getNode(), ((OTxRecordLockTimeout)resultPayload).getLockedId());
                }
                case 7: {
                    this.sendPhase2Task(involvedClusters, nodes, this.createTxPhase2Task(requestId, txTask, false));
                    this.localKo(requestId, database, txTask);
                    throw new ODistributedKeyLockedException(((OTxKeyLockTimeout)resultPayload).getNode(), (Object)((OTxKeyLockTimeout)resultPayload).getKey());
                }
                case 9: {
                    this.sendPhase2Task(involvedClusters, nodes, this.createTxPhase2Task(requestId, txTask, false));
                    this.localKo(requestId, database, txTask);
                    throw new OInvalidSequentialException();
                }
            }
            for (OTransactionResultPayload txResult : responseManager.getAllResponses()) {
                if (txResult.getResponseType() != 5) continue;
                OLogManager.instance().warn((Object)this, "One node on error", (Throwable)((OTxException)txResult).getException(), new Object[0]);
            }
        } else {
            List<OTransactionResultPayload> results = responseManager.getAllResponses();
            ArrayList<RuntimeException> exceptions = new ArrayList<RuntimeException>();
            ArrayList<String> messages = new ArrayList<String>();
            for (OTransactionResultPayload result : results) {
                String string = responseManager.getNodeNameFromPayload(result);
                switch (result.getResponseType()) {
                    case 2: {
                        this.sendPhase2Task(involvedClusters, nodes, this.createTxPhase2Task(requestId, txTask, false));
                        this.localKo(requestId, database, txTask);
                        throw new ODistributedRecordLockedException(((OTxRecordLockTimeout)result).getNode(), ((OTxRecordLockTimeout)result).getLockedId());
                    }
                    case 7: {
                        this.sendPhase2Task(involvedClusters, nodes, this.createTxPhase2Task(requestId, txTask, false));
                        this.localKo(requestId, database, txTask);
                        throw new ODistributedKeyLockedException(((OTxKeyLockTimeout)result).getNode(), (Object)((OTxKeyLockTimeout)result).getKey());
                    }
                    case 6: {
                        this.sendPhase2Task(involvedClusters, nodes, this.createTxPhase2Task(requestId, txTask, false));
                        this.localKo(requestId, database, txTask);
                        throw new OConcurrentCreateException(((OTxConcurrentCreation)result).getExpectedRid(), ((OTxConcurrentCreation)result).getActualRid());
                    }
                    case 1: {
                        messages.add("node: " + string + " success");
                        break;
                    }
                    case 4: {
                        this.sendPhase2Task(involvedClusters, nodes, this.createTxPhase2Task(requestId, txTask, false));
                        this.localKo(requestId, database, txTask);
                        ORecordId recordId = ((OTxConcurrentModification)result).getRecordId();
                        throw new OConcurrentModificationException((ORID)recordId, ((OTxConcurrentModification)result).getVersion(), iTx.getRecordEntry((ORID)recordId).getRecord().getVersion(), (int)iTx.getRecordEntry((ORID)recordId).getType());
                    }
                    case 5: {
                        exceptions.add(((OTxException)result).getException());
                        OLogManager.instance().debug((Object)this, "distributed exception", (Throwable)((OTxException)result).getException(), new Object[0]);
                        messages.add(String.format("exception (node " + string + "): '%s'", ((OTxException)result).getException().getMessage()));
                        break;
                    }
                    case 3: {
                        messages.add(String.format("unique index violation on index (node " + string + "):'%s' with key:'%s' and rid:'%s'", ((OTxUniqueIndex)result).getIndex(), ((OTxUniqueIndex)result).getKey(), ((OTxUniqueIndex)result).getRecordId()));
                        break;
                    }
                    case 9: {
                        this.sendPhase2Task(involvedClusters, nodes, this.createTxPhase2Task(requestId, txTask, false));
                        this.localKo(requestId, database, txTask);
                        throw new OInvalidSequentialException();
                    }
                }
            }
            this.sendPhase2Task(involvedClusters, nodes, this.createTxPhase2Task(requestId, txTask, false));
            this.localKo(requestId, database, txTask);
            ODistributedOperationException ex = new ODistributedOperationException(String.format("Request `%s` didn't reach the quorum of '%d', responses: [%s]", requestId, responseManager.getQuorum(), String.join((CharSequence)",", messages)));
            for (Exception exception : exceptions) {
                ex.addSuppressed((Throwable)exception);
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void localKo(ODistributedRequestId requestId, ODatabaseDocumentDistributed database, OLockKeySource source) {
        ODistributedDatabaseImpl dd = (ODistributedDatabaseImpl)this.messageService.getDatabase(database.getName());
        List<OLockGuard> guards = dd.localLock(source);
        try {
            database.rollback2pc(requestId);
        }
        finally {
            dd.localUnlock(guards);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void localOk(ODistributedRequestId requestId, ODatabaseDocumentDistributed database, OLockKeySource source) {
        ODistributedDatabaseImpl dd = (ODistributedDatabaseImpl)this.messageService.getDatabase(database.getName());
        List<OLockGuard> guards = dd.localLock(source);
        try {
            database.commit2pcLocal(requestId);
        }
        finally {
            dd.localUnlock(guards);
        }
    }

    private void sendPhase2Task(Set<String> involvedClusters, Set<String> nodes, OTransactionPhase2Task task) {
        this.dManager.sendRequest(this.storage.getName(), involvedClusters, nodes, (ORemoteTask)task, this.dManager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, (Object)LOCAL_RESULT_SUCCESS);
    }

    protected OTransactionPhase1Task createTxPhase1Task(OTransactionId id, OTransactionInternal transaction) {
        OTransactionPhase1Task txTask = new OTransactionPhase1Task();
        txTask.init(id, transaction);
        return txTask;
    }

    private OTransactionPhase2Task createTxPhase2Task(ODistributedRequestId requestId, OTransactionPhase1Task txTask, boolean success) {
        return new OTransactionPhase2Task(requestId, success, txTask.getRids(), txTask.getUniqueKeys(), txTask.getTransactionId());
    }

    void setResponseManager(ODistributedTxResponseManager responseManager) {
        this.responseManager = responseManager;
    }
}

