/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.OScenarioThreadLocal;
import com.orientechnologies.orient.core.tx.OTransactionData;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.impl.ODatabaseDocumentDistributed;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.concurrent.Callable;

public class ONewDeltaSyncImporter {
    public void importDelta(final OServer serverInstance, final String databaseName, final InputStream in, final String targetNode) {
        final String nodeName = serverInstance.getDistributedManager().getLocalNodeName();
        try {
            OScenarioThreadLocal.executeAsDistributed((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    ODistributedServerLog.info((Object)this, (String)nodeName, (String)targetNode, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)("Started import of delta for database '" + databaseName + "'"), (Object[])new Object[0]);
                    ODatabaseDocumentInternal db = serverInstance.openDatabase(databaseName);
                    ((ODatabaseDocumentDistributed)db).getDistributedShared().fillStatus();
                    DataInputStream dataInput = new DataInputStream(in);
                    while (dataInput.readBoolean()) {
                        OTransactionData transaction = OTransactionData.read((DataInput)dataInput);
                        db.syncCommit(transaction);
                    }
                    return null;
                }
            });
        }
        catch (OException e) {
            OLogManager.instance().error((Object)this, "Error running delta sync import", (Throwable)e, new Object[0]);
        }
    }
}

